/*
 * Decompiled with CFR 0.152.
 */
package com.github.squti.androidwaverecorder;

import android.media.AudioRecord;
import com.github.squti.androidwaverecorder.WaveConfig;
import com.github.squti.androidwaverecorder.WaveHeaderWriter;
import java.io.File;
import java.io.FileOutputStream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\bH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\b\u0010\u0013\u001a\u00020\u0011H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/github/squti/androidwaverecorder/WaveRecorder;", "", "filePath", "", "(Ljava/lang/String;)V", "audioRecorder", "Landroid/media/AudioRecord;", "isRecording", "", "waveConfig", "Lcom/github/squti/androidwaverecorder/WaveConfig;", "getWaveConfig", "()Lcom/github/squti/androidwaverecorder/WaveConfig;", "setWaveConfig", "(Lcom/github/squti/androidwaverecorder/WaveConfig;)V", "isAudioRecorderInitialized", "startRecording", "", "stopRecording", "writeAudioDataToStorage", "android-wave-recorder_release"})
public final class WaveRecorder {
    @NotNull
    private WaveConfig waveConfig;
    private boolean isRecording;
    private AudioRecord audioRecorder;
    private String filePath;

    @NotNull
    public final WaveConfig getWaveConfig() {
        return this.waveConfig;
    }

    public final void setWaveConfig(@NotNull WaveConfig waveConfig) {
        Intrinsics.checkParameterIsNotNull((Object)waveConfig, (String)"<set-?>");
        this.waveConfig = waveConfig;
    }

    public final void startRecording() {
        if (!this.isAudioRecorderInitialized()) {
            this.audioRecorder = new AudioRecord(1, this.waveConfig.getSampleRate(), this.waveConfig.getChannels(), this.waveConfig.getAudioEncoding(), AudioRecord.getMinBufferSize((int)this.waveConfig.getSampleRate(), (int)this.waveConfig.getChannels(), (int)this.waveConfig.getAudioEncoding()));
            this.isRecording = true;
            AudioRecord audioRecord = this.audioRecorder;
            if (audioRecord == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            }
            audioRecord.startRecording();
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                private CoroutineScope p$;
                int label;
                final /* synthetic */ WaveRecorder this$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            CoroutineScope $this$launch = this.p$;
                            WaveRecorder.access$writeAudioDataToStorage(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.this$0 = waveRecorder;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }
    }

    private final void writeAudioDataToStorage() {
        int bufferSize = AudioRecord.getMinBufferSize((int)this.waveConfig.getSampleRate(), (int)this.waveConfig.getChannels(), (int)this.waveConfig.getAudioEncoding());
        byte[] data = new byte[bufferSize];
        File file = new File(this.filePath);
        boolean bl = false;
        FileOutputStream outputStream = new FileOutputStream(file);
        while (this.isRecording) {
            int operationStatus;
            AudioRecord audioRecord = this.audioRecorder;
            if (audioRecord == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            }
            if (-3 == (operationStatus = audioRecord.read(data, 0, bufferSize))) continue;
            outputStream.write(data);
        }
        outputStream.close();
    }

    public final void stopRecording() {
        if (this.isAudioRecorderInitialized()) {
            this.isRecording = false;
            AudioRecord audioRecord = this.audioRecorder;
            if (audioRecord == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            }
            audioRecord.stop();
            AudioRecord audioRecord2 = this.audioRecorder;
            if (audioRecord2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
            }
            audioRecord2.release();
            new WaveHeaderWriter(this.filePath, this.waveConfig).writeHeader();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAudioRecorderInitialized() {
        if (this.audioRecorder == null) return false;
        AudioRecord audioRecord = this.audioRecorder;
        if (audioRecord == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
        }
        if (audioRecord.getState() != 1) return false;
        return true;
    }

    public WaveRecorder(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        this.filePath = filePath;
        this.waveConfig = new WaveConfig(0, 0, 0, 7, null);
    }

    public static final /* synthetic */ void access$writeAudioDataToStorage(WaveRecorder $this) {
        $this.writeAudioDataToStorage();
    }

    public static final /* synthetic */ AudioRecord access$getAudioRecorder$p(WaveRecorder $this) {
        AudioRecord audioRecord = $this.audioRecorder;
        if (audioRecord == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"audioRecorder");
        }
        return audioRecord;
    }

    public static final /* synthetic */ void access$setAudioRecorder$p(WaveRecorder $this, AudioRecord audioRecord) {
        $this.audioRecorder = audioRecord;
    }
}

