/*
 * Decompiled with CFR 0.152.
 */
package mustachejava.benchmarks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingJsonFactory;
import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheResolver;
import com.github.mustachejavabenchmarks.NullWriter;
import com.sun.management.ThreadMXBean;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import mustachejava.benchmarks.Tweet;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Benchmark)
public class TweetBench {
    private Mustache tweetMustache = new DefaultMustacheFactory().compile("tweet.mustache");
    private Mustache timelineMustache = new DefaultMustacheFactory().compile("timeline.mustache");
    private Tweet tweet = new Tweet();
    private NullWriter nullWriter = new NullWriter();
    private List<Object> tweetScope = new ArrayList<Tweet>(Collections.singletonList(this.tweet));
    private List<Object> timelineScope = new ArrayList<Object>();
    private Map<String, String> cache;
    private MustacheResolver cached;
    private static ThreadMXBean threadMXBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();

    private String readResource(String name) {
        StringWriter sw = new StringWriter();
        InputStreamReader reader = new InputStreamReader(ClassLoader.getSystemResourceAsStream(name));
        char[] chars = new char[1024];
        try {
            int read;
            while ((read = reader.read(chars)) != -1) {
                sw.write(chars, 0, read);
            }
            sw.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public TweetBench() {
        final ArrayList<Tweet> tweetList = new ArrayList<Tweet>();
        for (int i = 0; i < 20; ++i) {
            tweetList.add(new Tweet());
        }
        this.timelineScope.add(new Object(){
            List<Tweet> tweets;
            {
                this.tweets = tweetList;
            }
        });
        this.cache = new HashMap<String, String>();
        this.cache.put("tweet.mustache", this.readResource("tweet.mustache"));
        this.cache.put("entities.mustache", this.readResource("entities.mustache"));
        this.cached = resourceName -> new StringReader(this.cache.get(resourceName));
        try {
            MappingJsonFactory jf = new MappingJsonFactory();
            InputStream json = TweetBench.class.getClassLoader().getResourceAsStream("tweet.json");
            new ArrayList<JsonMap>(Collections.singletonList(new JsonMap((JsonNode)jf.createParser(json).readValueAsTree())));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void testCompilation() {
        DefaultMustacheFactory dmf = new DefaultMustacheFactory(this.cached);
        Mustache m = dmf.compile("tweet.mustache");
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void testExecution() throws IOException {
        this.tweetMustache.execute((Writer)this.nullWriter, this.tweetScope).close();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.SECONDS)
    public void testTimeline() throws IOException {
        this.timelineMustache.execute((Writer)this.nullWriter, this.timelineScope).close();
    }

    public static void main(String[] args) throws IOException {
        DefaultMustacheFactory dmf = new DefaultMustacheFactory();
        Mustache m = dmf.compile("tweet.mustache");
        StringWriter sw1 = new StringWriter();
        m.execute((Writer)sw1, (Object)new Tweet()).close();
        System.out.println(sw1);
        InputStream json = TweetBench.class.getClassLoader().getResourceAsStream("tweet.json");
        MappingJsonFactory jf = new MappingJsonFactory();
        JsonNode jsonNode = (JsonNode)jf.createParser(json).readValueAsTree();
        StringWriter sw2 = new StringWriter();
        m.execute((Writer)sw2, (Object)new JsonMap(jsonNode)).close();
        System.out.println(sw2);
        System.out.println(sw1.toString().equals(sw2.toString()));
        TweetBench tb = new TweetBench();
        int i = 0;
        long startTime = System.nanoTime();
        long threadId = Thread.currentThread().getId();
        long startMemory = threadMXBean.getThreadAllocatedBytes(threadId);
        int n = 0;
        while (true) {
            if (++i == 100000) {
                long endTime = System.nanoTime();
                long diffTime = endTime - startTime;
                long endMemory = threadMXBean.getThreadAllocatedBytes(threadId);
                long diffMemory = endMemory - startMemory;
                System.out.println(diffTime / (long)i + " ns/iteration, " + diffMemory / (long)i + " bytes/iteration, " + 1.0E9 / (double)diffTime * (double)i + " per second");
                startTime = endTime;
                startMemory = endMemory;
                i = 0;
                if (++n == 5) break;
            }
            tb.testTimeline();
        }
    }

    private static class JsonMap
    extends HashMap {
        private final JsonNode test;

        JsonMap(JsonNode test) {
            this.test = test;
        }

        @Override
        public Object get(Object key) {
            JsonNode value = this.test.get(key.toString());
            return this.convert(value);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.test.has(key.toString());
        }

        private Object convert(final JsonNode value) {
            if (value == null || value.isNull()) {
                return null;
            }
            if (value.isBoolean()) {
                return value.booleanValue();
            }
            if (value.isValueNode()) {
                return value.asText();
            }
            if (value.isArray()) {
                return () -> new Iterator(){
                    private Iterator iterator;
                    {
                        this.iterator = value.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    public Object next() {
                        return this.convert((JsonNode)this.iterator.next());
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
            return new JsonMap(value);
        }
    }
}

