/*
 * Decompiled with CFR 0.152.
 */
package mustachejava.benchmarks;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.codegen.CodegenObjectHandler;
import com.github.mustachejava.indy.IndyObjectHandler;
import com.github.mustachejava.reflect.SimpleObjectHandler;
import com.github.mustachejavabenchmarks.NullWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;

@State(value=Scope.Benchmark)
public class Main {
    private final NullWriter nw = new NullWriter();
    private final Mustache normal = new DefaultMustacheFactory().compile((Reader)new StringReader("({{#loop}}({{value}}){{/loop}})"), "test");
    private final Mustache indy;
    private final Mustache codegen;
    private final Mustache simple;
    private final Object scope = new Object(){
        List loop = new ArrayList();
        {
            int i = 0;
            while (i < 10) {
                final int finalI = i++;
                this.loop.add(new Object(){
                    String value;
                    {
                        this.value = String.valueOf(finalI);
                    }
                });
            }
        }
    };

    public Main() {
        DefaultMustacheFactory dmf1 = new DefaultMustacheFactory();
        dmf1.setObjectHandler((ObjectHandler)new CodegenObjectHandler());
        this.codegen = dmf1.compile((Reader)new StringReader("({{#loop}}({{value}}){{/loop}})"), "test");
        DefaultMustacheFactory dmf2 = new DefaultMustacheFactory();
        dmf2.setObjectHandler((ObjectHandler)new IndyObjectHandler());
        this.indy = dmf2.compile((Reader)new StringReader("({{#loop}}({{value}}){{/loop}})"), "test");
        DefaultMustacheFactory dmf3 = new DefaultMustacheFactory();
        dmf3.setObjectHandler((ObjectHandler)new SimpleObjectHandler());
        this.simple = dmf3.compile((Reader)new StringReader("({{#loop}}({{value}}){{/loop}})"), "test");
    }

    @Benchmark
    public void benchMustache() throws IOException {
        this.normal.execute((Writer)this.nw, this.scope).close();
    }

    @Benchmark
    public void benchMustacheCodegen() throws IOException {
        this.codegen.execute((Writer)this.nw, this.scope).close();
    }

    @Benchmark
    public void benchMustacheIndy() throws IOException {
        this.indy.execute((Writer)this.nw, this.scope).close();
    }

    @Benchmark
    public void benchMustacheSimple() throws IOException {
        this.simple.execute((Writer)this.nw, this.scope).close();
    }

    public static void main(String[] args) throws IOException {
        Main main = new Main();
        while (true) {
            main.benchMustacheSimple();
        }
    }
}

