/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.findbugs.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SmapParser {
    private final String javaFilename;
    private final Map<Integer, FileInfo> fileinfo = new HashMap<Integer, FileInfo>();
    private final Map<Integer, int[]> java2jsp = new HashMap<Integer, int[]>();
    private static final Pattern LINE_INFO_PATTERN = Pattern.compile("([0-9]+)(?:#([0-9]+))?(?:,([0-9]+))?:([0-9]+)(?:,([0-9]+))?");

    private static String getLine(BufferedReader reader) throws IOException {
        String s = reader.readLine();
        if (s == null) {
            throw new IOException("EOF parsing SMAP");
        }
        return s;
    }

    public SmapParser(String smap) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(smap.getBytes())));
        String header = SmapParser.getLine(reader);
        this.javaFilename = SmapParser.getLine(reader);
        String jsp = SmapParser.getLine(reader);
        String stratum = SmapParser.getLine(reader);
        String f = SmapParser.getLine(reader);
        if (!(header.equals("SMAP") && stratum.startsWith("*S ") && f.equals("*F"))) {
            throw new IllegalArgumentException("Unexpected SMAP file format");
        }
        while ((line = SmapParser.getLine(reader)) != null && !line.equals("*L")) {
            String path = null;
            if (line.startsWith("+ ")) {
                path = SmapParser.getLine(reader);
                line = line.substring(2);
            }
            int pos = line.indexOf(" ");
            int fileNum = Integer.parseInt(line.substring(0, pos));
            String name = line.substring(pos + 1);
            this.fileinfo.put(fileNum, new FileInfo(name, path == null ? name : path));
        }
        int lastLFI = 0;
        while ((line = SmapParser.getLine(reader)) != null && !line.equals("*E")) {
            if (line.startsWith("*")) continue;
            Matcher m = LINE_INFO_PATTERN.matcher(line);
            if (!m.matches()) {
                throw new IllegalArgumentException(line);
            }
            int inputStartLine = Integer.parseInt(m.group(1));
            int lineFileID = m.group(2) == null ? lastLFI : Integer.parseInt(m.group(2));
            int repeatCount = m.group(3) == null ? 1 : Integer.parseInt(m.group(3));
            int outputStartLine = Integer.parseInt(m.group(4));
            int outputLineIncrement = m.group(5) == null ? 1 : Integer.parseInt(m.group(5));
            for (int i = 0; i < repeatCount; ++i) {
                int baseOL;
                int[] inputMapping = new int[]{lineFileID, inputStartLine + i};
                for (int ol = baseOL = outputStartLine + i * outputLineIncrement; ol < baseOL + outputLineIncrement; ++ol) {
                    if (this.java2jsp.containsKey(ol)) continue;
                    this.java2jsp.put(ol, inputMapping);
                }
            }
            lastLFI = lineFileID;
        }
    }

    public String getJavaFilename() {
        return this.javaFilename;
    }

    public String getScriptFilename(int fileIndex) {
        FileInfo f = this.fileinfo.get(fileIndex);
        return f.name;
    }

    public int[] getScriptLineNumber(Integer lineNo) {
        return this.java2jsp.get(lineNo);
    }

    public List<Integer> getJavaLineNumbers(Integer jspLineNo) {
        ArrayList<Integer> javaLines = new ArrayList<Integer>();
        for (Map.Entry<Integer, int[]> lineMap : this.java2jsp.entrySet()) {
            if (lineMap.getValue()[1] != jspLineNo) continue;
            javaLines.add(lineMap.getKey());
        }
        return javaLines;
    }

    public SmapLocation getSmapLocation(Integer lineNo) {
        int[] origSource = this.java2jsp.get(lineNo);
        FileInfo info = this.fileinfo.get(origSource[0]);
        return new SmapLocation(info, origSource[1], origSource[0] == 0);
    }

    public static class SmapLocation {
        public final FileInfo fileInfo;
        public final int line;
        public final boolean isPrimaryFile;

        public SmapLocation(FileInfo fileInfo, int line, boolean isPrimaryFile) {
            this.fileInfo = fileInfo;
            this.line = line;
            this.isPrimaryFile = isPrimaryFile;
        }
    }

    public static class FileInfo {
        public final String name;
        public final String path;

        public FileInfo(String name, String path) {
            this.name = name;
            this.path = path;
        }
    }
}

