/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.test;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.test.AnalysisRunner;
import edu.umd.cs.findbugs.test.CountMatcher;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.hamcrest.Matcher;
import org.junit.rules.ExternalResource;

@ParametersAreNonnullByDefault
public class SpotBugsRule
extends ExternalResource {
    private AnalysisRunner runner;

    protected void before() throws Throwable {
        this.runner = new AnalysisRunner();
    }

    protected void after() {
        this.runner = null;
    }

    public static <T> Matcher<Iterable<T>> containsExactly(Matcher<T> matcher, int count) {
        return new CountMatcher<T>(count, matcher);
    }

    @Nonnull
    public SpotBugsRule addAuxClasspathEntry(Path path) {
        if (this.runner == null) {
            throw new IllegalStateException("Please call this addAuxClasspathEntry() method in @Before method or test method");
        }
        this.runner.addAuxClasspathEntry(path);
        return this;
    }

    @Nonnull
    public BugCollection performAnalysis(Path ... paths) {
        if (this.runner == null) {
            throw new IllegalStateException("Please call this performAnalysis() method in test method");
        }
        return this.runner.run(paths).getBugCollection();
    }
}

