/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.test;

import edu.umd.cs.findbugs.BugCollectionBugReporter;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.junit.Assert;

@ParametersAreNonnullByDefault
public class AnalysisRunner {
    private final List<Path> auxClasspathEntries = new ArrayList<Path>();

    @Nonnull
    public AnalysisRunner addAuxClasspathEntry(Path path) {
        Objects.requireNonNull(path);
        if (!path.toFile().canRead()) {
            throw new IllegalArgumentException("Cannot read " + path.toAbsolutePath());
        }
        this.auxClasspathEntries.add(path);
        return this;
    }

    @Nonnull
    public BugCollectionBugReporter run(Path ... files) {
        DetectorFactoryCollection.resetInstance((DetectorFactoryCollection)new DetectorFactoryCollection());
        FindBugs2 engine = new FindBugs2();
        Project project = new Project();
        project.setProjectName(this.getClass().getSimpleName());
        engine.setProject(project);
        DetectorFactoryCollection detectorFactoryCollection = DetectorFactoryCollection.instance();
        engine.setDetectorFactoryCollection(detectorFactoryCollection);
        BugCollectionBugReporter bugReporter = new BugCollectionBugReporter(project);
        bugReporter.setPriorityThreshold(3);
        bugReporter.setRankThreshold(20);
        engine.setBugReporter((BugReporter)bugReporter);
        UserPreferences preferences = UserPreferences.createDefaultUserPreferences();
        preferences.getFilterSettings().clearAllCategories();
        engine.setUserPreferences(preferences);
        for (Path file : files) {
            project.addFile(file.toAbsolutePath().toString());
        }
        for (Path auxClasspathEntry : this.auxClasspathEntries) {
            project.addAuxClasspathEntry(auxClasspathEntry.toAbsolutePath().toString());
        }
        try {
            engine.execute();
        }
        catch (IOException | InterruptedException e) {
            Assert.fail((String)("Analysis failed with exception; " + e.getMessage()));
        }
        if (!bugReporter.getQueuedErrors().isEmpty()) {
            AssertionError assertionError = new AssertionError((Object)"Analysis failed with exception. Check stderr for detail.");
            bugReporter.getQueuedErrors().stream().map(error -> error.getCause()).forEach(arg_0 -> assertionError.addSuppressed(arg_0));
            throw assertionError;
        }
        return bugReporter;
    }
}

