/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.android.build.gradle.tasks.AndroidJavaCompile;
import com.github.spotbugs.snom.SpotBugsTask;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.util.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpotBugsTaskFactory {
    private final Logger log = LoggerFactory.getLogger(SpotBugsTaskFactory.class);

    public void generate(Project project, Action<? super SpotBugsTask> configurationAction) {
        this.generateForJava(project, configurationAction);
        this.generateForAndroid(project, configurationAction);
    }

    private void generateForJava(Project project, Action<? super SpotBugsTask> configurationAction) {
        project.getPlugins().withType(JavaBasePlugin.class).configureEach(javaBasePlugin -> {
            JavaPluginConvention convention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            convention.getSourceSets().all(sourceSet -> {
                String name = sourceSet.getTaskName("spotbugs", null);
                this.log.debug("Creating SpotBugsTask for {}", sourceSet);
                project.getTasks().create(name, SpotBugsTask.class, task -> {
                    task.setSourceDirs(sourceSet.getAllSource().getSourceDirectories());
                    task.setClassDirs((FileCollection)sourceSet.getOutput());
                    task.setAuxClassPaths(sourceSet.getCompileClasspath());
                    configurationAction.execute((Object)task);
                });
            });
        });
    }

    private void generateForAndroid(Project project, Action<? super SpotBugsTask> configurationAction) {
        project.getPlugins().withId("com.android.application", plugin -> project.getTasks().withType(AndroidJavaCompile.class).all(task -> {
            String name = GUtil.toLowerCamelCase((CharSequence)("spotbugs " + task.getVariantName()));
            this.log.debug("Creating SpotBugsTask for {}", task);
            project.getTasks().register(name, SpotBugsTask.class, spotbugsTask -> {
                spotbugsTask.setSourceDirs((FileCollection)task.getSource());
                spotbugsTask.setClassDirs((FileCollection)task.getOutputDirectory().getAsFileTree());
                spotbugsTask.setAuxClassPaths(task.getClasspath());
                configurationAction.execute((Object)spotbugsTask);
            });
        }));
    }
}

