/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs;

import com.github.spotbugs.SpotBugsReports;
import com.github.spotbugs.internal.SpotBugsReportsImpl;
import com.github.spotbugs.internal.SpotBugsReportsInternal;
import com.github.spotbugs.internal.spotbugs.SpotBugsClasspathValidator;
import com.github.spotbugs.internal.spotbugs.SpotBugsRunner;
import com.github.spotbugs.internal.spotbugs.SpotBugsSpec;
import com.github.spotbugs.internal.spotbugs.SpotBugsSpecBuilder;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GradleVersion;
import org.gradle.workers.ForkMode;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class SpotBugsTask
extends SourceTask
implements VerificationTask,
Reporting<SpotBugsReports> {
    private FileCollection classes;
    private FileCollection classpath;
    private Set<File> sourceDirs;
    private FileCollection spotbugsClasspath;
    private FileCollection pluginClasspath;
    private boolean ignoreFailures;
    private boolean showProgress;
    private String effort;
    private String reportLevel;
    private String maxHeapSize;
    private Collection<String> visitors = new ArrayList<String>();
    private Collection<String> omitVisitors = new ArrayList<String>();
    private TextResource includeFilterConfig;
    private TextResource excludeFilterConfig;
    private TextResource excludeBugsFilterConfig;
    private Collection<String> extraArgs = new ArrayList<String>();
    private Collection<String> jvmArgs = new ArrayList<String>();
    @Nested
    private final SpotBugsReportsInternal reports;
    private final WorkerExecutor workerExecutor;

    @Inject
    public SpotBugsTask(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
        this.reports = this.createReports((Task)this);
    }

    private SpotBugsReportsInternal createReports(Task task) {
        return (SpotBugsReportsInternal)DeprecationLogger.whileDisabled(() -> {
            if (GradleVersion.current().compareTo(this.GRADLE_42()) < 0) {
                return new SpotBugsReportsImpl(task);
            }
            return (SpotBugsReportsImpl)this.getProject().getObjects().newInstance(SpotBugsReportsImpl.class, new Object[]{task});
        });
    }

    private GradleVersion GRADLE_42() {
        return GradleVersion.version((String)"4.2");
    }

    public SpotBugsReports getReports() {
        return this.reports;
    }

    public SpotBugsReports reports(Closure closure) {
        return this.reports(ConfigureUtil.configureUsing((Closure)closure));
    }

    public SpotBugsReports reports(Action<? super SpotBugsReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @Internal
    public File getIncludeFilter() {
        TextResource config = this.getIncludeFilterConfig();
        return config == null ? null : config.asFile();
    }

    public void setIncludeFilter(File filter) {
        this.setIncludeFilterConfig(this.getProject().getResources().getText().fromFile((Object)filter));
    }

    @Internal
    public File getExcludeFilter() {
        TextResource config = this.getExcludeFilterConfig();
        return config == null ? null : config.asFile();
    }

    public void setExcludeFilter(File filter) {
        this.setExcludeFilterConfig(this.getProject().getResources().getText().fromFile((Object)filter));
    }

    @Internal
    public File getExcludeBugsFilter() {
        TextResource config = this.getExcludeBugsFilterConfig();
        return config == null ? null : config.asFile();
    }

    public void setExcludeBugsFilter(File filter) {
        this.setExcludeBugsFilterConfig(this.getProject().getResources().getText().fromFile((Object)filter));
    }

    @TaskAction
    public void run() {
        new SpotBugsClasspathValidator(JavaVersion.current()).validateClasspath(this.getSpotbugsClasspath().getFiles().stream().map(File::getName).collect(Collectors.toSet()));
        SpotBugsSpec spec = this.generateSpec();
        if (this.reports.getEnabledReports().isEmpty()) {
            this.getProject().getLogger().lifecycle("WARNING: No SpotBugs report(s) were configured; aborting execution of {}", new Object[]{this.getPath()});
            return;
        }
        this.workerExecutor.submit(SpotBugsRunner.class, config -> {
            config.params(new Object[]{spec, this.getIgnoreFailures(), this.reports.getFirstEnabled().getDestination()});
            config.setClasspath((Iterable)this.getSpotbugsClasspath());
            config.setForkMode(ForkMode.ALWAYS);
            config.forkOptions(options -> {
                options.setDebug(spec.isDebugEnabled());
                options.setJvmArgs(spec.getJvmArgs());
                options.setMaxHeapSize(spec.getMaxHeapSize());
            });
            config.setIsolationMode(IsolationMode.PROCESS);
        });
    }

    SpotBugsSpec generateSpec() {
        SpotBugsSpecBuilder specBuilder = new SpotBugsSpecBuilder(this.getClasses()).withPluginsList(this.getPluginClasspath()).withSources(this.getAllSource()).withClasspath(this.getClasspath()).withShowProgress(this.getShowProgress()).withDebugging(this.getLogger().isDebugEnabled()).withEffort(this.getEffort()).withReportLevel(this.getReportLevel()).withMaxHeapSize(this.getMaxHeapSize()).withVisitors(this.getVisitors()).withOmitVisitors(this.getOmitVisitors()).withExcludeFilter(this.getExcludeFilter()).withIncludeFilter(this.getIncludeFilter()).withExcludeBugsFilter(this.getExcludeBugsFilter()).withExtraArgs(this.getExtraArgs()).withJvmArgs(this.getJvmArgs()).configureReports(this.getReports());
        return specBuilder.build();
    }

    public SpotBugsTask extraArgs(Iterable<String> arguments) {
        for (String argument : arguments) {
            this.extraArgs.add(argument);
        }
        return this;
    }

    public SpotBugsTask extraArgs(String ... arguments) {
        this.extraArgs.addAll(Arrays.asList(arguments));
        return this;
    }

    public SpotBugsTask jvmArgs(Iterable<String> arguments) {
        for (String argument : arguments) {
            this.jvmArgs.add(argument);
        }
        return this;
    }

    public SpotBugsTask jvmArgs(String ... arguments) {
        this.jvmArgs.addAll(Arrays.asList(arguments));
        return this;
    }

    SpotBugsTask setSourceSet(SourceSet sourceSet) {
        this.sourceDirs = sourceSet.getAllJava().getSrcDirs();
        this.setSource(this.sourceDirs);
        return this;
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Input
    @PathSensitive(value=PathSensitivity.RELATIVE)
    FileCollection getAllSource() {
        return this.getProject().files(new Object[]{this.sourceDirs}).plus((FileCollection)this.getSource());
    }

    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public FileCollection getClasses() {
        return this.classes;
    }

    public void setClasses(FileCollection classes) {
        this.classes = classes;
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Classpath
    public FileCollection getSpotbugsClasspath() {
        return this.spotbugsClasspath;
    }

    public void setSpotbugsClasspath(FileCollection spotbugsClasspath) {
        this.spotbugsClasspath = spotbugsClasspath;
    }

    @Classpath
    public FileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    public void setPluginClasspath(FileCollection pluginClasspath) {
        this.pluginClasspath = pluginClasspath;
    }

    @Input
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Input
    @Optional
    public boolean getShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }

    @Input
    @Optional
    public String getEffort() {
        return this.effort;
    }

    public void setEffort(String effort) {
        this.effort = effort;
    }

    @Input
    @Optional
    public String getReportLevel() {
        return this.reportLevel;
    }

    public void setReportLevel(String reportLevel) {
        this.reportLevel = reportLevel;
    }

    @Input
    @Optional
    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    @Input
    @Optional
    public Collection<String> getVisitors() {
        return this.visitors;
    }

    public void setVisitors(Collection<String> visitors) {
        this.visitors = visitors;
    }

    @Input
    @Optional
    public Collection<String> getOmitVisitors() {
        return this.omitVisitors;
    }

    public void setOmitVisitors(Collection<String> omitVisitors) {
        this.omitVisitors = omitVisitors;
    }

    @Incubating
    @Nested
    @Optional
    public TextResource getIncludeFilterConfig() {
        return this.includeFilterConfig;
    }

    public void setIncludeFilterConfig(TextResource includeFilterConfig) {
        this.includeFilterConfig = includeFilterConfig;
    }

    @Incubating
    @Nested
    @Optional
    public TextResource getExcludeFilterConfig() {
        return this.excludeFilterConfig;
    }

    public void setExcludeFilterConfig(TextResource excludeFilterConfig) {
        this.excludeFilterConfig = excludeFilterConfig;
    }

    @Incubating
    @Nested
    @Optional
    public TextResource getExcludeBugsFilterConfig() {
        return this.excludeBugsFilterConfig;
    }

    public void setExcludeBugsFilterConfig(TextResource excludeBugsFilterConfig) {
        this.excludeBugsFilterConfig = excludeBugsFilterConfig;
    }

    @Input
    @Optional
    public Collection<String> getExtraArgs() {
        return this.extraArgs;
    }

    public void setExtraArgs(Collection<String> extraArgs) {
        this.extraArgs = extraArgs;
    }

    @Input
    @Optional
    public Collection<String> getJvmArgs() {
        return this.jvmArgs;
    }

    public void setJvmArgs(Collection<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
    }
}

