/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.internal.spotbugs;

import com.github.spotbugs.internal.spotbugs.SpotBugsResult;
import com.github.spotbugs.internal.spotbugs.SpotBugsSpec;
import com.github.spotbugs.internal.spotbugs.SpotBugsWorker;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugs2;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.TextUICommandLine;
import java.io.IOException;
import java.util.List;

public class SpotBugsExecuter
implements SpotBugsWorker {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpotBugsResult runSpotbugs(SpotBugsSpec spec) throws IOException, InterruptedException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            List<String> args = spec.getArguments();
            String[] strArray = args.toArray(new String[0]);
            Thread.currentThread().setContextClassLoader(FindBugs2.class.getClassLoader());
            FindBugs2 findBugs2 = new FindBugs2();
            TextUICommandLine commandLine = new TextUICommandLine();
            FindBugs.processCommandLine((TextUICommandLine)commandLine, (String[])strArray, (IFindBugsEngine)findBugs2);
            findBugs2.execute();
            SpotBugsResult spotBugsResult = this.createSpotbugsResult((IFindBugsEngine)findBugs2);
            return spotBugsResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    SpotBugsResult createSpotbugsResult(IFindBugsEngine findBugs) {
        int bugCount = findBugs.getBugCount();
        int missingClassCount = findBugs.getMissingClassCount();
        int errorCount = findBugs.getErrorCount();
        return new SpotBugsResult(bugCount, missingClassCount, errorCount);
    }
}

