/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs;

import com.github.spotbugs.SpotBugsExtension;
import com.github.spotbugs.SpotBugsReports;
import com.github.spotbugs.SpotBugsTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.stream.StreamSupport;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.SourceSet;
import org.gradle.util.GradleVersion;

public class SpotBugsPlugin
extends AbstractCodeQualityPlugin<SpotBugsTask> {
    private static final GradleVersion SUPPORTED_VERSION = GradleVersion.version((String)"4.0");
    private SpotBugsExtension extension;

    protected String getToolName() {
        return "SpotBugs";
    }

    protected Class<SpotBugsTask> getTaskType() {
        return SpotBugsTask.class;
    }

    protected void beforeApply() {
        this.verifyGradleVersion(GradleVersion.current());
        this.configureSpotBugsConfigurations();
        this.project.afterEvaluate(this::verify);
    }

    private void verify(Project p) {
        p.getTasks().withType(SpotBugsTask.class).forEach(task -> {
            SpotBugsReports reports = task.getReports();
            if (reports.getText() != null && reports.getText().getDestination() == null) {
                String message = String.format("Task '%s' has no destination for TEXT report. Set reports.text.destination to this task.", task.getName());
                throw new IllegalStateException(message);
            }
            if (reports.getXml() != null && reports.getXml().getDestination() == null) {
                String message = String.format("Task '%s' has no destination for XML report. Set reports.xml.destination to this task.", task.getName());
                throw new IllegalStateException(message);
            }
            if (reports.getHtml() != null && reports.getHtml().getDestination() == null) {
                String message = String.format("Task '%s' has no destination for HTML report. Set reports.html.destination. to this task", task.getName());
                throw new IllegalStateException(message);
            }
            if (reports.getEmacs() != null && reports.getEmacs().getDestination() == null) {
                String message = String.format("Task '%s' has no destination for EMACS report. Set reports.emacs.destination. to this task", task.getName());
                throw new IllegalStateException(message);
            }
        });
    }

    void verifyGradleVersion(GradleVersion version) throws IllegalArgumentException {
        if (version.compareTo(SUPPORTED_VERSION) < 0) {
            String message = String.format("Gradle version %s is unsupported. Please use %s or later.", version, SUPPORTED_VERSION);
            throw new IllegalArgumentException(message);
        }
    }

    private void configureSpotBugsConfigurations() {
        Configuration configuration = (Configuration)this.project.getConfigurations().create("spotbugsPlugins");
        configuration.setVisible(false);
        configuration.setTransitive(true);
        configuration.setDescription("The SpotBugs plugins to be used for this project.");
    }

    protected CodeQualityExtension createExtension() {
        this.extension = (SpotBugsExtension)((Object)this.project.getExtensions().create("spotbugs", SpotBugsExtension.class, new Object[]{this.project}));
        this.extension.setToolVersion(this.loadToolVersion());
        return this.extension;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String loadToolVersion() {
        URL url = SpotBugsPlugin.class.getClassLoader().getResource("spotbugs-gradle-plugin.properties");
        try (InputStream input = url.openStream();){
            Properties prop = new Properties();
            prop.load(input);
            String string = prop.getProperty("spotbugs-version");
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void configureTaskDefaults(SpotBugsTask task, String baseName) {
        task.setPluginClasspath((FileCollection)this.project.getConfigurations().getAt("spotbugsPlugins"));
        Configuration configuration = this.project.getConfigurations().getAt("spotbugs");
        this.configureDefaultDependencies(configuration);
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies((Action)new Action<DependencySet>(){

            public void execute(DependencySet dependencies) {
                dependencies.add((Object)SpotBugsPlugin.this.project.getDependencies().create((Object)("com.github.spotbugs:spotbugs:" + SpotBugsPlugin.this.extension.getToolVersion())));
            }
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, SpotBugsTask task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("spotbugsClasspath", () -> configuration);
        taskMapping.map("ignoreFailures", (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return SpotBugsPlugin.this.extension.isIgnoreFailures();
            }
        });
        taskMapping.map("effort", (Callable)new Callable<String>(){

            @Override
            public String call() {
                return SpotBugsPlugin.this.extension.getEffort();
            }
        });
        taskMapping.map("reportLevel", (Callable)new Callable<String>(){

            @Override
            public String call() {
                return SpotBugsPlugin.this.extension.getReportLevel();
            }
        });
        taskMapping.map("visitors", (Callable)new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return SpotBugsPlugin.this.extension.getVisitors();
            }
        });
        taskMapping.map("omitVisitors", (Callable)new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return SpotBugsPlugin.this.extension.getOmitVisitors();
            }
        });
        taskMapping.map("excludeFilterConfig", (Callable)new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return SpotBugsPlugin.this.extension.getExcludeFilterConfig();
            }
        });
        taskMapping.map("includeFilterConfig", (Callable)new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return SpotBugsPlugin.this.extension.getIncludeFilterConfig();
            }
        });
        taskMapping.map("excludeBugsFilterConfig", (Callable)new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return SpotBugsPlugin.this.extension.getExcludeBugsFilterConfig();
            }
        });
        taskMapping.map("extraArgs", (Callable)new Callable<Collection<String>>(){

            @Override
            public Collection<String> call() {
                return SpotBugsPlugin.this.extension.getExtraArgs();
            }
        });
    }

    private void configureReportsConventionMapping(SpotBugsTask task, final String baseName) {
        task.getReports().all((Action)new Action<SingleFileReport>(){

            public void execute(final SingleFileReport report) {
                ConventionMapping reportMapping = SpotBugsPlugin.conventionMappingOf((Object)report);
                reportMapping.map("enabled", (Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() {
                        return report.getName().equals("xml");
                    }
                });
                reportMapping.map("destination", (Callable)new Callable<File>(){

                    @Override
                    public File call() {
                        return new File(SpotBugsPlugin.this.extension.getReportsDir(), baseName + "." + report.getName());
                    }
                });
            }
        });
    }

    protected void configureForSourceSet(final SourceSet sourceSet, SpotBugsTask task) {
        task.setDescription("Run SpotBugs analysis for " + sourceSet.getName() + " classes");
        task.setSource((FileTree)sourceSet.getAllJava());
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("classes", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                ConfigurableFileTree fileTree = StreamSupport.stream(sourceSet.getOutput().getClassesDirs().spliterator(), false).map(arg_0 -> ((ProjectInternal)SpotBugsPlugin.this.project).fileTree(arg_0)).reduce((lhs, rhs) -> {
                    lhs.plus((FileTree)rhs);
                    return lhs;
                }).orElseThrow(() -> new InvalidUserDataException("No classes dir configured for source set " + sourceSet.getName()));
                return fileTree.builtBy(new Object[]{sourceSet.getClassesTaskName()});
            }
        });
        taskMapping.map("classpath", (Callable)new Callable<FileCollection>(){

            @Override
            public FileCollection call() {
                return sourceSet.getCompileClasspath();
            }
        });
    }
}

