/*
 * Decompiled with CFR 0.152.
 */
package com.github.spotbugs.snom.internal;

import com.github.spotbugs.snom.SpotBugsReport;
import com.github.spotbugs.snom.SpotBugsTask;
import com.github.spotbugs.snom.internal.SpotBugsHtmlReport;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.resources.TextResource;
import org.gradle.api.resources.TextResourceFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\n\u001a\u0004\u0018\u00010\tH\u0016J \u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/spotbugs/snom/internal/SpotBugsHtmlReport;", "Lcom/github/spotbugs/snom/SpotBugsReport;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "task", "Lcom/github/spotbugs/snom/SpotBugsTask;", "(Lorg/gradle/api/model/ObjectFactory;Lcom/github/spotbugs/snom/SpotBugsTask;)V", "stylesheet", "Lorg/gradle/api/provider/Property;", "Lorg/gradle/api/resources/TextResource;", "getStylesheet", "resolve", "path", "", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "textResourceFactory", "Lorg/gradle/api/resources/TextResourceFactory;", "setStylesheet", "", "textResource", "toCommandLineOption", "spotbugs-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nSpotBugsHtmlReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpotBugsHtmlReport.kt\ncom/github/spotbugs/snom/internal/SpotBugsHtmlReport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1#2:83\n*E\n"})
public abstract class SpotBugsHtmlReport
extends SpotBugsReport {
    @NotNull
    private final Property<TextResource> stylesheet;

    @Inject
    public SpotBugsHtmlReport(@NotNull ObjectFactory objects, @NotNull SpotBugsTask task) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
        super(objects, task);
        this.getOutputLocation().convention(task.getReportsDir().file(task.getBaseName() + ".html"));
        Property property = task.getProject().getObjects().property(TextResource.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(...)");
        this.stylesheet = property;
    }

    @Override
    @NotNull
    public String toCommandLineOption() {
        Object object = this.stylesheet.map(arg_0 -> SpotBugsHtmlReport.toCommandLineOption$lambda$0(toCommandLineOption.1.INSTANCE, arg_0)).getOrElse((Object)"-html");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrElse(...)");
        return (String)object;
    }

    @Override
    @Nullable
    public TextResource getStylesheet() {
        return (TextResource)this.stylesheet.getOrNull();
    }

    private final TextResource resolve(String path, Configuration configuration, TextResourceFactory textResourceFactory) {
        Object v1;
        block2: {
            Set set = configuration.files(arg_0 -> SpotBugsHtmlReport.resolve$lambda$1(resolve.spotbugsJar.1.INSTANCE, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"files(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                File it = (File)t;
                boolean bl = false;
                if (!it.isFile()) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        File spotbugsJar2 = v1;
        if (spotbugsJar2 == null) {
            throw new InvalidUserDataException("The dependency on SpotBugs not found in 'spotbugs' configuration");
        }
        TextResource textResource = textResourceFactory.fromArchiveEntry((Object)spotbugsJar2, path);
        Intrinsics.checkNotNull((Object)textResource);
        return textResource;
    }

    @Override
    public void setStylesheet(@Nullable TextResource textResource) {
        this.stylesheet.set((Object)textResource);
    }

    @Override
    public void setStylesheet(@Nullable String path) {
        if (path == null) {
            this.stylesheet.set(null);
        } else {
            Configuration configuration = this.getTask().getProject().getConfigurations().getByName("spotbugs");
            TextResourceFactory textResourceFactory = this.getTask().getProject().getResources().getText();
            this.stylesheet.set(this.getTask().getProject().provider(() -> SpotBugsHtmlReport.setStylesheet$lambda$3(this, path, configuration, textResourceFactory)));
        }
    }

    private static final String toCommandLineOption$lambda$0(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(in);
    }

    private static final boolean resolve$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final TextResource setStylesheet$lambda$3(SpotBugsHtmlReport this$0, String $path, Configuration $configuration, TextResourceFactory $textResourceFactory) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNull((Object)$configuration);
        Intrinsics.checkNotNull((Object)$textResourceFactory);
        return this$0.resolve($path, $configuration, $textResourceFactory);
    }
}

