/*
 * Decompiled with CFR 0.152.
 */
package com.viewpagerindicator;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.viewpagerindicator.IconPagerAdapter;
import com.viewpagerindicator.IcsLinearLayout;
import com.viewpagerindicator.PageIndicator;
import com.viewpagerindicator.R;

public class TabPageIndicator
extends HorizontalScrollView
implements PageIndicator {
    private static final CharSequence EMPTY_TITLE = "";
    private Runnable mTabSelector;
    private final View.OnClickListener mTabClickListener = new View.OnClickListener(){

        public void onClick(View view) {
            TabView tabView = (TabView)view;
            int oldSelected = TabPageIndicator.this.mViewPager.getCurrentItem();
            int newSelected = tabView.getIndex();
            TabPageIndicator.this.mViewPager.setCurrentItem(newSelected);
            if (oldSelected == newSelected && TabPageIndicator.this.mTabReselectedListener != null) {
                TabPageIndicator.this.mTabReselectedListener.onTabReselected(newSelected);
            }
        }
    };
    private final IcsLinearLayout mTabLayout;
    private ViewPager mViewPager;
    private ViewPager.OnPageChangeListener mListener;
    private int mMaxTabWidth;
    private int mSelectedTabIndex;
    private OnTabReselectedListener mTabReselectedListener;

    public TabPageIndicator(Context context) {
        this(context, null);
    }

    public TabPageIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setHorizontalScrollBarEnabled(false);
        this.mTabLayout = new IcsLinearLayout(context, R.attr.vpiTabPageIndicatorStyle);
        this.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
    }

    public void setOnTabReselectedListener(OnTabReselectedListener listener) {
        this.mTabReselectedListener = listener;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        boolean lockedExpanded = widthMode == 0x40000000;
        this.setFillViewport(lockedExpanded);
        int childCount = this.mTabLayout.getChildCount();
        this.mMaxTabWidth = childCount > 1 && (widthMode == 0x40000000 || widthMode == Integer.MIN_VALUE) ? (childCount > 2 ? (int)((float)View.MeasureSpec.getSize((int)widthMeasureSpec) * 0.4f) : View.MeasureSpec.getSize((int)widthMeasureSpec) / 2) : -1;
        int oldWidth = this.getMeasuredWidth();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int newWidth = this.getMeasuredWidth();
        if (lockedExpanded && oldWidth != newWidth) {
            this.setCurrentItem(this.mSelectedTabIndex);
        }
    }

    private void animateToTab(int position) {
        final View tabView = this.mTabLayout.getChildAt(position);
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
        this.mTabSelector = new Runnable(){

            @Override
            public void run() {
                int scrollPos = tabView.getLeft() - (TabPageIndicator.this.getWidth() - tabView.getWidth()) / 2;
                TabPageIndicator.this.smoothScrollTo(scrollPos, 0);
                TabPageIndicator.this.mTabSelector = null;
            }
        };
        this.post(this.mTabSelector);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTabSelector != null) {
            this.post(this.mTabSelector);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
    }

    private void addTab(int index, CharSequence text, int iconResId) {
        TabView tabView = new TabView(this.getContext());
        tabView.mIndex = index;
        tabView.setFocusable(true);
        tabView.setOnClickListener(this.mTabClickListener);
        tabView.setText(text);
        if (iconResId != 0) {
            tabView.setCompoundDrawablesWithIntrinsicBounds(iconResId, 0, 0, 0);
        }
        this.mTabLayout.addView((View)tabView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
    }

    public void onPageScrollStateChanged(int arg0) {
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(arg0);
        }
    }

    public void onPageScrolled(int arg0, float arg1, int arg2) {
        if (this.mListener != null) {
            this.mListener.onPageScrolled(arg0, arg1, arg2);
        }
    }

    public void onPageSelected(int arg0) {
        this.setCurrentItem(arg0);
        if (this.mListener != null) {
            this.mListener.onPageSelected(arg0);
        }
    }

    @Override
    public void setViewPager(ViewPager view) {
        PagerAdapter adapter;
        if (this.mViewPager == view) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.setOnPageChangeListener(null);
        }
        if ((adapter = view.getAdapter()) == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.mViewPager = view;
        view.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.notifyDataSetChanged();
    }

    @Override
    public void notifyDataSetChanged() {
        this.mTabLayout.removeAllViews();
        PagerAdapter adapter = this.mViewPager.getAdapter();
        IconPagerAdapter iconAdapter = null;
        if (adapter instanceof IconPagerAdapter) {
            iconAdapter = (IconPagerAdapter)adapter;
        }
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            CharSequence title = adapter.getPageTitle(i);
            if (title == null) {
                title = EMPTY_TITLE;
            }
            int iconResId = 0;
            if (iconAdapter != null) {
                iconResId = iconAdapter.getIconResId(i);
            }
            this.addTab(i, title, iconResId);
        }
        if (this.mSelectedTabIndex > count) {
            this.mSelectedTabIndex = count - 1;
        }
        this.setCurrentItem(this.mSelectedTabIndex);
        this.requestLayout();
    }

    @Override
    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    @Override
    public void setCurrentItem(int item) {
        if (this.mViewPager == null) {
            throw new IllegalStateException("ViewPager has not been bound.");
        }
        this.mSelectedTabIndex = item;
        this.mViewPager.setCurrentItem(item);
        int tabCount = this.mTabLayout.getChildCount();
        for (int i = 0; i < tabCount; ++i) {
            View child = this.mTabLayout.getChildAt(i);
            boolean isSelected = i == item;
            child.setSelected(isSelected);
            if (!isSelected) continue;
            this.animateToTab(item);
        }
    }

    @Override
    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    private class TabView
    extends TextView {
        private int mIndex;

        public TabView(Context context) {
            super(context, null, R.attr.vpiTabPageIndicatorStyle);
        }

        public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (TabPageIndicator.this.mMaxTabWidth > 0 && this.getMeasuredWidth() > TabPageIndicator.this.mMaxTabWidth) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)TabPageIndicator.this.mMaxTabWidth, (int)0x40000000), heightMeasureSpec);
            }
        }

        public int getIndex() {
            return this.mIndex;
        }
    }

    public static interface OnTabReselectedListener {
        public void onTabReselected(int var1);
    }
}

