/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.stages;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.Directive;
import com.github.sommeri.less4j.core.ast.RuleSet;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.compiler.selectors.SelectorsManipulator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;

public class NestedInRulesetStack {
    private final SelectorsManipulator selectorsManipulator = new SelectorsManipulator();
    private Stack<List<Selector>> selectors = new Stack();
    private LinkedList<ASTCssNode> nestedNodes = new LinkedList();

    public NestedInRulesetStack(RuleSet topLevelNode) {
        this.pushSelectors(topLevelNode);
    }

    public void popSelectors() {
        this.selectors.pop();
    }

    public void pushSelectors(RuleSet kid) {
        this.selectors.push(new ArrayList<Selector>(kid.getSelectors()));
    }

    public List<ASTCssNode> getRulesets() {
        return this.nestedNodes;
    }

    public void collect(RuleSet nestedSet) {
        this.combine(nestedSet, this.selectors.peek());
        this.nestedNodes.add(nestedSet);
    }

    public void collect(Directive directive) {
        this.nestedNodes.add(directive);
    }

    private void combine(RuleSet ruleSet, List<Selector> previousSelectors) {
        ArrayList<Selector> result = new ArrayList<Selector>();
        for (Selector selector : ruleSet.getSelectors()) {
            result.addAll(this.selectorsManipulator.replaceAppenders(selector, previousSelectors));
        }
        ruleSet.replaceSelectors(result);
        ruleSet.configureParentToAllChilds();
    }

    public List<Selector> currentSelectors() {
        return this.selectors.peek();
    }
}

