/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.apifi.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sindaryn.apifi.service.ApiMetaOperations;
import org.sindaryn.apifi.service.EmbeddedCollectionMetaOperations;
import org.sindaryn.datafi.StaticUtils;
import org.sindaryn.datafi.persistence.Archivable;
import org.sindaryn.datafi.reflection.CachedEntityType;
import org.sindaryn.datafi.reflection.ReflectionCache;
import org.sindaryn.datafi.service.ArchivableDataManager;
import org.sindaryn.datafi.service.BaseDataManager;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public interface ApiLogic {
    public static <T, E extends ApiMetaOperations<T>> List<T> getAll(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, int limit, int offset) {
        metaOps.preFetchEntitiesInGetAll(clazz);
        List result = dataManager.findAll(clazz, (Pageable)ApiLogic.generatePageRequest(offset, limit, null, null)).getContent();
        metaOps.postFetchEntities(result);
        return result;
    }

    public static PageRequest generatePageRequest(int offset, int limit, String sortBy, Sort.Direction sortingDirection) {
        if (limit - offset <= 0 || limit < 0 || offset < 0) {
            throw new IllegalArgumentException("Invalid paging range");
        }
        if (sortBy != null) {
            return PageRequest.of((int)offset, (int)limit, (Sort)Sort.by((Sort.Direction)sortingDirection, (String[])new String[]{sortBy}));
        }
        return PageRequest.of((int)offset, (int)limit);
    }

    public static <T, E extends ApiMetaOperations<T>> T getById(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, Object id) {
        metaOps.preFetchEntityInGetById(id);
        T result = dataManager.findById(clazz, id).orElse(null);
        if (result == null) {
            StaticUtils.throwEntityNotFoundException((String)clazz.getSimpleName(), (Object)id);
        }
        metaOps.postFetchEntity(result);
        return result;
    }

    public static <T, E extends ApiMetaOperations<T>> T getByUnique(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, String resolverName, Object argument) {
        metaOps.preFetchEntityInGetByUnique(argument);
        T result = dataManager.getByUnique(clazz, resolverName, argument).orElse(null);
        if (result == null) {
            StaticUtils.throwEntityNotFoundException((String)clazz.getSimpleName(), (Object)argument);
        }
        metaOps.postFetchEntity(result);
        return result;
    }

    public static <T, E extends ApiMetaOperations<T>> List<T> getBy(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, String fieldName, Object argument) {
        metaOps.preFetchEntityInGetBy(argument);
        List result = dataManager.getBy(clazz, fieldName, argument);
        metaOps.postFetchEntities(result);
        return result;
    }

    public static <T, E extends ApiMetaOperations<T>> List<T> getAllBy(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, String resolverName, List<?> arguments) {
        metaOps.preFetchEntityInGetAllBy(arguments);
        List result = dataManager.getAllBy(clazz, resolverName, arguments.toArray());
        metaOps.postFetchEntities(result);
        return result;
    }

    public static <T, E extends ApiMetaOperations<T>> List<T> selectBy(Class<?> clazz, BaseDataManager<T> dataManager, E metaOps, String resolverName, List<?> arguments) {
        metaOps.preFetchEntityInCustomResolver(arguments);
        List result = dataManager.selectByResolver(clazz, resolverName, arguments.toArray());
        metaOps.postFetchEntities(result);
        return result;
    }

    public static <T, E extends ApiMetaOperations<T>> T add(BaseDataManager<T> dataManager, T input, E metaOps) {
        metaOps.preAddEntity(input);
        Object result = dataManager.save(input);
        metaOps.postAddEntity((Object)result);
        return (T)result;
    }

    public static <T, E extends ApiMetaOperations<T>> T update(BaseDataManager<T> dataManager, T input, ReflectionCache reflectionCache, E metaOps) {
        Object id = StaticUtils.getId(input, (ReflectionCache)reflectionCache);
        T toUpdate = ApiLogic.getById(input.getClass(), dataManager, metaOps, id);
        if (toUpdate == null) {
            ApiLogic.throw_entityNotFound(input, reflectionCache);
        }
        metaOps.preUpdateEntity(toUpdate);
        dataManager.cascadedUpdate(toUpdate, input);
        Object result = dataManager.save(toUpdate);
        metaOps.postUpdateEntity((Object)result);
        return (T)result;
    }

    public static <T, E extends ApiMetaOperations<T>> T delete(BaseDataManager<T> dataManager, ReflectionCache reflectionCache, T input, E metaOps) {
        Object id = StaticUtils.getId(input, (ReflectionCache)reflectionCache);
        T toDelete = ApiLogic.getById(input.getClass(), dataManager, metaOps, id);
        metaOps.preDeleteEntity(toDelete);
        dataManager.deleteById(input.getClass(), id);
        metaOps.postDeleteEntity(toDelete);
        return toDelete;
    }

    public static <T extends Archivable, E extends ApiMetaOperations<T>> T archive(ArchivableDataManager<T> dataManager, T input, ReflectionCache reflectionCache, E metaOps) {
        Object id = StaticUtils.getId(input, (ReflectionCache)reflectionCache);
        Archivable toArchive = (Archivable)ApiLogic.getById(input.getClass(), dataManager, metaOps, id);
        if (toArchive == null) {
            ApiLogic.throw_entityNotFound(input, reflectionCache);
        }
        metaOps.preArchiveEntity((Archivable)toArchive);
        input.setIsArchived(Boolean.valueOf(true));
        Archivable result = (Archivable)dataManager.save((Object)toArchive);
        metaOps.postArchiveEntity((Archivable)result);
        return (T)result;
    }

    public static <T extends Archivable, E extends ApiMetaOperations<T>> T deArchive(ArchivableDataManager<T> dataManager, T input, ReflectionCache reflectionCache, E metaOps) {
        Object id = StaticUtils.getId(input, (ReflectionCache)reflectionCache);
        Archivable toArchive = (Archivable)ApiLogic.getById(input.getClass(), dataManager, metaOps, id);
        if (toArchive == null) {
            ApiLogic.throw_entityNotFound(input, reflectionCache);
        }
        metaOps.preDeArchiveEntity((Archivable)toArchive);
        input.setIsArchived(Boolean.valueOf(false));
        Archivable result = (Archivable)dataManager.save((Object)toArchive);
        metaOps.postDeArchiveEntity((Archivable)result);
        return (T)result;
    }

    public static <T extends Archivable, E extends ApiMetaOperations<T>> List<T> archiveCollection(ArchivableDataManager<T> dataManager, List<T> input, E metaOps) {
        Class<?> clazz = ((Archivable)input.iterator().next()).getClass();
        List<Archivable> entitiesToArchive = ApiLogic.getCollectionById(clazz, dataManager, dataManager.idList(input));
        metaOps.preArchiveEntities(entitiesToArchive);
        entitiesToArchive.forEach(entity -> entity.setIsArchived(Boolean.valueOf(true)));
        List result = dataManager.saveAll(entitiesToArchive);
        metaOps.postArchiveEntities(result);
        return result;
    }

    public static <T extends Archivable, E extends ApiMetaOperations<T>> List<T> deArchiveCollection(ArchivableDataManager<T> dataManager, List<T> input, E metaOps) {
        Class<?> clazz = ((Archivable)input.iterator().next()).getClass();
        List<Archivable> entitiesToArchive = ApiLogic.getCollectionById(clazz, dataManager, dataManager.idList(input));
        metaOps.preDeArchiveEntities(entitiesToArchive);
        entitiesToArchive.forEach(entity -> entity.setIsArchived(Boolean.valueOf(false)));
        List result = dataManager.saveAll(entitiesToArchive);
        metaOps.postDeArchiveEntities(result);
        return result;
    }

    public static <T> List<T> getCollectionById(Class<?> clazz, BaseDataManager<T> dataManager, List<?> ids) {
        return dataManager.findAllById(clazz, ids);
    }

    public static <T, E extends ApiMetaOperations<T>> List<T> addCollection(BaseDataManager<T> dataManager, List<T> input, E metaOps) {
        metaOps.preAddEntities(input);
        List result = dataManager.saveAll(input);
        metaOps.postAddEntities(result);
        return result;
    }

    public static <T, E extends ApiMetaOperations<T>> List<T> updateCollection(BaseDataManager<T> dataManager, List<T> input, E metaOps) {
        Class<?> clazz = input.iterator().next().getClass();
        List<T> entitiesToUpdate = ApiLogic.getCollectionById(clazz, dataManager, dataManager.idList(input));
        metaOps.preUpdateEntities(entitiesToUpdate);
        List result = dataManager.cascadeUpdateCollection(entitiesToUpdate, input);
        metaOps.postUpdateEntities(result);
        return result;
    }

    public static <T, E extends ApiMetaOperations<T>> List<T> deleteCollection(BaseDataManager<T> dataManager, List<T> input, E metaOps) {
        Class<?> clazz = input.iterator().next().getClass();
        List<T> toDeletes = ApiLogic.getCollectionById(clazz, dataManager, dataManager.idList(input));
        metaOps.preDeleteEntities(toDeletes);
        dataManager.deleteInBatch(input);
        metaOps.postDeleteEntities(toDeletes);
        return toDeletes;
    }

    public static <T, HasTs> List<List<T>> getAsEmbeddedCollection(Class<?> clazz, BaseDataManager<T> dataManager, List<HasTs> input, String embeddedFieldName, ReflectionCache reflectioncache) {
        ArrayList lists = new ArrayList();
        input.forEach(IHasTs -> lists.add(dataManager.findAllById(clazz, (Iterable)dataManager.idList(ApiLogic.getEmbeddedCollectionFrom(IHasTs, embeddedFieldName, reflectioncache)))));
        return lists;
    }

    public static <T, HasT> List<T> getAsEmbeddedEntity(Class<?> clazz, BaseDataManager<T> dataManager, List<HasT> input, String fieldName, ReflectionCache reflectioncache) {
        ArrayList ids = new ArrayList();
        input.forEach(hasT -> {
            Object embeddedReference = ((CachedEntityType)reflectioncache.getEntitiesCache().get(hasT.getClass().getSimpleName())).invokeGetter(hasT, fieldName);
            ids.add(StaticUtils.getId((Object)embeddedReference, (ReflectionCache)reflectioncache));
        });
        return dataManager.findAllById(clazz, ids);
    }

    public static <T, HasTs, E extends EmbeddedCollectionMetaOperations<T, HasTs>> List<T> updateEmbeddedCollection(BaseDataManager<HasTs> collectionOwnerDataManager, BaseDataManager<T> toUpdateDataManager, HasTs collectionOwner, Iterable<T> toUpdate, E metaOps, ReflectionCache reflectioncache) {
        Object temp = collectionOwnerDataManager.findById(collectionOwner.getClass(), StaticUtils.getId(collectionOwner, (ReflectionCache)reflectioncache)).orElse(null);
        if (temp == null) {
            ApiLogic.throw_entityNotFound(collectionOwner, reflectioncache);
        }
        collectionOwner = temp;
        return ApiLogic.updateCollectionAsEmbedded(toUpdateDataManager, toUpdate, collectionOwner, metaOps);
    }

    public static <T, HasTs, E extends EmbeddedCollectionMetaOperations<T, HasTs>> List<T> updateCollectionAsEmbedded(BaseDataManager<T> toUpdateDataManager, Iterable<T> toUpdate, HasTs collectionOwner, E metaOps) {
        List<T> entitiesToUpdate = ApiLogic.getCollectionById(toUpdate.iterator().next().getClass(), toUpdateDataManager, toUpdateDataManager.idList(toUpdate));
        metaOps.preUpdate(entitiesToUpdate, collectionOwner);
        List result = toUpdateDataManager.cascadeUpdateCollection(entitiesToUpdate, toUpdate);
        metaOps.postUpdate(result, collectionOwner);
        return result;
    }

    public static <T, HasTs, E extends EmbeddedCollectionMetaOperations<T, HasTs>> List<T> addNewToEmbeddedCollection(BaseDataManager<HasTs> toAddToDataManager, BaseDataManager<T> toAddDataManager, HasTs toAddTo, String fieldName, List<T> toAdd, E metaOps, ReflectionCache reflectioncache) {
        Object temp = toAddToDataManager.findById(toAddTo.getClass(), StaticUtils.getId(toAddTo, (ReflectionCache)reflectioncache)).orElse(null);
        if (temp == null) {
            ApiLogic.throw_entityNotFound(toAddTo, reflectioncache);
        }
        toAddTo = temp;
        metaOps.preAttachOrAdd(toAdd, toAddTo);
        Collection<T> existingCollection = ApiLogic.getEmbeddedCollectionFrom(toAddTo, fieldName, reflectioncache);
        existingCollection.addAll(toAdd);
        ((CachedEntityType)reflectioncache.getEntitiesCache().get(toAddTo.getClass().getSimpleName())).invokeSetter(toAddTo, fieldName, existingCollection);
        HasTs hasTs = toAddTo;
        Collection<T> added = ApiLogic.getEmbeddedCollectionFrom(hasTs, fieldName, reflectioncache);
        List result = toAddDataManager.saveAll(ApiLogic.extractFromCollection(added, toAdd, reflectioncache));
        toAddToDataManager.save(hasTs);
        metaOps.postAttachOrAdd(result, toAddTo);
        return result;
    }

    public static <T, HasTs, E extends EmbeddedCollectionMetaOperations<T, HasTs>> List<T> attachExistingToEmbeddedCollection(BaseDataManager<HasTs> toAttachToDataManager, BaseDataManager<T> toAttachDataManager, HasTs toAttachTo, String embeddedFieldName, List<T> toAttach, E metaOps, ReflectionCache reflectioncache) {
        Object temp = toAttachToDataManager.findById(toAttachTo.getClass(), StaticUtils.getId(toAttachTo, (ReflectionCache)reflectioncache)).orElse(null);
        if (temp == null) {
            ApiLogic.throw_entityNotFound(toAttachTo, reflectioncache);
        }
        toAttachTo = temp;
        metaOps.preAttachOrAdd(toAttach, toAttachTo);
        List toAttachLoaded = toAttachDataManager.findAllById(ApiLogic.typeFromIterable(toAttach), (Iterable)toAttachDataManager.idList(toAttach));
        if (toAttachLoaded.isEmpty() || toAttachLoaded.size() != toAttach.size()) {
            throw new IllegalArgumentException("illegal attempt made to indirectly add new strong entities");
        }
        Collection<T> existingCollection = ApiLogic.getEmbeddedCollectionFrom(toAttachTo, StaticUtils.toCamelCase((String)embeddedFieldName), reflectioncache);
        existingCollection.addAll(toAttach);
        ((CachedEntityType)reflectioncache.getEntitiesCache().get(toAttachTo.getClass().getSimpleName())).invokeSetter(toAttachTo, StaticUtils.toCamelCase((String)embeddedFieldName), existingCollection);
        HasTs hasTs = toAttachTo;
        Object updatedToAttachTo = toAttachToDataManager.saveAndFlush(hasTs);
        Collection<T> attached = ApiLogic.getEmbeddedCollectionFrom(updatedToAttachTo, StaticUtils.toCamelCase((String)embeddedFieldName), reflectioncache);
        List<T> result = ApiLogic.extractFromCollection(attached, toAttach, reflectioncache);
        metaOps.postAttachOrAdd(result, toAttachTo);
        return result;
    }

    public static <T, HasTs, E extends EmbeddedCollectionMetaOperations<T, HasTs>> List<T> removeFromEmbeddedCollection(BaseDataManager<HasTs> toRemoveFromDataManager, BaseDataManager<T> toRemoveDataManager, HasTs toRemoveFrom, String toRemoveFieldName, List<T> toRemove, E metaOps, ReflectionCache reflectioncache) {
        Object temp = toRemoveFromDataManager.findById(toRemoveFrom.getClass(), StaticUtils.getId(toRemoveFrom, (ReflectionCache)reflectioncache)).orElse(null);
        if (temp == null) {
            ApiLogic.throw_entityNotFound(toRemoveFrom, reflectioncache);
        }
        toRemoveFrom = temp;
        Collection<T> currentEmbeddedCollection = ApiLogic.getEmbeddedCollectionFrom(toRemoveFrom, toRemoveFieldName, reflectioncache);
        metaOps.preRemove(toRemove, toRemoveFrom);
        currentEmbeddedCollection.removeIf(toRemove::contains);
        Object updatedToRemoveFrom = toRemoveFromDataManager.save(toRemoveFrom);
        Collection<T> attached = ApiLogic.getEmbeddedCollectionFrom(updatedToRemoveFrom, toRemoveFieldName, reflectioncache);
        metaOps.postRemove(toRemove, toRemoveFrom);
        return toRemove;
    }

    public static <T> List<T> extractFromCollection(Collection<T> toExtractFrom, Collection<T> toExtract, ReflectionCache reflectionCache) {
        ArrayList result = new ArrayList();
        toExtract.forEach(item -> result.add(ApiLogic.extract(toExtractFrom, item, reflectionCache)));
        return result;
    }

    public static <T> T extract(Collection<T> collection, T toCheck, ReflectionCache reflectionCache) {
        Object toCheckId = StaticUtils.getId(toCheck, (ReflectionCache)reflectionCache);
        for (T item : collection) {
            if (!StaticUtils.getId(item, (ReflectionCache)reflectionCache).equals(toCheckId)) continue;
            return item;
        }
        ApiLogic.throw_entityNotFound(toCheck, reflectionCache);
        return null;
    }

    public static void throw_entityNotFound(Object input, ReflectionCache reflectionCache) {
        throw new RuntimeException("Cannot find Entity " + input.getClass().getSimpleName() + " with id " + StaticUtils.getId((Object)input, (ReflectionCache)reflectionCache));
    }

    public static <T, HasTs> Collection<T> getEmbeddedCollectionFrom(HasTs iHasTs, String fieldName, ReflectionCache reflectioncache) {
        return (Collection)((CachedEntityType)reflectioncache.getEntitiesCache().get(iHasTs.getClass().getSimpleName())).invokeGetter(iHasTs, fieldName);
    }

    public static <T> Class<?> typeFromIterable(Iterable<T> iterable) {
        return iterable.iterator().next().getClass();
    }
}

