/*
 * Decompiled with CFR 0.152.
 */
package org.sindaryn.apifi.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.leangen.graphql.spqr.spring.annotations.GraphQLApi;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.transaction.Transactional;
import lombok.NonNull;
import org.sindaryn.apifi.StaticUtils;
import org.sindaryn.apifi.annotations.GraphQLApiEntity;
import org.sindaryn.apifi.generator.EntitiesInfoCache;
import org.sindaryn.apifi.generator.FieldSpecs;
import org.sindaryn.apifi.generator.MethodSpecs;
import org.sindaryn.apifi.security.SecurityAnnotationsHandler;
import org.sindaryn.datafi.annotations.GetAllBy;
import org.sindaryn.datafi.annotations.GetBy;
import org.sindaryn.datafi.annotations.GetByUnique;
import org.sindaryn.datafi.annotations.WithResolver;
import org.springframework.stereotype.Service;

public class GraphQLApiFactory {
    @NonNull
    private ProcessingEnvironment processingEnvironment;
    @NonNull
    private EntitiesInfoCache entitiesInfoCache;
    private FieldSpecs fieldSpecs;
    private MethodSpecs methodSpecs;
    private SecurityAnnotationsHandler securityAnnotationsHandler = new SecurityAnnotationsHandler();
    private Map<TypeName, FieldSpec> additionalDataManagers;

    protected void generateGraphQLService(TypeElement entity) {
        this.fieldSpecs = new FieldSpecs(this.processingEnvironment, this.entitiesInfoCache);
        this.methodSpecs = new MethodSpecs(this.processingEnvironment, this.securityAnnotationsHandler);
        this.additionalDataManagers = new HashMap<TypeName, FieldSpec>();
        String className = entity.getQualifiedName().toString();
        int lastDot = className.lastIndexOf(46);
        String packageName = className.substring(0, lastDot);
        String simpleClassName = className.substring(lastDot + 1);
        String serviceName = simpleClassName + "GraphQLService";
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)serviceName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Service.class).addAnnotation(Transactional.class).addAnnotation(GraphQLApi.class);
        GraphQLApiEntity apiEntityAnnotation = entity.getAnnotation(GraphQLApiEntity.class);
        if (apiEntityAnnotation.exposeDirectly()) {
            builder.addMethod(this.methodSpecs.generateGetAllEndpoint(entity)).addMethod(this.methodSpecs.generateGetByIdEndpoint(entity)).addMethod(this.methodSpecs.generateGetCollectionByIdEndpoint(entity));
            if (!apiEntityAnnotation.readOnly()) {
                builder.addMethod(this.methodSpecs.generateAddEndpoint(entity)).addMethod(this.methodSpecs.generateUpdateEndpoint(entity)).addMethod(this.methodSpecs.generateDeleteEndpoint(entity)).addMethod(this.methodSpecs.generateAddCollectionEndpoint(entity)).addMethod(this.methodSpecs.generateUpdateCollectionEndpoint(entity)).addMethod(this.methodSpecs.generateDeleteCollectionEndpoint(entity));
                if (StaticUtils.isArchivable(entity, this.processingEnvironment)) {
                    builder.addMethod(this.methodSpecs.generateArchiveEndpoint(entity)).addMethod(this.methodSpecs.generateDeArchiveEndpoint(entity)).addMethod(this.methodSpecs.generateArchiveCollectionEndpoint(entity)).addMethod(this.methodSpecs.generateDeArchiveCollectionEndpoint(entity));
                }
            }
        }
        builder.addField(this.fieldSpecs.metaOps(apiEntityAnnotation, entity)).addField(this.fieldSpecs.reflectionCache()).addField(this.fieldSpecs.dataManager(entity));
        for (VariableElement field : StaticUtils.getFields(entity)) {
            if (!this.isForeignKeyOrKeys(field)) continue;
            this.addEmbeddedFieldResolvers(entity, field, builder);
        }
        this.addGetByAndGetAllByResolvers(entity, builder);
        this.addCustomResolvers(entity, builder);
        this.handleSecurityAnnotations(builder, entity);
        org.sindaryn.datafi.StaticUtils.writeToJavaFile((String)simpleClassName, (String)packageName, (TypeSpec.Builder)builder, (ProcessingEnvironment)this.processingEnvironment, (String)"GraphQL Api Service Bean");
    }

    private void addCustomResolvers(TypeElement entity, TypeSpec.Builder builder) {
        WithResolver[] resolvers = (WithResolver[])entity.getAnnotationsByType(WithResolver.class);
        if (resolvers == null || resolvers.length <= 0) {
            return;
        }
        for (WithResolver resolver : resolvers) {
            builder.addMethod(this.methodSpecs.generateCustomResolverEndpoint(entity, resolver));
        }
    }

    private void addGetByAndGetAllByResolvers(TypeElement entity, TypeSpec.Builder builder) {
        for (VariableElement field : StaticUtils.getFields(entity)) {
            if (field.getAnnotation(GetAllBy.class) != null) {
                builder.addMethod(this.methodSpecs.generateGetByAllEndpoint(entity, field));
            }
            if (field.getAnnotation(GetBy.class) != null) {
                builder.addMethod(this.methodSpecs.generateGetByEndpoint(entity, field));
                continue;
            }
            if (field.getAnnotation(GetByUnique.class) == null) continue;
            builder.addMethod(this.methodSpecs.generateGetByUniqueEndpoint(entity, field));
        }
    }

    private boolean isForeignKeyOrKeys(VariableElement field) {
        return field.getAnnotation(OneToMany.class) != null || field.getAnnotation(ManyToOne.class) != null || field.getAnnotation(OneToOne.class) != null || field.getAnnotation(ManyToMany.class) != null;
    }

    private void addEmbeddedFieldResolvers(TypeElement entity, VariableElement field, TypeSpec.Builder builder) {
        if (field.getAnnotation(OneToMany.class) != null || field.getAnnotation(ManyToMany.class) != null) {
            builder.addMethod(this.methodSpecs.generateGetAsEmbeddedEntityCollection(field, entity));
            if (this.additionalDataManagers.get(ClassName.get((TypeMirror)field.asType())) == null) {
                List<? extends TypeMirror> typeArgs = ((DeclaredType)field.asType()).getTypeArguments();
                this.addDataManager(field, builder, typeArgs);
            }
            if (this.entitiesInfoCache.isStrongEntity(field)) {
                builder.addMethod(this.methodSpecs.generateAttachExistingToEmbeddedCollection(field, entity));
            } else {
                builder.addMethod(this.methodSpecs.generateAddNewToEmbeddedCollection(field, entity));
            }
            builder.addMethod(this.methodSpecs.generateUpdateEmbeddedCollection(field, entity));
            builder.addMethod(this.methodSpecs.generateRemoveFromEmbeddedCollection(field, entity));
            builder.addField(this.fieldSpecs.embeddedCollectionMetaOps(field));
        } else {
            this.addDataManager(field, builder, Collections.singletonList(field.asType()));
            builder.addMethod(this.methodSpecs.generateGetAsEmbeddedEntity(field, entity));
        }
    }

    private void addDataManager(VariableElement field, TypeSpec.Builder builder, List<? extends TypeMirror> typeArgs) {
        FieldSpec additionalDataManager = this.fieldSpecs.dataManager(typeArgs.iterator().next(), field.getSimpleName().toString());
        builder.addField(additionalDataManager);
        this.additionalDataManagers.put(ClassName.get((TypeMirror)field.asType()), additionalDataManager);
    }

    private void handleSecurityAnnotations(TypeSpec.Builder builder, TypeElement element) {
        Map.Entry<List<AnnotationSpec>, List<Class<? extends Annotation>>> entry = this.securityAnnotationsHandler.handleCRUD(element, new ArrayList<Class<? extends Annotation>>());
        List<AnnotationSpec> crudSecurityAnnotations = entry.getKey();
        if (!crudSecurityAnnotations.isEmpty()) {
            builder.addAnnotations(crudSecurityAnnotations);
        }
    }

    public GraphQLApiFactory(@NonNull ProcessingEnvironment processingEnvironment, @NonNull EntitiesInfoCache entitiesInfoCache) {
        if (processingEnvironment == null) {
            throw new NullPointerException("processingEnvironment is marked non-null but is null");
        }
        if (entitiesInfoCache == null) {
            throw new NullPointerException("entitiesInfoCache is marked non-null but is null");
        }
        this.processingEnvironment = processingEnvironment;
        this.entitiesInfoCache = entitiesInfoCache;
    }
}

