/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog;

import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class BinaryLogFileReader
implements Closeable {
    public static final byte[] MAGIC_HEADER = new byte[]{-2, 98, 105, 110};
    private final ByteArrayInputStream inputStream;
    private final EventDeserializer eventDeserializer;

    public BinaryLogFileReader(File file) throws IOException {
        this(file, new EventDeserializer());
    }

    public BinaryLogFileReader(File file, EventDeserializer eventDeserializer) throws IOException {
        this(file != null ? new BufferedInputStream(new FileInputStream(file)) : null, eventDeserializer);
    }

    public BinaryLogFileReader(InputStream inputStream) throws IOException {
        this(inputStream, new EventDeserializer());
    }

    public BinaryLogFileReader(InputStream inputStream, EventDeserializer eventDeserializer) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream cannot be NULL");
        }
        if (eventDeserializer == null) {
            throw new IllegalArgumentException("Event deserializer cannot be NULL");
        }
        this.inputStream = new ByteArrayInputStream(inputStream);
        try {
            byte[] magicHeader = this.inputStream.read(MAGIC_HEADER.length);
            if (!Arrays.equals(magicHeader, MAGIC_HEADER)) {
                throw new IOException("Not a valid binary log");
            }
        }
        catch (IOException e) {
            try {
                this.inputStream.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            throw e;
        }
        this.eventDeserializer = eventDeserializer;
    }

    public Event readEvent() throws IOException {
        return this.eventDeserializer.nextEvent(this.inputStream);
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

