/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog;

import com.github.shyiko.mysql.binlog.GtidSet;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.ChecksumType;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializationException;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.GtidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.RotateEventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import com.github.shyiko.mysql.binlog.jmx.BinaryLogClientMXBean;
import com.github.shyiko.mysql.binlog.network.AuthenticationException;
import com.github.shyiko.mysql.binlog.network.DefaultSSLSocketFactory;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import com.github.shyiko.mysql.binlog.network.SSLSocketFactory;
import com.github.shyiko.mysql.binlog.network.ServerException;
import com.github.shyiko.mysql.binlog.network.SocketFactory;
import com.github.shyiko.mysql.binlog.network.TLSHostnameVerifier;
import com.github.shyiko.mysql.binlog.network.protocol.ErrorPacket;
import com.github.shyiko.mysql.binlog.network.protocol.GreetingPacket;
import com.github.shyiko.mysql.binlog.network.protocol.PacketChannel;
import com.github.shyiko.mysql.binlog.network.protocol.ResultSetRowPacket;
import com.github.shyiko.mysql.binlog.network.protocol.command.AuthenticateCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.Command;
import com.github.shyiko.mysql.binlog.network.protocol.command.DumpBinaryLogCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.DumpBinaryLogGtidCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.PingCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.QueryCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.SSLRequestCommand;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class BinaryLogClient
implements BinaryLogClientMXBean {
    private static final SSLSocketFactory DEFAULT_REQUIRED_SSL_MODE_SOCKET_FACTORY = new DefaultSSLSocketFactory(){

        @Override
        protected void initSSLContext(SSLContext sc) throws GeneralSecurityException {
            sc.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, null);
        }
    };
    private static final SSLSocketFactory DEFAULT_VERIFY_CA_SSL_MODE_SOCKET_FACTORY = new DefaultSSLSocketFactory();
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String hostname;
    private final int port;
    private final String schema;
    private final String username;
    private final String password;
    private boolean blocking = true;
    private long serverId = 65535L;
    private volatile String binlogFilename;
    private volatile long binlogPosition = 4L;
    private volatile long connectionId;
    private SSLMode sslMode = SSLMode.DISABLED;
    private GtidSet gtidSet;
    private final Object gtidSetAccessLock = new Object();
    private EventDeserializer eventDeserializer = new EventDeserializer();
    private final List<EventListener> eventListeners = new LinkedList<EventListener>();
    private final List<LifecycleListener> lifecycleListeners = new LinkedList<LifecycleListener>();
    private SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private volatile PacketChannel channel;
    private volatile boolean connected;
    private ThreadFactory threadFactory;
    private boolean keepAlive = true;
    private long keepAliveInterval = TimeUnit.MINUTES.toMillis(1L);
    private long heartbeatInterval;
    private volatile long heartbeatLastSeen;
    private long connectTimeout = TimeUnit.SECONDS.toMillis(3L);
    private volatile ExecutorService keepAliveThreadExecutor;
    private final Lock connectLock = new ReentrantLock();

    public BinaryLogClient(String username, String password) {
        this("localhost", 3306, null, username, password);
    }

    public BinaryLogClient(String schema, String username, String password) {
        this("localhost", 3306, schema, username, password);
    }

    public BinaryLogClient(String hostname, int port, String username, String password) {
        this(hostname, port, null, username, password);
    }

    public BinaryLogClient(String hostname, int port, String schema, String username, String password) {
        this.hostname = hostname;
        this.port = port;
        this.schema = schema;
        this.username = username;
        this.password = password;
    }

    public boolean isBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        this.blocking = blocking;
    }

    public SSLMode getSSLMode() {
        return this.sslMode;
    }

    public void setSSLMode(SSLMode sslMode) {
        if (sslMode == null) {
            throw new IllegalArgumentException("SSL mode cannot be NULL");
        }
        this.sslMode = sslMode;
    }

    public long getServerId() {
        return this.serverId;
    }

    public void setServerId(long serverId) {
        this.serverId = serverId;
    }

    @Override
    public String getBinlogFilename() {
        return this.binlogFilename;
    }

    @Override
    public void setBinlogFilename(String binlogFilename) {
        this.binlogFilename = binlogFilename;
    }

    @Override
    public long getBinlogPosition() {
        return this.binlogPosition;
    }

    @Override
    public void setBinlogPosition(long binlogPosition) {
        this.binlogPosition = binlogPosition;
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGtidSet() {
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            return this.gtidSet != null ? this.gtidSet.toString() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGtidSet(String gtidSet) {
        if (gtidSet != null && this.binlogFilename == null) {
            this.binlogFilename = "";
        }
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            this.gtidSet = gtidSet != null ? new GtidSet(gtidSet) : null;
        }
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public long getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(long keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public long getKeepAliveConnectTimeout() {
        return this.connectTimeout;
    }

    public void setKeepAliveConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setEventDeserializer(EventDeserializer eventDeserializer) {
        if (eventDeserializer == null) {
            throw new IllegalArgumentException("Event deserializer cannot be NULL");
        }
        this.eventDeserializer = eventDeserializer;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws IOException {
        if (!this.connectLock.tryLock()) {
            throw new IllegalStateException("BinaryLogClient is already connected");
        }
        boolean notifyWhenDisconnected = false;
        try {
            Object checksumType;
            Callable cancelDisconnect = null;
            try {
                try {
                    long start = System.currentTimeMillis();
                    this.channel = this.openChannel();
                    if (this.connectTimeout > 0L && !this.isKeepAliveThreadRunning()) {
                        cancelDisconnect = this.scheduleDisconnectIn(this.connectTimeout - (System.currentTimeMillis() - start));
                    }
                    if (this.channel.getInputStream().peek() == -1) {
                        throw new EOFException();
                    }
                }
                catch (IOException e) {
                    throw new IOException("Failed to connect to MySQL on " + this.hostname + ":" + this.port + ". Please make sure it's running.", e);
                }
                GreetingPacket greetingPacket = this.receiveGreeting();
                this.authenticate(greetingPacket);
                this.connectionId = greetingPacket.getThreadId();
                if (this.binlogFilename == null) {
                    this.fetchBinlogFilenameAndPosition();
                }
                if (this.binlogPosition < 4L) {
                    if (this.logger.isLoggable(Level.WARNING)) {
                        this.logger.warning("Binary log position adjusted from " + this.binlogPosition + " to " + 4);
                    }
                    this.binlogPosition = 4L;
                }
                if ((checksumType = this.fetchBinlogChecksum()) != ChecksumType.NONE) {
                    this.confirmSupportOfChecksum((ChecksumType)((Object)checksumType));
                }
                if (this.heartbeatInterval > 0L) {
                    this.enableHeartbeat();
                }
                this.requestBinaryLogStream();
            }
            catch (IOException e) {
                this.disconnectChannel();
                throw e;
            }
            finally {
                block45: {
                    if (cancelDisconnect != null) {
                        try {
                            cancelDisconnect.call();
                        }
                        catch (Exception e) {
                            if (!this.logger.isLoggable(Level.WARNING)) break block45;
                            this.logger.warning("\"" + e.getMessage() + "\" was thrown while canceling scheduled disconnect call");
                        }
                    }
                }
            }
            this.connected = true;
            notifyWhenDisconnected = true;
            if (this.logger.isLoggable(Level.INFO)) {
                String position;
                checksumType = this.gtidSetAccessLock;
                synchronized (checksumType) {
                    position = this.gtidSet != null ? this.gtidSet.toString() : this.binlogFilename + "/" + this.binlogPosition;
                }
                this.logger.info("Connected to " + this.hostname + ":" + this.port + " at " + position + " (" + (this.blocking ? "sid:" + this.serverId + ", " : "") + "cid:" + this.connectionId + ")");
            }
            Iterator<LifecycleListener> iterator = this.lifecycleListeners;
            synchronized (iterator) {
                for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                    lifecycleListener.onConnect(this);
                }
            }
            if (this.keepAlive && !this.isKeepAliveThreadRunning()) {
                this.spawnKeepAliveThread();
            }
            this.ensureEventDataDeserializer(EventType.ROTATE, RotateEventDataDeserializer.class);
            iterator = this.gtidSetAccessLock;
            synchronized (iterator) {
                if (this.gtidSet != null) {
                    this.ensureEventDataDeserializer(EventType.GTID, GtidEventDataDeserializer.class);
                }
            }
            this.listenForEventPackets();
        }
        finally {
            this.connectLock.unlock();
            if (notifyWhenDisconnected) {
                List<LifecycleListener> list = this.lifecycleListeners;
                synchronized (list) {
                    for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                        lifecycleListener.onDisconnect(this);
                    }
                }
            }
        }
    }

    private PacketChannel openChannel() throws IOException {
        Socket socket = this.socketFactory != null ? this.socketFactory.createSocket() : new Socket();
        socket.connect(new InetSocketAddress(this.hostname, this.port), (int)this.connectTimeout);
        return new PacketChannel(socket);
    }

    private Callable scheduleDisconnectIn(final long timeout) {
        final BinaryLogClient self = this;
        final CountDownLatch connectLatch = new CountDownLatch(1);
        final Thread thread = this.newNamedThread(new Runnable(){

            @Override
            public void run() {
                block7: {
                    block6: {
                        try {
                            connectLatch.await(timeout, TimeUnit.MILLISECONDS);
                        }
                        catch (InterruptedException e) {
                            if (!BinaryLogClient.this.logger.isLoggable(Level.WARNING)) break block6;
                            BinaryLogClient.this.logger.log(Level.WARNING, e.getMessage());
                        }
                    }
                    if (connectLatch.getCount() != 0L) {
                        if (BinaryLogClient.this.logger.isLoggable(Level.WARNING)) {
                            BinaryLogClient.this.logger.warning("Failed to establish connection in " + timeout + "ms. " + "Forcing disconnect.");
                        }
                        try {
                            self.disconnectChannel();
                        }
                        catch (IOException e) {
                            if (!BinaryLogClient.this.logger.isLoggable(Level.WARNING)) break block7;
                            BinaryLogClient.this.logger.log(Level.WARNING, e.getMessage());
                        }
                    }
                }
            }
        }, "blc-disconnect-" + this.hostname + ":" + this.port);
        thread.start();
        return new Callable(){

            public Object call() throws Exception {
                connectLatch.countDown();
                thread.join();
                return null;
            }
        };
    }

    private GreetingPacket receiveGreeting() throws IOException {
        byte[] initialHandshakePacket = this.channel.read();
        if (initialHandshakePacket[0] == -1) {
            byte[] bytes = Arrays.copyOfRange(initialHandshakePacket, 1, initialHandshakePacket.length);
            ErrorPacket errorPacket = new ErrorPacket(bytes);
            throw new ServerException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
        }
        return new GreetingPacket(initialHandshakePacket);
    }

    private void enableHeartbeat() throws IOException {
        this.channel.write(new QueryCommand("set @master_heartbeat_period=" + this.heartbeatInterval * 1000000L));
        byte[] statementResult = this.channel.read();
        if (statementResult[0] == -1) {
            byte[] bytes = Arrays.copyOfRange(statementResult, 1, statementResult.length);
            ErrorPacket errorPacket = new ErrorPacket(bytes);
            throw new ServerException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestBinaryLogStream() throws IOException {
        Command dumpBinaryLogCommand;
        long serverId = this.blocking ? this.serverId : 0L;
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            dumpBinaryLogCommand = this.gtidSet != null ? new DumpBinaryLogGtidCommand(serverId, this.binlogFilename, this.binlogPosition, this.gtidSet) : new DumpBinaryLogCommand(serverId, this.binlogFilename, this.binlogPosition);
        }
        this.channel.write(dumpBinaryLogCommand);
    }

    private void ensureEventDataDeserializer(EventType eventType, Class<? extends EventDataDeserializer> eventDataDeserializerClass) {
        EventDataDeserializer eventDataDeserializer = this.eventDeserializer.getEventDataDeserializer(eventType);
        if (eventDataDeserializer.getClass() != eventDataDeserializerClass && eventDataDeserializer.getClass() != EventDeserializer.EventDataWrapper.Deserializer.class) {
            EventDataDeserializer internalEventDataDeserializer;
            try {
                internalEventDataDeserializer = eventDataDeserializerClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.eventDeserializer.setEventDataDeserializer(eventType, new EventDeserializer.EventDataWrapper.Deserializer(internalEventDataDeserializer, eventDataDeserializer));
        }
    }

    private void authenticate(GreetingPacket greetingPacket) throws IOException {
        int collation = greetingPacket.getServerCollation();
        int packetNumber = 1;
        if (this.sslMode != SSLMode.DISABLED) {
            boolean serverSupportsSSL;
            boolean bl = serverSupportsSSL = (greetingPacket.getServerCapabilities() & 0x800) != 0;
            if (!(serverSupportsSSL || this.sslMode != SSLMode.REQUIRED && this.sslMode != SSLMode.VERIFY_CA && this.sslMode != SSLMode.VERIFY_IDENTITY)) {
                throw new IOException("MySQL server does not support SSL");
            }
            if (serverSupportsSSL) {
                SSLRequestCommand sslRequestCommand = new SSLRequestCommand();
                sslRequestCommand.setCollation(collation);
                this.channel.write(sslRequestCommand, packetNumber++);
                SSLSocketFactory sslSocketFactory = this.sslSocketFactory != null ? this.sslSocketFactory : (this.sslMode == SSLMode.REQUIRED || this.sslMode == SSLMode.PREFERRED ? DEFAULT_REQUIRED_SSL_MODE_SOCKET_FACTORY : DEFAULT_VERIFY_CA_SSL_MODE_SOCKET_FACTORY);
                this.channel.upgradeToSSL(sslSocketFactory, this.sslMode == SSLMode.VERIFY_IDENTITY ? new TLSHostnameVerifier() : null);
            }
        }
        AuthenticateCommand authenticateCommand = new AuthenticateCommand(this.schema, this.username, this.password, greetingPacket.getScramble());
        authenticateCommand.setCollation(collation);
        this.channel.write(authenticateCommand, packetNumber);
        byte[] authenticationResult = this.channel.read();
        if (authenticationResult[0] != 0) {
            if (authenticationResult[0] == -1) {
                byte[] bytes = Arrays.copyOfRange(authenticationResult, 1, authenticationResult.length);
                ErrorPacket errorPacket = new ErrorPacket(bytes);
                throw new AuthenticationException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
            }
            throw new AuthenticationException("Unexpected authentication result (" + authenticationResult[0] + ")");
        }
    }

    private void spawnKeepAliveThread() {
        final ExecutorService threadExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                return BinaryLogClient.this.newNamedThread(runnable, "blc-keepalive-" + BinaryLogClient.this.hostname + ":" + BinaryLogClient.this.port);
            }
        });
        threadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                while (!threadExecutor.isShutdown()) {
                    try {
                        Thread.sleep(BinaryLogClient.this.keepAliveInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (threadExecutor.isShutdown()) {
                        return;
                    }
                    boolean connectionLost = false;
                    if (BinaryLogClient.this.heartbeatInterval > 0L) {
                        connectionLost = System.currentTimeMillis() - BinaryLogClient.this.heartbeatLastSeen > BinaryLogClient.this.keepAliveInterval;
                    } else {
                        try {
                            BinaryLogClient.this.channel.write(new PingCommand());
                        }
                        catch (IOException e) {
                            connectionLost = true;
                        }
                    }
                    if (!connectionLost) continue;
                    if (BinaryLogClient.this.logger.isLoggable(Level.INFO)) {
                        BinaryLogClient.this.logger.info("Trying to restore lost connection to " + BinaryLogClient.this.hostname + ":" + BinaryLogClient.this.port);
                    }
                    try {
                        BinaryLogClient.this.terminateConnect();
                        BinaryLogClient.this.connect(BinaryLogClient.this.connectTimeout);
                    }
                    catch (Exception ce) {
                        if (!BinaryLogClient.this.logger.isLoggable(Level.WARNING)) continue;
                        BinaryLogClient.this.logger.warning("Failed to restore connection to " + BinaryLogClient.this.hostname + ":" + BinaryLogClient.this.port + ". Next attempt in " + BinaryLogClient.this.keepAliveInterval + "ms");
                    }
                }
            }
        });
        this.keepAliveThreadExecutor = threadExecutor;
    }

    private Thread newNamedThread(Runnable runnable, String threadName) {
        Thread thread = this.threadFactory == null ? new Thread(runnable) : this.threadFactory.newThread(runnable);
        thread.setName(threadName);
        return thread;
    }

    boolean isKeepAliveThreadRunning() {
        return this.keepAliveThreadExecutor != null && !this.keepAliveThreadExecutor.isShutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(final long timeout) throws IOException, TimeoutException {
        boolean started;
        AtomicReference exceptionReference;
        AbstractLifecycleListener connectListener;
        block7: {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            connectListener = new AbstractLifecycleListener(){

                @Override
                public void onConnect(BinaryLogClient client) {
                    countDownLatch.countDown();
                }
            };
            this.registerLifecycleListener(connectListener);
            exceptionReference = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        BinaryLogClient.this.setConnectTimeout(timeout);
                        BinaryLogClient.this.connect();
                    }
                    catch (IOException e) {
                        exceptionReference.set(e);
                        countDownLatch.countDown();
                    }
                }
            };
            this.newNamedThread(runnable, "blc-" + this.hostname + ":" + this.port).start();
            started = false;
            try {
                started = countDownLatch.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block7;
                this.logger.log(Level.WARNING, e.getMessage());
            }
        }
        this.unregisterLifecycleListener(connectListener);
        if (exceptionReference.get() != null) {
            throw (IOException)exceptionReference.get();
        }
        if (!started) {
            try {
                this.terminateConnect();
            }
            finally {
                throw new TimeoutException("BinaryLogClient was unable to connect in " + timeout + "ms");
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    private void fetchBinlogFilenameAndPosition() throws IOException {
        this.channel.write(new QueryCommand("show master status"));
        ResultSetRowPacket[] resultSet = this.readResultSet();
        if (resultSet.length == 0) {
            throw new IOException("Failed to determine binlog filename/position");
        }
        ResultSetRowPacket resultSetRow = resultSet[0];
        this.binlogFilename = resultSetRow.getValue(0);
        this.binlogPosition = Long.parseLong(resultSetRow.getValue(1));
    }

    private ChecksumType fetchBinlogChecksum() throws IOException {
        this.channel.write(new QueryCommand("show global variables like 'binlog_checksum'"));
        ResultSetRowPacket[] resultSet = this.readResultSet();
        if (resultSet.length == 0) {
            return ChecksumType.NONE;
        }
        return ChecksumType.valueOf(resultSet[0].getValue(1).toUpperCase());
    }

    private void confirmSupportOfChecksum(ChecksumType checksumType) throws IOException {
        this.channel.write(new QueryCommand("set @master_binlog_checksum= @@global.binlog_checksum"));
        byte[] statementResult = this.channel.read();
        if (statementResult[0] == -1) {
            byte[] bytes = Arrays.copyOfRange(statementResult, 1, statementResult.length);
            ErrorPacket errorPacket = new ErrorPacket(bytes);
            throw new ServerException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
        }
        this.eventDeserializer.setChecksumType(checksumType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void listenForEventPackets() throws IOException {
        ByteArrayInputStream inputStream = this.channel.getInputStream();
        boolean completeShutdown = false;
        try {
            while (inputStream.peek() != -1) {
                Event event;
                int packetLength = inputStream.readInteger(3);
                inputStream.skip(1L);
                int marker = inputStream.read();
                if (marker == 255) {
                    ErrorPacket errorPacket = new ErrorPacket(inputStream.read(packetLength - 1));
                    throw new ServerException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
                }
                if (marker == 254 && !this.blocking) {
                    completeShutdown = true;
                    return;
                }
                try {
                    event = this.eventDeserializer.nextEvent(packetLength == 0xFFFFFF ? new ByteArrayInputStream(this.readPacketSplitInChunks(inputStream, packetLength - 1)) : inputStream);
                    if (event == null) {
                        throw new EOFException();
                    }
                }
                catch (Exception e) {
                    Throwable cause = e instanceof EventDataDeserializationException ? e.getCause() : e;
                    if (cause instanceof EOFException) throw e;
                    if (cause instanceof SocketException) {
                        throw e;
                    }
                    if (!this.isConnected()) continue;
                    List<LifecycleListener> list = this.lifecycleListeners;
                    synchronized (list) {
                        for (LifecycleListener lifecycleListener : this.lifecycleListeners) {
                            lifecycleListener.onEventDeserializationFailure(this, e);
                        }
                        continue;
                    }
                }
                if (!this.isConnected()) continue;
                if (event.getHeader().getEventType() == EventType.HEARTBEAT) {
                    this.heartbeatLastSeen = System.currentTimeMillis();
                }
                this.updateGtidSet(event);
                this.notifyEventListeners(event);
                this.updateClientBinlogFilenameAndPosition(event);
            }
            return;
        }
        catch (Exception e) {
            if (!this.isConnected()) return;
            List<LifecycleListener> list = this.lifecycleListeners;
            synchronized (list) {
                Iterator<LifecycleListener> iterator = this.lifecycleListeners.iterator();
                while (iterator.hasNext()) {
                    LifecycleListener lifecycleListener = iterator.next();
                    lifecycleListener.onCommunicationFailure(this, e);
                }
                return;
            }
        }
        finally {
            if (this.isConnected()) {
                if (completeShutdown) {
                    this.disconnect();
                } else {
                    this.disconnectChannel();
                }
            }
        }
    }

    private byte[] readPacketSplitInChunks(ByteArrayInputStream inputStream, int packetLength) throws IOException {
        int chunkLength;
        byte[] result = inputStream.read(packetLength);
        do {
            chunkLength = inputStream.readInteger(3);
            inputStream.skip(1L);
            result = Arrays.copyOf(result, result.length + chunkLength);
            inputStream.fill(result, result.length - chunkLength, chunkLength);
        } while (chunkLength == 0xFFFFFF);
        return result;
    }

    private void updateClientBinlogFilenameAndPosition(Event event) {
        EventHeaderV4 trackableEventHeader;
        long nextBinlogPosition;
        Object eventHeader = event.getHeader();
        EventType eventType = eventHeader.getEventType();
        if (eventType == EventType.ROTATE) {
            Object eventData = event.getData();
            RotateEventData rotateEventData = eventData instanceof EventDeserializer.EventDataWrapper ? (RotateEventData)((EventDeserializer.EventDataWrapper)eventData).getInternal() : (RotateEventData)eventData;
            this.binlogFilename = rotateEventData.getBinlogFilename();
            this.binlogPosition = rotateEventData.getBinlogPosition();
        } else if (eventType != EventType.TABLE_MAP && eventHeader instanceof EventHeaderV4 && (nextBinlogPosition = (trackableEventHeader = (EventHeaderV4)eventHeader).getNextPosition()) > 0L) {
            this.binlogPosition = nextBinlogPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGtidSet(Event event) {
        Object eventHeader = event.getHeader();
        if (eventHeader.getEventType() == EventType.GTID) {
            Object object = this.gtidSetAccessLock;
            synchronized (object) {
                if (this.gtidSet != null) {
                    Object eventData = event.getData();
                    GtidEventData gtidEventData = eventData instanceof EventDeserializer.EventDataWrapper ? (GtidEventData)((EventDeserializer.EventDataWrapper)eventData).getInternal() : (GtidEventData)eventData;
                    this.gtidSet.add(gtidEventData.getGtid());
                }
            }
        }
    }

    private ResultSetRowPacket[] readResultSet() throws IOException {
        byte[] bytes;
        LinkedList<ResultSetRowPacket> resultSet = new LinkedList<ResultSetRowPacket>();
        byte[] statementResult = this.channel.read();
        if (statementResult[0] == -1) {
            byte[] bytes2 = Arrays.copyOfRange(statementResult, 1, statementResult.length);
            ErrorPacket errorPacket = new ErrorPacket(bytes2);
            throw new ServerException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
        }
        while (this.channel.read()[0] != -2) {
        }
        while ((bytes = this.channel.read())[0] != -2) {
            resultSet.add(new ResultSetRowPacket(bytes));
        }
        return resultSet.toArray(new ResultSetRowPacket[resultSet.size()]);
    }

    public List<EventListener> getEventListeners() {
        return Collections.unmodifiableList(this.eventListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEventListener(EventListener eventListener) {
        List<EventListener> list = this.eventListeners;
        synchronized (list) {
            this.eventListeners.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEventListener(Class<? extends EventListener> listenerClass) {
        List<EventListener> list = this.eventListeners;
        synchronized (list) {
            Iterator<EventListener> iterator = this.eventListeners.iterator();
            while (iterator.hasNext()) {
                EventListener eventListener = iterator.next();
                if (!listenerClass.isInstance(eventListener)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEventListener(EventListener eventListener) {
        List<EventListener> list = this.eventListeners;
        synchronized (list) {
            this.eventListeners.remove(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEventListeners(Event event) {
        if (event.getData() instanceof EventDeserializer.EventDataWrapper) {
            event = new Event((EventHeader)event.getHeader(), ((EventDeserializer.EventDataWrapper)event.getData()).getExternal());
        }
        List<EventListener> list = this.eventListeners;
        synchronized (list) {
            for (EventListener eventListener : this.eventListeners) {
                try {
                    eventListener.onEvent(event);
                }
                catch (Exception e) {
                    if (!this.logger.isLoggable(Level.WARNING)) continue;
                    this.logger.log(Level.WARNING, eventListener + " choked on " + event, e);
                }
            }
        }
    }

    public List<LifecycleListener> getLifecycleListeners() {
        return Collections.unmodifiableList(this.lifecycleListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerLifecycleListener(LifecycleListener lifecycleListener) {
        List<LifecycleListener> list = this.lifecycleListeners;
        synchronized (list) {
            this.lifecycleListeners.add(lifecycleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterLifecycleListener(Class<? extends LifecycleListener> listenerClass) {
        List<LifecycleListener> list = this.lifecycleListeners;
        synchronized (list) {
            Iterator<LifecycleListener> iterator = this.lifecycleListeners.iterator();
            while (iterator.hasNext()) {
                LifecycleListener lifecycleListener = iterator.next();
                if (!listenerClass.isInstance(lifecycleListener)) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterLifecycleListener(LifecycleListener eventListener) {
        List<LifecycleListener> list = this.lifecycleListeners;
        synchronized (list) {
            this.lifecycleListeners.remove(eventListener);
        }
    }

    @Override
    public void disconnect() throws IOException {
        this.terminateKeepAliveThread();
        this.terminateConnect();
    }

    private void terminateKeepAliveThread() {
        ExecutorService keepAliveThreadExecutor = this.keepAliveThreadExecutor;
        if (keepAliveThreadExecutor == null) {
            return;
        }
        keepAliveThreadExecutor.shutdownNow();
        while (!BinaryLogClient.awaitTerminationInterruptibly(keepAliveThreadExecutor, Long.MAX_VALUE, TimeUnit.NANOSECONDS)) {
        }
    }

    private static boolean awaitTerminationInterruptibly(ExecutorService executorService, long timeout, TimeUnit unit) {
        try {
            return executorService.awaitTermination(timeout, unit);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private void terminateConnect() throws IOException {
        do {
            this.disconnectChannel();
        } while (!BinaryLogClient.tryLockInterruptibly(this.connectLock, 1000L, TimeUnit.MILLISECONDS));
        this.connectLock.unlock();
    }

    private static boolean tryLockInterruptibly(Lock lock, long time, TimeUnit unit) {
        try {
            return lock.tryLock(time, unit);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private void disconnectChannel() throws IOException {
        this.connected = false;
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
        }
    }

    public static abstract class AbstractLifecycleListener
    implements LifecycleListener {
        @Override
        public void onConnect(BinaryLogClient client) {
        }

        @Override
        public void onCommunicationFailure(BinaryLogClient client, Exception ex) {
        }

        @Override
        public void onEventDeserializationFailure(BinaryLogClient client, Exception ex) {
        }

        @Override
        public void onDisconnect(BinaryLogClient client) {
        }
    }

    public static interface LifecycleListener {
        public void onConnect(BinaryLogClient var1);

        public void onCommunicationFailure(BinaryLogClient var1, Exception var2);

        public void onEventDeserializationFailure(BinaryLogClient var1, Exception var2);

        public void onDisconnect(BinaryLogClient var1);
    }

    public static interface EventListener {
        public void onEvent(Event var1);
    }
}

