/*
 * Decompiled with CFR 0.152.
 */
package jp.shts.android.library;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.StringRes;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.View;
import jp.shts.android.library.R;

public class TriangleLabelView
extends View {
    private static final String TAG = TriangleLabelView.class.getSimpleName();
    private PaintHolder primary = new PaintHolder();
    private PaintHolder secondary = new PaintHolder();
    private float topPadding;
    private float bottomPadding;
    private float centerPadding;
    private Paint trianglePaint;
    private int backGroundColor;
    private int width;
    private int height;
    private static final int DEGREES_LEFT = -45;
    private static final int DEGREES_RIGHT = 45;
    private Corner corner;

    public TriangleLabelView(Context context) {
        this(context, null);
    }

    public TriangleLabelView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TriangleLabelView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public TriangleLabelView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        String secondary;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.TriangleLabelView);
        this.topPadding = ta.getDimension(R.styleable.TriangleLabelView_labelTopPadding, (float)this.dp2px(7.0f));
        this.centerPadding = ta.getDimension(R.styleable.TriangleLabelView_labelCenterPadding, (float)this.dp2px(3.0f));
        this.bottomPadding = ta.getDimension(R.styleable.TriangleLabelView_labelBottomPadding, (float)this.dp2px(3.0f));
        this.backGroundColor = ta.getColor(R.styleable.TriangleLabelView_backgroundColor, Color.parseColor((String)"#66000000"));
        this.primary.color = ta.getColor(R.styleable.TriangleLabelView_primaryTextColor, -1);
        this.secondary.color = ta.getColor(R.styleable.TriangleLabelView_secondaryTextColor, -1);
        this.primary.size = ta.getDimension(R.styleable.TriangleLabelView_primaryTextSize, this.sp2px(11.0f));
        this.secondary.size = ta.getDimension(R.styleable.TriangleLabelView_secondaryTextSize, this.sp2px(8.0f));
        String primary = ta.getString(R.styleable.TriangleLabelView_primaryText);
        if (primary != null) {
            this.primary.text = primary;
        }
        if ((secondary = ta.getString(R.styleable.TriangleLabelView_secondaryText)) != null) {
            this.secondary.text = secondary;
        }
        this.primary.style = ta.getInt(R.styleable.TriangleLabelView_primaryTextStyle, 2);
        this.secondary.style = ta.getInt(R.styleable.TriangleLabelView_secondaryTextStyle, 0);
        this.corner = Corner.from(ta.getInt(R.styleable.TriangleLabelView_corner, 1));
        ta.recycle();
        this.primary.initPaint();
        this.secondary.initPaint();
        this.trianglePaint = new Paint(1);
        this.trianglePaint.setColor(this.backGroundColor);
        this.primary.resetStatus();
        this.secondary.resetStatus();
    }

    public void setLabelTopPadding(float dp) {
        this.topPadding = this.dp2px(dp);
    }

    public float getLabelTopPadding() {
        return this.topPadding;
    }

    public void setLabelCenterPadding(float dp) {
        this.centerPadding = this.dp2px(dp);
        this.relayout();
    }

    public float getLabelCenterPadding() {
        return this.centerPadding;
    }

    public void setLabelBottomPadding(float dp) {
        this.bottomPadding = this.dp2px(dp);
        this.relayout();
    }

    public float getLabelBottomPadding() {
        return this.bottomPadding;
    }

    public void setPrimaryText(String text) {
        this.primary.text = text;
        this.primary.resetStatus();
        this.relayout();
    }

    public void setPrimaryText(@StringRes int textRes) {
        this.primary.text = this.getContext().getString(textRes);
        this.primary.resetStatus();
        this.relayout();
    }

    public String getPrimaryText() {
        return this.primary.text;
    }

    public void setSecondaryText(String smallText) {
        this.secondary.text = smallText;
        this.secondary.resetStatus();
        this.relayout();
    }

    public void setSecondaryText(@StringRes int textRes) {
        this.secondary.text = this.getContext().getString(textRes);
        this.secondary.resetStatus();
        this.relayout();
    }

    public String getSecondaryText() {
        return this.secondary.text;
    }

    public void setPrimaryTextColor(@ColorInt int color) {
        this.primary.color = color;
        this.primary.initPaint();
        this.primary.resetStatus();
        this.relayout();
    }

    public void setPrimaryTextColorResource(@ColorRes int colorResource) {
        this.primary.color = ContextCompat.getColor((Context)this.getContext(), (int)colorResource);
        this.primary.initPaint();
        this.primary.resetStatus();
        this.relayout();
    }

    public void setSecondaryTextColor(@ColorInt int color) {
        this.secondary.color = color;
        this.secondary.initPaint();
        this.secondary.resetStatus();
        this.relayout();
    }

    public void setSecondaryTextColorResource(@ColorRes int colorResource) {
        this.secondary.color = ContextCompat.getColor((Context)this.getContext(), (int)colorResource);
        this.secondary.initPaint();
        this.secondary.resetStatus();
        this.relayout();
    }

    public void setPrimaryTextSize(float sp) {
        this.primary.size = this.sp2px(sp);
        this.relayout();
    }

    public void setSecondaryTextSize(float sp) {
        this.secondary.size = this.sp2px(sp);
        this.relayout();
    }

    public float getPrimaryTextSize() {
        return this.primary.size;
    }

    public float getSecondaryTextSize() {
        return this.secondary.size;
    }

    public void setTriangleBackgroundColor(@ColorInt int color) {
        this.backGroundColor = color;
        this.trianglePaint.setColor(this.backGroundColor);
        this.relayout();
    }

    public void setTriangleBackgroundColorResource(@ColorRes int colorResource) {
        this.backGroundColor = ContextCompat.getColor((Context)this.getContext(), (int)colorResource);
        this.trianglePaint.setColor(this.backGroundColor);
        this.relayout();
    }

    public int getTriangleBackGroundColor() {
        return this.backGroundColor;
    }

    public void setCorner(Corner corner) {
        this.corner = corner;
        this.relayout();
    }

    public Corner getCorner() {
        return this.corner;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        if (this.corner.top()) {
            canvas.translate(0.0f, (float)((double)this.height * Math.sqrt(2.0) - (double)this.height));
        }
        if (this.corner.top()) {
            if (this.corner.left()) {
                canvas.rotate(-45.0f, 0.0f, (float)this.height);
            } else {
                canvas.rotate(45.0f, (float)this.width, (float)this.height);
            }
        } else if (this.corner.left()) {
            canvas.rotate(45.0f, 0.0f, 0.0f);
        } else {
            canvas.rotate(-45.0f, (float)this.width, 0.0f);
        }
        Path path = new Path();
        if (this.corner.top()) {
            path.moveTo(0.0f, (float)this.height);
            path.lineTo((float)(this.width / 2), 0.0f);
            path.lineTo((float)this.width, (float)this.height);
        } else {
            path.moveTo(0.0f, 0.0f);
            path.lineTo((float)(this.width / 2), (float)this.height);
            path.lineTo((float)this.width, 0.0f);
        }
        path.close();
        canvas.drawPath(path, this.trianglePaint);
        if (this.corner.top()) {
            canvas.drawText(this.secondary.text, (float)(this.width / 2), this.topPadding + this.secondary.height, this.secondary.paint);
            canvas.drawText(this.primary.text, (float)(this.width / 2), this.topPadding + this.secondary.height + this.centerPadding + this.primary.height, this.primary.paint);
        } else {
            canvas.drawText(this.secondary.text, (float)(this.width / 2), this.bottomPadding + this.secondary.height + this.centerPadding + this.primary.height, this.secondary.paint);
            canvas.drawText(this.primary.text, (float)(this.width / 2), this.bottomPadding + this.primary.height, this.primary.paint);
        }
        canvas.restore();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.height = (int)(this.topPadding + this.centerPadding + this.bottomPadding + this.secondary.height + this.primary.height);
        this.width = 2 * this.height;
        int realHeight = (int)((double)this.height * Math.sqrt(2.0));
        this.setMeasuredDimension(this.width, realHeight);
    }

    public int dp2px(float dpValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public float sp2px(float spValue) {
        float scale = this.getContext().getResources().getDisplayMetrics().scaledDensity;
        return spValue * scale;
    }

    private void relayout() {
        this.invalidate();
        this.requestLayout();
    }

    public static enum Corner {
        TOP_LEFT(1),
        TOP_RIGHT(2),
        BOTTOM_LEFT(3),
        BOTTOM_RIGHT(4);

        private final int type;

        private Corner(int type) {
            this.type = type;
        }

        private boolean top() {
            return this == TOP_LEFT || this == TOP_RIGHT;
        }

        private boolean left() {
            return this == TOP_LEFT || this == BOTTOM_LEFT;
        }

        private static Corner from(int type) {
            for (Corner c : Corner.values()) {
                if (c.type != type) continue;
                return c;
            }
            return TOP_LEFT;
        }
    }

    private static class PaintHolder {
        String text = "";
        Paint paint;
        int color;
        float size;
        float height;
        float width;
        int style;

        private PaintHolder() {
        }

        void initPaint() {
            this.paint = new Paint(1);
            this.paint.setColor(this.color);
            this.paint.setTextAlign(Paint.Align.CENTER);
            this.paint.setTextSize(this.size);
            if (this.style == 1) {
                this.paint.setTypeface(Typeface.SANS_SERIF);
            } else if (this.style == 2) {
                this.paint.setTypeface(Typeface.DEFAULT_BOLD);
            }
        }

        void resetStatus() {
            Rect rectText = new Rect();
            this.paint.getTextBounds(this.text, 0, this.text.length(), rectText);
            this.width = rectText.width();
            this.height = rectText.height();
        }
    }
}

