/*
 * Decompiled with CFR 0.152.
 */
package com.shaon2016.propicker.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.os.StatFs;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0006H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0004J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u0006J \u0010\u001e\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0004J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010!\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/shaon2016/propicker/util/FileUtil;", "", "()V", "FILENAME_FORMAT", "", "bitmapToFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "bitmap", "Landroid/graphics/Bitmap;", "copy", "", "source", "Ljava/io/InputStream;", "target", "Ljava/io/OutputStream;", "delete", "file", "fileFromContentUri", "contentUri", "Landroid/net/Uri;", "getCameraDirectory", "getCompressFormat", "Landroid/graphics/Bitmap$CompressFormat;", "extension", "getFileExtension", "uri", "getFreeSpace", "", "getImageFile", "dir", "getImageOutputDirectory", "getTimestamp", "propicker_release"})
public final class FileUtil {
    private static final String FILENAME_FORMAT;
    public static final FileUtil INSTANCE;

    @Nullable
    public final File getImageFile(@Nullable File dir, @Nullable String extension) {
        try {
            File storageDir;
            String string = extension;
            if (string == null) {
                string = ".jpg";
            }
            String ext = string;
            String imageFileName = "IMG_" + this.getTimestamp() + ext;
            File file = dir;
            if (file == null) {
                file = storageDir = this.getCameraDirectory();
            }
            if (!storageDir.exists()) {
                storageDir.mkdirs();
            }
            File file2 = new File(storageDir, imageFileName);
            file2.createNewFile();
            return file2;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static /* synthetic */ File getImageFile$default(FileUtil fileUtil, File file, String string, int n, Object object) {
        if ((n & 1) != 0) {
            file = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        return fileUtil.getImageFile(file, string);
    }

    private final File getCameraDirectory() {
        File dir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM);
        return new File(dir, "Camera");
    }

    private final String getTimestamp() {
        String timeFormat = "yyyyMMdd_HHmmssSSS";
        String string = new SimpleDateFormat(timeFormat, Locale.getDefault()).format(new Date());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SimpleDateFormat(timeFor\u2026Default()).format(Date())");
        return string;
    }

    public final long getFreeSpace(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        StatFs stat = new StatFs(file.getPath());
        long availBlocks = stat.getAvailableBlocksLong();
        long blockSize = stat.getBlockSizeLong();
        return availBlocks * blockSize;
    }

    @NotNull
    public final Bitmap.CompressFormat getCompressFormat(@NotNull String extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        return StringsKt.contains((CharSequence)extension, (CharSequence)"png", (boolean)true) ? Bitmap.CompressFormat.PNG : (StringsKt.contains((CharSequence)extension, (CharSequence)"webp", (boolean)true) ? Bitmap.CompressFormat.WEBP : Bitmap.CompressFormat.JPEG);
    }

    @NotNull
    public final File fileFromContentUri(@NotNull Context context, @NotNull Uri contentUri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
        String fileExtension = this.getFileExtension(context, contentUri);
        String fileName = "temp_file" + (fileExtension != null ? '.' + fileExtension : "");
        File tempFile = new File(context.getCacheDir(), fileName);
        tempFile.createNewFile();
        try {
            InputStream inputStream;
            FileOutputStream oStream = new FileOutputStream(tempFile);
            InputStream inputStream2 = inputStream = context.getContentResolver().openInputStream(contentUri);
            if (inputStream2 != null) {
                InputStream inputStream3 = inputStream2;
                boolean bl = false;
                boolean bl2 = false;
                InputStream it = inputStream3;
                boolean bl3 = false;
                INSTANCE.copy(inputStream, oStream);
            }
            oStream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tempFile;
    }

    private final String getFileExtension(Context context, Uri uri) {
        String fileType = context.getContentResolver().getType(uri);
        return MimeTypeMap.getSingleton().getExtensionFromMimeType(fileType);
    }

    private final void copy(InputStream source, OutputStream target) throws IOException {
        byte[] buf = new byte[8192];
        int length = 0;
        while (true) {
            int n = source.read(buf);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            length = it;
            if (n <= 0) break;
            target.write(buf, 0, length);
        }
    }

    @NotNull
    public final File bitmapToFile(@NotNull Context context, @NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        File file = this.getImageOutputDirectory(context);
        try {
            OutputStream stream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, stream);
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return file;
    }

    @NotNull
    public final File getImageOutputDirectory(@NotNull Context context) {
        File file;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object[] objectArray = context.getExternalFilesDirs(Environment.DIRECTORY_DCIM);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"context.getExternalFiles\u2026vironment.DIRECTORY_DCIM)");
        File file2 = (File)ArraysKt.firstOrNull((Object[])objectArray);
        if (file2 != null) {
            File file3 = file2;
            boolean bl = false;
            boolean bl2 = false;
            File it = file3;
            boolean bl3 = false;
            File file4 = new File(it, "images");
            boolean bl4 = false;
            boolean bl5 = false;
            File $this$apply = file4;
            boolean bl6 = false;
            $this$apply.mkdirs();
            file = file4;
        } else {
            file = null;
        }
        File mediaDir = file;
        return mediaDir != null && mediaDir.exists() ? new File(mediaDir, new SimpleDateFormat(FILENAME_FORMAT, Locale.US).format(System.currentTimeMillis()) + ".png") : new File(context.getFilesDir(), new SimpleDateFormat(FILENAME_FORMAT, Locale.US).format(System.currentTimeMillis()) + ".png");
    }

    public final void delete(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists()) {
            file.delete();
        }
    }

    private FileUtil() {
    }

    static {
        FileUtil fileUtil;
        INSTANCE = fileUtil = new FileUtil();
        FILENAME_FORMAT = "yyyy-MM-dd-HH-mm-ss-SSS";
    }
}

