/*
 * Decompiled with CFR 0.152.
 */
package io.github.shcho.xmldoclet;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.util.DocTrees;
import io.github.shcho.utils.StringUtils;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.Reporter;

public class XmlDoclet
implements Doclet {
    private static final boolean OK = true;
    private static final boolean ERROR = false;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_OUTPUT_DIR = ".";
    private static final String DEFAULT_OUTPUT_FILENAME = "javadoc.xml";
    private DocTrees docTrees;
    private Reporter reporter;
    private String outputDir = ".";
    private String filename = "javadoc.xml";
    private Boolean escapeCharacters = true;
    private final Set<Option> options = Set.of(new Option("-d", true, "Destination directory for output file. (Default: .)", "[<directory>]", Doclet.Option.Kind.STANDARD){

        @Override
        public boolean process(String option, List<String> arguments) {
            String outputDir = arguments.isEmpty() ? XmlDoclet.DEFAULT_OUTPUT_DIR : arguments.get(0);
            if (!Files.isDirectory(Paths.get(outputDir = outputDir.replaceAll("/+$", ""), new String[0]), new LinkOption[0])) {
                XmlDoclet.this.reporter.print(Diagnostic.Kind.ERROR, "Invalid output directory: " + outputDir);
                return false;
            }
            XmlDoclet.this.outputDir = outputDir;
            return true;
        }
    }, new Option("-Xfilename", true, "Output filename. (Default: javadoc.xml)", "[<filename>]", Doclet.Option.Kind.EXTENDED){

        @Override
        public boolean process(String option, List<String> arguments) {
            String filename;
            XmlDoclet.this.filename = filename = arguments.isEmpty() ? XmlDoclet.DEFAULT_OUTPUT_FILENAME : arguments.get(0);
            return true;
        }
    }, new Option("-Xescape", true, "Escape characters in javadoc comments\ne.g. `-Xescape true`, \"\uc548\ub155\" -> \"\\uc548\\ub155\"\n     `-Xescape false`, \"\uc548\ub155\" -> \"\uc548\ub155\"\n(Default: true)", "[true|false]", Doclet.Option.Kind.EXTENDED){

        @Override
        public boolean process(String option, List<String> arguments) {
            String escape = arguments.isEmpty() ? "true" : arguments.get(0);
            XmlDoclet.this.escapeCharacters = Boolean.parseBoolean(escape);
            return true;
        }
    });
    private final Set<Option> ignoredOptions = Set.of(new Option("-doctitle", true, "IGNORED", "[<doctitle>]", Doclet.Option.Kind.STANDARD){

        @Override
        public boolean process(String option, List<String> arguments) {
            XmlDoclet.this.reporter.print(Diagnostic.Kind.NOTE, "Option " + option + " is ignored");
            return true;
        }
    }, new Option("-windowtitle", true, "IGNORED", "[<windowtitle>]", Doclet.Option.Kind.STANDARD){

        @Override
        public boolean process(String option, List<String> arguments) {
            XmlDoclet.this.reporter.print(Diagnostic.Kind.NOTE, "Option " + option + " is ignored");
            return true;
        }
    }, new Option("-notimestamp", false, "IGNORED", null, Doclet.Option.Kind.STANDARD){

        @Override
        public boolean process(String option, List<String> arguments) {
            XmlDoclet.this.reporter.print(Diagnostic.Kind.NOTE, "Option " + option + " is ignored");
            return true;
        }
    });

    @Override
    public void init(Locale locale, Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    public Set<? extends Option> getSupportedOptions() {
        return Stream.concat(this.options.stream(), this.ignoredOptions.stream()).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean run(DocletEnvironment docEnv) {
        this.docTrees = docEnv.getDocTrees();
        this.reporter.print(Diagnostic.Kind.NOTE, "Output directory: " + this.outputDir);
        this.reporter.print(Diagnostic.Kind.NOTE, "Output filename: " + this.filename);
        this.reporter.print(Diagnostic.Kind.NOTE, "Escape characters: " + this.escapeCharacters);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputDir + "/" + this.filename), StandardCharsets.UTF_8);){
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xmlWriter = xmlOutputFactory.createXMLStreamWriter(writer);
            xmlWriter.writeStartDocument(DEFAULT_ENCODING, "1.0");
            xmlWriter.writeStartElement("root");
            for (PackageElement packageElement : ElementFilter.packagesIn(docEnv.getIncludedElements())) {
                this.processPackage(xmlWriter, packageElement);
            }
            xmlWriter.writeEndElement();
            xmlWriter.writeEndDocument();
            xmlWriter.close();
        }
        catch (Exception e) {
            this.reporter.print(Diagnostic.Kind.ERROR, "Error generating XML: " + e.getMessage());
            return false;
        }
        return true;
    }

    private void processPackage(XMLStreamWriter xmlWriter, PackageElement packageElement) throws Exception {
        xmlWriter.writeStartElement("package");
        xmlWriter.writeAttribute("name", packageElement.getQualifiedName().toString());
        for (TypeElement typeElement : ElementFilter.typesIn(packageElement.getEnclosedElements())) {
            this.processType(xmlWriter, typeElement);
        }
        xmlWriter.writeEndElement();
    }

    private void processType(XMLStreamWriter xmlWriter, TypeElement typeElement) throws Exception {
        String elementName;
        switch (typeElement.getKind()) {
            case CLASS: 
            case RECORD: {
                elementName = "class";
                break;
            }
            case INTERFACE: {
                elementName = "interface";
                break;
            }
            case ENUM: {
                elementName = "enum";
                break;
            }
            default: {
                return;
            }
        }
        xmlWriter.writeStartElement(elementName);
        xmlWriter.writeAttribute("name", typeElement.getSimpleName().toString());
        xmlWriter.writeAttribute("qualified", typeElement.getQualifiedName().toString());
        this.processDocCommentTree(xmlWriter, this.docTrees.getDocCommentTree(typeElement));
        for (VariableElement field : ElementFilter.fieldsIn(typeElement.getEnclosedElements())) {
            this.processField(xmlWriter, field, typeElement.getKind());
        }
        xmlWriter.writeEndElement();
    }

    private void processField(XMLStreamWriter xmlWriter, VariableElement field, ElementKind parentKind) throws Exception {
        String elementName = parentKind == ElementKind.ENUM ? "constant" : "field";
        xmlWriter.writeStartElement(elementName);
        xmlWriter.writeAttribute("name", field.getSimpleName().toString());
        this.processDocCommentTree(xmlWriter, this.docTrees.getDocCommentTree(field));
        xmlWriter.writeEndElement();
    }

    private void processDocCommentTree(XMLStreamWriter xmlWriter, DocCommentTree docCommentTree) throws XMLStreamException {
        if (docCommentTree == null) {
            return;
        }
        xmlWriter.writeStartElement("comment");
        String commentString = docCommentTree.toString();
        if (this.escapeCharacters.booleanValue()) {
            xmlWriter.writeCharacters(commentString);
        } else {
            xmlWriter.writeCharacters(StringUtils.unescapeJavaString(commentString));
        }
        xmlWriter.writeEndElement();
    }

    abstract class Option
    implements Doclet.Option {
        private final String name;
        private final boolean hasArg;
        private final String description;
        private final String parameters;
        private final Doclet.Option.Kind kind;

        Option(String name, boolean hasArg, String description, String parameters, Doclet.Option.Kind kind) {
            this.name = name;
            this.hasArg = hasArg;
            this.description = description;
            this.parameters = parameters;
            this.kind = kind;
        }

        @Override
        public int getArgumentCount() {
            return this.hasArg ? 1 : 0;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Doclet.Option.Kind getKind() {
            return this.kind;
        }

        @Override
        public List<String> getNames() {
            return List.of(this.name);
        }

        @Override
        public String getParameters() {
            return this.hasArg ? this.parameters : "";
        }
    }
}

