/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.xtooltip;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.text.Html;
import android.text.Spannable;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewPropertyAnimator;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.IdRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import it.sephiroth.android.library.xtooltip.AnimationListener;
import it.sephiroth.android.library.xtooltip.AttachStateChangeListener;
import it.sephiroth.android.library.xtooltip.ClosePolicy;
import it.sephiroth.android.library.xtooltip.R;
import it.sephiroth.android.library.xtooltip.Tooltip$WhenMappings;
import it.sephiroth.android.library.xtooltip.TooltipOverlay;
import it.sephiroth.android.library.xtooltip.TooltipTextDrawable;
import it.sephiroth.android.library.xtooltip.Typefaces;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ec\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001:\n\u0081\u0001\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010]\u001a\u00020;2\u0006\u0010^\u001a\u00020;H\u0002J\u0010\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020bH\u0003J\u0006\u0010c\u001a\u00020-J+\u0010d\u001a\u00020\u00002#\u0010e\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020-\u0018\u00010)J+\u0010f\u001a\u00020\u00002#\u0010e\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020-\u0018\u00010)J+\u0010g\u001a\u00020\u00002#\u0010e\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020-\u0018\u00010)J\u0010\u0010h\u001a\u00020-2\u0006\u0010i\u001a\u00020\u0018H\u0002J\u0010\u0010j\u001a\u00020-2\u0006\u0010i\u001a\u00020\u0018H\u0002JD\u0010k\u001a\u0004\u0018\u00010$2\u0006\u0010l\u001a\u00020\n2\b\u0010m\u001a\u0004\u0018\u00010\n2\u0006\u0010n\u001a\u00020\u001b2\f\u0010o\u001a\b\u0012\u0004\u0012\u0002030p2\u0006\u0010q\u001a\u00020`2\b\b\u0002\u0010r\u001a\u00020\u0011H\u0002J\u0006\u0010s\u001a\u00020-J\u0014\u0010t\u001a\u0004\u0018\u00010\u00002\b\u0010u\u001a\u0004\u0018\u00010$H\u0002J\u0018\u0010v\u001a\u00020-2\u0006\u0010w\u001a\u00020;2\u0006\u0010x\u001a\u00020;H\u0002J\u0018\u0010y\u001a\u00020-2\u0006\u0010q\u001a\u00020`2\u0006\u0010z\u001a\u000203H\u0002J\b\u0010{\u001a\u00020-H\u0002J\u0012\u0010|\u001a\u00020-2\b\u0010}\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010~\u001a\u00020-2\u0006\u0010z\u001a\u000203H\u0002J\u0010\u0010\u007f\u001a\u00020-2\u0006\u0010}\u001a\u00020\nH\u0002J!\u0010\u0080\u0001\u001a\u00020-2\u0006\u0010l\u001a\u00020\n2\u0006\u0010z\u001a\u0002032\b\b\u0002\u0010r\u001a\u00020\u0011R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\t\u001a\u0004\u0018\u00010\n8F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010(\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020-\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010.\u001a\u0004\u0018\u00010/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020302X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u00107\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020-\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010<R\u000e\u0010=\u001a\u00020>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010>X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010B\u001a\b\u0018\u00010CR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010G\u001a\u001f\u0012\u0013\u0012\u00110\u0000\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0004\u0012\u00020-\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020;X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010K\u001a\u0004\u0018\u00010LX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020IX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010T\u001a\u0004\u0018\u00010UX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010V\u001a\u0004\u0018\u00010WX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010X\u001a\u00020;X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010Y\u001a\u00020ZX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010[\u001a\u00020\\X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0086\u0001"}, d2={"Lit/sephiroth/android/library/xtooltip/Tooltip;", "", "context", "Landroid/content/Context;", "builder", "Lit/sephiroth/android/library/xtooltip/Tooltip$Builder;", "(Landroid/content/Context;Lit/sephiroth/android/library/xtooltip/Tooltip$Builder;)V", "activateRunnable", "Ljava/lang/Runnable;", "<set-?>", "Landroid/view/View;", "contentView", "getContentView", "()Landroid/view/View;", "setContentView", "(Landroid/view/View;)V", "hideRunnable", "", "isShowing", "()Z", "setShowing", "(Z)V", "isVisible", "mActivateDelay", "", "mActivated", "mAnchorPoint", "Landroid/graphics/Point;", "mAnchorView", "Ljava/lang/ref/WeakReference;", "mAnimator", "Landroid/animation/ValueAnimator;", "mClosePolicy", "Lit/sephiroth/android/library/xtooltip/ClosePolicy;", "mContentView", "mCurrentPosition", "Lit/sephiroth/android/library/xtooltip/Tooltip$Positions;", "mDrawable", "Lit/sephiroth/android/library/xtooltip/TooltipTextDrawable;", "mFadeDuration", "mFailureFunc", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "tooltip", "", "mFloatingAnimation", "Lit/sephiroth/android/library/xtooltip/Tooltip$Animation;", "mFollowAnchor", "mGravities", "", "Lit/sephiroth/android/library/xtooltip/Tooltip$Gravity;", "mHandler", "Landroid/os/Handler;", "mHasAnchorView", "mHiddenFunc", "mIsCustomView", "mLayoutInsetDecor", "mMaxWidth", "", "Ljava/lang/Integer;", "mNewLocation", "", "mOldLocation", "mOverlayStyle", "mPadding", "mPopupView", "Lit/sephiroth/android/library/xtooltip/Tooltip$TooltipViewContainer;", "mShowArrow", "mShowDuration", "mShowOverlay", "mShownFunc", "mSizeTolerance", "", "mSoftInputMode", "mText", "", "mTextAppearance", "mTextGravity", "mTextView", "Landroid/widget/TextView;", "mTextViewElevation", "mTextViewIdRes", "mTooltipLayoutIdRes", "mTypeface", "Landroid/graphics/Typeface;", "mViewOverlay", "Lit/sephiroth/android/library/xtooltip/TooltipOverlay;", "mWindowLayoutType", "predrawListener", "Landroid/view/ViewTreeObserver$OnPreDrawListener;", "windowManager", "Landroid/view/WindowManager;", "computeFlags", "curFlags", "createPopupLayoutParams", "Landroid/view/WindowManager$LayoutParams;", "token", "Landroid/os/IBinder;", "dismiss", "doOnFailure", "func", "doOnHidden", "doOnShown", "fadeIn", "fadeDuration", "fadeOut", "findPosition", "parent", "anchor", "offset", "gravities", "Ljava/util/ArrayList;", "params", "fitToScreen", "hide", "invokePopup", "positions", "offsetBy", "xoff", "yoff", "preparePopup", "gravity", "removeCallbacks", "removeListeners", "anchorView", "setupAnimation", "setupListeners", "show", "Animation", "Builder", "Gravity", "Positions", "TooltipViewContainer", "xtooltip_release"})
public final class Tooltip {
    private final WindowManager windowManager;
    private boolean isShowing;
    private final List<Gravity> mGravities;
    private boolean isVisible;
    private final float mSizeTolerance;
    private final boolean mLayoutInsetDecor = true;
    private final int mWindowLayoutType = 1000;
    private final int mSoftInputMode = 2;
    private final Handler mHandler;
    private TooltipViewContainer mPopupView;
    private CharSequence mText;
    private Point mAnchorPoint;
    private boolean mShowArrow;
    private int mPadding;
    private long mActivateDelay;
    private ClosePolicy mClosePolicy;
    private long mFadeDuration;
    private long mShowDuration;
    private Integer mMaxWidth;
    private int mTextAppearance;
    private int mTextGravity;
    private float mTextViewElevation;
    private Typeface mTypeface;
    private boolean mIsCustomView;
    private int mTooltipLayoutIdRes;
    private int mTextViewIdRes;
    private Animation mFloatingAnimation;
    private ValueAnimator mAnimator;
    private boolean mShowOverlay;
    private int mOverlayStyle;
    private boolean mActivated;
    private boolean mHasAnchorView;
    private boolean mFollowAnchor;
    private TooltipOverlay mViewOverlay;
    private TooltipTextDrawable mDrawable;
    private WeakReference<View> mAnchorView;
    private View mContentView;
    private TextView mTextView;
    private final Runnable hideRunnable;
    private final Runnable activateRunnable;
    @Nullable
    private View contentView;
    private ViewTreeObserver.OnPreDrawListener predrawListener;
    private Function1<? super Tooltip, Unit> mFailureFunc;
    private Function1<? super Tooltip, Unit> mShownFunc;
    private Function1<? super Tooltip, Unit> mHiddenFunc;
    private Positions mCurrentPosition;
    private int[] mOldLocation;
    private int[] mNewLocation;
    private final Context context;

    public final boolean isShowing() {
        return this.isShowing;
    }

    private final void setShowing(boolean bl) {
        this.isShowing = bl;
    }

    @Nullable
    public final View getContentView() {
        View view = this.mContentView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mContentView");
        }
        return view;
    }

    private final void setContentView(View view) {
        this.contentView = view;
    }

    @NotNull
    public final Tooltip doOnFailure(@Nullable Function1<? super Tooltip, Unit> func) {
        this.mFailureFunc = func;
        return this;
    }

    @NotNull
    public final Tooltip doOnShown(@Nullable Function1<? super Tooltip, Unit> func) {
        this.mShownFunc = func;
        return this;
    }

    @NotNull
    public final Tooltip doOnHidden(@Nullable Function1<? super Tooltip, Unit> func) {
        this.mHiddenFunc = func;
        return this;
    }

    @SuppressLint(value={"RtlHardcoded"})
    private final WindowManager.LayoutParams createPopupLayoutParams(IBinder token) {
        WindowManager.LayoutParams p = new WindowManager.LayoutParams();
        p.gravity = 51;
        p.width = -1;
        p.height = -1;
        p.format = -3;
        p.flags = this.computeFlags(p.flags);
        p.type = this.mWindowLayoutType;
        p.token = token;
        p.softInputMode = this.mSoftInputMode;
        p.setTitle((CharSequence)("ToolTip:" + Integer.toHexString(this.hashCode())));
        return p;
    }

    private final int computeFlags(int curFlags) {
        int curFlags1 = curFlags;
        curFlags1 |= 0x20;
        int n = curFlags1 = this.mClosePolicy.inside() || this.mClosePolicy.outside() ? curFlags1 & ~8 : curFlags1 | 8;
        if (!this.mClosePolicy.consume()) {
            curFlags1 |= 0x10;
        }
        curFlags1 |= 0x20000;
        curFlags1 |= 0x40000;
        curFlags1 |= 0x200;
        curFlags1 |= 0x100;
        return curFlags1 |= 0x10000;
    }

    private final void preparePopup(WindowManager.LayoutParams params, Gravity gravity) {
        TooltipViewContainer tooltipViewContainer = this.mPopupView;
        if (tooltipViewContainer != null) {
            TooltipViewContainer tooltipViewContainer2;
            TooltipViewContainer it = tooltipViewContainer2 = tooltipViewContainer;
            if (this.mViewOverlay != null && gravity == Gravity.CENTER) {
                it.removeView((View)this.mViewOverlay);
                this.mViewOverlay = null;
            }
        } else {
            AttachStateChangeListener listener$iv;
            CharSequence charSequence;
            Object $receiver$iv;
            Object $receiver;
            Tooltip tooltip;
            Tooltip $receiver2 = tooltip = this;
            TooltipViewContainer viewContainer = $receiver2.new TooltipViewContainer($receiver2.context);
            if ($receiver2.mShowOverlay && $receiver2.mViewOverlay == null) {
                TooltipOverlay tooltipOverlay = $receiver2.mViewOverlay = new TooltipOverlay($receiver2.context, 0, $receiver2.mOverlayStyle);
                if (tooltipOverlay == null) {
                    Intrinsics.throwNpe();
                }
                TooltipOverlay tooltipOverlay2 = tooltipOverlay;
                $receiver = tooltipOverlay2;
                $receiver.setAdjustViewBounds(true);
                $receiver.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            View contentView = LayoutInflater.from((Context)$receiver2.context).inflate($receiver2.mTooltipLayoutIdRes, (ViewGroup)viewContainer, false);
            Animation animation = $receiver2.mFloatingAnimation;
            if (animation != null) {
                Animation it = $receiver = animation;
                View view = contentView;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"contentView");
                View view2 = view;
                int size$iv = it.getRadius();
                $receiver$iv.setPadding(size$iv, size$iv, size$iv, size$iv);
            }
            View view = contentView.findViewById($receiver2.mTextViewIdRes);
            Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"contentView.findViewById(mTextViewIdRes)");
            TextView textView = $receiver2.mTextView = (TextView)view;
            if (textView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mTextView");
            }
            Object $receiver3 = $receiver = textView;
            TooltipTextDrawable tooltipTextDrawable = $receiver2.mDrawable;
            if (tooltipTextDrawable != null) {
                TooltipTextDrawable it = $receiver$iv = tooltipTextDrawable;
                $receiver3.setBackground(it);
            }
            if ($receiver2.mShowArrow) {
                $receiver3.setPadding($receiver2.mPadding, $receiver2.mPadding, $receiver2.mPadding, $receiver2.mPadding);
            } else {
                $receiver3.setPadding($receiver2.mPadding / 2, $receiver2.mPadding / 2, $receiver2.mPadding / 2, $receiver2.mPadding / 2);
            }
            if ($receiver2.mTextAppearance != 0) {
                $receiver3.setTextAppearance($receiver3.getContext(), $receiver2.mTextAppearance);
            }
            if (!$receiver2.mIsCustomView && $receiver2.mTextViewElevation > 0.0f && Build.VERSION.SDK_INT >= 21) {
                $receiver3.setElevation($receiver2.mTextViewElevation);
                $receiver3.setTranslationZ($receiver2.mTextViewElevation);
                $receiver3.setOutlineProvider(ViewOutlineProvider.BACKGROUND);
            }
            $receiver3.setGravity($receiver2.mTextGravity);
            if ($receiver2.mText instanceof Spannable) {
                charSequence = $receiver2.mText;
            } else {
                CharSequence charSequence2 = this.mText;
                if (charSequence2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                charSequence = (CharSequence)Html.fromHtml((String)((String)charSequence2));
            }
            $receiver3.setText(charSequence);
            Integer n = $receiver2.mMaxWidth;
            if (n != null) {
                $receiver$iv = n;
                int it = ((Number)$receiver$iv).intValue();
                $receiver3.setMaxWidth(it);
            }
            Typeface typeface = $receiver2.mTypeface;
            if (typeface != null) {
                Object it = $receiver$iv = typeface;
                $receiver3.setTypeface((Typeface)it);
            }
            if ($receiver2.mViewOverlay != null) {
                viewContainer.addView((View)$receiver2.mViewOverlay, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            }
            viewContainer.addView(contentView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
            viewContainer.setMeasureAllChildren(true);
            viewContainer.measure(0, 0);
            Timber.i((String)("viewContainer size: " + viewContainer.getMeasuredWidth() + ", " + viewContainer.getMeasuredHeight()), (Object[])new Object[0]);
            StringBuilder stringBuilder = new StringBuilder().append("contentView size: ");
            View view3 = contentView;
            Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"contentView");
            Timber.i((String)stringBuilder.append(view3.getMeasuredWidth()).append(", ").append(contentView.getMeasuredHeight()).toString(), (Object[])new Object[0]);
            TextView textView2 = $receiver2.mTextView;
            if (textView2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mTextView");
            }
            View $receiver$iv2 = (View)textView2;
            AttachStateChangeListener $receiver4 = listener$iv = new AttachStateChangeListener();
            $receiver4.onViewAttachedToWindow((Function2<? super View, ? super View.OnAttachStateChangeListener, Unit>)((Function2)new Function2<View, View.OnAttachStateChangeListener, Unit>($receiver2){
                final /* synthetic */ Tooltip $this_run$inlined;
                {
                    this.$this_run$inlined = tooltip;
                    super(2);
                }

                public final void invoke(@Nullable View $noName_0, @NotNull View.OnAttachStateChangeListener $noName_1) {
                    Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                    ValueAnimator valueAnimator = Tooltip.access$getMAnimator$p(this.$this_run$inlined);
                    if (valueAnimator != null) {
                        valueAnimator.start();
                    }
                    if (Tooltip.access$getMShowDuration$p(this.$this_run$inlined) > 0L) {
                        Tooltip.access$getMHandler$p(this.$this_run$inlined).removeCallbacks(Tooltip.access$getHideRunnable$p(this.$this_run$inlined));
                        Tooltip.access$getMHandler$p(this.$this_run$inlined).postDelayed(Tooltip.access$getHideRunnable$p(this.$this_run$inlined), Tooltip.access$getMShowDuration$p(this.$this_run$inlined));
                    }
                    Tooltip.access$getMHandler$p(this.$this_run$inlined).removeCallbacks(Tooltip.access$getActivateRunnable$p(this.$this_run$inlined));
                    Tooltip.access$getMHandler$p(this.$this_run$inlined).postDelayed(Tooltip.access$getActivateRunnable$p(this.$this_run$inlined), Tooltip.access$getMActivateDelay$p(this.$this_run$inlined));
                }
            }));
            $receiver4.onViewDetachedFromWindow((Function2<? super View, ? super View.OnAttachStateChangeListener, Unit>)((Function2)new Function2<View, View.OnAttachStateChangeListener, Unit>($receiver2){
                final /* synthetic */ Tooltip $this_run$inlined;
                {
                    this.$this_run$inlined = tooltip;
                    super(2);
                }

                public final void invoke(@Nullable View view, @NotNull View.OnAttachStateChangeListener listener) {
                    Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
                    View view2 = view;
                    if (view2 != null) {
                        view2.removeOnAttachStateChangeListener(listener);
                    }
                    ValueAnimator valueAnimator = Tooltip.access$getMAnimator$p(this.$this_run$inlined);
                    if (valueAnimator != null) {
                        valueAnimator.cancel();
                    }
                    Tooltip.access$removeCallbacks(this.$this_run$inlined);
                }
            }));
            $receiver$iv2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)listener$iv);
            $receiver2.mContentView = contentView;
            $receiver2.mPopupView = viewContainer;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Positions findPosition(View parent, View anchor, Point offset, ArrayList<Gravity> gravities, WindowManager.LayoutParams params, boolean fitToScreen) {
        Tooltip $receiver;
        Tooltip tooltip;
        int n;
        if (this.mPopupView == null) {
            return null;
        }
        if (gravities.isEmpty()) {
            return null;
        }
        Gravity gravity = gravities.remove(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)gravity), (String)"gravities.removeAt(0)");
        Gravity gravity2 = gravity;
        Timber.i((String)("findPosition. " + (Object)((Object)gravity2) + ", offset: " + offset), (Object[])new Object[0]);
        Rect displayFrame = new Rect();
        int[] anchorPosition = new int[]{0, 0};
        Point centerPosition = new Point(offset);
        parent.getWindowVisibleDisplayFrame(displayFrame);
        View view = anchor;
        if (view != null) {
            View view2;
            View it = view2 = view;
            anchor.getLocationOnScreen(anchorPosition);
            centerPosition.x += anchorPosition[0] + anchor.getWidth() / 2;
            centerPosition.y += anchorPosition[1] + anchor.getHeight() / 2;
            switch (Tooltip$WhenMappings.$EnumSwitchMapping$0[gravity2.ordinal()]) {
                case 1: {
                    anchorPosition[1] = anchorPosition[1] + anchor.getHeight() / 2;
                    break;
                }
                case 2: {
                    anchorPosition[0] = anchorPosition[0] + anchor.getWidth();
                    anchorPosition[1] = anchorPosition[1] + anchor.getHeight() / 2;
                    break;
                }
                case 3: {
                    anchorPosition[0] = anchorPosition[0] + anchor.getWidth() / 2;
                    break;
                }
                case 4: {
                    anchorPosition[0] = anchorPosition[0] + anchor.getWidth() / 2;
                    anchorPosition[1] = anchorPosition[1] + anchor.getHeight();
                    break;
                }
                case 5: {
                    anchorPosition[0] = anchorPosition[0] + anchor.getWidth() / 2;
                    anchorPosition[1] = anchorPosition[1] + anchor.getHeight() / 2;
                }
            }
        }
        anchorPosition[0] = anchorPosition[0] + offset.x;
        anchorPosition[1] = anchorPosition[1] + offset.y;
        Timber.d((String)("anchorPosition: " + anchorPosition[0] + ", " + anchorPosition[1]), (Object[])new Object[0]);
        Timber.d((String)("centerPosition: " + centerPosition), (Object[])new Object[0]);
        Timber.d((String)("displayFrame: " + displayFrame), (Object[])new Object[0]);
        View view3 = this.mContentView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mContentView");
        }
        int w = view3.getMeasuredWidth();
        View view4 = this.mContentView;
        if (view4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mContentView");
        }
        int h = view4.getMeasuredHeight();
        Timber.v((String)("contentView size: " + w + ", " + h), (Object[])new Object[0]);
        Point contentPosition = new Point();
        Point arrowPosition = new Point();
        Animation animation = this.mFloatingAnimation;
        if (animation != null) {
            n = animation.getRadius();
        } else {
            $receiver = tooltip = this;
            n = 0;
        }
        int radius = n;
        switch (Tooltip$WhenMappings.$EnumSwitchMapping$1[gravity2.ordinal()]) {
            case 1: {
                contentPosition.x = anchorPosition[0] - w;
                contentPosition.y = anchorPosition[1] - h / 2;
                arrowPosition.y = h / 2 - this.mPadding / 2 - radius;
                break;
            }
            case 2: {
                contentPosition.x = anchorPosition[0] - w / 2;
                contentPosition.y = anchorPosition[1] - h;
                arrowPosition.x = w / 2 - this.mPadding / 2 - radius;
                break;
            }
            case 3: {
                contentPosition.x = anchorPosition[0];
                contentPosition.y = anchorPosition[1] - h / 2;
                arrowPosition.y = h / 2 - this.mPadding / 2 - radius;
                break;
            }
            case 4: {
                contentPosition.x = anchorPosition[0] - w / 2;
                contentPosition.y = anchorPosition[1];
                arrowPosition.x = w / 2 - this.mPadding / 2 - radius;
                break;
            }
            case 5: {
                contentPosition.x = anchorPosition[0] - w / 2;
                contentPosition.y = anchorPosition[1] - h / 2;
            }
        }
        View view5 = anchor;
        if (view5 != null) {
            Tooltip it = tooltip = view5;
        } else {
            $receiver = tooltip = this;
            TooltipOverlay tooltipOverlay = $receiver.mViewOverlay;
            if (tooltipOverlay != null) {
                TooltipOverlay $i$a$2$let;
                TooltipOverlay it = $i$a$2$let = tooltipOverlay;
                switch (Tooltip$WhenMappings.$EnumSwitchMapping$2[gravity2.ordinal()]) {
                    case 1: {
                        contentPosition.x -= it.getMeasuredWidth() / 2;
                        break;
                    }
                    case 2: {
                        contentPosition.x += it.getMeasuredWidth() / 2;
                        break;
                    }
                    case 3: {
                        contentPosition.y -= it.getMeasuredHeight() / 2;
                        break;
                    }
                    case 4: {
                        contentPosition.y += it.getMeasuredHeight() / 2;
                    }
                }
            }
        }
        Timber.d((String)("arrowPosition: " + arrowPosition), (Object[])new Object[0]);
        Timber.d((String)("centerPosition: " + centerPosition), (Object[])new Object[0]);
        Timber.d((String)("contentPosition: " + contentPosition), (Object[])new Object[0]);
        if (fitToScreen) {
            void $receiver$iv;
            Rect finalRect = new Rect(contentPosition.x, contentPosition.y, contentPosition.x + w, contentPosition.y + h);
            $receiver = displayFrame;
            int t$iv = (int)this.mSizeTolerance;
            if (!$receiver$iv.contains(finalRect.left + t$iv, finalRect.top + t$iv, finalRect.right - t$iv, finalRect.bottom - t$iv)) {
                Timber.e((String)("content won't fit! " + displayFrame + ", " + finalRect), (Object[])new Object[0]);
                return this.findPosition(parent, anchor, offset, gravities, params, fitToScreen);
            }
        }
        return new Positions(displayFrame, arrowPosition, centerPosition, contentPosition, gravity2, params);
    }

    static /* synthetic */ Positions findPosition$default(Tooltip tooltip, View view, View view2, Point point, ArrayList arrayList, WindowManager.LayoutParams layoutParams, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return tooltip.findPosition(view, view2, point, arrayList, layoutParams, bl);
    }

    private final Tooltip invokePopup(Positions positions) {
        block7: {
            Tooltip tooltip;
            Positions positions2 = positions;
            if (positions2 != null) {
                Positions positions3;
                Positions it = positions3 = positions2;
                this.isShowing = true;
                this.mCurrentPosition = positions;
                this.setupAnimation(positions.getGravity());
                if (this.mHasAnchorView) {
                    WeakReference<View> weakReference = this.mAnchorView;
                    if ((weakReference != null ? (View)weakReference.get() : null) != null) {
                        WeakReference<View> weakReference2 = this.mAnchorView;
                        if (weakReference2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Object t = weakReference2.get();
                        if (t == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull(t, (String)"mAnchorView!!.get()!!");
                        this.setupListeners((View)t);
                    }
                }
                TooltipTextDrawable tooltipTextDrawable = this.mDrawable;
                if (tooltipTextDrawable != null) {
                    tooltipTextDrawable.setAnchor(it.getGravity(), !this.mShowArrow ? 0 : this.mPadding / 2, !this.mShowArrow ? null : new Point(it.getArrowPointX(), it.getArrowPointY()));
                }
                this.offsetBy(0, 0);
                it.getParams().packageName = this.context.getPackageName();
                TooltipViewContainer tooltipViewContainer = this.mPopupView;
                if (tooltipViewContainer != null) {
                    tooltipViewContainer.setFitsSystemWindows(this.mLayoutInsetDecor);
                }
                this.windowManager.addView((View)this.mPopupView, (ViewGroup.LayoutParams)it.getParams());
                Timber.v((String)("windowManager.addView: " + (Object)((Object)this.mPopupView)), (Object[])new Object[0]);
                this.fadeIn(this.mFadeDuration);
                return this;
            }
            Tooltip $receiver = tooltip = this;
            Function1<? super Tooltip, Unit> function1 = $receiver.mFailureFunc;
            if (function1 == null) break block7;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)$receiver);
        }
        return null;
    }

    private final void offsetBy(int xoff, int yoff) {
        block7: {
            if (!this.isShowing || this.mPopupView == null || this.mCurrentPosition == null) break block7;
            Timber.i((String)("offsetBy(" + xoff + ", " + yoff + ')'), (Object[])new Object[0]);
            View view = this.mContentView;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mContentView");
            }
            Positions positions = this.mCurrentPosition;
            if (positions == null) {
                Intrinsics.throwNpe();
            }
            view.setTranslationX((float)positions.getContentPointX() + (float)xoff);
            View view2 = this.mContentView;
            if (view2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mContentView");
            }
            Positions positions2 = this.mCurrentPosition;
            if (positions2 == null) {
                Intrinsics.throwNpe();
            }
            view2.setTranslationY((float)positions2.getContentPointY() + (float)yoff);
            TooltipOverlay tooltipOverlay = this.mViewOverlay;
            if (tooltipOverlay != null) {
                TooltipOverlay tooltipOverlay2;
                TooltipOverlay viewOverlay = tooltipOverlay2 = tooltipOverlay;
                Positions positions3 = this.mCurrentPosition;
                if (positions3 == null) {
                    Intrinsics.throwNpe();
                }
                viewOverlay.setTranslationX((float)positions3.getCenterPointX() - (float)(viewOverlay.getMeasuredWidth() / 2) + (float)xoff);
                Positions positions4 = this.mCurrentPosition;
                if (positions4 == null) {
                    Intrinsics.throwNpe();
                }
                viewOverlay.setTranslationY((float)positions4.getCenterPointY() - (float)(viewOverlay.getMeasuredHeight() / 2) + (float)yoff);
            }
        }
    }

    private final void setupListeners(View anchorView) {
        AttachStateChangeListener listener$iv;
        View $receiver$iv = anchorView;
        AttachStateChangeListener $receiver = listener$iv = new AttachStateChangeListener();
        $receiver.onViewDetachedFromWindow((Function2<? super View, ? super View.OnAttachStateChangeListener, Unit>)((Function2)new Function2<View, View.OnAttachStateChangeListener, Unit>(this){
            final /* synthetic */ Tooltip this$0;
            {
                this.this$0 = tooltip;
                super(2);
            }

            public final void invoke(@Nullable View view, @NotNull View.OnAttachStateChangeListener listener) {
                Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
                Timber.i((String)"anchorView detached from parent", (Object[])new Object[0]);
                View view2 = view;
                if (view2 != null) {
                    view2.removeOnAttachStateChangeListener(listener);
                }
                this.this$0.dismiss();
            }
        }));
        $receiver$iv.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)listener$iv);
        if (this.mFollowAnchor) {
            anchorView.getViewTreeObserver().addOnPreDrawListener(this.predrawListener);
        }
    }

    private final void removeListeners(View anchorView) {
        block0: {
            View view;
            if (!this.mFollowAnchor || (view = anchorView) == null || (view = view.getViewTreeObserver()) == null) break block0;
            view.removeOnPreDrawListener(this.predrawListener);
        }
    }

    private final void setupAnimation(Gravity gravity) {
        ValueAnimator valueAnimator;
        int n;
        TextView textView = this.mTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTextView");
        }
        View view = this.mContentView;
        if (view == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mContentView");
        }
        if (textView == view || this.mFloatingAnimation == null) {
            return;
        }
        Animation animation = this.mFloatingAnimation;
        if (animation == null) {
            Intrinsics.throwNpe();
        }
        int endValue = animation.getRadius();
        Animation animation2 = this.mFloatingAnimation;
        if (animation2 == null) {
            Intrinsics.throwNpe();
        }
        long duration = animation2.getDuration();
        Animation animation3 = this.mFloatingAnimation;
        if (animation3 == null) {
            Intrinsics.throwNpe();
        }
        if (animation3.getDirection() == 0) {
            n = gravity == Gravity.TOP || gravity == Gravity.BOTTOM ? 2 : 1;
        } else {
            Animation animation4 = this.mFloatingAnimation;
            if (animation4 == null) {
                Intrinsics.throwNpe();
            }
            n = animation4.getDirection();
        }
        int direction = n;
        String property = direction == 2 ? "translationY" : "translationX";
        TextView textView2 = this.mTextView;
        if (textView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTextView");
        }
        ValueAnimator valueAnimator2 = this.mAnimator = (ValueAnimator)ObjectAnimator.ofFloat((Object)textView2, (String)property, (float[])new float[]{-((float)endValue), endValue});
        if (valueAnimator2 == null) {
            Intrinsics.throwNpe();
        }
        ValueAnimator $receiver = valueAnimator = valueAnimator2;
        $receiver.setDuration(duration);
        $receiver.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        $receiver.setRepeatCount(-1);
        $receiver.setRepeatMode(2);
    }

    public final void show(@NotNull View parent, @NotNull Gravity gravity, boolean fitToScreen) {
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
                Intrinsics.checkParameterIsNotNull((Object)((Object)gravity), (String)"gravity");
                if (this.isShowing) break block2;
                if (!this.mHasAnchorView) break block3;
                WeakReference<View> weakReference = this.mAnchorView;
                if ((weakReference != null ? (View)weakReference.get() : null) != null) break block3;
            }
            return;
        }
        this.isVisible = false;
        IBinder iBinder = parent.getWindowToken();
        Intrinsics.checkExpressionValueIsNotNull((Object)iBinder, (String)"parent.windowToken");
        WindowManager.LayoutParams params = this.createPopupLayoutParams(iBinder);
        this.preparePopup(params, gravity);
        ArrayList gravities = (ArrayList)CollectionsKt.toCollection((Iterable)this.mGravities, (Collection)new ArrayList());
        gravities.remove((Object)gravity);
        gravities.add(0, gravity);
        WeakReference<View> weakReference = this.mAnchorView;
        this.invokePopup(this.findPosition(parent, (View)(weakReference != null ? (View)weakReference.get() : null), this.mAnchorPoint, gravities, params, fitToScreen));
    }

    public static /* synthetic */ void show$default(Tooltip tooltip, View view, Gravity gravity, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        tooltip.show(view, gravity, bl);
    }

    public final void hide() {
        Timber.i((String)"hide", (Object[])new Object[0]);
        if (!this.isShowing) {
            return;
        }
        this.fadeOut(this.mFadeDuration);
    }

    public final void dismiss() {
        block1: {
            if (!this.isShowing || this.mPopupView == null) break block1;
            WeakReference<View> weakReference = this.mAnchorView;
            this.removeListeners((View)(weakReference != null ? (View)weakReference.get() : null));
            this.removeCallbacks();
            this.windowManager.removeView((View)this.mPopupView);
            Timber.v((String)("dismiss: " + (Object)((Object)this.mPopupView)), (Object[])new Object[0]);
            this.mPopupView = null;
            this.isShowing = false;
            this.isVisible = false;
            Function1<? super Tooltip, Unit> function1 = this.mHiddenFunc;
            if (function1 != null) {
                Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this);
            }
        }
    }

    private final void removeCallbacks() {
        this.mHandler.removeCallbacks(this.hideRunnable);
        this.mHandler.removeCallbacks(this.activateRunnable);
    }

    private final void fadeIn(long fadeDuration) {
        block4: {
            if (!this.isShowing || this.isVisible) {
                return;
            }
            this.isVisible = true;
            if (fadeDuration > 0L && this.mPopupView != null) {
                TooltipViewContainer tooltipViewContainer = this.mPopupView;
                if (tooltipViewContainer == null) {
                    Intrinsics.throwNpe();
                }
                tooltipViewContainer.setAlpha(0.0f);
                TooltipViewContainer tooltipViewContainer2 = this.mPopupView;
                if (tooltipViewContainer2 == null) {
                    Intrinsics.throwNpe();
                }
                tooltipViewContainer2.animate().setDuration(this.mFadeDuration).alpha(1.0f).start();
            }
            Function1<? super Tooltip, Unit> function1 = this.mShownFunc;
            if (function1 == null) break block4;
            Unit cfr_ignored_0 = (Unit)function1.invoke((Object)this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fadeOut(long fadeDuration) {
        if (!this.isShowing || !this.isVisible) {
            return;
        }
        this.isVisible = false;
        this.removeCallbacks();
        Timber.i((String)("fadeOut(" + fadeDuration + ')'), (Object[])new Object[0]);
        if (fadeDuration > 0L) {
            TooltipViewContainer tooltipViewContainer = this.mPopupView;
            if (tooltipViewContainer != null) {
                void $receiver$iv;
                AnimationListener listener$iv;
                TooltipViewContainer tooltipViewContainer2;
                TooltipViewContainer popupView = tooltipViewContainer2 = tooltipViewContainer;
                popupView.clearAnimation();
                ViewPropertyAnimator viewPropertyAnimator = popupView.animate().alpha(0.0f).setDuration(fadeDuration);
                Intrinsics.checkExpressionValueIsNotNull((Object)viewPropertyAnimator, (String)"popupView.animate()\n    \u2026setDuration(fadeDuration)");
                ViewPropertyAnimator viewPropertyAnimator2 = viewPropertyAnimator;
                AnimationListener $receiver = listener$iv = new AnimationListener();
                $receiver.onAnimationEnd((Function1<? super Animator, Unit>)((Function1)new Function1<Animator, Unit>(popupView, this, fadeDuration){
                    final /* synthetic */ TooltipViewContainer $popupView$inlined;
                    final /* synthetic */ Tooltip this$0;
                    final /* synthetic */ long $fadeDuration$inlined;
                    {
                        this.$popupView$inlined = tooltipViewContainer;
                        this.this$0 = tooltip;
                        this.$fadeDuration$inlined = l;
                        super(1);
                    }

                    public final void invoke(@NotNull Animator it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.$popupView$inlined.setVisibility(4);
                        this.this$0.dismiss();
                    }
                }));
                $receiver$iv.setListener((Animator.AnimatorListener)listener$iv);
                $receiver$iv.start();
            }
        } else {
            this.dismiss();
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tooltip(Context context, Builder builder) {
        Object object;
        List list;
        void $receiver$iv$iv;
        void $receiver$iv;
        this.context = context;
        Object object2 = this.context.getSystemService("window");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        this.windowManager = (WindowManager)object2;
        Gravity[] gravityArray = Gravity.values();
        Tooltip tooltip = this;
        void var4_5 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (void element$iv$iv : $receiver$iv$iv) {
            void it = element$iv$iv;
            if (!(it != Gravity.CENTER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        tooltip.mGravities = list = (List)destination$iv$iv;
        Resources resources = this.context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.mSizeTolerance = resources.getDisplayMetrics().density * (float)10;
        this.mLayoutInsetDecor = true;
        this.mWindowLayoutType = 1000;
        this.mSoftInputMode = 2;
        this.mHandler = new Handler();
        this.mTooltipLayoutIdRes = R.layout.textview;
        this.mTextViewIdRes = 16908308;
        this.hideRunnable = new Runnable(this){
            final /* synthetic */ Tooltip this$0;

            public final void run() {
                this.this$0.hide();
            }
            {
                this.this$0 = tooltip;
            }
        };
        this.activateRunnable = new Runnable(this){
            final /* synthetic */ Tooltip this$0;

            public final void run() {
                Tooltip.access$setMActivated$p(this.this$0, true);
            }
            {
                this.this$0 = tooltip;
            }
        };
        this.predrawListener = new ViewTreeObserver.OnPreDrawListener(this){
            final /* synthetic */ Tooltip this$0;

            public final boolean onPreDraw() {
                block9: {
                    block11: {
                        View view;
                        block10: {
                            if (!Tooltip.access$getMHasAnchorView$p(this.this$0)) break block9;
                            WeakReference weakReference = Tooltip.access$getMAnchorView$p(this.this$0);
                            if ((weakReference != null ? (View)weakReference.get() : null) == null) break block9;
                            WeakReference weakReference2 = Tooltip.access$getMAnchorView$p(this.this$0);
                            Object object = weakReference2 != null ? (View)weakReference2.get() : null;
                            if (object == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"mAnchorView?.get()!!");
                            view = object;
                            ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
                            Intrinsics.checkExpressionValueIsNotNull((Object)viewTreeObserver, (String)"view.viewTreeObserver");
                            if (viewTreeObserver.isAlive()) break block10;
                            Tooltip.access$removeListeners(this.this$0, view);
                            break block9;
                        }
                        if (!this.this$0.isShowing() || Tooltip.access$getMPopupView$p(this.this$0) == null) break block9;
                        view.getLocationOnScreen(Tooltip.access$getMNewLocation$p(this.this$0));
                        if (Tooltip.access$getMOldLocation$p(this.this$0) == null) {
                            Tooltip.access$setMOldLocation$p(this.this$0, new int[]{Tooltip.access$getMNewLocation$p(this.this$0)[0], Tooltip.access$getMNewLocation$p(this.this$0)[1]});
                        }
                        int[] nArray = Tooltip.access$getMOldLocation$p(this.this$0);
                        if (nArray == null) {
                            Intrinsics.throwNpe();
                        }
                        if (nArray[0] != Tooltip.access$getMNewLocation$p(this.this$0)[1]) break block11;
                        int[] nArray2 = Tooltip.access$getMOldLocation$p(this.this$0);
                        if (nArray2 == null) {
                            Intrinsics.throwNpe();
                        }
                        if (nArray2[1] == Tooltip.access$getMNewLocation$p(this.this$0)[1]) break block9;
                    }
                    int n = Tooltip.access$getMNewLocation$p(this.this$0)[0];
                    int[] nArray = Tooltip.access$getMOldLocation$p(this.this$0);
                    if (nArray == null) {
                        Intrinsics.throwNpe();
                    }
                    int n2 = n - nArray[0];
                    int n3 = Tooltip.access$getMNewLocation$p(this.this$0)[1];
                    int[] nArray3 = Tooltip.access$getMOldLocation$p(this.this$0);
                    if (nArray3 == null) {
                        Intrinsics.throwNpe();
                    }
                    Tooltip.access$offsetBy(this.this$0, n2, n3 - nArray3[1]);
                }
                return true;
            }
            {
                this.this$0 = tooltip;
            }
        };
        TypedArray theme = this.context.getTheme().obtainStyledAttributes(null, R.styleable.TooltipLayout, builder.getDefStyleAttr$xtooltip_release(), builder.getDefStyleRes$xtooltip_release());
        this.mPadding = theme.getDimensionPixelSize(R.styleable.TooltipLayout_ttlm_padding, 30);
        this.mTextAppearance = theme.getResourceId(R.styleable.TooltipLayout_android_textAppearance, 0);
        this.mTextGravity = theme.getInt(R.styleable.TooltipLayout_android_gravity, 0x800033);
        this.mTextViewElevation = theme.getDimension(R.styleable.TooltipLayout_ttlm_elevation, 0.0f);
        this.mOverlayStyle = theme.getResourceId(R.styleable.TooltipLayout_ttlm_overlayStyle, R.style.ToolTipOverlayDefaultStyle);
        String font = theme.getString(R.styleable.TooltipLayout_ttlm_font);
        theme.recycle();
        this.mText = builder.getText$xtooltip_release();
        this.mActivateDelay = builder.getActivateDelay$xtooltip_release();
        Point point = builder.getPoint$xtooltip_release();
        if (point == null) {
            Intrinsics.throwNpe();
        }
        this.mAnchorPoint = point;
        this.mClosePolicy = builder.getClosePolicy$xtooltip_release();
        this.mMaxWidth = builder.getMaxWidth$xtooltip_release();
        this.mFloatingAnimation = builder.getFloatingAnimation$xtooltip_release();
        this.mShowDuration = builder.getShowDuration$xtooltip_release();
        this.mFadeDuration = builder.getFadeDuration$xtooltip_release();
        this.mShowOverlay = builder.getOverlay$xtooltip_release();
        this.mShowArrow = builder.getShowArrow$xtooltip_release() && builder.getLayoutId$xtooltip_release() == null;
        View view = builder.getAnchorView$xtooltip_release();
        if (view != null) {
            View it = object = view;
            this.mAnchorView = new WeakReference<View>(it);
            this.mHasAnchorView = true;
            this.mFollowAnchor = builder.getFollowAnchor$xtooltip_release();
        }
        Integer n = builder.getLayoutId$xtooltip_release();
        if (n != null) {
            object = n;
            int it = ((Number)object).intValue();
            Integer n2 = builder.getTextId$xtooltip_release();
            if (n2 == null) {
                Intrinsics.throwNpe();
            }
            this.mTextViewIdRes = n2;
            Integer n3 = builder.getLayoutId$xtooltip_release();
            if (n3 == null) {
                Intrinsics.throwNpe();
            }
            this.mTooltipLayoutIdRes = n3;
            this.mIsCustomView = true;
        } else {
            object = this;
            Tooltip $receiver = (Tooltip)object;
            $receiver.mDrawable = new TooltipTextDrawable($receiver.context, builder);
        }
        Typeface typeface = builder.getTypeface$xtooltip_release();
        if (typeface != null) {
            Object it = object = typeface;
            this.mTypeface = it;
        } else {
            object = this;
            Tooltip $receiver = (Tooltip)object;
            String string = font;
            if (string != null) {
                String string2;
                String it = string2 = string;
                $receiver.mTypeface = Typefaces.INSTANCE.get($receiver.context, it);
            }
        }
        this.mNewLocation = new int[]{0, 0};
    }

    public static final /* synthetic */ boolean access$isShowing$p(Tooltip $this) {
        return $this.isShowing;
    }

    public static final /* synthetic */ void access$setShowing$p(Tooltip $this, boolean bl) {
        $this.isShowing = bl;
    }

    public static final /* synthetic */ void access$setVisible$p(Tooltip $this, boolean bl) {
        $this.isVisible = bl;
    }

    public static final /* synthetic */ void access$setMActivated$p(Tooltip $this, boolean bl) {
        $this.mActivated = bl;
    }

    @NotNull
    public static final /* synthetic */ TextView access$getMTextView$p(Tooltip $this) {
        TextView textView = $this.mTextView;
        if (textView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mTextView");
        }
        return textView;
    }

    public static final /* synthetic */ void access$setMTextView$p(Tooltip $this, @NotNull TextView textView) {
        $this.mTextView = textView;
    }

    public static final /* synthetic */ void access$setMClosePolicy$p(Tooltip $this, @NotNull ClosePolicy closePolicy) {
        $this.mClosePolicy = closePolicy;
    }

    public /* synthetic */ Tooltip(@NotNull Context context, @NotNull Builder builder, DefaultConstructorMarker $constructor_marker) {
        this(context, builder);
    }

    @Nullable
    public static final /* synthetic */ ValueAnimator access$getMAnimator$p(Tooltip $this) {
        return $this.mAnimator;
    }

    public static final /* synthetic */ void access$setMAnimator$p(Tooltip $this, @Nullable ValueAnimator valueAnimator) {
        $this.mAnimator = valueAnimator;
    }

    public static final /* synthetic */ long access$getMShowDuration$p(Tooltip $this) {
        return $this.mShowDuration;
    }

    public static final /* synthetic */ void access$setMShowDuration$p(Tooltip $this, long l) {
        $this.mShowDuration = l;
    }

    @NotNull
    public static final /* synthetic */ Handler access$getMHandler$p(Tooltip $this) {
        return $this.mHandler;
    }

    @NotNull
    public static final /* synthetic */ Runnable access$getHideRunnable$p(Tooltip $this) {
        return $this.hideRunnable;
    }

    @NotNull
    public static final /* synthetic */ Runnable access$getActivateRunnable$p(Tooltip $this) {
        return $this.activateRunnable;
    }

    public static final /* synthetic */ long access$getMActivateDelay$p(Tooltip $this) {
        return $this.mActivateDelay;
    }

    public static final /* synthetic */ void access$setMActivateDelay$p(Tooltip $this, long l) {
        $this.mActivateDelay = l;
    }

    public static final /* synthetic */ void access$removeCallbacks(Tooltip $this) {
        $this.removeCallbacks();
    }

    public static final /* synthetic */ boolean access$getMHasAnchorView$p(Tooltip $this) {
        return $this.mHasAnchorView;
    }

    public static final /* synthetic */ void access$setMHasAnchorView$p(Tooltip $this, boolean bl) {
        $this.mHasAnchorView = bl;
    }

    @Nullable
    public static final /* synthetic */ WeakReference access$getMAnchorView$p(Tooltip $this) {
        return $this.mAnchorView;
    }

    public static final /* synthetic */ void access$setMAnchorView$p(Tooltip $this, @Nullable WeakReference weakReference) {
        $this.mAnchorView = weakReference;
    }

    public static final /* synthetic */ void access$removeListeners(Tooltip $this, @Nullable View anchorView) {
        $this.removeListeners(anchorView);
    }

    @Nullable
    public static final /* synthetic */ TooltipViewContainer access$getMPopupView$p(Tooltip $this) {
        return $this.mPopupView;
    }

    public static final /* synthetic */ void access$setMPopupView$p(Tooltip $this, @Nullable TooltipViewContainer tooltipViewContainer) {
        $this.mPopupView = tooltipViewContainer;
    }

    @NotNull
    public static final /* synthetic */ int[] access$getMNewLocation$p(Tooltip $this) {
        return $this.mNewLocation;
    }

    public static final /* synthetic */ void access$setMNewLocation$p(Tooltip $this, @NotNull int[] nArray) {
        $this.mNewLocation = nArray;
    }

    @Nullable
    public static final /* synthetic */ int[] access$getMOldLocation$p(Tooltip $this) {
        return $this.mOldLocation;
    }

    public static final /* synthetic */ void access$setMOldLocation$p(Tooltip $this, @Nullable int[] nArray) {
        $this.mOldLocation = nArray;
    }

    public static final /* synthetic */ void access$offsetBy(Tooltip $this, int xoff, int yoff) {
        $this.offsetBy(xoff, yoff);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J0\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0014J(\u0010\u0017\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0014J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001bH\u0017R@\u0010\u0005\u001a4\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lit/sephiroth/android/library/xtooltip/Tooltip$TooltipViewContainer;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "(Lit/sephiroth/android/library/xtooltip/Tooltip;Landroid/content/Context;)V", "sizeChange", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "w", "h", "", "dispatchKeyEvent", "", "event", "Landroid/view/KeyEvent;", "onLayout", "changed", "left", "top", "right", "bottom", "onSizeChanged", "oldw", "oldh", "onTouchEvent", "Landroid/view/MotionEvent;", "xtooltip_release"})
    public final class TooltipViewContainer
    extends FrameLayout {
        private Function2<? super Integer, ? super Integer, Unit> sizeChange;
        private HashMap _$_findViewCache;

        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            block0: {
                super.onSizeChanged(w, h, oldw, oldh);
                Function2<? super Integer, ? super Integer, Unit> function2 = this.sizeChange;
                if (function2 == null) break block0;
                Unit cfr_ignored_0 = (Unit)function2.invoke((Object)w, (Object)h);
            }
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            super.onLayout(changed, left, top, right, bottom);
            if (changed) {
                int[] out = new int[]{-1, -1};
                this.getLocationOnScreen(out);
                Timber.v((String)("globalVisibleRect: " + out[0] + ", " + out[1]), (Object[])new Object[0]);
                this.offsetTopAndBottom(-out[1]);
            }
        }

        public boolean dispatchKeyEvent(@NotNull KeyEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (!(Tooltip.this.isShowing() && Tooltip.this.isVisible && Tooltip.this.mActivated)) {
                return super.dispatchKeyEvent(event);
            }
            if (event.getKeyCode() == 4) {
                KeyEvent.DispatcherState state;
                if (this.getKeyDispatcherState() == null) {
                    return super.dispatchKeyEvent(event);
                }
                if (event.getAction() == 0 && event.getRepeatCount() == 0) {
                    KeyEvent.DispatcherState dispatcherState = this.getKeyDispatcherState();
                    if (dispatcherState != null) {
                        dispatcherState.startTracking(event, (Object)this);
                    }
                    return true;
                }
                if (event.getAction() == 1 && (state = this.getKeyDispatcherState()) != null && state.isTracking(event) && !event.isCanceled()) {
                    Timber.v((String)"Back pressed, close the tooltip", (Object[])new Object[0]);
                    Tooltip.this.hide();
                    return true;
                }
                return super.dispatchKeyEvent(event);
            }
            return super.dispatchKeyEvent(event);
        }

        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouchEvent(@NotNull MotionEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            if (!(Tooltip.this.isShowing() && Tooltip.this.isVisible && Tooltip.this.mActivated)) {
                return false;
            }
            Timber.i((String)("onTouchEvent: " + event), (Object[])new Object[0]);
            Timber.d((String)("event position: " + event.getX() + ", " + event.getY()), (Object[])new Object[0]);
            Rect r1 = new Rect();
            Tooltip.access$getMTextView$p(Tooltip.this).getGlobalVisibleRect(r1);
            boolean containsTouch = r1.contains((int)event.getX(), (int)event.getY());
            if (Tooltip.this.mClosePolicy.anywhere()) {
                Tooltip.this.hide();
            } else if (Tooltip.this.mClosePolicy.inside() && containsTouch) {
                Tooltip.this.hide();
            } else if (Tooltip.this.mClosePolicy.outside() && !containsTouch) {
                Tooltip.this.hide();
            }
            return Tooltip.this.mClosePolicy.consume();
        }

        public TooltipViewContainer(Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            super(context);
            this.setClipChildren(false);
            this.setClipToPadding(false);
        }

        public View _$_findCachedViewById(int n) {
            View view;
            if (this._$_findViewCache == null) {
                this._$_findViewCache = new HashMap();
            }
            if ((view = (View)this._$_findViewCache.get(n)) == null) {
                view = this.findViewById(n);
                this._$_findViewCache.put(n, view);
            }
            return view;
        }

        public void _$_clearFindViewByIdCache() {
            if (this._$_findViewCache != null) {
                this._$_findViewCache.clear();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u001c\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0005H\u00c6\u0003J\t\u0010)\u001a\u00020\tH\u00c6\u0003J\t\u0010*\u001a\u00020\u000bH\u00c6\u0003JE\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u00020\u0010H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0011\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0018\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u0011\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012R\u0011\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00062"}, d2={"Lit/sephiroth/android/library/xtooltip/Tooltip$Positions;", "", "displayFrame", "Landroid/graphics/Rect;", "arrowPoint", "Landroid/graphics/Point;", "centerPoint", "contentPoint", "gravity", "Lit/sephiroth/android/library/xtooltip/Tooltip$Gravity;", "params", "Landroid/view/WindowManager$LayoutParams;", "(Landroid/graphics/Rect;Landroid/graphics/Point;Landroid/graphics/Point;Landroid/graphics/Point;Lit/sephiroth/android/library/xtooltip/Tooltip$Gravity;Landroid/view/WindowManager$LayoutParams;)V", "getArrowPoint", "()Landroid/graphics/Point;", "arrowPointX", "", "getArrowPointX", "()I", "arrowPointY", "getArrowPointY", "getCenterPoint", "centerPointX", "getCenterPointX", "centerPointY", "getCenterPointY", "getContentPoint", "contentPointX", "getContentPointX", "contentPointY", "getContentPointY", "getDisplayFrame", "()Landroid/graphics/Rect;", "getGravity", "()Lit/sephiroth/android/library/xtooltip/Tooltip$Gravity;", "getParams", "()Landroid/view/WindowManager$LayoutParams;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "xtooltip_release"})
    private static final class Positions {
        private final int centerPointX;
        private final int centerPointY;
        private final int arrowPointX;
        private final int arrowPointY;
        private final int contentPointX;
        private final int contentPointY;
        @NotNull
        private final Rect displayFrame;
        @NotNull
        private final Point arrowPoint;
        @NotNull
        private final Point centerPoint;
        @NotNull
        private final Point contentPoint;
        @NotNull
        private final Gravity gravity;
        @NotNull
        private final WindowManager.LayoutParams params;

        public final int getCenterPointX() {
            return this.centerPointX;
        }

        public final int getCenterPointY() {
            return this.centerPointY;
        }

        public final int getArrowPointX() {
            return this.arrowPointX;
        }

        public final int getArrowPointY() {
            return this.arrowPointY;
        }

        public final int getContentPointX() {
            return this.contentPointX;
        }

        public final int getContentPointY() {
            return this.contentPointY;
        }

        @NotNull
        public final Rect getDisplayFrame() {
            return this.displayFrame;
        }

        @NotNull
        public final Point getArrowPoint() {
            return this.arrowPoint;
        }

        @NotNull
        public final Point getCenterPoint() {
            return this.centerPoint;
        }

        @NotNull
        public final Point getContentPoint() {
            return this.contentPoint;
        }

        @NotNull
        public final Gravity getGravity() {
            return this.gravity;
        }

        @NotNull
        public final WindowManager.LayoutParams getParams() {
            return this.params;
        }

        public Positions(@NotNull Rect displayFrame, @NotNull Point arrowPoint, @NotNull Point centerPoint, @NotNull Point contentPoint, @NotNull Gravity gravity, @NotNull WindowManager.LayoutParams params) {
            Intrinsics.checkParameterIsNotNull((Object)displayFrame, (String)"displayFrame");
            Intrinsics.checkParameterIsNotNull((Object)arrowPoint, (String)"arrowPoint");
            Intrinsics.checkParameterIsNotNull((Object)centerPoint, (String)"centerPoint");
            Intrinsics.checkParameterIsNotNull((Object)contentPoint, (String)"contentPoint");
            Intrinsics.checkParameterIsNotNull((Object)((Object)gravity), (String)"gravity");
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            this.displayFrame = displayFrame;
            this.arrowPoint = arrowPoint;
            this.centerPoint = centerPoint;
            this.contentPoint = contentPoint;
            this.gravity = gravity;
            this.params = params;
            this.centerPointX = this.centerPoint.x;
            this.centerPointY = this.centerPoint.y;
            this.arrowPointX = this.arrowPoint.x;
            this.arrowPointY = this.arrowPoint.y;
            this.contentPointX = this.contentPoint.x;
            this.contentPointY = this.contentPoint.y;
        }

        @NotNull
        public final Rect component1() {
            return this.displayFrame;
        }

        @NotNull
        public final Point component2() {
            return this.arrowPoint;
        }

        @NotNull
        public final Point component3() {
            return this.centerPoint;
        }

        @NotNull
        public final Point component4() {
            return this.contentPoint;
        }

        @NotNull
        public final Gravity component5() {
            return this.gravity;
        }

        @NotNull
        public final WindowManager.LayoutParams component6() {
            return this.params;
        }

        @NotNull
        public final Positions copy(@NotNull Rect displayFrame, @NotNull Point arrowPoint, @NotNull Point centerPoint, @NotNull Point contentPoint, @NotNull Gravity gravity, @NotNull WindowManager.LayoutParams params) {
            Intrinsics.checkParameterIsNotNull((Object)displayFrame, (String)"displayFrame");
            Intrinsics.checkParameterIsNotNull((Object)arrowPoint, (String)"arrowPoint");
            Intrinsics.checkParameterIsNotNull((Object)centerPoint, (String)"centerPoint");
            Intrinsics.checkParameterIsNotNull((Object)contentPoint, (String)"contentPoint");
            Intrinsics.checkParameterIsNotNull((Object)((Object)gravity), (String)"gravity");
            Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
            return new Positions(displayFrame, arrowPoint, centerPoint, contentPoint, gravity, params);
        }

        @NotNull
        public static /* synthetic */ Positions copy$default(Positions positions, Rect rect, Point point, Point point2, Point point3, Gravity gravity, WindowManager.LayoutParams layoutParams, int n, Object object) {
            if ((n & 1) != 0) {
                rect = positions.displayFrame;
            }
            if ((n & 2) != 0) {
                point = positions.arrowPoint;
            }
            if ((n & 4) != 0) {
                point2 = positions.centerPoint;
            }
            if ((n & 8) != 0) {
                point3 = positions.contentPoint;
            }
            if ((n & 0x10) != 0) {
                gravity = positions.gravity;
            }
            if ((n & 0x20) != 0) {
                layoutParams = positions.params;
            }
            return positions.copy(rect, point, point2, point3, gravity, layoutParams);
        }

        @NotNull
        public String toString() {
            return "Positions(displayFrame=" + this.displayFrame + ", arrowPoint=" + this.arrowPoint + ", centerPoint=" + this.centerPoint + ", contentPoint=" + this.contentPoint + ", gravity=" + (Object)((Object)this.gravity) + ", params=" + this.params + ")";
        }

        public int hashCode() {
            Rect rect = this.displayFrame;
            Point point = this.arrowPoint;
            Point point2 = this.centerPoint;
            Point point3 = this.contentPoint;
            Gravity gravity = this.gravity;
            WindowManager.LayoutParams layoutParams = this.params;
            return (((((rect != null ? rect.hashCode() : 0) * 31 + (point != null ? point.hashCode() : 0)) * 31 + (point2 != null ? point2.hashCode() : 0)) * 31 + (point3 != null ? point3.hashCode() : 0)) * 31 + (gravity != null ? ((Object)((Object)gravity)).hashCode() : 0)) * 31 + (layoutParams != null ? layoutParams.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Positions)) break block3;
                    Positions positions = (Positions)object;
                    if (!Intrinsics.areEqual((Object)this.displayFrame, (Object)positions.displayFrame) || !Intrinsics.areEqual((Object)this.arrowPoint, (Object)positions.arrowPoint) || !Intrinsics.areEqual((Object)this.centerPoint, (Object)positions.centerPoint) || !Intrinsics.areEqual((Object)this.contentPoint, (Object)positions.contentPoint) || !Intrinsics.areEqual((Object)((Object)this.gravity), (Object)((Object)positions.gravity)) || !Intrinsics.areEqual((Object)this.params, (Object)positions.params)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lit/sephiroth/android/library/xtooltip/Tooltip$Gravity;", "", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "TOP", "BOTTOM", "CENTER", "xtooltip_release"})
    public static final class Gravity
    extends Enum<Gravity> {
        public static final /* enum */ Gravity LEFT;
        public static final /* enum */ Gravity RIGHT;
        public static final /* enum */ Gravity TOP;
        public static final /* enum */ Gravity BOTTOM;
        public static final /* enum */ Gravity CENTER;
        private static final /* synthetic */ Gravity[] $VALUES;

        static {
            Gravity[] gravityArray = new Gravity[5];
            Gravity[] gravityArray2 = gravityArray;
            gravityArray[0] = LEFT = new Gravity();
            gravityArray[1] = RIGHT = new Gravity();
            gravityArray[2] = TOP = new Gravity();
            gravityArray[3] = BOTTOM = new Gravity();
            gravityArray[4] = CENTER = new Gravity();
            $VALUES = gravityArray;
        }

        public static Gravity[] values() {
            return (Gravity[])$VALUES.clone();
        }

        public static Gravity valueOf(String string) {
            return Enum.valueOf(Gravity.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lit/sephiroth/android/library/xtooltip/Tooltip$Animation;", "", "radius", "", "direction", "duration", "", "(IIJ)V", "getDirection", "()I", "getDuration", "()J", "getRadius", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "Companion", "xtooltip_release"})
    public static final class Animation {
        private final int radius;
        private final int direction;
        private final long duration;
        @NotNull
        private static final Animation DEFAULT;
        @NotNull
        private static final Animation SLOW;
        public static final Companion Companion;

        public final int getRadius() {
            return this.radius;
        }

        public final int getDirection() {
            return this.direction;
        }

        public final long getDuration() {
            return this.duration;
        }

        public Animation(int radius, int direction, long duration) {
            this.radius = radius;
            this.direction = direction;
            this.duration = duration;
        }

        static {
            Companion = new Companion(null);
            DEFAULT = new Animation(8, 0, 400L);
            SLOW = new Animation(4, 0, 600L);
        }

        public final int component1() {
            return this.radius;
        }

        public final int component2() {
            return this.direction;
        }

        public final long component3() {
            return this.duration;
        }

        @NotNull
        public final Animation copy(int radius, int direction, long duration) {
            return new Animation(radius, direction, duration);
        }

        @NotNull
        public static /* synthetic */ Animation copy$default(Animation animation, int n, int n2, long l, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = animation.radius;
            }
            if ((n3 & 2) != 0) {
                n2 = animation.direction;
            }
            if ((n3 & 4) != 0) {
                l = animation.duration;
            }
            return animation.copy(n, n2, l);
        }

        @NotNull
        public String toString() {
            return "Animation(radius=" + this.radius + ", direction=" + this.direction + ", duration=" + this.duration + ")";
        }

        public int hashCode() {
            long l = this.duration;
            return (this.radius * 31 + this.direction) * 31 + (int)(l ^ l >>> 32);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Animation)) break block3;
                    Animation animation = (Animation)object;
                    if (!(this.radius == animation.radius) || !(this.direction == animation.direction) || !(this.duration == animation.duration)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lit/sephiroth/android/library/xtooltip/Tooltip$Animation$Companion;", "", "()V", "DEFAULT", "Lit/sephiroth/android/library/xtooltip/Tooltip$Animation;", "getDEFAULT", "()Lit/sephiroth/android/library/xtooltip/Tooltip$Animation;", "SLOW", "getSLOW", "xtooltip_release"})
        public static final class Companion {
            @NotNull
            public final Animation getDEFAULT() {
                return DEFAULT;
            }

            @NotNull
            public final Animation getSLOW() {
                return SLOW;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010V\u001a\u00020\u0006J,\u0010W\u001a\u00020\u00002\u0006\u0010X\u001a\u00020\f2\b\b\u0002\u0010Y\u001a\u00020\u00182\b\b\u0002\u0010Z\u001a\u00020\u00182\b\b\u0002\u0010[\u001a\u00020*J\u0016\u0010W\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020\u00182\u0006\u0010]\u001a\u00020\u0018J\u000e\u0010^\u001a\u00020\u00002\u0006\u0010V\u001a\u00020*J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0012J\u0006\u0010`\u001a\u00020aJ\u001a\u0010b\u001a\u00020\u00002\b\b\u0001\u0010/\u001a\u00020\u00182\b\b\u0001\u0010M\u001a\u00020\u0018J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010V\u001a\u00020\u0006J\u0010\u0010#\u001a\u00020\u00002\b\u0010V\u001a\u0004\u0018\u00010$J\u000e\u00105\u001a\u00020\u00002\u0006\u0010c\u001a\u00020\u0018J\u000e\u00108\u001a\u00020\u00002\u0006\u0010V\u001a\u00020*J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010V\u001a\u00020\u0006J\u0017\u0010d\u001a\u00020\u00002\n\b\u0001\u0010d\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010eJ\u000e\u0010G\u001a\u00020\u00002\u0006\u0010G\u001a\u00020HJ\u0010\u0010G\u001a\u00020\u00002\b\b\u0001\u0010G\u001a\u00020\u0018J)\u0010G\u001a\u00020\u00002\b\b\u0001\u0010G\u001a\u00020\u00182\u0012\u0010f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010g\"\u00020\u0001\u00a2\u0006\u0002\u0010hJ\u0010\u0010P\u001a\u00020\u00002\b\u0010V\u001a\u0004\u0018\u00010QR\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\b\"\u0004\b\"\u0010\nR\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\"\u0010/\u001a\u0004\u0018\u00010\u00188\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0010\n\u0002\u00104\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001e\u00105\u001a\u0004\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u0010\n\u0002\u00104\u001a\u0004\b6\u00101\"\u0004\b7\u00103R\u001a\u00108\u001a\u00020*X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010,\"\u0004\b:\u0010.R\u001c\u0010;\u001a\u0004\u0018\u00010<X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020*X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010,\"\u0004\bC\u0010.R\u001a\u0010D\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010\b\"\u0004\bF\u0010\nR\u001c\u0010G\u001a\u0004\u0018\u00010HX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\"\u0010M\u001a\u0004\u0018\u00010\u00188\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0010\n\u0002\u00104\u001a\u0004\bN\u00101\"\u0004\bO\u00103R\u001c\u0010P\u001a\u0004\u0018\u00010QX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010U\u00a8\u0006i"}, d2={"Lit/sephiroth/android/library/xtooltip/Tooltip$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "activateDelay", "", "getActivateDelay$xtooltip_release", "()J", "setActivateDelay$xtooltip_release", "(J)V", "anchorView", "Landroid/view/View;", "getAnchorView$xtooltip_release", "()Landroid/view/View;", "setAnchorView$xtooltip_release", "(Landroid/view/View;)V", "closePolicy", "Lit/sephiroth/android/library/xtooltip/ClosePolicy;", "getClosePolicy$xtooltip_release", "()Lit/sephiroth/android/library/xtooltip/ClosePolicy;", "setClosePolicy$xtooltip_release", "(Lit/sephiroth/android/library/xtooltip/ClosePolicy;)V", "defStyleAttr", "", "getDefStyleAttr$xtooltip_release", "()I", "setDefStyleAttr$xtooltip_release", "(I)V", "defStyleRes", "getDefStyleRes$xtooltip_release", "setDefStyleRes$xtooltip_release", "fadeDuration", "getFadeDuration$xtooltip_release", "setFadeDuration$xtooltip_release", "floatingAnimation", "Lit/sephiroth/android/library/xtooltip/Tooltip$Animation;", "getFloatingAnimation$xtooltip_release", "()Lit/sephiroth/android/library/xtooltip/Tooltip$Animation;", "setFloatingAnimation$xtooltip_release", "(Lit/sephiroth/android/library/xtooltip/Tooltip$Animation;)V", "followAnchor", "", "getFollowAnchor$xtooltip_release", "()Z", "setFollowAnchor$xtooltip_release", "(Z)V", "layoutId", "getLayoutId$xtooltip_release", "()Ljava/lang/Integer;", "setLayoutId$xtooltip_release", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "maxWidth", "getMaxWidth$xtooltip_release", "setMaxWidth$xtooltip_release", "overlay", "getOverlay$xtooltip_release", "setOverlay$xtooltip_release", "point", "Landroid/graphics/Point;", "getPoint$xtooltip_release", "()Landroid/graphics/Point;", "setPoint$xtooltip_release", "(Landroid/graphics/Point;)V", "showArrow", "getShowArrow$xtooltip_release", "setShowArrow$xtooltip_release", "showDuration", "getShowDuration$xtooltip_release", "setShowDuration$xtooltip_release", "text", "", "getText$xtooltip_release", "()Ljava/lang/CharSequence;", "setText$xtooltip_release", "(Ljava/lang/CharSequence;)V", "textId", "getTextId$xtooltip_release", "setTextId$xtooltip_release", "typeface", "Landroid/graphics/Typeface;", "getTypeface$xtooltip_release", "()Landroid/graphics/Typeface;", "setTypeface$xtooltip_release", "(Landroid/graphics/Typeface;)V", "value", "anchor", "view", "xoff", "yoff", "follow", "x", "y", "arrow", "policy", "create", "Lit/sephiroth/android/library/xtooltip/Tooltip;", "customView", "w", "styleId", "(Ljava/lang/Integer;)Lit/sephiroth/android/library/xtooltip/Tooltip$Builder;", "args", "", "(I[Ljava/lang/Object;)Lit/sephiroth/android/library/xtooltip/Tooltip$Builder;", "xtooltip_release"})
    public static final class Builder {
        @Nullable
        private Point point;
        @NotNull
        private ClosePolicy closePolicy;
        @Nullable
        private CharSequence text;
        @Nullable
        private View anchorView;
        @Nullable
        private Integer maxWidth;
        private int defStyleRes;
        private int defStyleAttr;
        @Nullable
        private Typeface typeface;
        private boolean overlay;
        @Nullable
        private Animation floatingAnimation;
        private long showDuration;
        private long fadeDuration;
        private boolean showArrow;
        private long activateDelay;
        private boolean followAnchor;
        @LayoutRes
        @Nullable
        private Integer layoutId;
        @IdRes
        @Nullable
        private Integer textId;
        private final Context context;

        @Nullable
        public final Point getPoint$xtooltip_release() {
            return this.point;
        }

        public final void setPoint$xtooltip_release(@Nullable Point point) {
            this.point = point;
        }

        @NotNull
        public final ClosePolicy getClosePolicy$xtooltip_release() {
            return this.closePolicy;
        }

        public final void setClosePolicy$xtooltip_release(@NotNull ClosePolicy closePolicy) {
            Intrinsics.checkParameterIsNotNull((Object)closePolicy, (String)"<set-?>");
            this.closePolicy = closePolicy;
        }

        @Nullable
        public final CharSequence getText$xtooltip_release() {
            return this.text;
        }

        public final void setText$xtooltip_release(@Nullable CharSequence charSequence) {
            this.text = charSequence;
        }

        @Nullable
        public final View getAnchorView$xtooltip_release() {
            return this.anchorView;
        }

        public final void setAnchorView$xtooltip_release(@Nullable View view) {
            this.anchorView = view;
        }

        @Nullable
        public final Integer getMaxWidth$xtooltip_release() {
            return this.maxWidth;
        }

        public final void setMaxWidth$xtooltip_release(@Nullable Integer n) {
            this.maxWidth = n;
        }

        public final int getDefStyleRes$xtooltip_release() {
            return this.defStyleRes;
        }

        public final void setDefStyleRes$xtooltip_release(int n) {
            this.defStyleRes = n;
        }

        public final int getDefStyleAttr$xtooltip_release() {
            return this.defStyleAttr;
        }

        public final void setDefStyleAttr$xtooltip_release(int n) {
            this.defStyleAttr = n;
        }

        @Nullable
        public final Typeface getTypeface$xtooltip_release() {
            return this.typeface;
        }

        public final void setTypeface$xtooltip_release(@Nullable Typeface typeface) {
            this.typeface = typeface;
        }

        public final boolean getOverlay$xtooltip_release() {
            return this.overlay;
        }

        public final void setOverlay$xtooltip_release(boolean bl) {
            this.overlay = bl;
        }

        @Nullable
        public final Animation getFloatingAnimation$xtooltip_release() {
            return this.floatingAnimation;
        }

        public final void setFloatingAnimation$xtooltip_release(@Nullable Animation animation) {
            this.floatingAnimation = animation;
        }

        public final long getShowDuration$xtooltip_release() {
            return this.showDuration;
        }

        public final void setShowDuration$xtooltip_release(long l) {
            this.showDuration = l;
        }

        public final long getFadeDuration$xtooltip_release() {
            return this.fadeDuration;
        }

        public final void setFadeDuration$xtooltip_release(long l) {
            this.fadeDuration = l;
        }

        public final boolean getShowArrow$xtooltip_release() {
            return this.showArrow;
        }

        public final void setShowArrow$xtooltip_release(boolean bl) {
            this.showArrow = bl;
        }

        public final long getActivateDelay$xtooltip_release() {
            return this.activateDelay;
        }

        public final void setActivateDelay$xtooltip_release(long l) {
            this.activateDelay = l;
        }

        public final boolean getFollowAnchor$xtooltip_release() {
            return this.followAnchor;
        }

        public final void setFollowAnchor$xtooltip_release(boolean bl) {
            this.followAnchor = bl;
        }

        @Nullable
        public final Integer getLayoutId$xtooltip_release() {
            return this.layoutId;
        }

        public final void setLayoutId$xtooltip_release(@Nullable Integer n) {
            this.layoutId = n;
        }

        @Nullable
        public final Integer getTextId$xtooltip_release() {
            return this.textId;
        }

        public final void setTextId$xtooltip_release(@Nullable Integer n) {
            this.textId = n;
        }

        @NotNull
        public final Builder typeface(@Nullable Typeface value) {
            this.typeface = value;
            return this;
        }

        @NotNull
        public final Builder styleId(@StyleRes @Nullable Integer styleId) {
            Integer n = styleId;
            if (n != null) {
                Integer n2 = n;
                int it = ((Number)n2).intValue();
                this.defStyleAttr = 0;
                this.defStyleRes = it;
            } else {
                Builder builder;
                Builder $receiver = builder = this;
                $receiver.defStyleRes = R.style.ToolTipLayoutDefaultStyle;
                $receiver.defStyleAttr = R.attr.ttlm_defaultStyle;
            }
            return this;
        }

        @NotNull
        public final Builder customView(@LayoutRes int layoutId, @IdRes int textId) {
            this.layoutId = layoutId;
            this.textId = textId;
            return this;
        }

        @NotNull
        public final Builder activateDelay(long value) {
            this.activateDelay = value;
            return this;
        }

        @NotNull
        public final Builder arrow(boolean value) {
            this.showArrow = value;
            return this;
        }

        @NotNull
        public final Builder fadeDuration(long value) {
            this.fadeDuration = value;
            return this;
        }

        @NotNull
        public final Builder showDuration(long value) {
            this.showDuration = value;
            return this;
        }

        @NotNull
        public final Builder floatingAnimation(@Nullable Animation value) {
            this.floatingAnimation = value;
            return this;
        }

        @NotNull
        public final Builder maxWidth(int w) {
            this.maxWidth = w;
            return this;
        }

        @NotNull
        public final Builder overlay(boolean value) {
            this.overlay = value;
            return this;
        }

        @NotNull
        public final Builder anchor(int x, int y) {
            this.anchorView = null;
            this.point = new Point(x, y);
            return this;
        }

        @NotNull
        public final Builder anchor(@NotNull View view, int xoff, int yoff, boolean follow) {
            Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
            this.anchorView = view;
            this.followAnchor = follow;
            this.point = new Point(xoff, yoff);
            return this;
        }

        @NotNull
        public static /* synthetic */ Builder anchor$default(Builder builder, View view, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            if ((n3 & 8) != 0) {
                bl = false;
            }
            return builder.anchor(view, n, n2, bl);
        }

        @NotNull
        public final Builder text(@NotNull CharSequence text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.text = text;
            return this;
        }

        @NotNull
        public final Builder text(@StringRes int text) {
            this.text = this.context.getString(text);
            return this;
        }

        @NotNull
        public final Builder text(@StringRes int text, Object ... args) {
            Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
            this.text = this.context.getString(text, new Object[]{args});
            return this;
        }

        @NotNull
        public final Builder closePolicy(@NotNull ClosePolicy policy) {
            Intrinsics.checkParameterIsNotNull((Object)policy, (String)"policy");
            this.closePolicy = policy;
            Timber.v((String)("closePolicy: " + policy), (Object[])new Object[0]);
            return this;
        }

        @NotNull
        public final Tooltip create() {
            if (this.anchorView == null && this.point == null) {
                throw (Throwable)new IllegalArgumentException("missing anchor point or anchor view");
            }
            return new Tooltip(this.context, this, null);
        }

        public Builder(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
            this.closePolicy = ClosePolicy.Companion.getTOUCH_INSIDE_CONSUME();
            this.defStyleRes = R.style.ToolTipLayoutDefaultStyle;
            this.defStyleAttr = R.attr.ttlm_defaultStyle;
            this.overlay = true;
            this.fadeDuration = 100L;
            this.showArrow = true;
        }
    }
}

