/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.xtooltip;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.animation.AccelerateDecelerateInterpolator;
import it.sephiroth.android.library.xtooltip.R;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 @2\u00020\u0001:\u0001@B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0005H\u0016J\b\u00100\u001a\u00020\u0005H\u0016J\b\u00101\u001a\u00020\u0005H\u0016J\u0010\u00102\u001a\u00020,2\u0006\u00103\u001a\u000204H\u0014J\b\u00105\u001a\u00020,H\u0002J\b\u00106\u001a\u00020,H\u0002J\u0010\u00107\u001a\u00020,2\u0006\u00108\u001a\u00020\u0005H\u0016J\u0012\u00109\u001a\u00020,2\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0018\u0010<\u001a\u00020#2\u0006\u0010=\u001a\u00020#2\u0006\u0010>\u001a\u00020#H\u0016J\b\u0010?\u001a\u00020,H\u0002R$\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010$\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b%\u0010\n\"\u0004\b&\u0010\fR$\u0010'\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u000e8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010\u0011\u00a8\u0006A"}, d2={"Lit/sephiroth/android/library/xtooltip/TooltipOverlayDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "defStyleResId", "", "(Landroid/content/Context;I)V", "value", "innerAlpha", "getInnerAlpha", "()I", "setInnerAlpha", "(I)V", "rippleRadius", "", "innerRadius", "setInnerRadius", "(F)V", "mDuration", "", "mFirstAnimator", "Landroid/animation/ValueAnimator;", "mFirstAnimatorSet", "Landroid/animation/AnimatorSet;", "mInnerAlpha", "mInnerPaint", "Landroid/graphics/Paint;", "mOuterAlpha", "mOuterPaint", "mOuterRadius", "mRepeatCount", "mRepeatIndex", "mSecondAnimator", "mSecondAnimatorSet", "mStarted", "", "outerAlpha", "getOuterAlpha", "setOuterAlpha", "outerRadius", "getOuterRadius", "()F", "setOuterRadius", "draw", "", "canvas", "Landroid/graphics/Canvas;", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "onBoundsChange", "bounds", "Landroid/graphics/Rect;", "play", "replay", "setAlpha", "i", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "setVisible", "visible", "restart", "stop", "Companion", "xtooltip_release"})
public final class TooltipOverlayDrawable
extends Drawable {
    private final Paint mOuterPaint;
    private final Paint mInnerPaint;
    private float mOuterRadius;
    private float innerRadius;
    private final AnimatorSet mFirstAnimatorSet;
    private final AnimatorSet mSecondAnimatorSet;
    private final ValueAnimator mFirstAnimator;
    private final ValueAnimator mSecondAnimator;
    private int mRepeatIndex;
    private boolean mStarted;
    private final int mOuterAlpha;
    private final int mInnerAlpha;
    private int mRepeatCount;
    private long mDuration;
    public static final float ALPHA_MAX = 255.0f;
    public static final double FADEOUT_START_DELAY = 0.55;
    public static final double FADEIN_DURATION = 0.3;
    public static final double SECOND_ANIM_START_DELAY = 0.25;
    public static final Companion Companion = new Companion(null);

    private final void setInnerRadius(float rippleRadius) {
        this.innerRadius = rippleRadius;
        this.invalidateSelf();
    }

    private final int getOuterAlpha() {
        return this.mOuterPaint.getAlpha();
    }

    private final void setOuterAlpha(int value) {
        this.mOuterPaint.setAlpha(value);
        this.invalidateSelf();
    }

    private final int getInnerAlpha() {
        return this.mInnerPaint.getAlpha();
    }

    private final void setInnerAlpha(int value) {
        this.mInnerPaint.setAlpha(value);
        this.invalidateSelf();
    }

    private final float getOuterRadius() {
        return this.mOuterRadius;
    }

    private final void setOuterRadius(float value) {
        this.mOuterRadius = value;
        this.invalidateSelf();
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Rect bounds = this.getBounds();
        int centerX = bounds.width() / 2;
        int centerY = bounds.height() / 2;
        canvas.drawCircle((float)centerX, (float)centerY, this.mOuterRadius, this.mOuterPaint);
        canvas.drawCircle((float)centerX, (float)centerY, this.innerRadius, this.mInnerPaint);
    }

    public void setAlpha(int i) {
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
    }

    public boolean setVisible(boolean visible, boolean restart) {
        boolean changed;
        boolean bl = changed = this.isVisible() != visible;
        if (visible) {
            if (restart || !this.mStarted) {
                this.replay();
            }
        } else {
            this.stop();
        }
        return changed;
    }

    public int getOpacity() {
        return -3;
    }

    protected void onBoundsChange(@NotNull Rect bounds) {
        Intrinsics.checkParameterIsNotNull((Object)bounds, (String)"bounds");
        Timber.i((String)("onBoundsChange: " + bounds), (Object[])new Object[0]);
        super.onBoundsChange(bounds);
        this.mOuterRadius = Math.min(bounds.width(), bounds.height()) / 2;
        this.mFirstAnimator.setFloatValues(new float[]{0.0f, this.mOuterRadius});
        this.mSecondAnimator.setFloatValues(new float[]{0.0f, this.mOuterRadius});
    }

    public int getIntrinsicWidth() {
        return 96;
    }

    public int getIntrinsicHeight() {
        return 96;
    }

    private final void play() {
        this.mRepeatIndex = 0;
        this.mStarted = true;
        this.mFirstAnimatorSet.start();
        this.mSecondAnimatorSet.setStartDelay((long)((double)this.mDuration * 0.25));
        this.mSecondAnimatorSet.start();
    }

    private final void replay() {
        this.stop();
        this.play();
    }

    private final void stop() {
        this.mFirstAnimatorSet.cancel();
        this.mSecondAnimatorSet.cancel();
        this.mRepeatIndex = 0;
        this.mStarted = false;
        this.setInnerRadius(0.0f);
        this.setOuterRadius(0.0f);
    }

    /*
     * WARNING - void declaration
     */
    public TooltipOverlayDrawable(@NotNull Context context, int defStyleResId) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.mOuterPaint = new Paint(1);
        this.mInnerPaint = new Paint(1);
        this.mRepeatCount = 1;
        this.mDuration = 400L;
        this.mOuterPaint.setStyle(Paint.Style.FILL);
        this.mInnerPaint.setStyle(Paint.Style.FILL);
        TypedArray array = context.getTheme().obtainStyledAttributes(defStyleResId, R.styleable.TooltipOverlay);
        int n = 0;
        TypedArray typedArray = array;
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"array");
        int n2 = typedArray.getIndexCount();
        while (n < n2) {
            void i;
            int index = array.getIndex((int)i);
            int n3 = index;
            if (n3 == R.styleable.TooltipOverlay_android_color) {
                int color = array.getColor(index, 0);
                this.mOuterPaint.setColor(color);
                this.mInnerPaint.setColor(color);
            } else if (n3 == R.styleable.TooltipOverlay_ttlm_repeatCount) {
                this.mRepeatCount = array.getInt(index, 1);
            } else if (n3 == R.styleable.TooltipOverlay_android_alpha) {
                int alpha = (int)(array.getFloat(index, (float)this.mInnerPaint.getAlpha() / 255.0f) * (float)255);
                this.mInnerPaint.setAlpha(alpha);
                this.mOuterPaint.setAlpha(alpha);
            } else if (n3 == R.styleable.TooltipOverlay_ttlm_duration) {
                this.mDuration = array.getInt(index, 400);
            }
            ++i;
        }
        array.recycle();
        this.mOuterAlpha = this.getOuterAlpha();
        this.mInnerAlpha = this.getInnerAlpha();
        ObjectAnimator objectAnimator = ObjectAnimator.ofInt((Object)((Object)this), (String)"outerAlpha", (int[])new int[]{0, this.mOuterAlpha});
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator, (String)"ObjectAnimator.ofInt(thi\u2026erAlpha\", 0, mOuterAlpha)");
        Animator fadeIn = (Animator)objectAnimator;
        fadeIn.setDuration((long)((double)this.mDuration * 0.3));
        ObjectAnimator objectAnimator2 = ObjectAnimator.ofInt((Object)((Object)this), (String)"outerAlpha", (int[])new int[]{this.mOuterAlpha, 0, 0});
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator2, (String)"ObjectAnimator.ofInt(thi\u2026lpha\", mOuterAlpha, 0, 0)");
        Animator fadeOut = (Animator)objectAnimator2;
        fadeOut.setStartDelay((long)((double)this.mDuration * 0.55));
        fadeOut.setDuration((long)((double)this.mDuration * 0.44999999999999996));
        ObjectAnimator objectAnimator3 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"outerRadius", (float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator3, (String)"ObjectAnimator.ofFloat(t\u2026s, \"outerRadius\", 0f, 1f)");
        this.mFirstAnimator = (ValueAnimator)objectAnimator3;
        ((ObjectAnimator)this.mFirstAnimator).setDuration(this.mDuration);
        this.mFirstAnimatorSet = new AnimatorSet();
        this.mFirstAnimatorSet.playTogether(new Animator[]{fadeIn, (Animator)this.mFirstAnimator, fadeOut});
        this.mFirstAnimatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mFirstAnimatorSet.setDuration(this.mDuration);
        ObjectAnimator objectAnimator4 = ObjectAnimator.ofInt((Object)((Object)this), (String)"innerAlpha", (int[])new int[]{0, this.mInnerAlpha});
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator4, (String)"ObjectAnimator.ofInt(thi\u2026erAlpha\", 0, mInnerAlpha)");
        fadeIn = (Animator)objectAnimator4;
        ((ObjectAnimator)fadeIn).setDuration((long)((double)this.mDuration * 0.3));
        ObjectAnimator objectAnimator5 = ObjectAnimator.ofInt((Object)((Object)this), (String)"innerAlpha", (int[])new int[]{this.mInnerAlpha, 0, 0});
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator5, (String)"ObjectAnimator.ofInt(thi\u2026lpha\", mInnerAlpha, 0, 0)");
        fadeOut = (Animator)objectAnimator5;
        fadeOut.setStartDelay((long)((double)this.mDuration * 0.55));
        ((ObjectAnimator)fadeOut).setDuration((long)((double)this.mDuration * 0.44999999999999996));
        ObjectAnimator objectAnimator6 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"innerRadius", (float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator6, (String)"ObjectAnimator.ofFloat(t\u2026s, \"innerRadius\", 0f, 1f)");
        this.mSecondAnimator = (ValueAnimator)objectAnimator6;
        ((ObjectAnimator)this.mSecondAnimator).setDuration(this.mDuration);
        this.mSecondAnimatorSet = new AnimatorSet();
        this.mSecondAnimatorSet.playTogether(new Animator[]{fadeIn, (Animator)this.mSecondAnimator, fadeOut});
        this.mSecondAnimatorSet.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        this.mSecondAnimatorSet.setStartDelay((long)((double)this.mDuration * 0.25));
        this.mSecondAnimatorSet.setDuration(this.mDuration);
        this.mFirstAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            private boolean cancelled;

            public final boolean getCancelled() {
                return this.cancelled;
            }

            public final void setCancelled(boolean bl) {
                this.cancelled = bl;
            }

            public void onAnimationCancel(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                super.onAnimationCancel(animation);
                this.cancelled = true;
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                if (!this.cancelled && this.isVisible()) {
                    TooltipOverlayDrawable tooltipOverlayDrawable = this;
                    tooltipOverlayDrawable.mRepeatIndex = tooltipOverlayDrawable.mRepeatIndex + 1;
                    if (tooltipOverlayDrawable.mRepeatIndex < mRepeatCount) {
                        mFirstAnimatorSet.start();
                    }
                }
            }
        });
        this.mSecondAnimatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){
            private boolean cancelled;

            public final boolean getCancelled() {
                return this.cancelled;
            }

            public final void setCancelled(boolean bl) {
                this.cancelled = bl;
            }

            public void onAnimationCancel(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                super.onAnimationCancel(animation);
                this.cancelled = true;
            }

            public void onAnimationEnd(@NotNull Animator animation) {
                Intrinsics.checkParameterIsNotNull((Object)animation, (String)"animation");
                if (!this.cancelled && this.isVisible() && mRepeatIndex < mRepeatCount) {
                    mSecondAnimatorSet.setStartDelay(0L);
                    mSecondAnimatorSet.start();
                }
            }
        });
    }

    public static final /* synthetic */ void access$setMRepeatCount$p(TooltipOverlayDrawable $this, int n) {
        $this.mRepeatCount = n;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lit/sephiroth/android/library/xtooltip/TooltipOverlayDrawable$Companion;", "", "()V", "ALPHA_MAX", "", "FADEIN_DURATION", "", "FADEOUT_START_DELAY", "SECOND_ANIM_START_DELAY", "xtooltip_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

