/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import it.sephiroth.android.library.tooltip.R;
import it.sephiroth.android.library.tooltip.Tooltip;
import it.sephiroth.android.library.tooltip.Utils;

class TooltipTextDrawable
extends Drawable {
    public static final float ARROW_RATIO_DEFAULT = 1.4f;
    public static final float ALPHA_MAX = 255.0f;
    static final String TAG = "TooltipTextDrawable";
    private final RectF rectF;
    private final Path path;
    private final Point tmpPoint = new Point();
    private final Rect outlineRect = new Rect();
    private final Paint bgPaint;
    private final Paint stPaint;
    private final float arrowRatio;
    private final float ellipseSize;
    private Point point;
    private int padding = 0;
    private int arrowWeight = 0;
    private Tooltip.Gravity gravity;

    public TooltipTextDrawable(Context context, Tooltip.Builder builder) {
        TypedArray theme = context.getTheme().obtainStyledAttributes(null, R.styleable.TooltipLayout, builder.defStyleAttr, builder.defStyleRes);
        this.ellipseSize = theme.getDimensionPixelSize(R.styleable.TooltipLayout_ttlm_cornerRadius, 4);
        int strokeWidth = theme.getDimensionPixelSize(R.styleable.TooltipLayout_ttlm_strokeWeight, 2);
        int backgroundColor = theme.getColor(R.styleable.TooltipLayout_ttlm_backgroundColor, 0);
        int strokeColor = theme.getColor(R.styleable.TooltipLayout_ttlm_strokeColor, 0);
        this.arrowRatio = theme.getFloat(R.styleable.TooltipLayout_ttlm_arrowRatio, 1.4f);
        theme.recycle();
        this.rectF = new RectF();
        if (backgroundColor != 0) {
            this.bgPaint = new Paint(1);
            this.bgPaint.setColor(backgroundColor);
            this.bgPaint.setStyle(Paint.Style.FILL);
        } else {
            this.bgPaint = null;
        }
        if (strokeColor != 0) {
            this.stPaint = new Paint(1);
            this.stPaint.setColor(strokeColor);
            this.stPaint.setStyle(Paint.Style.STROKE);
            this.stPaint.setStrokeWidth((float)strokeWidth);
        } else {
            this.stPaint = null;
        }
        this.path = new Path();
    }

    public void draw(Canvas canvas) {
        if (null != this.bgPaint) {
            canvas.drawPath(this.path, this.bgPaint);
        }
        if (null != this.stPaint) {
            canvas.drawPath(this.path, this.stPaint);
        }
    }

    public void setAnchor(Tooltip.Gravity gravity, int padding, @Nullable Point point) {
        if (gravity != this.gravity || padding != this.padding || !Utils.equals(this.point, point)) {
            this.gravity = gravity;
            this.padding = padding;
            this.arrowWeight = (int)((float)padding / this.arrowRatio);
            this.point = null != point ? new Point(point) : null;
            Rect bounds = this.getBounds();
            if (!bounds.isEmpty()) {
                this.calculatePath(this.getBounds());
                this.invalidateSelf();
            }
        }
    }

    void calculatePath(Rect outBounds) {
        int left = outBounds.left + this.padding;
        int top = outBounds.top + this.padding;
        int right = outBounds.right - this.padding;
        int bottom = outBounds.bottom - this.padding;
        float maxY = (float)bottom - this.ellipseSize;
        float maxX = (float)right - this.ellipseSize;
        float minY = (float)top + this.ellipseSize;
        float minX = (float)left + this.ellipseSize;
        if (null != this.point && null != this.gravity) {
            this.calculatePathWithGravity(outBounds, left, top, right, bottom, maxY, maxX, minY, minX);
        } else {
            this.rectF.set((float)left, (float)top, (float)right, (float)bottom);
            this.path.addRoundRect(this.rectF, this.ellipseSize, this.ellipseSize, Path.Direction.CW);
        }
    }

    private void calculatePathWithGravity(Rect outBounds, int left, int top, int right, int bottom, float maxY, float maxX, float minY, float minX) {
        boolean drawPoint = TooltipTextDrawable.isDrawPoint(left, top, right, bottom, maxY, maxX, minY, minX, this.tmpPoint, this.point, this.gravity, this.arrowWeight);
        TooltipTextDrawable.clampPoint(left, top, right, bottom, this.tmpPoint);
        this.path.reset();
        this.path.moveTo((float)left + this.ellipseSize, (float)top);
        if (drawPoint && this.gravity == Tooltip.Gravity.BOTTOM) {
            this.path.lineTo((float)(left + this.tmpPoint.x - this.arrowWeight), (float)top);
            this.path.lineTo((float)(left + this.tmpPoint.x), (float)outBounds.top);
            this.path.lineTo((float)(left + this.tmpPoint.x + this.arrowWeight), (float)top);
        }
        this.path.lineTo((float)right - this.ellipseSize, (float)top);
        this.path.quadTo((float)right, (float)top, (float)right, (float)top + this.ellipseSize);
        if (drawPoint && this.gravity == Tooltip.Gravity.LEFT) {
            this.path.lineTo((float)right, (float)(top + this.tmpPoint.y - this.arrowWeight));
            this.path.lineTo((float)outBounds.right, (float)(top + this.tmpPoint.y));
            this.path.lineTo((float)right, (float)(top + this.tmpPoint.y + this.arrowWeight));
        }
        this.path.lineTo((float)right, (float)bottom - this.ellipseSize);
        this.path.quadTo((float)right, (float)bottom, (float)right - this.ellipseSize, (float)bottom);
        if (drawPoint && this.gravity == Tooltip.Gravity.TOP) {
            this.path.lineTo((float)(left + this.tmpPoint.x + this.arrowWeight), (float)bottom);
            this.path.lineTo((float)(left + this.tmpPoint.x), (float)outBounds.bottom);
            this.path.lineTo((float)(left + this.tmpPoint.x - this.arrowWeight), (float)bottom);
        }
        this.path.lineTo((float)left + this.ellipseSize, (float)bottom);
        this.path.quadTo((float)left, (float)bottom, (float)left, (float)bottom - this.ellipseSize);
        if (drawPoint && this.gravity == Tooltip.Gravity.RIGHT) {
            this.path.lineTo((float)left, (float)(top + this.tmpPoint.y + this.arrowWeight));
            this.path.lineTo((float)outBounds.left, (float)(top + this.tmpPoint.y));
            this.path.lineTo((float)left, (float)(top + this.tmpPoint.y - this.arrowWeight));
        }
        this.path.lineTo((float)left, (float)top + this.ellipseSize);
        this.path.quadTo((float)left, (float)top, (float)left + this.ellipseSize, (float)top);
    }

    private static boolean isDrawPoint(int left, int top, int right, int bottom, float maxY, float maxX, float minY, float minX, Point tmpPoint, Point point, Tooltip.Gravity gravity, int arrowWeight) {
        boolean drawPoint = false;
        tmpPoint.set(point.x, point.y);
        if (gravity == Tooltip.Gravity.RIGHT || gravity == Tooltip.Gravity.LEFT) {
            if (tmpPoint.y >= top && tmpPoint.y <= bottom) {
                if ((float)(top + tmpPoint.y + arrowWeight) > maxY) {
                    tmpPoint.y = (int)(maxY - (float)arrowWeight - (float)top);
                } else if ((float)(top + tmpPoint.y - arrowWeight) < minY) {
                    tmpPoint.y = (int)(minY + (float)arrowWeight - (float)top);
                }
                drawPoint = true;
            }
        } else if (tmpPoint.x >= left && tmpPoint.x <= right && tmpPoint.x >= left && tmpPoint.x <= right) {
            if ((float)(left + tmpPoint.x + arrowWeight) > maxX) {
                tmpPoint.x = (int)(maxX - (float)arrowWeight - (float)left);
            } else if ((float)(left + tmpPoint.x - arrowWeight) < minX) {
                tmpPoint.x = (int)(minX + (float)arrowWeight - (float)left);
            }
            drawPoint = true;
        }
        return drawPoint;
    }

    private static void clampPoint(int left, int top, int right, int bottom, Point tmpPoint) {
        if (tmpPoint.y < top) {
            tmpPoint.y = top;
        } else if (tmpPoint.y > bottom) {
            tmpPoint.y = bottom;
        }
        if (tmpPoint.x < left) {
            tmpPoint.x = left;
        }
        if (tmpPoint.x > right) {
            tmpPoint.x = right;
        }
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.calculatePath(bounds);
    }

    public float getRadius() {
        return this.ellipseSize;
    }

    public int getAlpha() {
        return this.bgPaint.getAlpha();
    }

    public void setAlpha(int alpha) {
        this.bgPaint.setAlpha(alpha);
        this.stPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
    }

    public int getOpacity() {
        return -3;
    }

    @TargetApi(value=21)
    public void getOutline(Outline outline) {
        this.copyBounds(this.outlineRect);
        this.outlineRect.inset(this.padding, this.padding);
        outline.setRoundRect(this.outlineRect, this.getRadius());
        if (this.getAlpha() < 255) {
            outline.setAlpha(0.0f);
        }
    }
}

