/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.ImageView;
import it.sephiroth.android.library.tooltip.R;
import it.sephiroth.android.library.tooltip.TooltipOverlayDrawable;

public class TooltipOverlay
extends ImageView {
    private int mMargins;

    public TooltipOverlay(Context context) {
        this(context, null);
    }

    public TooltipOverlay(Context context, AttributeSet attrs) {
        this(context, attrs, R.style.ToolTipOverlayDefaultStyle);
    }

    public TooltipOverlay(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, R.style.ToolTipLayoutDefaultStyle);
    }

    private void init(Context context, int defStyleResId) {
        TooltipOverlayDrawable drawable = new TooltipOverlayDrawable(context, defStyleResId);
        this.setImageDrawable(drawable);
        TypedArray array = context.getTheme().obtainStyledAttributes(defStyleResId, R.styleable.TooltipOverlay);
        this.mMargins = array.getDimensionPixelSize(R.styleable.TooltipOverlay_android_layout_margin, 0);
        array.recycle();
    }

    public TooltipOverlay(Context context, AttributeSet attrs, int defStyleAttr, int defStyleResId) {
        super(context, attrs, defStyleAttr);
        this.init(context, defStyleResId);
    }

    public int getLayoutMargins() {
        return this.mMargins;
    }
}

