/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Resources;
import android.graphics.Point;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import it.sephiroth.android.library.tooltip.R;
import it.sephiroth.android.library.tooltip.TooltipView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class TooltipManager {
    public static boolean DBG = false;
    private static final String TAG = "TooltipManager";
    private static volatile TooltipManager INSTANCE;
    private final List<OnTooltipAttachedStateChange> mTooltipAttachStatusListeners = new ArrayList<OnTooltipAttachedStateChange>();
    final WeakHashMap<Integer, WeakReference<TooltipView>> mTooltips = new WeakHashMap();
    final Object lock = new Object();
    private TooltipView.OnCloseListener mCloseListener = new TooltipView.OnCloseListener(){

        @Override
        public void onClose(TooltipView layout2) {
            if (DBG) {
                Log.i((String)TooltipManager.TAG, (String)("onClose: " + layout2.getTooltipId()));
            }
            TooltipManager.this.hide(layout2.getTooltipId());
        }
    };
    private TooltipView.OnToolTipListener mTooltipListener = new TooltipView.OnToolTipListener(){

        @Override
        public void onHideCompleted(TooltipView layout2) {
            if (DBG) {
                Log.i((String)TooltipManager.TAG, (String)("onHideCompleted: " + layout2.getTooltipId()));
            }
            int id = layout2.getTooltipId();
            layout2.removeFromParent();
            TooltipManager.this.fireOnTooltipDetached(id);
        }

        @Override
        public void onShowCompleted(TooltipView layout2) {
            if (DBG) {
                Log.i((String)TooltipManager.TAG, (String)("onShowCompleted: " + layout2.getTooltipId()));
            }
        }

        @Override
        public void onShowFailed(TooltipView layout2) {
            if (DBG) {
                Log.i((String)TooltipManager.TAG, (String)("onShowFailed: " + layout2.getTooltipId()));
            }
            TooltipManager.this.remove(layout2.getTooltipId());
        }
    };

    private TooltipManager() {
    }

    public static synchronized TooltipManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TooltipManager();
        }
        return INSTANCE;
    }

    public void addOnTooltipAttachedStateChange(OnTooltipAttachedStateChange listener) {
        if (!this.mTooltipAttachStatusListeners.contains(listener)) {
            this.mTooltipAttachStatusListeners.add(listener);
        }
    }

    public void removeOnTooltipAttachedStateChange(OnTooltipAttachedStateChange listener) {
        this.mTooltipAttachStatusListeners.remove(listener);
    }

    private void fireOnTooltipDetached(int id) {
        if (this.mTooltipAttachStatusListeners.size() > 0) {
            for (OnTooltipAttachedStateChange listener : this.mTooltipAttachStatusListeners) {
                listener.onTooltipDetached(id);
            }
        }
    }

    private void fireOnTooltipAttached(int id) {
        if (this.mTooltipAttachStatusListeners.size() > 0) {
            for (OnTooltipAttachedStateChange listener : this.mTooltipAttachStatusListeners) {
                listener.onTooltipAttached(id);
            }
        }
    }

    public Builder create(Context context, int id) {
        return new Builder(this, context, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean show(Builder builder, boolean immediate) {
        if (DBG) {
            Log.i((String)TAG, (String)"show");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.mTooltips.containsKey(builder.id)) {
                Log.w((String)TAG, (String)"A Tooltip with the same id was walready specified");
                return false;
            }
            TooltipView layout2 = new TooltipView(builder.context, builder);
            layout2.setOnCloseListener(this.mCloseListener);
            layout2.setOnToolTipListener(this.mTooltipListener);
            this.mTooltips.put(builder.id, new WeakReference<TooltipView>(layout2));
            Activity act = TooltipManager.getActivity(builder.context);
            if (null == act || act.getWindow() == null || act.getWindow().getDecorView() == null) {
                return false;
            }
            this.showInternal(act.getWindow().getDecorView(), layout2, immediate);
        }
        this.printStats();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide(int id) {
        WeakReference<TooltipView> layout2;
        if (DBG) {
            Log.i((String)TAG, (String)("hide: " + id));
        }
        Object object = this.lock;
        synchronized (object) {
            layout2 = this.mTooltips.remove(id);
        }
        if (null != layout2) {
            TooltipView tooltipView = (TooltipView)layout2.get();
            tooltipView.setOnCloseListener(null);
            tooltipView.hide(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TooltipView get(int id) {
        Object object = this.lock;
        synchronized (object) {
            WeakReference<TooltipView> weakReference = this.mTooltips.get(id);
            if (weakReference != null) {
                return (TooltipView)weakReference.get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int id) {
        TooltipView layout2;
        Object object = this.lock;
        synchronized (object) {
            layout2 = this.get(id);
        }
        if (null != layout2) {
            if (DBG) {
                Log.i((String)TAG, (String)("update: " + id));
            }
            layout2.layout(layout2.getLeft(), layout2.getTop(), layout2.getRight(), layout2.getBottom());
            layout2.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean active(int id) {
        Object object = this.lock;
        synchronized (object) {
            return this.mTooltips.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(int id) {
        WeakReference<TooltipView> layout2;
        if (DBG) {
            Log.i((String)TAG, (String)("remove: " + id));
        }
        Object object = this.lock;
        synchronized (object) {
            layout2 = this.mTooltips.remove(id);
        }
        if (null != layout2) {
            TooltipView tooltipView = (TooltipView)layout2.get();
            tooltipView.setOnCloseListener(null);
            tooltipView.setOnToolTipListener(null);
            tooltipView.removeFromParent();
            this.fireOnTooltipDetached(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(int id, CharSequence text) {
        TooltipView layout2;
        Object object = this.lock;
        synchronized (object) {
            layout2 = this.get(id);
        }
        if (null != layout2) {
            layout2.setText(text);
        }
    }

    private void printStats() {
        if (DBG) {
            Log.d((String)TAG, (String)("active tooltips: " + this.mTooltips.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        if (DBG) {
            Log.i((String)TAG, (String)"destroy");
        }
        Object object = this.lock;
        synchronized (object) {
            for (int id : this.mTooltips.keySet()) {
                this.remove(id);
            }
        }
        this.mTooltipAttachStatusListeners.clear();
        this.printStats();
    }

    private void showInternal(View rootView, TooltipView layout2, boolean immediate) {
        if (null != rootView && rootView instanceof ViewGroup) {
            if (layout2.getParent() == null) {
                if (DBG) {
                    Log.v((String)TAG, (String)"attach to mToolTipLayout parent");
                }
                ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
                ((ViewGroup)rootView).addView((View)layout2, params);
            }
            if (immediate) {
                layout2.show();
            }
            this.fireOnTooltipAttached(layout2.getTooltipId());
        }
    }

    @Nullable
    static Activity getActivity(@Nullable Context cont) {
        if (cont == null) {
            return null;
        }
        if (cont instanceof Activity) {
            return (Activity)cont;
        }
        if (cont instanceof ContextWrapper) {
            return TooltipManager.getActivity(((ContextWrapper)cont).getBaseContext());
        }
        return null;
    }

    public static interface onTooltipClosingCallback {
        public void onClosing(int var1, boolean var2, boolean var3);
    }

    public static enum Gravity {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        CENTER;

    }

    public static enum ClosePolicy {
        TouchInside,
        TouchInsideExclusive,
        TouchOutside,
        TouchOutsideExclusive,
        None;

    }

    public static final class Builder {
        final Context context;
        int id;
        CharSequence text;
        View view;
        Gravity gravity;
        int actionbarSize = 0;
        int textResId = R.layout.tooltip_textview;
        ClosePolicy closePolicy;
        long showDuration;
        Point point;
        WeakReference<TooltipManager> manager;
        long showDelay = 0L;
        boolean hideArrow;
        int maxWidth = -1;
        int defStyleRes = R.style.ToolTipLayoutDefaultStyle;
        int defStyleAttr = R.attr.ttlm_defaultStyle;
        long activateDelay = 0L;
        boolean isCustomView;
        boolean restrictToScreenEdges = true;
        long fadeDuration = 200L;
        onTooltipClosingCallback closeCallback;

        Builder(TooltipManager manager, Context context, int id) {
            this.manager = new WeakReference<TooltipManager>(manager);
            this.id = id;
            this.context = context;
        }

        public Builder withCustomView(int resId, boolean replace_background) {
            this.textResId = resId;
            this.isCustomView = replace_background;
            return this;
        }

        public Builder withCustomView(int resId) {
            return this.withCustomView(resId, true);
        }

        public Builder withStyleId(int styleId) {
            this.defStyleAttr = 0;
            this.defStyleRes = styleId;
            return this;
        }

        public Builder fitToScreen(boolean value) {
            this.restrictToScreenEdges = value;
            return this;
        }

        public Builder fadeDuration(long ms) {
            this.fadeDuration = ms;
            return this;
        }

        public Builder withCallback(onTooltipClosingCallback callback) {
            this.closeCallback = callback;
            return this;
        }

        public Builder text(Resources res, int resid) {
            return this.text(res.getString(resid));
        }

        public Builder text(int resid) {
            if (null != this.view) {
                return this.text(this.view.getResources().getString(resid));
            }
            return this;
        }

        public Builder text(CharSequence text) {
            this.text = text;
            return this;
        }

        public Builder maxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public Builder anchor(View view, Gravity gravity) {
            this.point = null;
            this.view = view;
            this.gravity = gravity;
            return this;
        }

        public Builder anchor(Point point, Gravity gravity) {
            this.view = null;
            this.point = new Point(point);
            this.gravity = gravity;
            return this;
        }

        public Builder toggleArrow(boolean show) {
            this.hideArrow = !show;
            return this;
        }

        public Builder actionBarSize(int actionBarSize) {
            this.actionbarSize = actionBarSize;
            return this;
        }

        public Builder actionBarSize(Resources resources, int resId) {
            return this.actionBarSize(resources.getDimensionPixelSize(resId));
        }

        public Builder closePolicy(ClosePolicy policy, long milliseconds) {
            this.closePolicy = policy;
            this.showDuration = milliseconds;
            return this;
        }

        public Builder activateDelay(long ms) {
            this.activateDelay = ms;
            return this;
        }

        public Builder showDelay(long ms) {
            this.showDelay = ms;
            return this;
        }

        public boolean show() {
            TooltipManager tmanager;
            if (null == this.closePolicy) {
                throw new IllegalStateException("ClosePolicy cannot be null");
            }
            if (null == this.point && null == this.view) {
                throw new IllegalStateException("Target point or target view must be specified");
            }
            if (this.gravity == Gravity.CENTER) {
                this.hideArrow = true;
            }
            if (null != (tmanager = (TooltipManager)this.manager.get())) {
                return tmanager.show(this, true);
            }
            return false;
        }
    }

    public static interface OnTooltipAttachedStateChange {
        public void onTooltipAttached(int var1);

        public void onTooltipDetached(int var1);
    }
}

