/*
 * Decompiled with CFR 0.152.
 */
package it.sephiroth.android.library.tooltip;

import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.annotation.Size;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import it.sephiroth.android.library.tooltip.R;
import it.sephiroth.android.library.tooltip.TooltipView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class TooltipManager {
    static final boolean DBG = false;
    private static final String TAG = "TooltipManager";
    private static volatile TooltipManager INSTANCE;
    private final List<OnTooltipAttachedStateChange> mTooltipAttachStatusListeners = new ArrayList<OnTooltipAttachedStateChange>();
    final WeakHashMap<Integer, WeakReference<TooltipView>> mTooltips = new WeakHashMap();
    final Object lock = new Object();
    private TooltipView.OnCloseListener mCloseListener = new TooltipView.OnCloseListener(){

        @Override
        public void onClose(TooltipView layout2) {
            TooltipManager.this.hide(layout2.getTooltipId());
        }
    };
    private TooltipView.OnToolTipListener mTooltipListener = new TooltipView.OnToolTipListener(){

        @Override
        public void onHideCompleted(TooltipView layout2) {
            int id = layout2.getTooltipId();
            layout2.removeFromParent();
            TooltipManager.this.fireOnTooltipDetached(id);
        }

        @Override
        public void onShowCompleted(TooltipView layout2) {
        }

        @Override
        public void onShowFailed(TooltipView layout2) {
            TooltipManager.this.remove(layout2.getTooltipId());
        }
    };

    private TooltipManager() {
    }

    public static synchronized TooltipManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TooltipManager();
        }
        return INSTANCE;
    }

    public void addOnTooltipAttachedStateChange(OnTooltipAttachedStateChange listener) {
        if (!this.mTooltipAttachStatusListeners.contains(listener)) {
            this.mTooltipAttachStatusListeners.add(listener);
        }
    }

    public void removeOnTooltipAttachedStateChange(OnTooltipAttachedStateChange listener) {
        this.mTooltipAttachStatusListeners.remove(listener);
    }

    private void fireOnTooltipDetached(int id) {
        if (this.mTooltipAttachStatusListeners.size() > 0) {
            for (OnTooltipAttachedStateChange listener : this.mTooltipAttachStatusListeners) {
                listener.onTooltipDetached(id);
            }
        }
    }

    private void fireOnTooltipAttached(int id) {
        if (this.mTooltipAttachStatusListeners.size() > 0) {
            for (OnTooltipAttachedStateChange listener : this.mTooltipAttachStatusListeners) {
                listener.onTooltipAttached(id);
            }
        }
    }

    public Builder create(int id) {
        return new Builder(this, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean show(Builder builder, boolean immediate) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mTooltips.containsKey(builder.id)) {
                Log.w((String)TAG, (String)"A Tooltip with the same id was walready specified");
                return false;
            }
            TooltipView layout2 = new TooltipView(builder.view.getContext(), builder);
            layout2.setOnCloseListener(this.mCloseListener);
            layout2.setOnToolTipListener(this.mTooltipListener);
            this.mTooltips.put(builder.id, new WeakReference<TooltipView>(layout2));
            this.showInternal(builder.view.getRootView(), layout2, immediate);
        }
        this.printStats();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide(int id) {
        WeakReference<TooltipView> layout2;
        Object object = this.lock;
        synchronized (object) {
            layout2 = this.mTooltips.remove(id);
        }
        if (null != layout2) {
            TooltipView tooltipView = (TooltipView)layout2.get();
            tooltipView.setOnCloseListener(null);
            tooltipView.hide(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public TooltipView get(int id) {
        Object object = this.lock;
        synchronized (object) {
            WeakReference<TooltipView> weakReference = this.mTooltips.get(id);
            if (weakReference != null) {
                return (TooltipView)weakReference.get();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int id) {
        TooltipView layout2;
        Object object = this.lock;
        synchronized (object) {
            layout2 = this.get(id);
        }
        if (null != layout2) {
            layout2.layout(layout2.getLeft(), layout2.getTop(), layout2.getRight(), layout2.getBottom());
            layout2.requestLayout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean active(int id) {
        Object object = this.lock;
        synchronized (object) {
            return this.mTooltips.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void remove(int id) {
        WeakReference<TooltipView> layout2;
        Object object = this.lock;
        synchronized (object) {
            layout2 = this.mTooltips.remove(id);
        }
        if (null != layout2) {
            TooltipView tooltipView = (TooltipView)layout2.get();
            tooltipView.setOnCloseListener(null);
            tooltipView.setOnToolTipListener(null);
            tooltipView.removeFromParent();
            this.fireOnTooltipDetached(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(int id, CharSequence text) {
        TooltipView layout2;
        Object object = this.lock;
        synchronized (object) {
            layout2 = this.get(id);
        }
        if (null != layout2) {
            layout2.setText(text);
        }
    }

    private void printStats() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroy() {
        Object object = this.lock;
        synchronized (object) {
            for (int id : this.mTooltips.keySet()) {
                this.remove(id);
            }
        }
        this.mTooltipAttachStatusListeners.clear();
        this.printStats();
    }

    private void showInternal(View rootView, TooltipView layout2, boolean immediate) {
        if (null != rootView && rootView instanceof ViewGroup) {
            if (layout2.getParent() == null) {
                ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
                ((ViewGroup)rootView).addView((View)layout2, params);
            }
            if (immediate) {
                layout2.show();
            }
            this.fireOnTooltipAttached(layout2.getTooltipId());
        }
    }

    public static interface onTooltipClosingCallback {
        public void onClosing(int var1, boolean var2, boolean var3);
    }

    public static enum Gravity {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        CENTER;

    }

    public static enum ClosePolicy {
        TouchInside,
        TouchInsideExclusive,
        TouchOutside,
        TouchOutsideExclusive,
        None;

    }

    public static final class Builder {
        int id;
        String contentDescription;
        CharSequence text;
        View view;
        Gravity gravity;
        int actionbarSize = 0;
        int textResId = R.layout.tooltip_textview;
        ClosePolicy closePolicy;
        long showDuration;
        Point point;
        WeakReference<TooltipManager> manager;
        long showDelay = 0L;
        boolean hideArrow;
        int maxWidth = -1;
        int defStyleRes = R.style.ToolTipLayoutDefaultStyle;
        int defStyleAttr = R.attr.ttlm_defaultStyle;
        long activateDelay = 0L;
        boolean isCustomView;
        boolean restrictToScreenEdges = true;
        long fadeDuration = 200L;
        onTooltipClosingCallback closeCallback;
        @ColorInt
        int bgColor = -12303292;
        @ColorInt
        int textColor = -1;
        @ColorInt
        int strokeColor = -12303292;
        @Size
        int textSize = 14;
        int textGravity = 17;
        int textAlignment;
        int textDirection;

        Builder(TooltipManager manager, int id) {
            this.manager = new WeakReference<TooltipManager>(manager);
            this.id = id;
            if (Build.VERSION.SDK_INT >= 17) {
                this.textAlignment = 4;
                this.textDirection = 0;
            }
        }

        public Builder withCustomView(int resId, boolean replace_background) {
            this.textResId = resId;
            this.isCustomView = replace_background;
            return this;
        }

        public Builder withCustomView(int resId) {
            return this.withCustomView(resId, true);
        }

        public Builder withStyleId(int styleId) {
            this.defStyleAttr = 0;
            this.defStyleRes = styleId;
            return this;
        }

        public Builder fitToScreen(boolean value) {
            this.restrictToScreenEdges = value;
            return this;
        }

        public Builder fadeDuration(long ms) {
            this.fadeDuration = ms;
            return this;
        }

        public Builder withCallback(onTooltipClosingCallback callback) {
            this.closeCallback = callback;
            return this;
        }

        public Builder text(Resources res, int resid) {
            return this.text(res.getString(resid));
        }

        public Builder text(int resid) {
            if (null != this.view) {
                return this.text(this.view.getResources().getString(resid));
            }
            return this;
        }

        public Builder text(CharSequence text) {
            this.text = text;
            return this;
        }

        public Builder maxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public Builder anchor(View view, Gravity gravity) {
            this.point = null;
            this.view = view;
            this.gravity = gravity;
            return this;
        }

        public Builder anchor(Point point, Gravity gravity) {
            this.view = null;
            this.point = new Point(point);
            this.gravity = gravity;
            return this;
        }

        public Builder toggleArrow(boolean show) {
            this.hideArrow = !show;
            return this;
        }

        public Builder actionBarSize(int actionBarSize) {
            this.actionbarSize = actionBarSize;
            return this;
        }

        public Builder actionBarSize(Resources resources, int resId) {
            return this.actionBarSize(resources.getDimensionPixelSize(resId));
        }

        public Builder closePolicy(ClosePolicy policy, long milliseconds) {
            this.closePolicy = policy;
            this.showDuration = milliseconds;
            return this;
        }

        public Builder activateDelay(long ms) {
            this.activateDelay = ms;
            return this;
        }

        public Builder showDelay(long ms) {
            this.showDelay = ms;
            return this;
        }

        public Builder backgroundRes(@ColorRes int color) {
            this.bgColor = this.view.getContext().getResources().getColor(color);
            return this;
        }

        public Builder background(@ColorInt int color) {
            this.bgColor = color;
            return this;
        }

        public Builder background(String color) {
            this.bgColor = Color.parseColor((String)color);
            return this;
        }

        public Builder strokeColorRes(@ColorRes int color) {
            this.strokeColor = this.view.getContext().getResources().getColor(color);
            return this;
        }

        public Builder strokeColor(@ColorInt int color) {
            this.strokeColor = color;
            return this;
        }

        public Builder strokeColor(String color) {
            this.strokeColor = Color.parseColor((String)color);
            return this;
        }

        public Builder textResColor(@ColorRes int color) {
            this.textColor = this.view.getContext().getResources().getColor(color);
            return this;
        }

        public Builder textColor(@ColorInt int color) {
            this.textColor = color;
            return this;
        }

        public Builder textColor(String color) {
            this.textColor = Color.parseColor((String)color);
            return this;
        }

        public Builder textGravity(int gravity) {
            this.textGravity = gravity;
            return this;
        }

        public Builder textAlignment(int alignment) {
            this.textAlignment = alignment;
            return this;
        }

        public Builder textDirection(int direction) {
            this.textDirection = direction;
            return this;
        }

        public Builder setContentDescription(String description) {
            this.contentDescription = description;
            return this;
        }

        public boolean show() {
            TooltipManager tmanager;
            if (null == this.closePolicy) {
                throw new IllegalStateException("ClosePolicy cannot be null");
            }
            if (null == this.point && null == this.view) {
                throw new IllegalStateException("Target point or target view must be specified");
            }
            if (this.gravity == Gravity.CENTER) {
                this.hideArrow = true;
            }
            if (null != (tmanager = (TooltipManager)this.manager.get())) {
                return tmanager.show(this, true);
            }
            return false;
        }

        public boolean build() {
            TooltipManager tmanager;
            if (null == this.closePolicy) {
                throw new IllegalStateException("ClosePolicy cannot be null");
            }
            if (null == this.point && null == this.view) {
                throw new IllegalStateException("Target point or target view must be specified");
            }
            if (this.gravity == Gravity.CENTER) {
                this.hideArrow = true;
            }
            return null != (tmanager = (TooltipManager)this.manager.get()) && tmanager.show(this, false);
        }
    }

    public static interface OnTooltipAttachedStateChange {
        public void onTooltipAttached(int var1);

        public void onTooltipDetached(int var1);
    }
}

