/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.HostIdentifierException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.AddressDivisionSeries;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.IPAddressDivisionSeries;
import inet.ipaddr.format.IPAddressGenericDivision;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class AddressDivisionGroupingBase
implements AddressDivisionSeries {
    private static final long serialVersionUID = 1L;
    protected static final Integer NO_PREFIX_LENGTH = -1;
    static final BigInteger ALL_ONES = BigInteger.ZERO.not();
    static ResourceBundle bundle;
    protected transient ValueCache valueCache;
    private final AddressDivisionBase[] divisions;
    protected Integer cachedPrefixLength;
    private transient Boolean isMultiple;
    private transient BigInteger cachedCount;
    private transient BigInteger cachedPrefixCount;
    protected transient int hashCode;

    public AddressDivisionGroupingBase(AddressDivisionBase[] divisions) {
        this(divisions, true);
    }

    public AddressDivisionGroupingBase(AddressDivisionBase[] divisions, boolean checkDivisions) {
        this.divisions = divisions;
        if (checkDivisions) {
            for (int i = 0; i < divisions.length; ++i) {
                if (divisions[i] != null) continue;
                throw new NullPointerException(AddressDivisionGroupingBase.getMessage("ipaddress.error.null.segment"));
            }
        }
    }

    protected static String getMessage(String key) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return key;
    }

    @Override
    public AddressDivisionBase getDivision(int index) {
        return this.getDivisionsInternal()[index];
    }

    protected void initCachedValues(Integer cachedNetworkPrefixLength, BigInteger cachedCount) {
        this.cachedPrefixLength = cachedNetworkPrefixLength == null ? NO_PREFIX_LENGTH : cachedNetworkPrefixLength;
        this.cachedCount = cachedCount;
    }

    @Override
    public int getDivisionCount() {
        return this.getDivisionsInternal().length;
    }

    @Override
    public byte[] getBytes() {
        return (byte[])this.getBytesInternal().clone();
    }

    protected byte[] getBytesInternal() {
        byte[] cached;
        block3: {
            block2: {
                if (this.hasNoValueCache()) break block2;
                cached = this.valueCache.lowerBytes;
                if (this.valueCache.lowerBytes != null) break block3;
            }
            this.valueCache.lowerBytes = cached = this.getBytesImpl(true);
        }
        return cached;
    }

    @Override
    public byte[] getBytes(byte[] bytes, int index) {
        return AddressDivisionGroupingBase.getBytesCopy(bytes, index, this.getBytesInternal(), this.getBitCount());
    }

    @Override
    public byte[] getBytes(byte[] bytes) {
        return this.getBytes(bytes, 0);
    }

    private static byte[] getBytesCopy(byte[] bytes, int startIndex, byte[] cached, int bitCount) {
        int byteCount = bitCount + 7 >> 3;
        if (bytes == null || bytes.length < byteCount + startIndex) {
            if (startIndex > 0) {
                byte[] bytes2 = new byte[byteCount + startIndex];
                if (bytes != null) {
                    System.arraycopy(bytes, 0, bytes2, 0, Math.min(startIndex, bytes.length));
                }
                System.arraycopy(cached, 0, bytes2, startIndex, cached.length);
                return bytes2;
            }
            return (byte[])cached.clone();
        }
        System.arraycopy(cached, 0, bytes, startIndex, byteCount);
        return bytes;
    }

    @Override
    public byte[] getUpperBytes() {
        return (byte[])this.getUpperBytesInternal().clone();
    }

    protected byte[] getUpperBytesInternal() {
        byte[] cached;
        if (this.hasNoValueCache()) {
            ValueCache cache = this.valueCache;
            cache.upperBytes = cached = this.getBytesImpl(false);
            if (!this.isMultiple()) {
                cache.lowerBytes = cached;
            }
        } else {
            ValueCache cache = this.valueCache;
            cached = cache.upperBytes;
            if (cache.upperBytes == null) {
                if (!this.isMultiple()) {
                    cached = cache.lowerBytes;
                    if (cache.lowerBytes != null) {
                        cache.upperBytes = cached;
                    } else {
                        cache.upperBytes = cached = this.getBytesImpl(false);
                        cache.lowerBytes = cached;
                    }
                } else {
                    cache.upperBytes = cached = this.getBytesImpl(false);
                }
            }
        }
        return cached;
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes, int index) {
        return AddressDivisionGroupingBase.getBytesCopy(bytes, index, this.getUpperBytesInternal(), this.getBitCount());
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        return this.getBytes(bytes, 0);
    }

    protected abstract byte[] getBytesImpl(boolean var1);

    protected void setBytes(byte[] bytes) {
        if (this.valueCache == null) {
            this.valueCache = new ValueCache();
        }
        this.valueCache.lowerBytes = bytes;
    }

    protected void setUpperBytes(byte[] bytes) {
        if (this.valueCache == null) {
            this.valueCache = new ValueCache();
        }
        this.valueCache.upperBytes = bytes;
    }

    @Override
    public BigInteger getValue() {
        BigInteger cached;
        if (this.hasNoValueCache() || (cached = this.valueCache.value) == null) {
            this.valueCache.value = cached = new BigInteger(1, this.getBytesInternal());
        }
        return cached;
    }

    @Override
    public BigInteger getUpperValue() {
        BigInteger cached;
        if (this.hasNoValueCache()) {
            ValueCache cache = this.valueCache;
            cache.upperValue = cached = new BigInteger(1, this.getUpperBytesInternal());
            if (!this.isMultiple()) {
                cache.value = cached;
            }
        } else {
            ValueCache cache = this.valueCache;
            cached = cache.upperValue;
            if (cached == null) {
                if (!this.isMultiple()) {
                    cached = cache.value;
                    if (cached != null) {
                        cache.upperValue = cached;
                    } else {
                        cache.upperValue = cached = new BigInteger(1, this.getUpperBytesInternal());
                        cache.value = cached;
                    }
                } else {
                    cache.upperValue = cached = new BigInteger(1, this.getUpperBytesInternal());
                }
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasNoValueCache() {
        if (this.valueCache == null) {
            AddressDivisionGroupingBase addressDivisionGroupingBase = this;
            synchronized (addressDivisionGroupingBase) {
                if (this.valueCache == null) {
                    this.valueCache = new ValueCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isPrefixed() {
        return this.getPrefixLength() != null;
    }

    @Override
    public Integer getPrefixLength() {
        return this.cachedPrefixLength;
    }

    protected static Integer calculatePrefix(IPAddressDivisionSeries series) {
        int count = series.getDivisionCount();
        if (count > 0) {
            if (series.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && !series.getDivision(count - 1).isPrefixed()) {
                return null;
            }
            int result = 0;
            for (int i = 0; i < count; ++i) {
                IPAddressGenericDivision div = series.getDivision(i);
                Integer prefix = div.getDivisionPrefixLength();
                if (prefix != null) {
                    return ParsedAddressGrouping.cache(result += prefix.intValue());
                }
                result += div.getBitCount();
            }
        }
        return null;
    }

    @Override
    public int getMinPrefixLengthForBlock() {
        int count = this.getDivisionCount();
        int totalPrefix = this.getBitCount();
        for (int i = count - 1; i >= 0; --i) {
            AddressDivisionBase div = this.getDivision(i);
            int segBitCount = div.getBitCount();
            int segPrefix = div.getMinPrefixLengthForBlock();
            if (segPrefix == segBitCount) break;
            totalPrefix -= segBitCount;
            if (segPrefix == 0) continue;
            totalPrefix += segPrefix;
            break;
        }
        return totalPrefix;
    }

    @Override
    public Integer getPrefixLengthForSingleBlock() {
        int count = this.getDivisionCount();
        int totalPrefix = 0;
        for (int i = 0; i < count; ++i) {
            AddressDivisionBase div = this.getDivision(i);
            Integer divPrefix = div.getPrefixLengthForSingleBlock();
            if (divPrefix == null) {
                return null;
            }
            totalPrefix += divPrefix.intValue();
            if (divPrefix >= div.getBitCount()) continue;
            ++i;
            while (i < count) {
                AddressDivisionBase laterDiv = this.getDivision(i);
                if (!laterDiv.isFullRange()) {
                    return null;
                }
                ++i;
            }
        }
        return AddressDivisionGroupingBase.cacheBits(totalPrefix);
    }

    protected static Integer getPrefixLengthForSingleBlock(IPAddressDivisionSeries series) {
        int count = series.getDivisionCount();
        int totalPrefix = 0;
        boolean isAutoSubnets = series.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        for (int i = 0; i < count; ++i) {
            IPAddressGenericDivision div = series.getDivision(i);
            Integer divPrefix = div.getPrefixLengthForSingleBlock();
            if (divPrefix == null) {
                return null;
            }
            totalPrefix += divPrefix.intValue();
            if (isAutoSubnets && div.isPrefixed()) {
                return AddressDivisionGroupingBase.cacheBits(totalPrefix);
            }
            if (divPrefix >= div.getBitCount()) continue;
            ++i;
            while (i < count) {
                IPAddressGenericDivision laterDiv = series.getDivision(i);
                if (!laterDiv.isFullRange()) {
                    return null;
                }
                if (isAutoSubnets && laterDiv.isPrefixed()) {
                    return AddressDivisionGroupingBase.cacheBits(totalPrefix);
                }
                ++i;
            }
        }
        return AddressDivisionGroupingBase.cacheBits(totalPrefix);
    }

    protected static Integer cacheBits(int i) {
        return ParsedAddressGrouping.cache(i);
    }

    @Override
    public BigInteger getCount() {
        BigInteger cached = this.cachedCount;
        if (cached == null) {
            this.cachedCount = cached = this.getCountImpl();
        }
        return cached;
    }

    protected BigInteger getCountImpl() {
        return AddressDivisionSeries.super.getCount();
    }

    @Override
    public BigInteger getPrefixCount() {
        BigInteger cached = this.cachedPrefixCount;
        if (cached == null) {
            Integer prefixLength = this.getPrefixLength();
            this.cachedPrefixCount = prefixLength == null || prefixLength >= this.getBitCount() ? (cached = this.getCount()) : (cached = this.getPrefixCountImpl());
        }
        return cached;
    }

    protected BigInteger getPrefixCountImpl() {
        return AddressDivisionSeries.super.getPrefixCount();
    }

    @Override
    public boolean isMultiple() {
        Boolean result = this.isMultiple;
        if (result == null) {
            for (int i = this.getDivisionCount() - 1; i >= 0; --i) {
                AddressDivisionBase seg = this.getDivision(i);
                if (!seg.isMultiple()) continue;
                this.isMultiple = true;
                return this.isMultiple;
            }
            this.isMultiple = false;
            return this.isMultiple;
        }
        return result;
    }

    protected static int adjustHashCode(int currentHash, long lowerValue, long upperValue) {
        return AddressDivisionBase.adjustHashCode(currentHash, lowerValue, upperValue);
    }

    public int hashCode() {
        int res = this.hashCode;
        if (res == 0) {
            res = 1;
            int count = this.getDivisionCount();
            for (int i = 0; i < count; ++i) {
                AddressDivisionBase combo = this.getDivision(i);
                BigInteger lower = combo.getValue();
                BigInteger upper = combo.getUpperValue();
                int longBits = 64;
                do {
                    long low = lower.longValue();
                    long up = upper.longValue();
                    lower = lower.shiftRight(longBits);
                    upper = upper.shiftRight(longBits);
                    res = AddressDivisionGroupingBase.adjustHashCode(res, low, up);
                } while (!upper.equals(BigInteger.ZERO));
            }
            this.hashCode = res;
        }
        return res;
    }

    protected boolean isSameGrouping(AddressDivisionGroupingBase other) {
        int count = this.getDivisionCount();
        if (count != other.getDivisionCount()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            AddressDivisionBase two;
            AddressDivisionBase one = this.getDivision(i);
            if (one.equals(two = other.getDivision(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AddressDivisionGroupingBase) {
            AddressDivisionGroupingBase other = (AddressDivisionGroupingBase)o;
            return other.isSameGrouping(this);
        }
        return false;
    }

    protected AddressDivisionBase[] getDivisionsInternal() {
        return this.divisions;
    }

    public String toString() {
        return Arrays.asList(this.getDivisionsInternal()).toString();
    }

    @Override
    public String[] getDivisionStrings() {
        String[] result = new String[this.getDivisionCount()];
        Arrays.setAll(result, i -> this.getDivision(i).getWildcardString());
        return result;
    }

    @Override
    public boolean isZero() {
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            if (this.getDivision(i).isZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean includesZero() {
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            if (this.getDivision(i).includesZero()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMax() {
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            if (this.getDivision(i).isMax()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean includesMax() {
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            if (this.getDivision(i).includesMax()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isFullRange() {
        int divCount = this.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            AddressDivisionBase div = this.getDivision(i);
            if (div.isFullRange()) continue;
            return false;
        }
        return true;
    }

    protected static void checkSubnet(AddressDivisionSeries series, int prefixLength) throws PrefixLenException {
        if (prefixLength < 0 || prefixLength > series.getBitCount()) {
            throw new PrefixLenException((AddressItem)series, prefixLength);
        }
    }

    @Override
    public boolean isSinglePrefixBlock() {
        return this.isPrefixed() && this.containsSinglePrefixBlock(this.getPrefixLength());
    }

    @Override
    public boolean isPrefixBlock() {
        return this.isPrefixed() && this.containsPrefixBlock(this.getPrefixLength());
    }

    protected static boolean containsPrefixBlock(IPAddressDivisionSeries series, int prefixLength) {
        AddressDivisionGroupingBase.checkSubnet(series, prefixLength);
        boolean isAllSubnets = series.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (isAllSubnets && series.isPrefixed() && series.getNetworkPrefixLength() <= prefixLength) {
            return true;
        }
        int prevBitCount = 0;
        int divCount = series.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            IPAddressGenericDivision div = series.getDivision(i);
            int bitCount = div.getBitCount();
            int totalBitCount = bitCount + prevBitCount;
            if (prefixLength < totalBitCount) {
                int divPrefixLen = Math.max(0, prefixLength - prevBitCount);
                if (!div.containsPrefixBlock(divPrefixLen)) {
                    return false;
                }
                if (isAllSubnets && div.isPrefixed()) {
                    return true;
                }
                ++i;
                while (i < divCount) {
                    div = series.getDivision(i);
                    if (!div.isFullRange()) {
                        return false;
                    }
                    if (isAllSubnets && div.isPrefixed()) {
                        return true;
                    }
                    ++i;
                }
                return true;
            }
            prevBitCount = totalBitCount;
        }
        return true;
    }

    protected static boolean containsSinglePrefixBlock(IPAddressDivisionSeries series, int prefixLength) {
        AddressDivisionGroupingBase.checkSubnet(series, prefixLength);
        boolean isAllSubnets = series.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (isAllSubnets && series.isPrefixed() && series.getNetworkPrefixLength() < prefixLength) {
            return false;
        }
        int prevBitCount = 0;
        int divCount = series.getDivisionCount();
        for (int i = 0; i < divCount; ++i) {
            IPAddressGenericDivision div = series.getDivision(i);
            int bitCount = div.getBitCount();
            int totalBitCount = bitCount + prevBitCount;
            if (prefixLength >= totalBitCount) {
                if (div.isMultiple()) {
                    return false;
                }
            } else {
                int divPrefixLen = Math.max(0, prefixLength - prevBitCount);
                if (!div.containsSinglePrefixBlock(divPrefixLen)) {
                    return false;
                }
                if (isAllSubnets && div.isPrefixed()) {
                    return true;
                }
                ++i;
                while (i < divCount) {
                    div = series.getDivision(i);
                    if (!div.isFullRange()) {
                        return false;
                    }
                    if (isAllSubnets && div.isPrefixed()) {
                        return true;
                    }
                    ++i;
                }
                return true;
            }
            prevBitCount = totalBitCount;
        }
        return true;
    }

    static {
        String propertyFileName = "IPAddressResources";
        String name = HostIdentifierException.class.getPackage().getName() + '.' + propertyFileName;
        try {
            bundle = ResourceBundle.getBundle(name);
        }
        catch (MissingResourceException e) {
            System.err.println("bundle " + name + " is missing");
        }
    }

    protected static class ValueCache {
        public byte[] lowerBytes;
        public byte[] upperBytes;
        public BigInteger value;
        public BigInteger upperValue;
        public InetAddress inetAddress;
        public InetAddress upperInetAddress;

        protected ValueCache() {
        }
    }
}

