/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressSegmentSeries;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.HostIdentifierException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.NetworkMismatchException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressCreator;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.AddressDivisionSeries;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.AddressStringDivision;
import inet.ipaddr.format.AddressStringDivisionSeries;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.util.AddressDivisionWriter;
import inet.ipaddr.format.util.AddressSegmentParams;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class AddressDivisionGrouping
implements AddressDivisionSeries,
Comparable<AddressDivisionGrouping> {
    private static final long serialVersionUID = 4L;
    static BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    protected static final Integer NO_PREFIX_LENGTH = -1;
    static ResourceBundle bundle;
    protected transient ValueCache valueCache;
    private final AddressDivision[] divisions;
    protected Integer cachedPrefixLength;
    private transient Boolean isMultiple;
    private transient BigInteger cachedCount;
    protected int hashCode;

    static {
        String propertyFileName = "IPAddressResources";
        String name = String.valueOf(HostIdentifierException.class.getPackage().getName()) + '.' + propertyFileName;
        try {
            bundle = ResourceBundle.getBundle(name);
        }
        catch (MissingResourceException e) {
            System.err.println("bundle " + name + " is missing");
        }
    }

    static String getMessage(String key) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return key;
    }

    public AddressDivisionGrouping(AddressDivision[] divisions) {
        this(divisions, true);
    }

    public AddressDivisionGrouping(AddressDivision[] divisions, boolean checkDivisions) {
        this.divisions = divisions;
        if (checkDivisions) {
            int i = 0;
            while (i < divisions.length) {
                if (divisions[i] == null) {
                    throw new NullPointerException(AddressDivisionGrouping.getMessage("ipaddress.error.null.segment"));
                }
                ++i;
            }
        }
    }

    protected void initCachedValues(Integer cachedNetworkPrefixLength, BigInteger cachedCount) {
        this.cachedPrefixLength = cachedNetworkPrefixLength == null ? NO_PREFIX_LENGTH : cachedNetworkPrefixLength;
        this.cachedCount = cachedCount;
    }

    @Override
    public AddressDivision getDivision(int index) {
        return this.getDivisionsInternal()[index];
    }

    @Override
    public int getDivisionCount() {
        return this.getDivisionsInternal().length;
    }

    @Override
    public int getBitCount() {
        int count = this.getDivisionCount();
        int bitCount = 0;
        int i = 0;
        while (i < count) {
            bitCount += this.getDivision(i).getBitCount();
            ++i;
        }
        return bitCount;
    }

    @Override
    public byte[] getBytes() {
        return (byte[])this.getBytesInternal().clone();
    }

    protected byte[] getBytesInternal() {
        byte[] cached;
        block3: {
            block2: {
                if (this.hasNoValueCache()) break block2;
                cached = this.valueCache.lowerBytes;
                if (this.valueCache.lowerBytes != null) break block3;
            }
            this.valueCache.lowerBytes = cached = this.getBytesImpl(true);
        }
        return cached;
    }

    @Override
    public byte[] getBytes(byte[] bytes, int index) {
        return AddressDivisionGrouping.getBytesCopy(bytes, index, this.getBytesInternal(), this.getBitCount());
    }

    @Override
    public byte[] getBytes(byte[] bytes) {
        return this.getBytes(bytes, 0);
    }

    private static byte[] getBytesCopy(byte[] bytes, int startIndex, byte[] cached, int bitCount) {
        int byteCount = bitCount + 7 >> 3;
        if (bytes == null || bytes.length < byteCount + startIndex) {
            if (startIndex > 0) {
                byte[] bytes2 = new byte[byteCount + startIndex];
                if (bytes != null) {
                    System.arraycopy(bytes, 0, bytes2, 0, Math.min(startIndex, bytes.length));
                }
                System.arraycopy(cached, 0, bytes2, startIndex, cached.length);
                return bytes2;
            }
            return (byte[])cached.clone();
        }
        System.arraycopy(cached, 0, bytes, startIndex, byteCount);
        return bytes;
    }

    @Override
    public byte[] getUpperBytes() {
        return (byte[])this.getUpperBytesInternal().clone();
    }

    protected byte[] getUpperBytesInternal() {
        byte[] cached;
        if (this.hasNoValueCache()) {
            ValueCache cache = this.valueCache;
            cache.upperBytes = cached = this.getBytesImpl(false);
            if (!this.isMultiple()) {
                cache.lowerBytes = cached;
            }
        } else {
            ValueCache cache = this.valueCache;
            cached = cache.upperBytes;
            if (cache.upperBytes == null) {
                if (!this.isMultiple()) {
                    cached = cache.lowerBytes;
                    if (cache.lowerBytes != null) {
                        cache.upperBytes = cached;
                    } else {
                        cache.upperBytes = cached = this.getBytesImpl(false);
                        cache.lowerBytes = cached;
                    }
                } else {
                    cache.upperBytes = cached = this.getBytesImpl(false);
                }
            }
        }
        return cached;
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes, int index) {
        return AddressDivisionGrouping.getBytesCopy(bytes, index, this.getUpperBytesInternal(), this.getBitCount());
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        return this.getBytes(bytes, 0);
    }

    protected byte[] getBytesImpl(boolean low) {
        byte[] bytes = new byte[this.getBitCount() + 7 >> 3];
        int byteCount = bytes.length;
        int divCount = this.getDivisionCount();
        int k = divCount - 1;
        int byteIndex = byteCount - 1;
        int bitIndex = 8;
        while (k >= 0) {
            AddressDivision div = this.getDivision(k);
            long segmentValue = low ? div.getLowerValue() : div.getUpperValue();
            int divBits = div.getBitCount();
            while (divBits > 0) {
                int n = byteIndex--;
                bytes[n] = (byte)((long)bytes[n] | segmentValue << 8 - bitIndex);
                segmentValue >>= bitIndex;
                if (divBits < bitIndex) {
                    bitIndex -= divBits;
                    break;
                }
                divBits -= bitIndex;
                bitIndex = 8;
            }
            --k;
        }
        return bytes;
    }

    protected void setBytes(byte[] bytes) {
        if (this.valueCache == null) {
            this.valueCache = new ValueCache();
        }
        this.valueCache.lowerBytes = bytes;
    }

    protected void setUpperBytes(byte[] bytes) {
        if (this.valueCache == null) {
            this.valueCache = new ValueCache();
        }
        this.valueCache.upperBytes = bytes;
    }

    @Override
    public BigInteger getValue() {
        BigInteger cached;
        if (this.hasNoValueCache() || (cached = this.valueCache.value) == null) {
            this.valueCache.value = cached = new BigInteger(1, this.getBytesInternal());
        }
        return cached;
    }

    @Override
    public BigInteger getUpperValue() {
        BigInteger cached;
        if (this.hasNoValueCache()) {
            ValueCache cache = this.valueCache;
            cache.upperValue = cached = new BigInteger(1, this.getUpperBytesInternal());
            if (!this.isMultiple()) {
                cache.value = cached;
            }
        } else {
            ValueCache cache = this.valueCache;
            cached = cache.upperValue;
            if (cached == null) {
                if (!this.isMultiple()) {
                    cached = cache.value;
                    if (cached != null) {
                        cache.upperValue = cached;
                    } else {
                        cache.upperValue = cached = new BigInteger(1, this.getUpperBytesInternal());
                        cache.value = cached;
                    }
                } else {
                    cache.upperValue = cached = new BigInteger(1, this.getUpperBytesInternal());
                }
            }
        }
        return cached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasNoValueCache() {
        if (this.valueCache == null) {
            AddressDivisionGrouping addressDivisionGrouping = this;
            synchronized (addressDivisionGrouping) {
                block5: {
                    if (this.valueCache != null) break block5;
                    this.valueCache = new ValueCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isPrefixed() {
        return this.getPrefixLength() != null;
    }

    @Override
    public Integer getPrefixLength() {
        return this.cachedPrefixLength;
    }

    @Override
    public int getMinPrefixLengthForBlock() {
        int count = this.getDivisionCount();
        int totalPrefix = this.getBitCount();
        int i = count - 1;
        while (i >= 0) {
            AddressDivision div = this.getDivision(i);
            int segBitCount = div.getBitCount();
            int segPrefix = div.getMinPrefixLengthForBlock();
            if (segPrefix == segBitCount) break;
            totalPrefix -= segBitCount;
            if (segPrefix != 0) {
                totalPrefix += segPrefix;
                break;
            }
            --i;
        }
        return totalPrefix;
    }

    @Override
    public Integer getPrefixLengthForSingleBlock() {
        int count = this.getDivisionCount();
        int totalPrefix = 0;
        int i = 0;
        while (i < count) {
            AddressDivision div = this.getDivision(i);
            int divPrefix = div.getMinPrefixLengthForBlock();
            if (!div.matchesWithMask(div.getLowerValue(), -1 << div.getBitCount() - divPrefix)) {
                return null;
            }
            if (divPrefix < div.getBitCount()) {
                ++i;
                while (i < count) {
                    AddressDivision laterDiv = this.getDivision(i);
                    if (!laterDiv.isFullRange()) {
                        return null;
                    }
                    ++i;
                }
                return AddressDivisionGrouping.cacheBits(totalPrefix + divPrefix);
            }
            totalPrefix += divPrefix;
            ++i;
        }
        return AddressDivisionGrouping.cacheBits(totalPrefix);
    }

    protected static Integer cacheBits(int i) {
        return ParsedAddressGrouping.cache(i);
    }

    @Override
    public BigInteger getCount() {
        BigInteger cached = this.cachedCount;
        if (cached == null) {
            this.cachedCount = cached = this.getCountImpl();
        }
        return cached;
    }

    protected BigInteger getCountImpl() {
        BigInteger result = BigInteger.ONE;
        int count = this.getDivisionCount();
        if (count > 0 && this.isMultiple()) {
            int i = 0;
            while (i < count) {
                long segCount = this.getDivision(i).getDivisionValueCount();
                result = result.multiply(BigInteger.valueOf(segCount));
                ++i;
            }
        }
        return result;
    }

    @Override
    public BigInteger getPrefixCount() {
        Integer prefixLength = this.getPrefixLength();
        if (prefixLength == null || prefixLength >= this.getBitCount() || !this.isMultiple()) {
            return this.getCount();
        }
        BigInteger result = BigInteger.ONE;
        int divisionCount = this.getDivisionCount();
        int divPrefixLength = prefixLength;
        int i = 0;
        while (i < divisionCount) {
            AddressDivision division = this.getDivision(i);
            int divBitCount = division.getBitCount();
            long segCount = divPrefixLength < divBitCount ? division.getDivisionPrefixCount(divPrefixLength) : division.getDivisionValueCount();
            result = result.multiply(BigInteger.valueOf(segCount));
            if (divPrefixLength <= divBitCount) break;
            divPrefixLength -= divBitCount;
            ++i;
        }
        return result;
    }

    @Override
    public int isMore(AddressDivisionSeries other) {
        if (!this.isMultiple()) {
            return other.isMultiple() ? -1 : 0;
        }
        if (!other.isMultiple()) {
            return 1;
        }
        return this.getCount().compareTo(other.getCount());
    }

    @Override
    public boolean isMultiple() {
        Boolean result = this.isMultiple;
        if (result == null) {
            int i = this.getDivisionCount() - 1;
            while (i >= 0) {
                AddressDivision seg = this.getDivision(i);
                if (seg.isMultiple()) {
                    this.isMultiple = true;
                    return this.isMultiple;
                }
                --i;
            }
            this.isMultiple = false;
            return this.isMultiple;
        }
        return result;
    }

    @Override
    public boolean isSinglePrefixBlock() {
        return this.isPrefixed() && this.containsSinglePrefixBlock(this.getPrefixLength());
    }

    @Override
    public boolean isPrefixBlock() {
        return this.isPrefixed() && this.containsPrefixBlock(this.getPrefixLength());
    }

    protected void checkSubnet(int prefixLength) throws PrefixLenException {
        if (prefixLength < 0 || prefixLength > this.getBitCount()) {
            throw new PrefixLenException((AddressItem)this, prefixLength);
        }
    }

    @Override
    public boolean containsPrefixBlock(int prefixLength) {
        this.checkSubnet(prefixLength);
        int divisionCount = this.getDivisionCount();
        int prevBitCount = 0;
        int i = 0;
        while (i < divisionCount) {
            AddressDivision division = this.getDivision(i);
            int bitCount = division.getBitCount();
            int totalBitCount = bitCount + prevBitCount;
            if (prefixLength < totalBitCount) {
                int divPrefixLen = Math.max(0, prefixLength - prevBitCount);
                if (!division.isPrefixBlock(division.getLowerValue(), division.getUpperValue(), divPrefixLen)) {
                    return false;
                }
                ++i;
                while (i < divisionCount) {
                    division = this.getDivision(i);
                    if (!division.isFullRange()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            prevBitCount = totalBitCount;
            ++i;
        }
        return true;
    }

    @Override
    public boolean containsSinglePrefixBlock(int prefixLength) {
        this.checkSubnet(prefixLength);
        int divisionCount = this.getDivisionCount();
        int prevBitCount = 0;
        int i = 0;
        while (i < divisionCount) {
            AddressDivision division = this.getDivision(i);
            int bitCount = division.getBitCount();
            int totalBitCount = bitCount + prevBitCount;
            if (prefixLength >= totalBitCount) {
                if (division.isMultiple()) {
                    return false;
                }
            } else {
                int divPrefixLen = Math.max(0, prefixLength - prevBitCount);
                if (!division.isSinglePrefixBlock(division.getLowerValue(), division.getUpperValue(), divPrefixLen)) {
                    return false;
                }
                ++i;
                while (i < divisionCount) {
                    division = this.getDivision(i);
                    if (!division.isFullRange()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            prevBitCount = totalBitCount;
            ++i;
        }
        return true;
    }

    public int hashCode() {
        int res = this.hashCode;
        if (res == 0) {
            int fullResult = 1;
            int count = this.getDivisionCount();
            int i = 0;
            while (i < count) {
                AddressDivision combo = this.getDivision(i);
                long value = combo.getLowerValue();
                long shifted = value >>> 32;
                int adjusted = (int)(shifted == 0L ? value : value ^ shifted);
                fullResult = 31 * fullResult + adjusted;
                long upperValue = combo.getUpperValue();
                if (upperValue != value) {
                    shifted = upperValue >>> 32;
                    adjusted = (int)(shifted == 0L ? upperValue : upperValue ^ shifted);
                    fullResult = 31 * fullResult + adjusted;
                }
                ++i;
            }
            this.hashCode = res = fullResult;
        }
        return res;
    }

    protected boolean isSameGrouping(AddressDivisionGrouping other) {
        if (this.getDivisionCount() != other.getDivisionCount()) {
            return false;
        }
        int i = 0;
        while (i < this.getDivisionCount()) {
            AddressDivision two;
            AddressDivision one = this.getDivision(i);
            if (!one.isSameValues(two = other.getDivision(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AddressDivisionGrouping) {
            AddressDivisionGrouping other = (AddressDivisionGrouping)o;
            return other.isSameGrouping(this);
        }
        return false;
    }

    @Override
    public int compareTo(AddressDivisionGrouping other) {
        return IPAddress.DEFAULT_ADDRESS_COMPARATOR.compare(this, other);
    }

    protected AddressDivision[] getDivisionsInternal() {
        return this.divisions;
    }

    public String toString() {
        return Arrays.asList(this.getDivisionsInternal()).toString();
    }

    @Override
    public String[] getDivisionStrings() {
        String[] result = new String[this.getDivisionCount()];
        Arrays.setAll(result, i -> this.getDivision(i).getWildcardString());
        return result;
    }

    @Override
    public boolean isZero() {
        int divCount = this.getDivisionCount();
        int i = 0;
        while (i < divCount) {
            if (!this.getDivision(i).isZero()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean includesZero() {
        int divCount = this.getDivisionCount();
        int i = 0;
        while (i < divCount) {
            if (!this.getDivision(i).includesZero()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isMax() {
        int divCount = this.getDivisionCount();
        int i = 0;
        while (i < divCount) {
            if (!this.getDivision(i).isMax()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean includesMax() {
        int divCount = this.getDivisionCount();
        int i = 0;
        while (i < divCount) {
            if (!this.getDivision(i).includesMax()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isFullRange() {
        int divCount = this.getDivisionCount();
        int i = 0;
        while (i < divCount) {
            AddressDivision div = this.getDivision(i);
            if (!div.isFullRange()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected static Integer getPrefixedSegmentPrefixLength(int bitsPerSegment, int prefixLength, int segmentIndex) {
        return ParsedAddressGrouping.getPrefixedSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
    }

    protected static int getNetworkSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        return ParsedAddressGrouping.getNetworkSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
    }

    protected static int getHostSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        return ParsedAddressGrouping.getHostSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
    }

    protected static Integer getSegmentPrefixLength(int bitsPerSegment, Integer prefixLength, int segmentIndex) {
        return ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
    }

    protected static Integer getSegmentPrefixLength(int segmentBits, int segmentPrefixedBits) {
        return ParsedAddressGrouping.getSegmentPrefixLength(segmentBits, segmentPrefixedBits);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getAdjustedPrefix(boolean nextSegment, int bitsPerSegment, boolean skipBitCountPrefix) {
        Integer prefix = this.getPrefixLength();
        int bitCount = this.getBitCount();
        if (nextSegment) {
            if (prefix == null) {
                if (this.getMinPrefixLengthForBlock() != 0) return bitCount;
                return 0;
            }
            if (prefix == bitCount) {
                return bitCount;
            }
            int existingPrefixLength = prefix;
            int adjustment = existingPrefixLength % bitsPerSegment;
            return existingPrefixLength + bitsPerSegment - adjustment;
        }
        if (prefix == null) {
            if (this.getMinPrefixLengthForBlock() == 0) {
                return 0;
            }
            if (!skipBitCountPrefix) return bitCount;
            prefix = bitCount;
        } else if (prefix == 0) {
            return 0;
        }
        int existingPrefixLength = prefix;
        int adjustment = (existingPrefixLength - 1) % bitsPerSegment + 1;
        return existingPrefixLength - adjustment;
    }

    protected int getAdjustedPrefix(int adjustment, boolean floor, boolean ceiling) {
        Integer prefix = this.getPrefixLength();
        if (prefix == null) {
            prefix = this.getMinPrefixLengthForBlock() == 0 ? AddressDivisionGrouping.cacheBits(0) : AddressDivisionGrouping.cacheBits(this.getBitCount());
        }
        int result = prefix + adjustment;
        if (ceiling) {
            result = Math.min(this.getBitCount(), result);
        }
        if (floor) {
            result = Math.max(0, result);
        }
        return result;
    }

    protected static <S extends IPAddressSegment> void normalizePrefixBoundary(int sectionPrefixBits, S[] segments, int segmentBitCount, int segmentByteCount, BiFunction<S, Integer, S> segProducer) {
        S segment;
        int networkSegmentIndex = AddressDivisionGrouping.getNetworkSegmentIndex(sectionPrefixBits, segmentByteCount, segmentBitCount);
        if (networkSegmentIndex >= 0 && !((IPAddressDivision)(segment = segments[networkSegmentIndex])).isPrefixed()) {
            segments[networkSegmentIndex] = (IPAddressSegment)segProducer.apply(segment, segmentBitCount);
        }
    }

    protected static <S extends AddressSegment> S[] setPrefixedSegments(AddressNetwork<?> network, int sectionPrefixBits, S[] segments, int segmentBitCount, int segmentByteCount, AddressNetwork.AddressSegmentCreator<S> segmentCreator, BiFunction<S, Integer, S> segProducer) {
        boolean allPrefsSubnet = network.getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        int i = sectionPrefixBits == 0 ? 0 : AddressDivisionGrouping.getNetworkSegmentIndex(sectionPrefixBits, segmentByteCount, segmentBitCount);
        while (i < segments.length) {
            Integer pref = AddressDivisionGrouping.getPrefixedSegmentPrefixLength(segmentBitCount, sectionPrefixBits, i);
            if (pref != null) {
                segments[i] = (AddressSegment)segProducer.apply(segments[i], pref);
                if (allPrefsSubnet && ++i < segments.length) {
                    S allSeg = segmentCreator.createSegment(0, 0);
                    Arrays.fill(segments, i, segments.length, allSeg);
                }
            }
            ++i;
        }
        return segments;
    }

    protected static <R extends AddressSection, S extends AddressSegment> S[] removePrefix(R original, S[] segments, int segmentBitCount, SegFunction<S, Integer, Integer, S> prefixSetter) {
        Integer oldPrefix = original.getPrefixLength();
        if (oldPrefix != null) {
            segments = (AddressSegment[])segments.clone();
            int i = 0;
            while (i < segments.length) {
                Integer oldPref = AddressDivisionGrouping.getPrefixedSegmentPrefixLength(segmentBitCount, oldPrefix, i);
                segments[i] = (AddressSegment)prefixSetter.apply(segments[i], oldPref, null);
                ++i;
            }
        }
        return segments;
    }

    protected static <S extends AddressSegment> S[] createSegments(S[] segments, long highBytes, long lowBytes, int bitsPerSegment, AddressNetwork<S> network, Integer prefixLength) {
        AddressCreator<?, ?, ?, S> creator = network.getAddressCreator();
        int segmentMask = ~(-1 << bitsPerSegment);
        int lowIndex = Math.max(0, segments.length - 64 / bitsPerSegment);
        int segmentIndex = segments.length - 1;
        long bytes = lowBytes;
        while (true) {
            Integer segmentPrefixLength;
            int value;
            Object seg;
            if (!network.equals((seg = creator.createSegment(value = segmentMask & (int)bytes, segmentPrefixLength = AddressDivisionGrouping.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex))).getNetwork())) {
                throw new NetworkMismatchException((AddressItem)seg);
            }
            segments[segmentIndex] = seg;
            if (--segmentIndex >= lowIndex) {
                bytes >>>= bitsPerSegment;
                continue;
            }
            if (lowIndex == 0) break;
            lowIndex = 0;
            bytes = highBytes;
        }
        return segments;
    }

    protected static <S extends AddressSegment> S[] createSegments(S[] segments, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, int bytesPerSegment, int bitsPerSegment, AddressNetwork<S> network, Integer prefixLength) {
        AddressCreator<?, ?, ?, S> creator = network.getAddressCreator();
        int segmentCount = segments.length;
        int segmentIndex = 0;
        while (segmentIndex < segmentCount) {
            Object seg;
            Integer segmentPrefixLength = AddressDivisionGrouping.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
            if (segmentPrefixLength != null && segmentPrefixLength == 0 && network.getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                Object allSeg = creator.createSegment(0, 0);
                if (!network.equals(allSeg.getNetwork())) {
                    throw new NetworkMismatchException((AddressItem)allSeg);
                }
                Arrays.fill(segments, segmentIndex, segmentCount, allSeg);
                break;
            }
            int value = 0;
            int value2 = 0;
            if (lowerValueProvider == null) {
                value = upperValueProvider.getValue(segmentIndex);
            } else {
                value = lowerValueProvider.getValue(segmentIndex);
                if (upperValueProvider != null) {
                    value2 = upperValueProvider.getValue(segmentIndex);
                }
            }
            Object s = seg = lowerValueProvider != null && upperValueProvider != null ? creator.createSegment(value, value2, segmentPrefixLength) : creator.createSegment(value, segmentPrefixLength);
            if (!network.equals(seg.getNetwork())) {
                throw new NetworkMismatchException((AddressItem)seg);
            }
            segments[segmentIndex] = seg;
            ++segmentIndex;
        }
        return segments;
    }

    /*
     * Unable to fully structure code
     */
    protected static <S extends AddressSegment> S[] toSegments(S[] segments, byte[] bytes, int startIndex, int endIndex, int bytesPerSegment, int bitsPerSegment, AddressNetwork<S> network, Integer prefixLength) {
        block13: {
            block14: {
                if (endIndex < 0 || endIndex > bytes.length) {
                    throw new AddressValueException(endIndex);
                }
                if (startIndex < 0 || startIndex > endIndex) {
                    throw new AddressValueException(startIndex);
                }
                creator = network.getAddressCreator();
                segmentCount = segments.length;
                expectedByteCount = segmentCount * bytesPerSegment;
                missingBytes = expectedByteCount + startIndex - endIndex;
                if (missingBytes >= 0) break block13;
                expectedStartIndex = endIndex - expectedByteCount;
                higherStartIndex = expectedStartIndex - 1;
                expectedExtendedValue = bytes[higherStartIndex];
                if (expectedExtendedValue == 0) ** GOTO lbl23
                mostSignificantBit = bytes[expectedStartIndex] >>> 7;
                if (mostSignificantBit == 0) break block14;
                if (expectedExtendedValue != -1) {
                    throw new AddressValueException(expectedExtendedValue);
                }
                ** GOTO lbl23
            }
            throw new AddressValueException(expectedExtendedValue);
lbl-1000:
            // 1 sources

            {
                if (bytes[--higherStartIndex] == expectedExtendedValue) continue;
                throw new AddressValueException(expectedExtendedValue);
lbl23:
                // 3 sources

                ** while (startIndex < higherStartIndex)
            }
lbl24:
            // 1 sources

            startIndex = expectedStartIndex;
            missingBytes = 0;
        }
        allPrefixedAddressesAreSubnets = network.getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        i = 0;
        segmentIndex = 0;
        while (i < expectedByteCount) {
            segmentPrefixLength = AddressDivisionGrouping.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
            if (allPrefixedAddressesAreSubnets && segmentPrefixLength != null && segmentPrefixLength == 0) {
                allSeg = creator.createSegment(0, 0);
                if (!network.equals(allSeg.getNetwork())) {
                    throw new NetworkMismatchException((AddressItem)allSeg);
                }
                Arrays.fill(segments, segmentIndex, segmentCount, allSeg);
                break;
            }
            value = 0;
            k = bytesPerSegment + i;
            j = i;
            if (j < missingBytes) {
                mostSignificantBit = bytes[startIndex] >>> 7;
                if (mostSignificantBit == 0) {
                    j = missingBytes;
                } else {
                    upper = Math.min(missingBytes, k);
                    while (j < upper) {
                        value <<= 8;
                        value |= 255;
                        ++j;
                    }
                }
            }
            while (j < k) {
                byteValue = 255 & bytes[startIndex + j - missingBytes];
                value <<= 8;
                value |= byteValue;
                ++j;
            }
            i = k;
            seg = creator.createSegment(value, segmentPrefixLength);
            if (!network.equals(seg.getNetwork())) {
                throw new NetworkMismatchException((AddressItem)seg);
            }
            segments[segmentIndex] = seg;
            ++segmentIndex;
        }
        return segments;
    }

    protected static <R extends AddressSection, S extends AddressSegment> S[] createSingle(R original, AddressNetwork.AddressSegmentCreator<S> segmentCreator, IntFunction<S> segProducer) {
        int segmentCount = original.getSegmentCount();
        AddressSegment[] segs = segmentCreator.createSegmentArray(segmentCount);
        int i = 0;
        while (i < segmentCount) {
            segs[i] = (AddressSegment)segProducer.apply(i);
            ++i;
        }
        return segs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <R extends AddressSegmentSeries> SectionCache<R> getSectionCache(R section, Supplier<SectionCache<R>> sectionCacheGetter, Supplier<SectionCache<R>> sectionCacheCreator) {
        SectionCache<R> result = sectionCacheGetter.get();
        if (result == null) {
            R r = section;
            synchronized (r) {
                result = sectionCacheGetter.get();
                if (result == null) {
                    result = sectionCacheCreator.get();
                }
            }
        }
        return result;
    }

    protected static <R extends AddressSegmentSeries> R getSingleLowestOrHighestSection(R section) {
        if (!(section.isMultiple() || section.isPrefixed() && section.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets())) {
            return section;
        }
        return null;
    }

    protected static <R extends AddressSection, S extends AddressSegment> R reverseSegments(R section, AddressCreator<?, R, ?, S> creator, IntFunction<S> segProducer, boolean removePrefix) {
        int count = section.getSegmentCount();
        AddressSegment[] newSegs = creator.createSegmentArray(count);
        int halfCount = count >>> 1;
        int i = 0;
        boolean isSame = !removePrefix || !section.isPrefixed();
        int j = count - 1;
        while (i < halfCount) {
            newSegs[j] = (AddressSegment)segProducer.apply(i);
            newSegs[i] = (AddressSegment)segProducer.apply(j);
            if (!(!isSame || ((Object)newSegs[i]).equals(section.getSegment(i)) && ((Object)newSegs[j]).equals(section.getSegment(j)))) {
                isSame = false;
            }
            ++i;
            --j;
        }
        if ((count & 1) == 1) {
            newSegs[i] = (AddressSegment)segProducer.apply(i);
            if (isSame && !((Object)newSegs[i]).equals(section.getSegment(i))) {
                isSame = false;
            }
        }
        if (isSame) {
            return section;
        }
        return (R)creator.createSectionInternal(newSegs);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R reverseBits(boolean perByte, R section, AddressCreator<?, R, ?, S> creator, IntFunction<S> segBitReverser, boolean removePrefix) {
        if (perByte) {
            boolean isSame = !removePrefix || !section.isPrefixed();
            int count = section.getSegmentCount();
            AddressSegment[] newSegs = creator.createSegmentArray(count);
            int i = 0;
            while (i < count) {
                newSegs[i] = (AddressSegment)segBitReverser.apply(i);
                if (isSame && !((Object)newSegs[i]).equals(section.getSegment(i))) {
                    isSame = false;
                }
                ++i;
            }
            if (isSame) {
                return section;
            }
            return (R)creator.createSectionInternal(newSegs);
        }
        return AddressDivisionGrouping.reverseSegments(section, creator, segBitReverser, removePrefix);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R reverseBytes(boolean perSegment, R section, AddressCreator<?, R, ?, S> creator, IntFunction<S> segByteReverser, boolean removePrefix) {
        if (perSegment) {
            boolean isSame = !removePrefix || !section.isPrefixed();
            int count = section.getSegmentCount();
            AddressSegment[] newSegs = creator.createSegmentArray(count);
            int i = 0;
            while (i < count) {
                newSegs[i] = (AddressSegment)segByteReverser.apply(i);
                if (isSame && !((Object)newSegs[i]).equals(section.getSegment(i))) {
                    isSame = false;
                }
                ++i;
            }
            if (isSame) {
                return section;
            }
            return (R)creator.createSectionInternal(newSegs);
        }
        return AddressDivisionGrouping.reverseSegments(section, creator, segByteReverser, removePrefix);
    }

    protected <S extends AddressDivisionBase> S[] createNewDivisions(int bitsPerDigit, GroupingCreator<S> groupingCreator, IntFunction<S[]> groupingArrayCreator) {
        return this.createNewPrefixedDivisions(bitsPerDigit, null, null, (value, upperValue, bitCount, radix, network, prefixLength) -> groupingCreator.createDivision(value, upperValue, bitCount, radix), groupingArrayCreator);
    }

    protected static BigInteger getRadixPower(BigInteger radix, int power) {
        return AddressDivisionBase.getRadixPower(radix, power);
    }

    protected <S extends AddressDivisionBase> S[] createNewPrefixedDivisions(int bitsPerDigit, IPAddressNetwork<?, ?, ?, ?, ?> network, Integer networkPrefixLength, PrefixedGroupingCreator<S> groupingCreator, IntFunction<S[]> groupingArrayCreator) {
        if (bitsPerDigit >= 32) {
            throw new AddressValueException(bitsPerDigit);
        }
        int bitCount = this.getBitCount();
        ArrayList<Integer> bitDivs = new ArrayList<Integer>(bitsPerDigit);
        int largestBitCount = 63;
        largestBitCount -= largestBitCount % bitsPerDigit;
        while (true) {
            if (bitCount <= largestBitCount) {
                int mod = bitCount % bitsPerDigit;
                int secondLast = bitCount - mod;
                if (secondLast > 0) {
                    bitDivs.add(secondLast);
                }
                if (mod <= 0) break;
                bitDivs.add(mod);
                break;
            }
            bitCount -= largestBitCount;
            bitDivs.add(largestBitCount);
        }
        int bitDivSize = bitDivs.size();
        AddressDivisionBase[] divs = (AddressDivisionBase[])groupingArrayCreator.apply(bitDivSize);
        int currentSegmentIndex = 0;
        AddressDivision seg = this.getDivision(currentSegmentIndex);
        long segLowerVal = seg.getLowerValue();
        long segUpperVal = seg.getUpperValue();
        int segBits = seg.getBitCount();
        int bitsSoFar = 0;
        int radix = AddressDivisionGrouping.getRadixPower(BigInteger.valueOf(2L), bitsPerDigit).intValue();
        int i = bitDivSize - 1;
        while (i >= 0) {
            int divBitSize;
            int originalDivBitSize = divBitSize = ((Integer)bitDivs.get(i)).intValue();
            long divUpperValue = 0L;
            long divLowerValue = 0L;
            while (true) {
                int diff;
                if (segBits >= divBitSize) {
                    diff = segBits - divBitSize;
                    divLowerValue |= segLowerVal >>> diff;
                    int shift = ~(-1 << diff);
                    segLowerVal &= (long)shift;
                    segBits = diff;
                    Integer segPrefixBits = networkPrefixLength == null ? null : AddressDivisionGrouping.getSegmentPrefixLength(originalDivBitSize, networkPrefixLength - bitsSoFar);
                    S div = groupingCreator.createDivision(divLowerValue, divUpperValue |= (segUpperVal &= (long)shift) >>> diff, originalDivBitSize, radix, network, segPrefixBits);
                    divs[bitDivSize - i - 1] = div;
                    if (segBits != 0 || i <= 0) break;
                    seg = this.getDivision(++currentSegmentIndex);
                    segLowerVal = seg.getLowerValue();
                    segUpperVal = seg.getUpperValue();
                    segBits = seg.getBitCount();
                    break;
                }
                diff = divBitSize - segBits;
                divLowerValue |= segLowerVal << diff;
                divUpperValue |= segUpperVal << diff;
                divBitSize = diff;
                seg = this.getDivision(++currentSegmentIndex);
                segLowerVal = seg.getLowerValue();
                segUpperVal = seg.getUpperValue();
                segBits = seg.getBitCount();
            }
            bitsSoFar += originalDivBitSize;
            --i;
        }
        return divs;
    }

    protected static <R extends AddressSection, S extends AddressSegment> Iterator<R> iterator(boolean useOriginal, R original, final AddressCreator<?, R, ?, S> creator, final Iterator<S[]> iterator, final Integer prefixLength) {
        if (useOriginal) {
            return new Iterator<R>(original){
                R orig;
                {
                    this.orig = addressSection;
                }

                @Override
                public R next() {
                    if (this.orig == null) {
                        throw new NoSuchElementException();
                    }
                    Object result = this.orig;
                    this.orig = null;
                    return result;
                }

                @Override
                public boolean hasNext() {
                    return this.orig != null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<R>(){

            @Override
            public R next() {
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                AddressSegment[] next = (AddressSegment[])iterator.next();
                return AddressDivisionGrouping.createIteratedSection((AddressSegment[])next, (AddressCreator)creator, (Integer)prefixLength);
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static <R extends AddressSection, S extends AddressSegment> R createIteratedSection(S[] next, AddressCreator<?, R, ?, S> creator, Integer prefixLength) {
        return (R)creator.createPrefixedSectionInternal((AddressSegment[])next, prefixLength, true);
    }

    protected <S extends AddressSegment> Iterator<S[]> iterator(AddressNetwork.AddressSegmentCreator<S> segmentCreator, Supplier<S[]> segSupplier, IntFunction<Iterator<S>> segIteratorProducer, Predicate<S[]> excludeFunc) {
        return this.iterator(segmentCreator, segSupplier, segIteratorProducer, excludeFunc, this.getDivisionCount() - 1, this.getDivisionCount(), null);
    }

    protected <S extends AddressSegment> Iterator<S[]> iterator(AddressNetwork.AddressSegmentCreator<S> segmentCreator, Supplier<S[]> segSupplier, final IntFunction<Iterator<S>> segIteratorProducer, final Predicate<S[]> excludeFunc, final int networkSegmentIndex, final int hostSegmentIndex, final IntFunction<Iterator<S>> prefixedSegIteratorProducer) {
        int segmentCount = this.getDivisionCount();
        if (!(this.isMultiple() || prefixedSegIteratorProducer != null && hostSegmentIndex < segmentCount)) {
            return new Iterator<S[]>(segSupplier, excludeFunc){
                S[] result;
                {
                    this.result = (AddressSegment[])supplier.get();
                    if (predicate != null && predicate.test(this.result)) {
                        this.result = null;
                    }
                }

                @Override
                public boolean hasNext() {
                    return this.result != null;
                }

                @Override
                public S[] next() {
                    if (this.result == null) {
                        throw new NoSuchElementException();
                    }
                    S[] res = this.result;
                    this.result = null;
                    return res;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<S[]>(segmentCount, segmentCreator){
            private boolean done;
            private final Iterator<S>[] variations;
            private S[] nextSet;
            {
                this.variations = new Iterator[n];
                this.nextSet = addressSegmentCreator.createSegmentArray(n);
                this.updateVariations(0);
                int i = n2 + 1;
                while (i < n) {
                    this.variations[i] = (Iterator)intFunction.apply(i);
                    this.nextSet[i] = (AddressSegment)this.variations[i].next();
                    ++i;
                }
                if (predicate != null && predicate.test(this.nextSet)) {
                    this.increment();
                }
            }

            private void updateVariations(int start) {
                int i = start;
                while (i < hostSegmentIndex) {
                    this.variations[i] = (Iterator)segIteratorProducer.apply(i);
                    this.nextSet[i] = (AddressSegment)this.variations[i].next();
                    ++i;
                }
                if (i == networkSegmentIndex) {
                    this.variations[i] = (Iterator)prefixedSegIteratorProducer.apply(i);
                    this.nextSet[i] = (AddressSegment)this.variations[i].next();
                }
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public S[] next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                return this.increment();
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            private S[] increment() {
                previousSegs /* !! */  = null;
                j = networkSegmentIndex;
                ** GOTO lbl14
                {
                    if (previousSegs /* !! */  == null) {
                        previousSegs /* !! */  = (AddressSegment[])this.nextSet.clone();
                    }
                    this.nextSet[j] = (AddressSegment)this.variations[j].next();
                    this.updateVariations(j + 1);
                    if (excludeFunc == null || !excludeFunc.test(this.nextSet)) {
                        return previousSegs /* !! */ ;
                    }
                    j = networkSegmentIndex;
                    do {
                        if (this.variations[j].hasNext()) continue block0;
                        --j;
lbl14:
                        // 2 sources

                    } while (j >= 0);
                }
                this.done = true;
                return previousSegs /* !! */  == null ? this.nextSet : previousSegs /* !! */ ;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static <T extends Address, S extends AddressSegment> Iterator<T> iterator(T original, final AddressCreator<T, ?, ?, S> creator, boolean useOriginal, final Iterator<S[]> iterator, final Integer prefixLength) {
        if (useOriginal) {
            return new Iterator<T>(original){
                T orig;
                {
                    this.orig = address;
                }

                @Override
                public boolean hasNext() {
                    return this.orig != null;
                }

                @Override
                public T next() {
                    if (this.orig == null) {
                        throw new NoSuchElementException();
                    }
                    Object result = this.orig;
                    this.orig = null;
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AddressSegment[] next = (AddressSegment[])iterator.next();
                return prefixLength != null ? creator.createAddressInternal(next, prefixLength, true) : creator.createAddressInternal(next);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static void checkOverflow(long increment, long lowerValue, long upperValue, long count, LongSupplier maxValue) {
        if (increment < 0L) {
            if (lowerValue < -increment) {
                throw new AddressValueException(increment);
            }
        } else {
            if (count > 1L) {
                increment -= count - 1L;
            }
            if (increment > maxValue.getAsLong() - upperValue) {
                throw new AddressValueException(increment);
            }
        }
    }

    protected static void checkOverflow(long increment, BigInteger bigIncrement, BigInteger lowerValue, BigInteger upperValue, BigInteger count, Supplier<BigInteger> maxValue) {
        boolean isMultiple;
        boolean bl = isMultiple = count.compareTo(BigInteger.ONE) > 0;
        if (increment < 0L) {
            if (lowerValue.compareTo(bigIncrement.negate()) < 0) {
                throw new AddressValueException(increment);
            }
        } else {
            if (isMultiple) {
                bigIncrement = bigIncrement.subtract(count.subtract(BigInteger.ONE));
            }
            if (bigIncrement.compareTo(maxValue.get().subtract(upperValue)) > 0) {
                throw new AddressValueException(increment);
            }
        }
    }

    protected static <R extends AddressSection, S extends AddressSegment> R fastIncrement(R section, long increment, AddressCreator<?, R, ?, S> addrCreator, Supplier<R> lowerProducer, Supplier<R> upperProducer, Integer prefixLength) {
        if (increment >= 0L) {
            BigInteger count = section.getCount();
            if (count.compareTo(LONG_MAX) <= 0) {
                BigInteger upperValue;
                long longCount = count.longValue();
                if (longCount > increment) {
                    if (longCount == increment + 1L) {
                        return (R)((AddressSection)upperProducer.get());
                    }
                    return AddressDivisionGrouping.incrementRange(section, increment, addrCreator, lowerProducer, prefixLength);
                }
                BigInteger value = section.getValue();
                if (value.compareTo(LONG_MAX) <= 0 && (upperValue = section.getUpperValue()).compareTo(LONG_MAX) <= 0) {
                    return AddressDivisionGrouping.increment(section, increment, addrCreator, count.longValue(), value.longValue(), upperValue.longValue(), lowerProducer, upperProducer, prefixLength);
                }
            }
        } else {
            BigInteger value = section.getValue();
            if (value.compareTo(LONG_MAX) <= 0) {
                return (R)AddressDivisionGrouping.add((AddressSection)lowerProducer.get(), value.longValue(), increment, addrCreator, prefixLength);
            }
        }
        return null;
    }

    protected static <R extends AddressSection, S extends AddressSegment> R increment(R section, long increment, AddressCreator<?, R, ?, S> addrCreator, long count, long lowerValue, long upperValue, Supplier<R> lowerProducer, Supplier<R> upperProducer, Integer prefixLength) {
        boolean isDecrement;
        if (!section.isMultiple()) {
            return AddressDivisionGrouping.add(section, lowerValue, increment, addrCreator, prefixLength);
        }
        boolean bl = isDecrement = increment <= 0L;
        if (isDecrement) {
            return (R)AddressDivisionGrouping.add((AddressSection)lowerProducer.get(), lowerValue, increment, addrCreator, prefixLength);
        }
        if (count > increment) {
            if (count == increment + 1L) {
                return (R)((AddressSection)upperProducer.get());
            }
            return AddressDivisionGrouping.incrementRange(section, increment, addrCreator, lowerProducer, prefixLength);
        }
        if (increment <= Long.MAX_VALUE - upperValue) {
            return (R)AddressDivisionGrouping.add((AddressSection)upperProducer.get(), upperValue, increment - (count - 1L), addrCreator, prefixLength);
        }
        return (R)AddressDivisionGrouping.add((AddressSection)upperProducer.get(), BigInteger.valueOf(increment - (count - 1L)), addrCreator, prefixLength);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R increment(R section, long increment, BigInteger bigIncrement, AddressCreator<?, R, ?, S> addrCreator, Supplier<R> lowerProducer, Supplier<R> upperProducer, Integer prefixLength) {
        BigInteger incrementPlus1;
        boolean isDecrement;
        if (!section.isMultiple()) {
            return AddressDivisionGrouping.add(section, bigIncrement, addrCreator, prefixLength);
        }
        boolean bl = isDecrement = increment <= 0L;
        if (isDecrement) {
            return (R)AddressDivisionGrouping.add((AddressSection)lowerProducer.get(), bigIncrement, addrCreator, prefixLength);
        }
        BigInteger count = section.getCount();
        int countCompare = count.compareTo(incrementPlus1 = bigIncrement.add(BigInteger.ONE));
        if (countCompare <= 0) {
            if (countCompare == 0) {
                return (R)((AddressSection)upperProducer.get());
            }
            return (R)AddressDivisionGrouping.add((AddressSection)upperProducer.get(), incrementPlus1.subtract(count), addrCreator, prefixLength);
        }
        return AddressDivisionGrouping.incrementRange(section, increment, addrCreator, lowerProducer, prefixLength);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R incrementRange(R section, long increment, AddressCreator<?, R, ?, S> addrCreator, Supplier<R> lowerProducer, Integer prefixLength) {
        if (increment == 0L) {
            return (R)((AddressSection)lowerProducer.get());
        }
        int segCount = section.getSegmentCount();
        AddressSegment[] newSegments = addrCreator.createSegmentArray(segCount);
        int i = segCount - 1;
        while (i >= 0) {
            AddressSegment seg = section.getSegment(i);
            int segRange = seg.getValueCount();
            long revolutions = increment / (long)segRange;
            int remainder = (int)(increment % (long)segRange);
            Object newSegment = addrCreator.createSegment(seg.getLowerSegmentValue() + remainder);
            newSegments[i] = newSegment;
            if (revolutions == 0L) {
                --i;
                while (i >= 0) {
                    AddressSegment original = section.getSegment(i);
                    newSegments[i] = addrCreator.createSegment(original.getLowerSegmentValue());
                    --i;
                }
                break;
            }
            increment = revolutions;
            --i;
        }
        return (R)AddressDivisionGrouping.createIteratedSection((AddressSegment[])newSegments, addrCreator, (Integer)prefixLength);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R add(R section, BigInteger increment, AddressCreator<?, R, ?, S> addrCreator, Integer prefixLength) {
        if (section.isMultiple()) {
            throw new IllegalArgumentException();
        }
        int segCount = section.getSegmentCount();
        BigInteger fullValue = section.getValue();
        fullValue = fullValue.add(increment);
        byte[] bytes = fullValue.toByteArray();
        return addrCreator.createSectionInternal(bytes, segCount, prefixLength, true);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R add(R section, long fullValue, long increment, AddressCreator<?, R, ?, S> addrCreator, Integer prefixLength) {
        if (section.isMultiple()) {
            throw new IllegalArgumentException();
        }
        int segCount = section.getSegmentCount();
        AddressSegment[] newSegs = addrCreator.createSegmentArray(segCount);
        AddressDivisionGrouping.createSegments((AddressSegment[])newSegs, (long)0L, (long)(fullValue + increment), (int)section.getBitsPerSegment(), addrCreator.getNetwork(), (Integer)prefixLength);
        return (R)AddressDivisionGrouping.createIteratedSection((AddressSegment[])newSegs, addrCreator, (Integer)prefixLength);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R getSection(int index, int endIndex, R section, AddressCreator<?, R, ?, S> creator) {
        if (index == 0 && endIndex == section.getSegmentCount()) {
            return section;
        }
        int segmentCount = endIndex - index;
        if (segmentCount < 0) {
            throw new IndexOutOfBoundsException();
        }
        AddressSegment[] segs = creator.createSegmentArray(segmentCount);
        section.getSegments(index, endIndex, segs, 0);
        return (R)creator.createSectionInternal(segs);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R append(R section, R other, AddressCreator<?, R, ?, S> creator) {
        int otherSegmentCount = other.getSegmentCount();
        int segmentCount = section.getSegmentCount();
        int totalSegmentCount = segmentCount + otherSegmentCount;
        Object[] segs = creator.createSegmentArray(totalSegmentCount);
        section.getSegments(0, segmentCount, (AddressSegment[])segs, 0);
        if (section.isPrefixed() && section.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            Object allSegment = creator.createSegment(0, 0);
            Arrays.fill(segs, segmentCount, totalSegmentCount, allSegment);
        } else {
            other.getSegments(0, otherSegmentCount, (AddressSegment[])segs, segmentCount);
        }
        return (R)creator.createSectionInternal((AddressSegment[])segs);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R replace(R section, int index, int endIndex, R replacement, int replacementStartIndex, int replacementEndIndex, AddressCreator<?, R, ?, S> creator, boolean appendNetwork, boolean isMac) {
        int otherSegmentCount = replacementEndIndex - replacementStartIndex;
        int segmentCount = section.getSegmentCount();
        int totalSegmentCount = segmentCount + otherSegmentCount - (endIndex - index);
        Object[] segs = creator.createSegmentArray(totalSegmentCount);
        section.getSegments(0, index, (AddressSegment[])segs, 0);
        if (index < totalSegmentCount) {
            if (section.isPrefixed() && section.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && (appendNetwork ? AddressDivisionGrouping.getHostSegmentIndex(section.getPrefixLength(), section.getBytesPerSegment(), section.getBitsPerSegment()) < index : AddressDivisionGrouping.getNetworkSegmentIndex(section.getPrefixLength(), section.getBytesPerSegment(), section.getBitsPerSegment()) < index) && (isMac || index > 0)) {
                Object allSegment = creator.createSegment(0, 0);
                Arrays.fill(segs, index, totalSegmentCount, allSegment);
                return (R)creator.createSectionInternal((AddressSegment[])segs);
            }
            replacement.getSegments(replacementStartIndex, replacementEndIndex, (AddressSegment[])segs, index);
            if (index + otherSegmentCount < totalSegmentCount) {
                if (replacement.isPrefixed() && section.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && AddressDivisionGrouping.getNetworkSegmentIndex(replacement.getPrefixLength(), replacement.getBytesPerSegment(), replacement.getBitsPerSegment()) < replacementEndIndex && (isMac || otherSegmentCount > 0)) {
                    Object allSegment = creator.createSegment(0, 0);
                    Arrays.fill(segs, index + otherSegmentCount, totalSegmentCount, allSegment);
                } else {
                    section.getSegments(endIndex, segmentCount, (AddressSegment[])segs, index + otherSegmentCount);
                }
            }
        }
        return (R)creator.createSectionInternal((AddressSegment[])segs);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R createSectionInternal(AddressCreator<?, R, ?, S> creator, S[] segments, int startIndex, boolean extended) {
        return (R)creator.createSectionInternal((AddressSegment[])segments, startIndex, extended);
    }

    protected static AddressDivisionWriter getCachedParams(StringOptions opts) {
        return opts.cachedParams;
    }

    protected static void setCachedParams(StringOptions opts, AddressDivisionWriter cachedParams) {
        opts.cachedParams = cachedParams;
    }

    protected boolean isDualString() {
        int count = this.getDivisionCount();
        int i = 0;
        while (i < count) {
            AddressDivision division = this.getDivision(i);
            if (division.isMultiple()) {
                boolean isLastFull = true;
                AddressDivision lastDivision = null;
                int j = count - 1;
                while (j >= 0) {
                    division = this.getDivision(j);
                    if (division.isMultiple()) {
                        if (!isLastFull) {
                            throw new IncompatibleAddressException(division, i, lastDivision, i + 1, "ipaddress.error.segmentMismatch");
                        }
                        isLastFull = division.isFullRange();
                    } else {
                        isLastFull = false;
                    }
                    lastDivision = division;
                    --j;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static <T extends AddressStringDivisionSeries, E extends AddressStringDivisionSeries> String toNormalizedStringRange(AddressStringParams<T> params, T lower, T upper, CharSequence zone) {
        StringBuilder builder;
        int length = params.getStringLength(lower, zone) + params.getStringLength(upper, zone);
        String separator = params.getWildcards().rangeSeparator;
        if (separator != null) {
            builder = new StringBuilder(length += separator.length());
            params.append(params.append(builder, lower, null).append(separator), upper, zone);
        } else {
            builder = new StringBuilder(length);
            params.append(params.append(builder, lower, null), upper, zone);
        }
        AddressStringParams.checkLengths(length, builder);
        return builder.toString();
    }

    protected static class AddressStringParams<T extends AddressStringDivisionSeries>
    implements AddressDivisionWriter,
    AddressSegmentParams,
    Cloneable {
        public static final StringOptions.Wildcards DEFAULT_WILDCARDS = new StringOptions.Wildcards();
        private StringOptions.Wildcards wildcards = DEFAULT_WILDCARDS;
        protected boolean expandSegments;
        private String segmentStrPrefix = "";
        private int radix;
        protected Character separator;
        private boolean uppercase;
        private boolean reverse;
        private boolean splitDigits;
        private String addressLabel = "";
        private char zoneSeparator;

        public AddressStringParams(int radix, Character separator, boolean uppercase) {
            this(radix, separator, uppercase, '\u0000');
        }

        public AddressStringParams(int radix, Character separator, boolean uppercase, char zoneSeparator) {
            this.radix = radix;
            this.separator = separator;
            this.uppercase = uppercase;
            this.zoneSeparator = zoneSeparator;
        }

        public void setZoneSeparator(char zoneSeparator) {
            this.zoneSeparator = zoneSeparator;
        }

        public String getAddressLabel() {
            return this.addressLabel;
        }

        public void setAddressLabel(String str) {
            this.addressLabel = str;
        }

        public Character getSeparator() {
            return this.separator;
        }

        public void setSeparator(Character separator) {
            this.separator = separator;
        }

        @Override
        public StringOptions.Wildcards getWildcards() {
            return this.wildcards;
        }

        public void setWildcards(StringOptions.Wildcards wc) {
            this.wildcards = wc;
        }

        @Override
        public boolean preferWildcards() {
            return true;
        }

        @Override
        public int getLeadingZeros(int segmentIndex) {
            if (this.expandSegments) {
                return -1;
            }
            return 0;
        }

        @Override
        public String getSegmentStrPrefix() {
            return this.segmentStrPrefix;
        }

        public void setSegmentStrPrefix(String segmentStrPrefix) {
            if (segmentStrPrefix == null) {
                throw new NullPointerException();
            }
            this.segmentStrPrefix = segmentStrPrefix;
        }

        @Override
        public int getRadix() {
            return this.radix;
        }

        public void setRadix(int radix) {
            this.radix = radix;
        }

        public void setUppercase(boolean uppercase) {
            this.uppercase = uppercase;
        }

        @Override
        public boolean isUppercase() {
            return this.uppercase;
        }

        public void setSplitDigits(boolean split) {
            this.splitDigits = split;
        }

        @Override
        public boolean isSplitDigits() {
            return this.splitDigits;
        }

        @Override
        public Character getSplitDigitSeparator() {
            return this.separator;
        }

        @Override
        public boolean isReverseSplitDigits() {
            return this.reverse;
        }

        public void setReverse(boolean rev) {
            this.reverse = rev;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public void expandSegments(boolean expand) {
            this.expandSegments = expand;
        }

        public StringBuilder appendLabel(StringBuilder builder) {
            String str = this.getAddressLabel();
            if (str != null) {
                builder.append(str);
            }
            return builder;
        }

        public int getAddressLabelLength() {
            String str = this.getAddressLabel();
            if (str != null) {
                return str.length();
            }
            return 0;
        }

        public int getSegmentsStringLength(T part) {
            int count = 0;
            if (part.getDivisionCount() != 0) {
                int divCount = part.getDivisionCount();
                int i = 0;
                while (i < divCount) {
                    count += this.appendSegment(i, null, part);
                    ++i;
                }
                Character separator = this.getSeparator();
                if (separator != null) {
                    count += divCount - 1;
                }
            }
            return count;
        }

        public StringBuilder appendSegments(StringBuilder builder, T part) {
            int count = part.getDivisionCount();
            if (count != 0) {
                boolean reverse = this.isReverse();
                int i = 0;
                Character separator = this.getSeparator();
                while (true) {
                    int segIndex = reverse ? count - i - 1 : i;
                    this.appendSegment(segIndex, builder, part);
                    if (++i == count) break;
                    if (separator == null) continue;
                    builder.append(separator);
                }
            }
            return builder;
        }

        public int appendSingleDivision(AddressStringDivision seg, StringBuilder builder) {
            if (builder == null) {
                return this.getAddressLabelLength() + seg.getStandardString(0, this, null);
            }
            this.appendLabel(builder);
            seg.getStandardString(0, this, builder);
            return 0;
        }

        protected int appendSegment(int segmentIndex, StringBuilder builder, T part) {
            AddressStringDivision seg = part.getDivision(segmentIndex);
            return seg.getStandardString(segmentIndex, this, builder);
        }

        public int getZoneLength(CharSequence zone) {
            if (zone != null && zone.length() > 0) {
                return zone.length() + 1;
            }
            return 0;
        }

        public int getStringLength(T addr, CharSequence zone) {
            int result = this.getStringLength(addr);
            if (zone != null) {
                result += this.getZoneLength(zone);
            }
            return result;
        }

        public int getStringLength(T addr) {
            return this.getAddressLabelLength() + this.getSegmentsStringLength(addr);
        }

        public StringBuilder appendZone(StringBuilder builder, CharSequence zone) {
            if (zone != null && zone.length() > 0) {
                builder.append(this.zoneSeparator).append(zone);
            }
            return builder;
        }

        public StringBuilder append(StringBuilder builder, T addr, CharSequence zone) {
            return this.appendZone(this.appendSegments(this.appendLabel(builder), addr), zone);
        }

        public StringBuilder append(StringBuilder builder, T addr) {
            return this.append(builder, addr, null);
        }

        @Override
        public int getDivisionStringLength(AddressStringDivision seg) {
            return this.appendSingleDivision(seg, null);
        }

        @Override
        public StringBuilder appendDivision(StringBuilder builder, AddressStringDivision seg) {
            this.appendSingleDivision(seg, builder);
            return builder;
        }

        public String toString(T addr, CharSequence zone) {
            int length = this.getStringLength(addr, zone);
            StringBuilder builder = new StringBuilder(length);
            this.append(builder, addr, zone);
            AddressStringParams.checkLengths(length, builder);
            return builder.toString();
        }

        public String toString(T addr) {
            return this.toString(addr, null);
        }

        public static void checkLengths(int length, StringBuilder builder) {
        }

        public static AddressStringParams<AddressStringDivisionSeries> toParams(StringOptions opts) {
            AddressStringParams result = (AddressStringParams)AddressDivisionGrouping.getCachedParams(opts);
            if (result == null) {
                result = new AddressStringParams(opts.base, opts.separator, opts.uppercase);
                result.expandSegments(opts.expandSegments);
                result.setWildcards(opts.wildcards);
                result.setSegmentStrPrefix(opts.segmentStrPrefix);
                result.setAddressLabel(opts.addrLabel);
                result.setReverse(opts.reverse);
                result.setSplitDigits(opts.splitDigits);
                AddressDivisionGrouping.setCachedParams(opts, result);
            }
            return result;
        }

        public AddressStringParams<T> clone() {
            try {
                AddressStringParams parms = (AddressStringParams)super.clone();
                return parms;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    protected static interface GroupingCreator<S extends AddressDivisionBase> {
        public S createDivision(long var1, long var3, int var5, int var6);
    }

    protected static interface PrefixedGroupingCreator<S extends AddressDivisionBase> {
        public S createDivision(long var1, long var3, int var5, int var6, IPAddressNetwork<?, ?, ?, ?, ?> var7, Integer var8);
    }

    protected static class SectionCache<R extends AddressSegmentSeries> {
        public R lower;
        public R lowerNonZeroHost;
        public R upper;
        public boolean lowerNonZeroHostIsNull;
    }

    protected static interface SegFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }

    protected static class StringCache {
        public String canonicalString;
        public String hexString;
        public String hexStringPrefixed;

        protected StringCache() {
        }
    }

    public static class StringOptions {
        public final Wildcards wildcards;
        public final boolean expandSegments;
        public final int base;
        public final String segmentStrPrefix;
        public final Character separator;
        public final String addrLabel;
        public final boolean reverse;
        public final boolean splitDigits;
        public final boolean uppercase;
        AddressDivisionWriter cachedParams;

        protected StringOptions(int base, boolean expandSegments, Wildcards wildcards, String segmentStrPrefix, Character separator, String label, boolean reverse, boolean splitDigits, boolean uppercase) {
            this.expandSegments = expandSegments;
            this.wildcards = wildcards;
            this.base = base;
            if (segmentStrPrefix == null) {
                throw new NullPointerException("segment str");
            }
            this.segmentStrPrefix = segmentStrPrefix;
            this.separator = separator;
            if (label == null) {
                throw new NullPointerException("label");
            }
            this.addrLabel = label;
            this.reverse = reverse;
            this.splitDigits = splitDigits;
            this.uppercase = uppercase;
        }

        public static class Builder {
            public static final Wildcards DEFAULT_WILDCARDS = new Wildcards();
            protected Wildcards wildcards = DEFAULT_WILDCARDS;
            protected boolean expandSegments;
            protected int base;
            protected String segmentStrPrefix = "";
            protected Character separator;
            protected String addrLabel = "";
            protected boolean reverse;
            protected boolean splitDigits;
            protected boolean uppercase;

            protected Builder(int base, char separator) {
                this.base = base;
                this.separator = Character.valueOf(separator);
            }

            public Builder setWildcards(Wildcards wildcards) {
                this.wildcards = wildcards;
                return this;
            }

            public Builder setReverse(boolean reverse) {
                this.reverse = reverse;
                return this;
            }

            public Builder setUppercase(boolean uppercase) {
                this.uppercase = uppercase;
                return this;
            }

            public Builder setSplitDigits(boolean splitDigits) {
                this.splitDigits = splitDigits;
                return this;
            }

            public Builder setExpandedSegments(boolean expandSegments) {
                this.expandSegments = expandSegments;
                return this;
            }

            public Builder setRadix(int base) {
                this.base = base;
                return this;
            }

            public Builder setSeparator(Character separator) {
                this.separator = separator;
                return this;
            }

            public Builder setAddressLabel(String label) {
                this.addrLabel = label;
                return this;
            }

            public Builder setSegmentStrPrefix(String prefix) {
                this.segmentStrPrefix = prefix;
                return this;
            }

            public StringOptions toOptions() {
                return new StringOptions(this.base, this.expandSegments, this.wildcards, this.segmentStrPrefix, this.separator, this.addrLabel, this.reverse, this.splitDigits, this.uppercase);
            }
        }

        public static class Wildcards {
            public final String rangeSeparator;
            public final String wildcard;
            public final String singleWildcard;

            public Wildcards() {
                this(Address.RANGE_SEPARATOR_STR, Address.SEGMENT_WILDCARD_STR, null);
            }

            public Wildcards(String wildcard, String singleWildcard) {
                this(Address.RANGE_SEPARATOR_STR, wildcard, singleWildcard);
            }

            public Wildcards(String rangeSeparator) {
                this(rangeSeparator, null, null);
            }

            public Wildcards(String rangeSeparator, String wildcard, String singleWildcard) {
                if (rangeSeparator == null) {
                    rangeSeparator = Address.RANGE_SEPARATOR_STR;
                }
                this.rangeSeparator = rangeSeparator;
                this.wildcard = wildcard;
                this.singleWildcard = singleWildcard;
            }

            public String toString() {
                return "range separator: " + this.rangeSeparator + "\nwildcard: " + this.wildcard + "\nsingle wildcard: " + this.singleWildcard;
            }
        }
    }

    protected static class ValueCache {
        public byte[] lowerBytes;
        public byte[] upperBytes;
        public BigInteger value;
        public BigInteger upperValue;
        public InetAddress inetAddress;
        public InetAddress upperInetAddress;

        protected ValueCache() {
        }
    }
}

