/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.validate.AddressParseData;
import inet.ipaddr.format.validate.ParsedAddressCreator;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.io.Serializable;

class ParsedIPAddress
implements Serializable {
    private static final long serialVersionUID = 4L;
    private final IPAddress.IPVersion ipVersion;
    private final ParsedHostIdentifierStringQualifier qualifier;
    private final CharSequence addressString;
    final IPAddressStringParameters options;
    private final HostIdentifierString originator;
    private final IPAddressParseData parseData;

    ParsedIPAddress(HostIdentifierString from, CharSequence addressString, IPAddressStringParameters options, IPAddressParseData parseData, IPAddress.IPVersion ipVersion, ParsedHostIdentifierStringQualifier qualifier) {
        this.ipVersion = ipVersion;
        this.parseData = parseData;
        this.qualifier = qualifier;
        this.addressString = addressString;
        this.options = options;
        this.originator = from;
    }

    private IPv6AddressNetwork.IPv6AddressCreator getIPv6AddressCreator() {
        return this.options.getIPv6Parameters().getNetwork().getAddressCreator();
    }

    private IPv4AddressNetwork.IPv4AddressCreator getIPv4AddressCreator() {
        return this.options.getIPv4Parameters().getNetwork().getAddressCreator();
    }

    void reverseSegments() {
        this.parseData.reverseSegments();
    }

    IPAddress.IPVersion getIPVersion() {
        return this.ipVersion;
    }

    boolean isMixedIPv6() {
        return this.parseData.isMixedIPv6();
    }

    boolean isBase85IPv6() {
        return this.parseData.isBase85;
    }

    boolean isIPv6() {
        return this.parseData.ipVersion.isIPv6();
    }

    boolean isIPv4() {
        return this.parseData.ipVersion.isIPv4();
    }

    Integer getNetworkPrefixLength() {
        return this.qualifier.getNetworkPrefixLength();
    }

    boolean isPrefixed() {
        return this.getNetworkPrefixLength() != null;
    }

    IPAddresses<?, ?> createAddresses() {
        IPAddress.IPVersion version = this.ipVersion;
        if (version == IPAddress.IPVersion.IPV4) {
            return this.createIPv4Addresses();
        }
        if (version == IPAddress.IPVersion.IPV6) {
            return this.createIPv6Addresses();
        }
        return null;
    }

    private static <S extends IPAddressSegment> S[] allocateHostSegments(S[] segments, S[] originalSegments, AddressNetwork.AddressSegmentCreator<S> creator, int segmentCount, int originalCount) {
        if (segments == null) {
            segments = (IPAddressSegment[])creator.createSegmentArray(segmentCount);
            System.arraycopy(originalSegments, 0, segments, 0, originalCount);
        }
        return segments;
    }

    private IPAddresses<IPv4Address, IPv4AddressSection> createIPv4Addresses() {
        IPAddress mask = this.qualifier.getMask();
        if (mask != null && mask.getBlockMaskPrefixLength(true) != null) {
            mask = null;
        }
        boolean hasMask = mask != null;
        int segmentCount = this.parseData.addressParseData.segmentCount;
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getIPv4AddressCreator();
        int ipv4SegmentCount = 4;
        int missingCount = ipv4SegmentCount - segmentCount;
        IPAddressSegment[] hostSegments = null;
        AddressSegment[] segments = creator.createSegmentArray(ipv4SegmentCount);
        boolean expandedSegments = missingCount <= 0;
        int expandedEnd = -1;
        int expandedStart = -1;
        int i = 0;
        int normalizedSegmentIndex = 0;
        while (i < segmentCount) {
            boolean isLastSegment;
            long[] vals = this.parseData.addressParseData.values[i];
            boolean[] flags = this.parseData.addressParseData.flags[i];
            int[] indices = this.parseData.addressParseData.indices[i];
            long lower = vals[0];
            long upper = vals[1];
            boolean bl = isLastSegment = i == segmentCount - 1;
            if (!expandedSegments && isLastSegment && !this.parseData.isWildcard(i)) {
                expandedSegments = true;
                int count = missingCount;
                expandedStart = i;
                expandedEnd = i + count;
                while (count >= 0) {
                    Integer segmentMask;
                    int newUpper;
                    int newLower;
                    Integer currentPrefix = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, this.qualifier);
                    boolean[] segFlags = flags;
                    if (lower != upper) {
                        int shift = 8 * count;
                        int segmentMask2 = 255;
                        newLower = (int)(lower >>> shift) & segmentMask2;
                        newUpper = (int)(upper >>> shift) & segmentMask2;
                        if (count == 0 && (long)newLower == lower) {
                            if ((long)newUpper != upper) {
                                segFlags[3] = false;
                            }
                        } else {
                            segFlags = null;
                        }
                    } else {
                        newLower = newUpper = (int)(lower >> 8 * count) & 0xFF;
                        if (count != 0 || (long)newLower != lower) {
                            segFlags = null;
                        }
                    }
                    Integer n = segmentMask = hasMask ? Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue()) : null;
                    if (segmentMask != null || currentPrefix != null) {
                        hostSegments = (IPv4AddressSegment[])ParsedIPAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv4SegmentCount, (int)normalizedSegmentIndex);
                        hostSegments[normalizedSegmentIndex] = (IPv4AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, newLower, newUpper, flags, indices, null, null, creator);
                    }
                    segments[normalizedSegmentIndex] = (IPv4AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, newLower, newUpper, segFlags, indices, currentPrefix, segmentMask, creator);
                    ++normalizedSegmentIndex;
                    --count;
                }
                break;
            }
            Integer segmentMask = hasMask ? Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue()) : null;
            Integer segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, this.qualifier);
            if (segmentMask != null || segmentPrefixLength != null) {
                hostSegments = (IPv4AddressSegment[])ParsedIPAddress.allocateHostSegments(hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv4SegmentCount, (int)normalizedSegmentIndex);
                hostSegments[normalizedSegmentIndex] = (IPv4AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)upper, flags, indices, null, null, creator);
            }
            segments[normalizedSegmentIndex] = (IPv4AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)upper, flags, indices, segmentPrefixLength, segmentMask, creator);
            if (!expandedSegments && this.parseData.isWildcard(i) && (!this.parseData.is_inet_aton_joined || isLastSegment)) {
                boolean expandSegments = true;
                int j = i + 1;
                while (j < segmentCount) {
                    if (this.parseData.isWildcard(j)) {
                        expandSegments = false;
                        break;
                    }
                    ++j;
                }
                if (expandSegments) {
                    expandedSegments = true;
                    int count = missingCount;
                    while (count-- > 0) {
                        segmentMask = hasMask ? Integer.valueOf(mask.getSegment(++normalizedSegmentIndex).getLowerSegmentValue()) : null;
                        segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, this.qualifier);
                        if (segmentMask != null || segmentPrefixLength != null) {
                            hostSegments = (IPv4AddressSegment[])ParsedIPAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv4SegmentCount, (int)normalizedSegmentIndex);
                            hostSegments[normalizedSegmentIndex] = (IPv4AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)upper, flags, indices, null, null, creator);
                        }
                        segments[normalizedSegmentIndex] = (IPv4AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV4, 0, 255, null, null, segmentPrefixLength, segmentMask, creator);
                    }
                }
            }
            ++i;
            ++normalizedSegmentIndex;
        }
        IPv4AddressNetwork.IPv4AddressCreator addressCreator = creator;
        Integer prefLength = ParsedIPAddress.getPrefixLength(this.qualifier);
        IPv4AddressSection result = (IPv4AddressSection)addressCreator.createPrefixedSectionInternal(segments, prefLength);
        IPv4AddressSection hostResult = hostSegments != null ? (IPv4AddressSection)addressCreator.createSectionInternal(hostSegments) : null;
        if (this.checkExpandedValues(result, expandedStart, expandedEnd)) {
            throw new IncompatibleAddressException(this.addressString, "ipaddress.error.invalid.joined.ranges");
        }
        if (this.checkExpandedValues(hostResult, expandedStart, expandedEnd)) {
            hostResult = null;
        }
        return new IPAddresses<IPv4Address, IPv4AddressSection>(this, result, hostResult){

            @Override
            ParsedAddressCreator<IPv4Address, IPv4AddressSection, ?, ?> getCreator() {
                return this.getIPv4AddressCreator();
            }
        };
    }

    private boolean checkExpandedValues(IPAddressSection section, int start, int end) {
        if (section != null && start < end) {
            IPAddressSegment seg = section.getSegment(start);
            boolean lastWasRange = seg.isMultiple();
            do {
                seg = section.getSegment(++start);
                if (lastWasRange) {
                    if (seg.isFullRange()) continue;
                    return true;
                }
                lastWasRange = seg.isMultiple();
            } while (start < end);
        }
        return false;
    }

    IPAddresses<IPv6Address, IPv6AddressSection> createIPv6Addresses() {
        IPAddress mask = this.qualifier.getMask();
        if (mask != null && mask.getBlockMaskPrefixLength(true) != null) {
            mask = null;
        }
        boolean hasMask = mask != null;
        int segmentCount = this.parseData.addressParseData.segmentCount;
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getIPv6AddressCreator();
        int ipv6SegmentCount = 8;
        IPAddressSegment[] hostSegments = null;
        AddressSegment[] segments = creator.createSegmentArray(ipv6SegmentCount);
        boolean mixed = this.isMixedIPv6();
        int normalizedSegmentIndex = 0;
        int missingSegmentCount = (mixed ? 6 : 8) - segmentCount;
        boolean expandedSegments = missingSegmentCount <= 0;
        int expandedEnd = -1;
        int expandedStart = -1;
        int i = 0;
        while (i < segmentCount) {
            long[] vals = this.parseData.addressParseData.values[i];
            boolean[] flags = this.parseData.addressParseData.flags[i];
            int[] indices = this.parseData.addressParseData.indices[i];
            long lower = vals[0];
            long upper = vals[1];
            if (!expandedSegments && i == segmentCount - 1 && !this.parseData.isWildcard(i)) {
                boolean isRange;
                long upperHighBytes;
                long lowerHighBytes;
                expandedSegments = true;
                int count = missingSegmentCount;
                if (count >= 4) {
                    lowerHighBytes = vals[2];
                    upperHighBytes = vals[3];
                    isRange = lower != upper || lowerHighBytes != upperHighBytes;
                } else {
                    upperHighBytes = 0L;
                    lowerHighBytes = 0L;
                    isRange = lower != upper;
                }
                expandedStart = i;
                expandedEnd = i + count;
                while (count >= 0) {
                    Integer segmentMask;
                    int newUpper;
                    int newLower;
                    Integer currentPrefix = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, this.qualifier);
                    boolean[] segFlags = flags;
                    if (isRange) {
                        int shift;
                        int segmentMask2 = 65535;
                        if (count >= 4) {
                            shift = 16 * (count % 4);
                            newLower = (int)(lowerHighBytes >>> shift) & segmentMask2;
                            newUpper = (int)(upperHighBytes >>> shift) & segmentMask2;
                        } else {
                            shift = 16 * count;
                            newLower = (int)(lower >>> shift) & segmentMask2;
                            newUpper = (int)(upper >>> shift) & segmentMask2;
                        }
                        if (count == 0 && (long)newLower == lower && lowerHighBytes == 0L) {
                            if ((long)newUpper != upper || upperHighBytes != 0L) {
                                segFlags[3] = false;
                            }
                        } else {
                            segFlags = null;
                        }
                    } else if (count >= 4) {
                        newLower = newUpper = (int)(lowerHighBytes >>> 16 * (count % 4)) & 0xFFFF;
                        segFlags = null;
                    } else {
                        newLower = newUpper = (int)(lower >>> 16 * count) & 0xFFFF;
                        if (count != 0 || (long)newLower != lower || lowerHighBytes != 0L) {
                            segFlags = null;
                        }
                    }
                    Integer n = segmentMask = hasMask ? Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue()) : null;
                    if (segmentMask != null || currentPrefix != null) {
                        hostSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                        hostSegments[normalizedSegmentIndex] = (IPv6AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV6, newLower, newUpper, segFlags, indices, null, null, creator);
                    }
                    segments[normalizedSegmentIndex] = (IPv6AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV6, newLower, newUpper, segFlags, indices, currentPrefix, segmentMask, creator);
                    ++normalizedSegmentIndex;
                    --count;
                }
                break;
            }
            Integer segmentMask = hasMask ? Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue()) : null;
            Integer segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, this.qualifier);
            if (segmentMask != null || segmentPrefixLength != null) {
                hostSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateHostSegments(hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                hostSegments[normalizedSegmentIndex] = (IPv6AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV6, (int)lower, (int)upper, flags, indices, null, null, creator);
            }
            segments[normalizedSegmentIndex] = (IPv6AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV6, (int)lower, (int)upper, flags, indices, segmentPrefixLength, segmentMask, creator);
            ++normalizedSegmentIndex;
            int expandValueLower = 0;
            int expandValueUpper = 0;
            if (!expandedSegments) {
                boolean expandSegments = false;
                if (this.parseData.isWildcard(i)) {
                    expandValueLower = 0;
                    expandValueUpper = 65535;
                    expandSegments = true;
                    int j = i + 1;
                    while (j < segmentCount) {
                        if (this.parseData.isWildcard(j) || this.parseData.isCompressed(j)) {
                            expandSegments = false;
                            break;
                        }
                        ++j;
                    }
                } else if (this.parseData.isCompressed(i)) {
                    expandSegments = true;
                    expandValueUpper = 0;
                    expandValueLower = 0;
                }
                if (expandSegments) {
                    expandedSegments = true;
                    int count = missingSegmentCount;
                    while (count-- > 0) {
                        segmentMask = hasMask ? Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue()) : null;
                        segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, this.qualifier);
                        if (segmentMask != null || segmentPrefixLength != null) {
                            hostSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                            hostSegments[normalizedSegmentIndex] = (IPv6AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV6, expandValueLower, expandValueUpper, null, null, null, null, creator);
                        }
                        segments[normalizedSegmentIndex] = (IPv6AddressSegment)ParsedIPAddress.createSegment(this.addressString, IPAddress.IPVersion.IPV6, expandValueLower, expandValueUpper, null, null, segmentPrefixLength, segmentMask, creator);
                        ++normalizedSegmentIndex;
                    }
                }
            }
            ++i;
        }
        IPv6AddressSection hostResult = null;
        IPv6AddressSection result = null;
        IPv6AddressNetwork.IPv6AddressCreator addressCreator = creator;
        if (mixed) {
            IPv4AddressSection ipv4AddressSection = this.parseData.mixedParsedAddress.createIPv4Addresses().getSection();
            boolean embeddedSectionIsChanged = false;
            int n = 0;
            while (n < 2) {
                IPv6AddressSegment newSegment;
                boolean doHostSegment;
                int m = n << 1;
                IPv4AddressSegment one = ipv4AddressSection.getSegment(m);
                IPv4AddressSegment two = ipv4AddressSection.getSegment(m + 1);
                Integer segmentMask = hasMask ? Integer.valueOf(mask.getSegment(normalizedSegmentIndex).getLowerSegmentValue()) : null;
                Integer segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, this.qualifier);
                boolean bl = doHostSegment = segmentMask != null || segmentPrefixLength != null;
                if (doHostSegment) {
                    hostSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateHostSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)ipv6SegmentCount, (int)normalizedSegmentIndex);
                }
                int oneLower = one.getLowerSegmentValue();
                int twoLower = two.getLowerSegmentValue();
                if (!one.isMultiple() && !two.isMultiple()) {
                    if (doHostSegment) {
                        hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(oneLower, twoLower, null, null, creator);
                    }
                    newSegment = ParsedIPAddress.createSegment(oneLower, twoLower, segmentPrefixLength, segmentMask, creator);
                    segments[normalizedSegmentIndex] = newSegment;
                } else {
                    int oneUpper = one.getUpperSegmentValue();
                    int twoUpper = two.getUpperSegmentValue();
                    if (doHostSegment) {
                        hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createSegment(one, two, oneLower, oneUpper, twoLower, twoUpper, null, null, creator);
                    }
                    newSegment = ParsedIPAddress.createSegment(one, two, oneLower, oneUpper, twoLower, twoUpper, segmentPrefixLength, segmentMask, creator);
                    segments[normalizedSegmentIndex] = newSegment;
                }
                embeddedSectionIsChanged |= newSegment.isPrefixed() || newSegment.getLowerSegmentValue() != (one.getLowerSegmentValue() << 8 | two.getLowerSegmentValue()) || newSegment.getUpperSegmentValue() != (one.getUpperSegmentValue() << 8 | two.getUpperSegmentValue());
                ++normalizedSegmentIndex;
                ++n;
            }
            if (!embeddedSectionIsChanged) {
                if (hostSegments != null) {
                    hostResult = (IPv6AddressSection)addressCreator.createSectionInternal(hostSegments, ipv4AddressSection);
                }
                result = (IPv6AddressSection)addressCreator.createSectionInternal(segments, ipv4AddressSection, ParsedIPAddress.getPrefixLength(this.qualifier));
            }
        }
        if (result == null) {
            if (hostSegments != null) {
                hostResult = (IPv6AddressSection)addressCreator.createSectionInternal(hostSegments);
            }
            result = (IPv6AddressSection)addressCreator.createPrefixedSectionInternal(segments, ParsedIPAddress.getPrefixLength(this.qualifier));
        }
        if (this.checkExpandedValues(result, expandedStart, expandedEnd)) {
            throw new IncompatibleAddressException(this.addressString, "ipaddress.error.invalid.joined.ranges");
        }
        if (this.checkExpandedValues(hostResult, expandedStart, expandedEnd)) {
            hostResult = null;
        }
        return new IPAddresses<IPv6Address, IPv6AddressSection>(this, result, hostResult){

            @Override
            ParsedAddressCreator<IPv6Address, IPv6AddressSection, ?, ?> getCreator() {
                return this.getIPv6AddressCreator();
            }
        };
    }

    private static <S extends IPAddressSegment> S createSegment(CharSequence addressString, IPAddress.IPVersion version, int val, int upperVal, boolean[] flags, int[] indices, Integer segmentPrefixLength, Integer mask, ParsedAddressCreator<?, ?, ?, S> creator) {
        if (val != upperVal) {
            return ParsedIPAddress.createRangeSegment(addressString, version, val, upperVal, flags, indices, segmentPrefixLength, mask, creator);
        }
        int stringVal = val;
        if (mask != null) {
            val &= mask.intValue();
        }
        IPAddressSegment result = flags == null ? (IPAddressSegment)creator.createSegment(val, val, segmentPrefixLength) : (IPAddressSegment)creator.createSegmentInternal(val, segmentPrefixLength, addressString, stringVal, flags[2], indices[3], indices[4]);
        return (S)result;
    }

    private static IPv6AddressSegment createSegment(int value1, int value2, Integer segmentPrefixLength, Integer mask, IPv6AddressNetwork.IPv6AddressCreator creator) {
        int value = value1 << 8 | value2;
        if (mask != null) {
            value &= mask.intValue();
        }
        IPv6AddressSegment result = creator.createSegment(value, segmentPrefixLength);
        return result;
    }

    private static IPv6AddressSegment createSegment(IPv4AddressSegment one, IPv4AddressSegment two, int upperRangeLower, int upperRangeUpper, int lowerRangeLower, int lowerRangeUpper, Integer segmentPrefixLength, Integer mask, IPv6AddressNetwork.IPv6AddressCreator creator) throws IncompatibleAddressException {
        boolean hasMask;
        boolean bl = hasMask = mask != null;
        if (hasMask) {
            int maskInt = mask;
            int shift = 8;
            int shiftedMask = maskInt >> shift;
            upperRangeLower &= shiftedMask;
            upperRangeUpper &= shiftedMask;
            lowerRangeLower &= maskInt;
            lowerRangeUpper &= maskInt;
        }
        IPv6AddressSegment result = ParsedIPAddress.join(one, two, upperRangeLower, upperRangeUpper, lowerRangeLower, lowerRangeUpper, segmentPrefixLength, creator);
        if (hasMask && !result.isMaskCompatibleWithRange(mask, segmentPrefixLength)) {
            throw new IncompatibleAddressException((AddressItem)result, mask, "ipaddress.error.maskMismatch");
        }
        return result;
    }

    private static IPv6AddressSegment join(IPv4AddressSegment one, IPv4AddressSegment two, int upperRangeLower, int upperRangeUpper, int lowerRangeLower, int lowerRangeUpper, Integer segmentPrefixLength, IPv6AddressNetwork.IPv6AddressCreator creator) throws IncompatibleAddressException {
        int shift = 8;
        if (upperRangeLower != upperRangeUpper) {
            if (segmentPrefixLength != null && creator.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                if (segmentPrefixLength > shift) {
                    int lowerPrefixLength = segmentPrefixLength - shift;
                    int fullMask = ~(-1 << shift);
                    int networkMask = fullMask & fullMask << shift - lowerPrefixLength;
                    int hostMask = ~networkMask & fullMask;
                    if ((lowerRangeLower &= networkMask) != 0 || (lowerRangeUpper |= hostMask) != 255) {
                        throw new IncompatibleAddressException((AddressItem)one, two, "ipaddress.error.invalidMixedRange");
                    }
                } else {
                    lowerRangeLower = 0;
                    lowerRangeUpper = 255;
                }
            } else if (lowerRangeLower != 0 || lowerRangeUpper != 255) {
                throw new IncompatibleAddressException((AddressItem)one, two, "ipaddress.error.invalidMixedRange");
            }
        }
        return creator.createSegment(upperRangeLower << shift | lowerRangeLower, upperRangeUpper << shift | lowerRangeUpper, segmentPrefixLength);
    }

    private static <S extends IPAddressSegment> S createRangeSegment(CharSequence addressString, IPAddress.IPVersion version, int stringLower, int stringUpper, boolean[] flags, int[] indices, Integer segmentPrefixLength, Integer mask, ParsedAddressCreator<?, ?, ?, S> creator) {
        boolean hasMask;
        int lower = stringLower;
        int upper = stringUpper;
        boolean bl = hasMask = mask != null;
        if (hasMask) {
            int maskInt = mask;
            lower &= maskInt;
            upper &= maskInt;
        }
        IPAddressSegment result = flags == null ? (IPAddressSegment)creator.createSegment(lower, upper, segmentPrefixLength) : (IPAddressSegment)creator.createSegmentInternal(lower, upper, segmentPrefixLength, addressString, stringLower, stringUpper, flags[2], flags[3], indices[3], indices[4], indices[7]);
        if (hasMask && !result.isMaskCompatibleWithRange(mask, segmentPrefixLength)) {
            throw new IncompatibleAddressException((AddressItem)result, mask, "ipaddress.error.maskMismatch");
        }
        return (S)result;
    }

    static IPAddress createAllAddress(IPAddress.IPVersion version, ParsedHostIdentifierStringQualifier qualifier, HostIdentifierString originator, IPAddressStringParameters options) {
        int segmentCount = IPAddress.getSegmentCount(version);
        IPAddress mask = qualifier.getMask();
        if (mask != null && mask.getBlockMaskPrefixLength(true) != null) {
            mask = null;
        }
        boolean hasMask = mask != null;
        Integer prefLength = ParsedIPAddress.getPrefixLength(qualifier);
        if (version.isIPv4()) {
            IPv4AddressNetwork.IPv4AddressCreator creator = options.getIPv4Parameters().getNetwork().getAddressCreator();
            AddressSegment[] segments = (IPv4AddressSegment[])creator.createSegmentArray(segmentCount);
            int i = 0;
            while (i < segmentCount) {
                Integer segmentMask = hasMask ? Integer.valueOf(mask.getSegment(i).getLowerSegmentValue()) : null;
                segments[i] = (IPv4AddressSegment)ParsedIPAddress.createRangeSegment(null, version, 0, 255, null, null, ParsedIPAddress.getSegmentPrefixLength(i, version, qualifier), segmentMask, creator);
                ++i;
            }
            return (IPAddress)creator.createAddressInternal(segments, originator, prefLength);
        }
        IPv6AddressNetwork.IPv6AddressCreator creator = options.getIPv6Parameters().getNetwork().getAddressCreator();
        AddressSegment[] segments = (IPv6AddressSegment[])creator.createSegmentArray(segmentCount);
        int i = 0;
        while (i < segmentCount) {
            Integer segmentMask = hasMask ? Integer.valueOf(mask.getSegment(i).getLowerSegmentValue()) : null;
            segments[i] = (IPv6AddressSegment)ParsedIPAddress.createRangeSegment(null, version, 0, 65535, null, null, ParsedIPAddress.getSegmentPrefixLength(i, version, qualifier), segmentMask, creator);
            ++i;
        }
        return (IPAddress)creator.createAddressInternal(segments, qualifier.getZone(), originator, prefLength);
    }

    private static Integer getPrefixLength(ParsedHostIdentifierStringQualifier qualifier) {
        IPAddress mask = qualifier.getMask();
        Integer bits = mask != null ? mask.getBlockMaskPrefixLength(true) : qualifier.getNetworkPrefixLength();
        return bits;
    }

    private static Integer getSegmentPrefixLength(int segmentIndex, int bitsPerSegment, ParsedHostIdentifierStringQualifier qualifier) {
        IPAddress mask = qualifier.getMask();
        Integer networkPrefixLength = qualifier.getNetworkPrefixLength();
        Integer bits = mask != null ? mask.getBlockMaskPrefixLength(true) : networkPrefixLength;
        return IPAddressSection.getSegmentPrefixLength(bitsPerSegment, bits, segmentIndex);
    }

    private static Integer getSegmentPrefixLength(int segmentIndex, IPAddress.IPVersion version, ParsedHostIdentifierStringQualifier qualifier) {
        return ParsedIPAddress.getSegmentPrefixLength(segmentIndex, IPAddressSection.bitsPerSegment(version), qualifier);
    }

    public String toString() {
        return this.addressString.toString();
    }

    static class CachedIPAddresses<T extends IPAddress>
    implements Serializable {
        private static final long serialVersionUID = 4L;
        protected T address;
        protected T hostAddress;

        CachedIPAddresses() {
        }

        public CachedIPAddresses(T address) {
            this(address, address);
        }

        public CachedIPAddresses(T address, T hostAddress) {
            this.address = address;
            this.hostAddress = hostAddress;
        }

        public T getAddress() {
            return this.address;
        }

        public T getHostAddress() {
            return this.hostAddress;
        }
    }

    static class IPAddressParseData
    implements Serializable {
        private static final long serialVersionUID = 4L;
        AddressParseData addressParseData;
        int qualifierIndex = -1;
        boolean isPrefixed;
        boolean isZoned;
        boolean hasPort;
        IPAddress.IPVersion ipVersion;
        boolean is_inet_aton_joined;
        ParsedIPAddress mixedParsedAddress;
        boolean isBase85;
        boolean isBase85Zoned;

        IPAddressParseData(CharSequence str) {
            this.addressParseData = new AddressParseData(str);
        }

        void initSegmentData(int segmentCapacity) {
            this.addressParseData.initSegmentData(segmentCapacity);
        }

        void clearQualifier() {
            this.qualifierIndex = -1;
            this.hasPort = false;
            this.isZoned = false;
            this.isPrefixed = false;
            this.isBase85Zoned = false;
        }

        void reverseSegments() {
            if (this.mixedParsedAddress != null) {
                this.mixedParsedAddress.reverseSegments();
            }
            this.addressParseData.reverseSegments();
        }

        boolean isCompressed() {
            return this.addressParseData.consecutiveSepIndex >= 0;
        }

        boolean isCompressed(int index) {
            int[] inds = this.addressParseData.indices[index];
            int start = inds[3];
            int end = inds[7];
            return start == end;
        }

        boolean isWildcard(int index) {
            return this.addressParseData.isWildcard(index);
        }

        boolean isMixedIPv6() {
            return this.mixedParsedAddress != null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.addressParseData);
            builder.append("ip version: ").append((Object)this.ipVersion);
            if (this.ipVersion.isIPv6()) {
                if (this.isMixedIPv6()) {
                    if (this.isZoned) {
                        builder.append(", with zone ");
                        this.printQualifier(builder);
                    }
                    if (this.isPrefixed) {
                        builder.append(", with prefix length ");
                        this.printQualifier(builder);
                    }
                    builder.append(", with IPv4 embedded address: ").append('\n').append(this.mixedParsedAddress.parseData);
                } else {
                    if (this.isBase85) {
                        builder.append(" base 85");
                        if (this.isBase85Zoned) {
                            builder.append(", with zone ");
                            this.printQualifier(builder);
                        }
                    } else if (this.isZoned) {
                        builder.append(", with zone ");
                        this.printQualifier(builder);
                    }
                    if (this.isPrefixed) {
                        builder.append(", with prefix length ");
                        this.printQualifier(builder);
                    }
                    builder.append('\n');
                }
            } else if (this.ipVersion.isIPv4()) {
                if (this.isPrefixed) {
                    builder.append(", with prefix length  ");
                    this.printQualifier(builder);
                }
                if (this.is_inet_aton_joined) {
                    builder.append(", with joined segments");
                }
                builder.append('\n');
            }
            if (this.hasPort) {
                builder.append(", with port ");
                this.printQualifier(builder);
                builder.append('\n');
            }
            return builder.toString();
        }

        private void printQualifier(StringBuilder builder) {
            if (this.qualifierIndex >= 0) {
                CharSequence str = this.addressParseData.str;
                builder.append(str.subSequence(this.qualifierIndex, str.length()));
            } else {
                builder.append("unknown");
            }
        }
    }

    static abstract class IPAddresses<T extends IPAddress, R extends IPAddressSection>
    extends CachedIPAddresses<T> {
        private static final long serialVersionUID = 4L;
        private final R section;
        private final R hostSection;
        final /* synthetic */ ParsedIPAddress this$0;

        IPAddresses(R section, R hostSection) {
            this.this$0 = var1_1;
            this.section = section;
            this.hostSection = hostSection;
        }

        abstract ParsedAddressCreator<T, R, ?, ?> getCreator();

        @Override
        public T getAddress() {
            if (this.address == null) {
                this.address = (IPAddress)this.getCreator().createAddressInternal(this.section, this.this$0.qualifier.getZone(), this.this$0.originator);
            }
            return (T)this.address;
        }

        @Override
        public T getHostAddress() {
            if (this.hostSection == null) {
                return this.getAddress();
            }
            if (this.hostAddress == null) {
                this.hostAddress = (IPAddress)this.getCreator().createAddressInternal(this.hostSection, this.this$0.qualifier.getZone(), null);
            }
            return (T)this.hostAddress;
        }

        R getSection() {
            return this.section;
        }
    }
}

