/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressSegmentSeries;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.format.AddressCreator;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.AddressDivisionSeries;
import inet.ipaddr.format.AddressStringDivision;
import inet.ipaddr.format.AddressStringDivisionSeries;
import inet.ipaddr.format.util.AddressDivisionWriter;
import inet.ipaddr.format.util.AddressSegmentParams;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import java.util.function.Supplier;

public class AddressDivisionGrouping
implements AddressDivisionSeries,
Comparable<AddressDivisionGrouping> {
    private static final long serialVersionUID = 3L;
    private transient byte[] lowerBytes;
    private transient byte[] upperBytes;
    protected final AddressDivision[] divisions;
    private transient BigInteger cachedCount;
    protected Integer cachedPrefix;
    private transient Boolean isMultiple;
    protected int hashCode;

    public AddressDivisionGrouping(AddressDivision[] divisions) {
        this.divisions = divisions;
    }

    protected void initCachedValues(Integer cachedNetworkPrefix, BigInteger cachedCount) {
        this.cachedPrefix = cachedNetworkPrefix;
        this.cachedCount = cachedCount;
    }

    @Override
    public AddressDivision getDivision(int index) {
        return this.divisions[index];
    }

    @Override
    public int getDivisionCount() {
        return this.divisions.length;
    }

    @Override
    public int getBitCount() {
        int count = this.getDivisionCount();
        int bitCount = 0;
        int i = 0;
        while (i < count) {
            bitCount += this.getDivision(i).getBitCount();
            ++i;
        }
        return bitCount;
    }

    protected byte[] getCachedBytes() {
        return this.lowerBytes;
    }

    protected static byte[] getCachedBytes(AddressDivisionGrouping grouping) {
        return grouping.getCachedBytes();
    }

    @Override
    public byte[] getBytes() {
        if (this.lowerBytes == null) {
            this.setBytes(this.getBytesImpl(true));
        }
        return (byte[])this.lowerBytes.clone();
    }

    @Override
    public byte[] getBytes(byte[] bytes) {
        byte[] cached = this.lowerBytes;
        if (cached == null) {
            cached = this.getBytesImpl(true);
            this.setBytes(cached);
        }
        return this.getBytes(bytes, cached);
    }

    private byte[] getBytes(byte[] bytes, byte[] cached) {
        int byteCount = this.getBitCount() + 7 >> 3;
        if (bytes == null || bytes.length < byteCount) {
            return (byte[])cached.clone();
        }
        System.arraycopy(cached, 0, bytes, 0, byteCount);
        return bytes;
    }

    @Override
    public byte[] getUpperBytes() {
        if (!this.isMultiple()) {
            return this.getBytes();
        }
        byte[] cached = this.upperBytes;
        if (cached == null) {
            cached = this.getBytesImpl(false);
            this.setUpperBytes(cached);
        }
        return (byte[])cached.clone();
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        if (!this.isMultiple()) {
            return this.getBytes(bytes);
        }
        byte[] cached = this.upperBytes;
        if (cached == null) {
            cached = this.getBytesImpl(false);
            this.setUpperBytes(cached);
        }
        return this.getBytes(bytes, cached);
    }

    protected byte[] getBytesImpl(boolean low) {
        byte[] bytes = new byte[this.getBitCount() + 7 >> 3];
        int byteCount = bytes.length;
        int divCount = this.getDivisionCount();
        int k = divCount - 1;
        int byteIndex = byteCount - 1;
        int bitIndex = 8;
        while (k >= 0) {
            AddressDivision div = this.getDivision(k);
            long segmentValue = low ? div.getLowerValue() : div.getUpperValue();
            int divBits = div.getBitCount();
            while (divBits > 0) {
                int n = byteIndex--;
                bytes[n] = (byte)((long)bytes[n] | segmentValue << 8 - bitIndex);
                segmentValue >>= bitIndex;
                if (divBits < bitIndex) {
                    bitIndex -= divBits;
                    break;
                }
                divBits -= bitIndex;
                bitIndex = 8;
            }
            --k;
        }
        return bytes;
    }

    protected void setBytes(byte[] bytes) {
        this.lowerBytes = bytes;
    }

    protected void setUpperBytes(byte[] bytes) {
        this.upperBytes = bytes;
    }

    @Override
    public boolean isPrefixed() {
        return this.getPrefixLength() != null;
    }

    @Override
    public Integer getPrefixLength() {
        return this.cachedPrefix;
    }

    @Override
    public int getMinPrefix() {
        int count = this.getDivisionCount();
        int totalPrefix = this.getBitCount();
        int i = count - 1;
        while (i >= 0) {
            AddressDivision div = this.getDivision(i);
            int segBitCount = div.getBitCount();
            int segPrefix = div.getMinPrefix();
            if (segPrefix == segBitCount) break;
            totalPrefix -= segBitCount;
            if (segPrefix != 0) {
                totalPrefix += segPrefix;
                break;
            }
            --i;
        }
        return totalPrefix;
    }

    @Override
    public Integer getEquivalentPrefix() {
        int count = this.getDivisionCount();
        int totalPrefix = 0;
        int i = 0;
        while (i < count) {
            AddressDivision div = this.getDivision(i);
            int divPrefix = div.getMinPrefix();
            if (!div.matchesWithMask(div.getLowerValue(), -1 << div.getBitCount() - divPrefix)) {
                return null;
            }
            if (divPrefix < div.getBitCount()) {
                ++i;
                while (i < count) {
                    AddressDivision laterDiv = this.getDivision(i);
                    if (!laterDiv.isFullRange()) {
                        return null;
                    }
                    ++i;
                }
                return totalPrefix + divPrefix;
            }
            totalPrefix += divPrefix;
            ++i;
        }
        return totalPrefix;
    }

    @Override
    public BigInteger getCount() {
        if (this.cachedCount == null) {
            this.cachedCount = this.getCountImpl();
        }
        return this.cachedCount;
    }

    protected BigInteger getCountImpl() {
        BigInteger result = BigInteger.ONE;
        if (this.getDivisionCount() > 0 && this.isMultiple()) {
            int count = this.getDivisionCount();
            int i = 0;
            while (i < count) {
                long segCount = this.getDivision(i).getDivisionValueCount();
                result = result.multiply(BigInteger.valueOf(segCount));
                ++i;
            }
        }
        return result;
    }

    @Override
    public int isMore(AddressDivisionSeries other) {
        if (!this.isMultiple()) {
            return other.isMultiple() ? -1 : 0;
        }
        if (!other.isMultiple()) {
            return 1;
        }
        return this.getCount().compareTo(other.getCount());
    }

    @Override
    public boolean isMultiple() {
        Boolean result = this.isMultiple;
        if (result == null) {
            int i = this.divisions.length - 1;
            while (i >= 0) {
                AddressDivision seg = this.divisions[i];
                if (seg.isMultiple()) {
                    this.isMultiple = true;
                    return this.isMultiple;
                }
                --i;
            }
            this.isMultiple = false;
            return this.isMultiple;
        }
        return result;
    }

    @Override
    public boolean isMultipleByPrefix() {
        return this.cachedPrefix != null && this.cachedPrefix < this.getBitCount();
    }

    @Override
    public boolean isRangeEquivalentToPrefix() {
        if (this.cachedPrefix == null) {
            return !this.isMultiple();
        }
        return this.isRangeEquivalent(this.cachedPrefix);
    }

    public boolean isRangeEquivalent(int prefix) {
        if (prefix == 0) {
            return true;
        }
        int nonPrefixBits = Math.max(0, this.getBitCount() - prefix);
        int divisionCount = this.getDivisionCount();
        int i = divisionCount - 1;
        while (i >= 0) {
            AddressDivision division = this.getDivision(i);
            int bitCount = division.getBitCount();
            if (nonPrefixBits == 0) {
                if (division.isMultiple()) {
                    return false;
                }
            } else {
                int nonPrefixDivisionBits = Math.min(bitCount, nonPrefixBits);
                long divisionPrefixMask = -1L << nonPrefixDivisionBits;
                long lower = division.getLowerValue();
                if ((lower | divisionPrefixMask ^ 0xFFFFFFFFFFFFFFFFL) != division.getUpperValue() || (lower & divisionPrefixMask) != lower) {
                    return false;
                }
                nonPrefixBits = Math.max(0, nonPrefixBits - bitCount);
            }
            --i;
        }
        return true;
    }

    public int hashCode() {
        int res = this.hashCode;
        if (res == 0) {
            int fullResult = 1;
            int count = this.getDivisionCount();
            int i = 0;
            while (i < count) {
                AddressDivision combo = this.getDivision(i);
                long value = combo.getLowerValue();
                long shifted = value >>> 32;
                int adjusted = (int)(shifted == 0L ? value : value ^ shifted);
                fullResult = 31 * fullResult + adjusted;
                long upperValue = combo.getUpperValue();
                if (upperValue != value) {
                    shifted = upperValue >>> 32;
                    adjusted = (int)(shifted == 0L ? upperValue : upperValue ^ shifted);
                    fullResult = 31 * fullResult + adjusted;
                }
                ++i;
            }
            this.hashCode = res = fullResult;
        }
        return res;
    }

    protected boolean isSameGrouping(AddressDivisionGrouping other) {
        AddressDivision[] oneSegs = this.divisions;
        AddressDivision[] twoSegs = other.divisions;
        if (oneSegs.length != twoSegs.length) {
            return false;
        }
        int i = 0;
        while (i < oneSegs.length) {
            AddressDivision one = oneSegs[i];
            AddressDivision two = twoSegs[i];
            if (!one.isSameValues(two)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AddressDivisionGrouping) {
            AddressDivisionGrouping other = (AddressDivisionGrouping)o;
            return other.isSameGrouping(this);
        }
        return false;
    }

    @Override
    public int compareTo(AddressDivisionGrouping other) {
        return IPAddress.addressComparator.compare(this, other);
    }

    public String toString() {
        return Arrays.asList(this.divisions).toString();
    }

    @Override
    public boolean isZero() {
        int divCount = this.getDivisionCount();
        int i = 0;
        while (i < divCount) {
            if (!this.getDivision(i).isZero()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isFullRange() {
        int divCount = this.getDivisionCount();
        boolean isPrefixCached = this.cachedPrefix != null;
        int bitsSoFar = 0;
        int i = 0;
        while (i < divCount) {
            AddressDivision div = this.getDivision(i);
            if (!div.isFullRange()) {
                return false;
            }
            if (isPrefixCached && (bitsSoFar += this.getBitCount()) >= this.cachedPrefix) break;
            ++i;
        }
        return true;
    }

    protected static Integer getSegmentPrefixLength(int bitsPerSegment, Integer prefixLength, int segmentIndex) {
        if (prefixLength != null) {
            return AddressDivisionGrouping.getSegmentPrefixLengthNonNull(bitsPerSegment, prefixLength, segmentIndex);
        }
        return null;
    }

    protected static Integer getSegmentPrefixLengthNonNull(int bitsPerSegment, int prefixLength, int segmentIndex) {
        int decrement = bitsPerSegment == 8 ? segmentIndex << 3 : (bitsPerSegment == 16 ? segmentIndex << 4 : segmentIndex * bitsPerSegment);
        return AddressDivisionGrouping.getSegmentPrefixLength(bitsPerSegment, prefixLength - decrement);
    }

    protected static Integer getSegmentPrefixLength(int segmentBits, int segmentPrefixedBits) {
        if (segmentPrefixedBits <= 0) {
            return 0;
        }
        if (segmentPrefixedBits <= segmentBits) {
            return segmentPrefixedBits;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int getAdjustedPrefix(boolean nextSegment, int bitsPerSegment, boolean skipBitCountPrefix) {
        Integer prefix = this.getPrefixLength();
        int bitCount = this.getBitCount();
        if (nextSegment) {
            if (prefix == null) {
                if (this.getMinPrefix() != 0) return bitCount;
                return 0;
            }
            if (prefix == bitCount) {
                return bitCount;
            }
            int existingPrefixLength = prefix;
            int adjustment = existingPrefixLength % bitsPerSegment;
            return existingPrefixLength + bitsPerSegment - adjustment;
        }
        if (prefix == null) {
            if (this.getMinPrefix() == 0) {
                return 0;
            }
            if (!skipBitCountPrefix) return bitCount;
            prefix = bitCount;
        } else if (prefix == 0) {
            return 0;
        }
        int existingPrefixLength = prefix;
        int adjustment = (existingPrefixLength - 1) % bitsPerSegment + 1;
        return existingPrefixLength - adjustment;
    }

    protected int getAdjustedPrefix(int adjustment, boolean floor, boolean ceiling) {
        Integer prefix = this.getPrefixLength();
        if (prefix == null) {
            prefix = this.getMinPrefix() == 0 ? Integer.valueOf(0) : Integer.valueOf(this.getBitCount());
        }
        int result = prefix + adjustment;
        if (ceiling) {
            result = Math.min(this.getBitCount(), result);
        }
        if (floor) {
            result = Math.max(0, result);
        }
        return result;
    }

    protected static <R extends AddressSegmentSeries> R getSingle(R original, Supplier<R> singleFromMultipleCreator) {
        if (!original.isPrefixed() && !original.isMultiple()) {
            return original;
        }
        return (R)((AddressSegmentSeries)singleFromMultipleCreator.get());
    }

    protected static <S extends AddressSegment> S[] toPrefixedSegments(Integer sectionPrefixBits, S[] segments, int segmentBitCount, AddressNetwork.AddressSegmentCreator<S> segmentCreator, BiFunction<S, Integer, S> segProducer, boolean alwaysClone) {
        if (sectionPrefixBits != null) {
            return AddressDivisionGrouping.setPrefixedSegments((int)sectionPrefixBits, (AddressSegment[])((AddressSegment[])segments.clone()), (int)segmentBitCount, segmentCreator, segProducer);
        }
        if (alwaysClone) {
            return (AddressSegment[])segments.clone();
        }
        return segments;
    }

    private static <S extends AddressSegment> S[] setPrefixedSegments(int sectionPrefixBits, S[] segments, int segmentBitCount, AddressNetwork.AddressSegmentCreator<S> segmentCreator, BiFunction<S, Integer, S> segProducer) {
        int i = 0;
        while (i < segments.length) {
            Integer pref = AddressDivisionGrouping.getSegmentPrefixLengthNonNull(segmentBitCount, sectionPrefixBits, i);
            if (pref != null) {
                segments[i] = (AddressSegment)segProducer.apply(segments[i], pref);
                if (++i < segments.length) {
                    S allSeg = segmentCreator.createSegment(0, 0);
                    do {
                        segments[i] = allSeg;
                    } while (++i < segments.length);
                }
            }
            ++i;
        }
        return segments;
    }

    protected static <R extends AddressSection, S extends AddressSegment> S[] setPrefixed(R original, int newPrefixBits, S[] segments, int segmentBitCount, boolean noShrink, AddressNetwork.AddressSegmentCreator<S> segmentCreator, BiFunction<S, Integer, S> prefixApplier, SegFunction<S, Integer, Integer, S> prefixSetter) {
        Integer oldPrefix = original.getPrefixLength();
        if (oldPrefix == null || oldPrefix > newPrefixBits) {
            segments = AddressDivisionGrouping.toPrefixedSegments((Integer)newPrefixBits, segments, (int)segmentBitCount, segmentCreator, prefixApplier, (boolean)false);
        } else if (oldPrefix < newPrefixBits) {
            if (noShrink) {
                return segments;
            }
            segments = (AddressSegment[])segments.clone();
            int i = 0;
            while (i < segments.length) {
                Integer newPref = AddressDivisionGrouping.getSegmentPrefixLengthNonNull(segmentBitCount, newPrefixBits, i);
                Integer oldPref = AddressDivisionGrouping.getSegmentPrefixLengthNonNull(segmentBitCount, oldPrefix, i);
                segments[i] = (AddressSegment)prefixSetter.apply(segments[i], oldPref, newPref);
                if (newPref != null && ++i < segments.length) {
                    S zeroSeg = segmentCreator.createSegment(0, 0);
                    do {
                        segments[i] = zeroSeg;
                    } while (++i < segments.length);
                }
                ++i;
            }
        }
        return segments;
    }

    protected static <R extends AddressSection, S extends AddressSegment> S[] removePrefix(R original, S[] segments, int segmentBitCount, SegFunction<S, Integer, Integer, S> prefixSetter) {
        Integer oldPrefix = original.getPrefixLength();
        if (oldPrefix != null) {
            segments = (AddressSegment[])segments.clone();
            int i = 0;
            while (i < segments.length) {
                Integer oldPref = AddressDivisionGrouping.getSegmentPrefixLengthNonNull(segmentBitCount, oldPrefix, i);
                segments[i] = (AddressSegment)prefixSetter.apply(segments[i], oldPref, null);
                ++i;
            }
        }
        return segments;
    }

    protected static <T extends AddressSegment> T[] toSegments(long val, int valueByteLength, int segmentCount, int bytesPerSegment, int bitsPerSegment, int maxValuePerSegment, AddressNetwork.AddressSegmentCreator<T> creator, Integer prefixLength) {
        AddressSegment[] segments = creator.createSegmentArray(segmentCount);
        int segmentMask = ~(-1 << bitsPerSegment);
        int segmentIndex = segmentCount - 1;
        while (segmentIndex >= 0) {
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
            int value = segmentMask & (int)val;
            val >>>= bitsPerSegment;
            segments[segmentIndex] = creator.createSegment(value, segmentPrefixLength);
            --segmentIndex;
        }
        return segments;
    }

    protected static <S extends AddressSegment> S[] toSegments(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, int segmentCount, int bytesPerSegment, int bitsPerSegment, int maxValuePerSegment, AddressNetwork.AddressSegmentCreator<S> creator, Integer prefixLength) {
        AddressSegment[] segments = creator.createSegmentArray(segmentCount);
        int segmentIndex = 0;
        while (segmentIndex < segmentCount) {
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
            if (segmentPrefixLength != null && segmentPrefixLength == 0) {
                S allSeg = creator.createSegment(0, maxValuePerSegment, 0);
                do {
                    segments[segmentIndex] = allSeg;
                } while (++segmentIndex < segmentCount);
                break;
            }
            int value = 0;
            int value2 = 0;
            if (lowerValueProvider == null) {
                value = upperValueProvider.getValue(segmentIndex, bytesPerSegment);
            } else {
                value = lowerValueProvider.getValue(segmentIndex, bytesPerSegment);
                if (upperValueProvider != null) {
                    value2 = upperValueProvider.getValue(segmentIndex, bytesPerSegment);
                }
            }
            segments[segmentIndex] = lowerValueProvider != null && upperValueProvider != null ? creator.createSegment(value, value2, segmentPrefixLength) : creator.createSegment(value, segmentPrefixLength);
            ++segmentIndex;
        }
        return segments;
    }

    protected static <S extends AddressSegment> S[] toSegments(byte[] bytes, int segmentCount, int bytesPerSegment, int bitsPerSegment, int maxValuePerSegment, AddressNetwork.AddressSegmentCreator<S> creator, Integer prefixLength) {
        AddressSegment[] segments = creator.createSegmentArray(segmentCount);
        int i = 0;
        int segmentIndex = 0;
        while (i < bytes.length) {
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
            if (segmentPrefixLength != null && segmentPrefixLength == 0) {
                S allSeg = creator.createSegment(0, maxValuePerSegment, 0);
                do {
                    segments[segmentIndex] = allSeg;
                } while (++segmentIndex < segmentCount);
                break;
            }
            int value = 0;
            int k = bytesPerSegment + i;
            int j = i;
            while (j < k) {
                int byteValue = 0xFF & bytes[j];
                value <<= 8;
                value |= byteValue;
                ++j;
            }
            segments[segmentIndex] = creator.createSegment(value, segmentPrefixLength);
            i += bytesPerSegment;
            ++segmentIndex;
        }
        return segments;
    }

    protected static <R extends AddressSection, S extends AddressSegment> S[] createSingle(R original, AddressNetwork.AddressSegmentCreator<S> segmentCreator, IntFunction<S> segProducer) {
        int segmentCount = original.getSegmentCount();
        AddressSegment[] segs = segmentCreator.createSegmentArray(segmentCount);
        int i = 0;
        while (i < segmentCount) {
            segs[i] = (AddressSegment)segProducer.apply(i);
            ++i;
        }
        return segs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <R extends AddressSegmentSeries> SectionCache<R> getSectionCache(R section, Supplier<SectionCache<R>> sectionCacheGetter, Supplier<SectionCache<R>> sectionCacheCreator) {
        SectionCache<R> result = sectionCacheGetter.get();
        if (result == null) {
            R r = section;
            synchronized (r) {
                result = sectionCacheGetter.get();
                if (result == null) {
                    result = sectionCacheCreator.get();
                }
            }
        }
        return result;
    }

    protected static <T extends Address, R extends AddressSection, S extends AddressSegment> R getLowestOrHighestSection(R section, AddressCreator<?, R, ?, S> creator, boolean lowest, IntFunction<S> segProducer, Supplier<SectionCache<R>> sectionCacheSupplier) {
        return (R)AddressDivisionGrouping.getSingle(section, () -> {
            SectionCache cache = (SectionCache)sectionCacheSupplier.get();
            AddressSection result = (AddressSection)cache.get(lowest);
            if (result == null) {
                AddressSegment[] segs = AddressDivisionGrouping.createSingle((AddressSection)section, (AddressNetwork.AddressSegmentCreator)creator, (IntFunction)segProducer);
                result = creator.createSectionInternal(segs);
                cache.set(lowest, result);
            }
            return result;
        });
    }

    protected static <T extends Address, R extends AddressSection, S extends AddressSegment> T getLowestOrHighestAddress(T addr, AddressCreator<T, R, ?, S> creator, boolean lowest, Supplier<R> sectionProducer, Supplier<SectionCache<T>> sectionCacheSupplier) {
        return (T)AddressDivisionGrouping.getSingle(addr, () -> {
            SectionCache cache = (SectionCache)sectionCacheSupplier.get();
            Address result = (Address)cache.get(lowest);
            if (result == null) {
                result = creator.createAddress((AddressSection)sectionProducer.get());
                cache.set(lowest, result);
                return result;
            }
            return result;
        });
    }

    protected static <R extends AddressSection, S extends AddressSegment> R reverseSegments(R section, AddressCreator<?, R, ?, S> creator, IntFunction<S> segProducer, boolean removePrefix) {
        int count = section.getSegmentCount();
        AddressSegment[] newSegs = creator.createSegmentArray(count);
        int halfCount = count >>> 1;
        int i = 0;
        boolean isSame = !removePrefix || !section.isPrefixed();
        int j = count - 1;
        while (i < halfCount) {
            newSegs[j] = (AddressSegment)segProducer.apply(i);
            newSegs[i] = (AddressSegment)segProducer.apply(j);
            if (!(!isSame || ((Object)newSegs[i]).equals(section.getSegment(i)) && ((Object)newSegs[j]).equals(section.getSegment(j)))) {
                isSame = false;
            }
            ++i;
            --j;
        }
        if ((count & 1) == 1) {
            newSegs[i] = (AddressSegment)segProducer.apply(i);
            if (isSame && !((Object)newSegs[i]).equals(section.getSegment(i))) {
                isSame = false;
            }
        }
        if (isSame) {
            return section;
        }
        return (R)creator.createSectionInternal(newSegs);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R reverseBits(boolean perByte, R section, AddressCreator<?, R, ?, S> creator, IntFunction<S> segBitReverser, boolean removePrefix) {
        if (perByte) {
            boolean isSame = !removePrefix || !section.isPrefixed();
            int count = section.getSegmentCount();
            AddressSegment[] newSegs = creator.createSegmentArray(count);
            int i = 0;
            while (i < count) {
                newSegs[i] = (AddressSegment)segBitReverser.apply(i);
                if (isSame && !((Object)newSegs[i]).equals(section.getSegment(i))) {
                    isSame = false;
                }
                ++i;
            }
            if (isSame) {
                return section;
            }
            return (R)creator.createSectionInternal(newSegs);
        }
        return AddressDivisionGrouping.reverseSegments(section, creator, segBitReverser, removePrefix);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R reverseBytes(boolean perSegment, R section, AddressCreator<?, R, ?, S> creator, IntFunction<S> segByteReverser, boolean removePrefix) {
        if (perSegment) {
            boolean isSame = !removePrefix || !section.isPrefixed();
            int count = section.getSegmentCount();
            AddressSegment[] newSegs = creator.createSegmentArray(count);
            int i = 0;
            while (i < count) {
                newSegs[i] = (AddressSegment)segByteReverser.apply(i);
                if (isSame && !((Object)newSegs[i]).equals(section.getSegment(i))) {
                    isSame = false;
                }
                ++i;
            }
            if (isSame) {
                return section;
            }
            return (R)creator.createSectionInternal(newSegs);
        }
        return AddressDivisionGrouping.reverseSegments(section, creator, segByteReverser, removePrefix);
    }

    protected <S extends AddressDivisionBase> S[] createNewDivisions(int bitsPerDigit, GroupingCreator<S> groupingCreator, IntFunction<S[]> groupingArrayCreator) {
        return this.createNewPrefixedDivisions(bitsPerDigit, null, (value, upperValue, bitCount, radix, prefixLength) -> groupingCreator.createDivision(value, upperValue, bitCount, radix), groupingArrayCreator);
    }

    protected <S extends AddressDivisionBase> S[] createNewPrefixedDivisions(int bitsPerDigit, Integer networkPrefixLength, PrefixedGroupingCreator<S> groupingCreator, IntFunction<S[]> groupingArrayCreator) {
        if (bitsPerDigit >= 32) {
            throw new IllegalArgumentException();
        }
        int bitCount = this.getBitCount();
        ArrayList<Integer> bitDivs = new ArrayList<Integer>(bitsPerDigit);
        int largestBitCount = 63;
        largestBitCount -= largestBitCount % bitsPerDigit;
        while (true) {
            if (bitCount <= largestBitCount) {
                int mod = bitCount % bitsPerDigit;
                int secondLast = bitCount - mod;
                if (secondLast > 0) {
                    bitDivs.add(secondLast);
                }
                if (mod <= 0) break;
                bitDivs.add(mod);
                break;
            }
            bitCount -= largestBitCount;
            bitDivs.add(largestBitCount);
        }
        int bitDivSize = bitDivs.size();
        AddressDivisionBase[] divs = (AddressDivisionBase[])groupingArrayCreator.apply(bitDivSize);
        int currentSegmentIndex = 0;
        AddressDivision seg = this.getDivision(currentSegmentIndex);
        long segLowerVal = seg.getLowerValue();
        long segUpperVal = seg.getUpperValue();
        int segBits = seg.getBitCount();
        int bitsSoFar = 0;
        int radix = AddressDivisionBase.getRadixPower(BigInteger.valueOf(2L), bitsPerDigit).intValue();
        int i = bitDivSize - 1;
        while (i >= 0) {
            int divBitSize;
            int originalDivBitSize = divBitSize = ((Integer)bitDivs.get(i)).intValue();
            long divUpperValue = 0L;
            long divLowerValue = 0L;
            while (true) {
                int diff;
                if (segBits >= divBitSize) {
                    diff = segBits - divBitSize;
                    divLowerValue |= segLowerVal >>> diff;
                    int shift = ~(-1 << diff);
                    segLowerVal &= (long)shift;
                    segBits = diff;
                    Integer segPrefixBits = networkPrefixLength == null ? null : AddressDivisionGrouping.getSegmentPrefixLength(originalDivBitSize, networkPrefixLength - bitsSoFar);
                    S div = groupingCreator.createDivision(divLowerValue, divUpperValue |= (segUpperVal &= (long)shift) >>> diff, originalDivBitSize, radix, segPrefixBits);
                    divs[bitDivSize - i - 1] = div;
                    if (segBits != 0 || i <= 0) break;
                    seg = this.getDivision(++currentSegmentIndex);
                    segLowerVal = seg.getLowerValue();
                    segUpperVal = seg.getUpperValue();
                    segBits = seg.getBitCount();
                    break;
                }
                diff = divBitSize - segBits;
                divLowerValue |= segLowerVal << diff;
                divUpperValue |= segUpperVal << diff;
                divBitSize = diff;
                seg = this.getDivision(++currentSegmentIndex);
                segLowerVal = seg.getLowerValue();
                segUpperVal = seg.getUpperValue();
                segBits = seg.getBitCount();
            }
            bitsSoFar += originalDivBitSize;
            --i;
        }
        return divs;
    }

    protected static <T extends Address, R extends AddressSection, S extends AddressSegment> Iterator<R> iterator(boolean useOriginal, R original, final AddressCreator<T, R, ?, S> creator, final Iterator<S[]> iterator) {
        if (useOriginal) {
            return new Iterator<R>(original){
                R orig;
                {
                    this.orig = addressSection;
                }

                @Override
                public R next() {
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object result = this.orig;
                    this.orig = null;
                    return result;
                }

                @Override
                public boolean hasNext() {
                    return this.orig != null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<R>(){

            @Override
            public R next() {
                if (!iterator.hasNext()) {
                    throw new NoSuchElementException();
                }
                AddressSegment[] next = (AddressSegment[])iterator.next();
                return creator.createSectionInternal(next);
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected <S extends AddressSegment> Iterator<S[]> iterator(AddressNetwork.AddressSegmentCreator<S> segmentCreator, final Supplier<S[]> segSupplier, final IntFunction<Iterator<S>> segIteratorProducer) {
        if (!this.isMultiple()) {
            return new Iterator<S[]>(){
                boolean done;

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public S[] next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    this.done = true;
                    return (AddressSegment[])segSupplier.get();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<S[]>(segmentCreator){
            private boolean done;
            final int segmentCount;
            private final Iterator<S>[] variations;
            private S[] nextSet;
            {
                this.segmentCount = AddressDivisionGrouping.this.getDivisionCount();
                this.variations = new Iterator[this.segmentCount];
                this.nextSet = addressSegmentCreator.createSegmentArray(this.segmentCount);
                this.updateVariations(0);
            }

            private void updateVariations(int start) {
                int i = start;
                while (i < this.segmentCount) {
                    this.variations[i] = (Iterator)segIteratorProducer.apply(i);
                    this.nextSet[i] = (AddressSegment)this.variations[i].next();
                    ++i;
                }
            }

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            public S[] next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                AddressSegment[] segs = (AddressSegment[])this.nextSet.clone();
                this.increment();
                return segs;
            }

            private void increment() {
                int j = this.segmentCount - 1;
                while (j >= 0) {
                    if (this.variations[j].hasNext()) {
                        this.nextSet[j] = (AddressSegment)this.variations[j].next();
                        this.updateVariations(j + 1);
                        return;
                    }
                    --j;
                }
                this.done = true;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static <T extends Address, S extends AddressSegment> Iterator<T> iterator(T original, final AddressCreator<T, ?, ?, S> creator, boolean useOriginal, final Iterator<S[]> iterator) {
        if (useOriginal) {
            return new Iterator<T>(original){
                T orig;
                {
                    this.orig = address;
                }

                @Override
                public boolean hasNext() {
                    return this.orig != null;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object result = this.orig;
                    this.orig = null;
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                AddressSegment[] next = (AddressSegment[])iterator.next();
                return creator.createAddressInternal(next);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected static <R extends AddressSection, S extends AddressSegment> R getSection(int index, int endIndex, R section, AddressCreator<?, R, ?, S> creator) {
        if (index == 0 && endIndex == section.getSegmentCount()) {
            return section;
        }
        int segmentCount = endIndex - index;
        if (segmentCount < 0) {
            throw new IndexOutOfBoundsException();
        }
        AddressSegment[] segs = creator.createSegmentArray(segmentCount);
        section.getSegments(index, endIndex, segs, 0);
        return (R)creator.createSectionInternal(segs);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R append(R section, R other, AddressCreator<?, R, ?, S> creator, boolean extendPrefix) {
        int otherSegmentCount = other.getSegmentCount();
        int segmentCount = section.getSegmentCount();
        int totalSegmentCount = segmentCount + otherSegmentCount;
        AddressSegment[] segs = creator.createSegmentArray(totalSegmentCount);
        section.getSegments(0, segmentCount, segs, 0);
        if (extendPrefix && section.isPrefixed()) {
            Object allSegment = creator.createSegment(0, 0);
            int i = segmentCount;
            while (i < totalSegmentCount) {
                segs[i] = allSegment;
                ++i;
            }
        } else {
            other.getSegments(0, otherSegmentCount, segs, segmentCount);
        }
        return (R)creator.createSectionInternal(segs);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R replace(R section, R other, AddressCreator<?, R, ?, S> creator, int index, boolean extendPrefix) {
        int segmentCount;
        int otherSegmentCount = other.getSegmentCount();
        if (index + otherSegmentCount > (segmentCount = section.getSegmentCount())) {
            throw new AddressTypeException(section, other, "ipaddress.error.exceeds.size");
        }
        if (otherSegmentCount == 0) {
            return section;
        }
        AddressSegment[] segs = creator.createSegmentArray(segmentCount);
        section.getSegments(0, index, segs, 0);
        other.getSegments(0, otherSegmentCount, segs, index);
        if (segmentCount > index + otherSegmentCount) {
            if (extendPrefix && other.isPrefixed()) {
                Object allSegment = creator.createSegment(0, 0);
                int i = index + otherSegmentCount;
                while (i < segmentCount) {
                    segs[i] = allSegment;
                    ++i;
                }
            } else {
                section.getSegments(index + otherSegmentCount, segmentCount, segs, index + otherSegmentCount);
            }
        }
        return (R)creator.createSectionInternal(segs);
    }

    protected static <R extends AddressSection, S extends AddressSegment> R createSectionInternal(AddressCreator<?, R, ?, S> creator, S[] segments, int startIndex, boolean extended) {
        return (R)creator.createSectionInternal((AddressSegment[])segments, startIndex, extended);
    }

    protected static AddressDivisionWriter getCachedParams(StringOptions opts) {
        return opts.cachedParams;
    }

    protected static void setCachedParams(StringOptions opts, AddressDivisionWriter cachedParams) {
        opts.cachedParams = cachedParams;
    }

    protected boolean isDualString() {
        int count = this.getDivisionCount();
        int i = 0;
        while (i < count) {
            AddressDivision division = this.getDivision(i);
            if (division.isMultiple()) {
                boolean isLastFull = true;
                AddressDivision lastDivision = null;
                int j = count - 1;
                while (j >= 0) {
                    division = this.getDivision(j);
                    if (division.isMultiple()) {
                        if (!isLastFull) {
                            throw new AddressTypeException(division, i, lastDivision, i + 1, "ipaddress.error.segmentMismatch");
                        }
                        isLastFull = division.isFullRange();
                    } else {
                        isLastFull = false;
                    }
                    lastDivision = division;
                    --j;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static <T extends AddressStringDivisionSeries> String toNormalizedStringRange(AddressStringParams<T> params, T lower, T upper, CharSequence zone) {
        StringBuilder builder;
        int length = params.getStringLength(lower, zone) + params.getStringLength(upper, zone);
        String separator = params.getWildcards().rangeSeparator;
        if (separator != null) {
            builder = new StringBuilder(length += separator.length());
            params.append(params.append(builder, lower, zone).append(separator), upper, zone);
        } else {
            builder = new StringBuilder(length);
            params.append(params.append(builder, lower, zone), upper, zone);
        }
        AddressStringParams.checkLengths(length, builder);
        return builder.toString();
    }

    protected static class AddressStringParams<T extends AddressStringDivisionSeries>
    implements AddressDivisionWriter,
    AddressSegmentParams,
    Cloneable {
        public static final StringOptions.Wildcards DEFAULT_WILDCARDS = new StringOptions.Wildcards();
        private StringOptions.Wildcards wildcards = DEFAULT_WILDCARDS;
        protected boolean expandSegments;
        private String segmentStrPrefix;
        private int radix;
        protected Character separator;
        private boolean uppercase;
        private boolean reverse;
        private boolean splitDigits;
        private String addressLabel = "";
        private char zoneSeparator;

        public AddressStringParams(int radix, Character separator, boolean uppercase) {
            this(radix, separator, uppercase, '\u0000');
        }

        public AddressStringParams(int radix, Character separator, boolean uppercase, char zoneSeparator) {
            this.radix = radix;
            this.separator = separator;
            this.uppercase = uppercase;
            this.zoneSeparator = zoneSeparator;
        }

        public void setZoneSeparator(char zoneSeparator) {
            this.zoneSeparator = zoneSeparator;
        }

        public String getAddressLabel() {
            return this.addressLabel;
        }

        public void setAddressLabel(String str) {
            this.addressLabel = str;
        }

        public Character getSeparator() {
            return this.separator;
        }

        public void setSeparator(Character separator) {
            this.separator = separator;
        }

        @Override
        public StringOptions.Wildcards getWildcards() {
            return this.wildcards;
        }

        public void setWildcards(StringOptions.Wildcards wc) {
            this.wildcards = wc;
        }

        @Override
        public boolean preferWildcards() {
            return true;
        }

        @Override
        public int getLeadingZeros(int segmentIndex) {
            if (this.expandSegments) {
                return -1;
            }
            return 0;
        }

        @Override
        public String getSegmentStrPrefix() {
            return this.segmentStrPrefix;
        }

        public void setSegmentStrPrefix(String segmentStrPrefix) {
            this.segmentStrPrefix = segmentStrPrefix;
        }

        @Override
        public int getRadix() {
            return this.radix;
        }

        public void setRadix(int radix) {
            this.radix = radix;
        }

        public void setUppercase(boolean uppercase) {
            this.uppercase = uppercase;
        }

        @Override
        public boolean isUppercase() {
            return this.uppercase;
        }

        public void setSplitDigits(boolean split) {
            this.splitDigits = split;
        }

        @Override
        public boolean isSplitDigits() {
            return this.splitDigits;
        }

        @Override
        public Character getSplitDigitSeparator() {
            return this.separator;
        }

        @Override
        public boolean isReverseSplitDigits() {
            return this.reverse;
        }

        public void setReverse(boolean rev) {
            this.reverse = rev;
        }

        public boolean isReverse() {
            return this.reverse;
        }

        public void expandSegments(boolean expand) {
            this.expandSegments = expand;
        }

        public StringBuilder appendLabel(StringBuilder builder) {
            String str = this.getAddressLabel();
            if (str != null) {
                builder.append(str);
            }
            return builder;
        }

        public int getAddressLabelLength() {
            String str = this.getAddressLabel();
            if (str != null) {
                return str.length();
            }
            return 0;
        }

        public int getSegmentsStringLength(T part) {
            int count = 0;
            if (part.getDivisionCount() != 0) {
                int divCount = part.getDivisionCount();
                int i = 0;
                while (i < divCount) {
                    AddressStringDivision seg = part.getDivision(i);
                    count += this.appendSegment(i, seg, null);
                    ++i;
                }
                Character separator = this.getSeparator();
                if (separator != null) {
                    count += divCount - 1;
                }
            }
            return count;
        }

        public StringBuilder appendSegments(StringBuilder builder, T part) {
            if (part.getDivisionCount() != 0) {
                int count = part.getDivisionCount();
                boolean reverse = this.isReverse();
                int i = 0;
                Character separator = this.getSeparator();
                while (true) {
                    int segIndex = reverse ? count - i - 1 : i;
                    AddressStringDivision seg = part.getDivision(segIndex);
                    this.appendSegment(segIndex, seg, builder);
                    if (++i == count) break;
                    if (separator == null) continue;
                    builder.append(separator);
                }
            }
            return builder;
        }

        public int appendSingleDivision(AddressStringDivision seg, StringBuilder builder) {
            if (builder == null) {
                return this.getAddressLabelLength() + this.appendSegment(0, seg, null);
            }
            this.appendLabel(builder);
            this.appendSegment(0, seg, builder);
            return 0;
        }

        protected int appendSegment(int segIndex, AddressStringDivision seg, StringBuilder builder) {
            return seg.getConfiguredString(segIndex, this, builder);
        }

        public int getZoneLength(CharSequence zone) {
            if (zone != null && zone.length() > 0) {
                return zone.length() + 1;
            }
            return 0;
        }

        public int getStringLength(T addr, CharSequence zone) {
            int result = this.getStringLength(addr);
            if (zone != null) {
                result += this.getZoneLength(zone);
            }
            return result;
        }

        public int getStringLength(T addr) {
            return this.getAddressLabelLength() + this.getSegmentsStringLength(addr);
        }

        public StringBuilder appendZone(StringBuilder builder, CharSequence zone) {
            if (zone != null && zone.length() > 0) {
                builder.append(this.zoneSeparator).append(zone);
            }
            return builder;
        }

        public StringBuilder append(StringBuilder builder, T addr, CharSequence zone) {
            this.appendSegments(this.appendLabel(builder), addr);
            if (zone != null) {
                this.appendZone(builder, zone);
            }
            return builder;
        }

        public StringBuilder append(StringBuilder builder, T addr) {
            return this.append(builder, addr, null);
        }

        @Override
        public int getDivisionStringLength(AddressStringDivision seg) {
            return this.appendSingleDivision(seg, null);
        }

        @Override
        public StringBuilder appendDivision(StringBuilder builder, AddressStringDivision seg) {
            this.appendSingleDivision(seg, builder);
            return builder;
        }

        public String toString(T addr, CharSequence zone) {
            int length = this.getStringLength(addr, zone);
            StringBuilder builder = new StringBuilder(length);
            this.append(builder, addr, zone);
            AddressStringParams.checkLengths(length, builder);
            return builder.toString();
        }

        public String toString(T addr) {
            return this.toString(addr, null);
        }

        public static void checkLengths(int length, StringBuilder builder) {
        }

        public static AddressStringParams<AddressStringDivisionSeries> toParams(StringOptions opts) {
            AddressStringParams result = (AddressStringParams)AddressDivisionGrouping.getCachedParams(opts);
            if (result == null) {
                result = new AddressStringParams(opts.base, opts.separator, opts.uppercase);
                result.expandSegments(opts.expandSegments);
                result.setWildcards(opts.wildcards);
                result.setSegmentStrPrefix(opts.segmentStrPrefix);
                result.setAddressLabel(opts.addrLabel);
                result.setReverse(opts.reverse);
                result.setSplitDigits(opts.splitDigits);
                AddressDivisionGrouping.setCachedParams(opts, result);
            }
            return result;
        }

        public AddressStringParams<T> clone() {
            try {
                AddressStringParams parms = (AddressStringParams)super.clone();
                return parms;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    protected static interface GroupingCreator<S extends AddressDivisionBase> {
        public S createDivision(long var1, long var3, int var5, int var6);
    }

    protected static interface PrefixedGroupingCreator<S extends AddressDivisionBase> {
        public S createDivision(long var1, long var3, int var5, int var6, Integer var7);
    }

    protected static class SectionCache<R extends AddressSegmentSeries> {
        public R lower;
        public R upper;

        R get(boolean lowest) {
            return lowest ? this.lower : this.upper;
        }

        void set(boolean lowest, R newSeries) {
            if (lowest) {
                this.lower = newSeries;
            } else {
                this.upper = newSeries;
            }
        }
    }

    protected static interface SegFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }

    protected static class StringCache {
        public String canonicalString;
        public String hexString;
        public String hexStringPrefixed;

        protected StringCache() {
        }
    }

    public static class StringOptions {
        public final Wildcards wildcards;
        public final boolean expandSegments;
        public final int base;
        public final String segmentStrPrefix;
        public final Character separator;
        public final String addrLabel;
        public final boolean reverse;
        public final boolean splitDigits;
        public final boolean uppercase;
        AddressDivisionWriter cachedParams;

        protected StringOptions(int base, boolean expandSegments, Wildcards wildcards, String segmentStrPrefix, Character separator, String label, boolean reverse, boolean splitDigits, boolean uppercase) {
            this.expandSegments = expandSegments;
            this.wildcards = wildcards;
            this.base = base;
            this.segmentStrPrefix = segmentStrPrefix;
            this.separator = separator;
            this.addrLabel = label;
            this.reverse = reverse;
            this.splitDigits = splitDigits;
            this.uppercase = uppercase;
        }

        public static class Builder {
            public static final Wildcards DEFAULT_WILDCARDS = new Wildcards();
            protected Wildcards wildcards = DEFAULT_WILDCARDS;
            protected boolean expandSegments;
            protected int base;
            protected String segmentStrPrefix;
            protected Character separator;
            protected String addrLabel;
            protected boolean reverse;
            protected boolean splitDigits;
            protected boolean uppercase;

            protected Builder(int base, char separator) {
                this.base = base;
                this.separator = Character.valueOf(separator);
            }

            public Builder setWildcards(Wildcards wildcards) {
                this.wildcards = wildcards;
                return this;
            }

            public Builder setReverse(boolean reverse) {
                this.reverse = reverse;
                return this;
            }

            public Builder setUppercase(boolean uppercase) {
                this.uppercase = uppercase;
                return this;
            }

            public Builder setSplitDigits(boolean splitDigits) {
                this.splitDigits = splitDigits;
                return this;
            }

            public Builder setExpandedSegments(boolean expandSegments) {
                this.expandSegments = expandSegments;
                return this;
            }

            public Builder setRadix(int base) {
                this.base = base;
                return this;
            }

            public Builder setSeparator(Character separator) {
                this.separator = separator;
                return this;
            }

            public Builder setAddressLabel(String label) {
                this.addrLabel = label;
                return this;
            }

            public Builder setSegmentStrPrefix(String prefix) {
                this.segmentStrPrefix = prefix;
                return this;
            }

            public StringOptions toParams() {
                return new StringOptions(this.base, this.expandSegments, this.wildcards, this.segmentStrPrefix, this.separator, this.addrLabel, this.reverse, this.splitDigits, this.uppercase);
            }
        }

        public static class Wildcards {
            public final String rangeSeparator;
            public final String wildcard;
            public final String singleWildcard;

            public Wildcards() {
                this(Address.RANGE_SEPARATOR_STR, Address.SEGMENT_WILDCARD_STR, null);
            }

            public Wildcards(String wildcard, String singleWildcard) {
                this(Address.RANGE_SEPARATOR_STR, wildcard, singleWildcard);
            }

            public Wildcards(String rangeSeparator) {
                this(rangeSeparator, null, null);
            }

            public Wildcards(String rangeSeparator, String wildcard, String singleWildcard) {
                if (rangeSeparator == null) {
                    rangeSeparator = Address.RANGE_SEPARATOR_STR;
                }
                this.rangeSeparator = rangeSeparator;
                this.wildcard = wildcard;
                this.singleWildcard = singleWildcard;
            }

            public String toString() {
                return "range separator: " + this.rangeSeparator + "\nwildcard: " + this.wildcard + "\nsingle wildcard: " + this.singleWildcard;
            }
        }
    }
}

