/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressStringException;
import inet.ipaddr.format.IPAddressDivision;

public class IPAddressTypeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static String errorMessage = IPAddressTypeException.getMessage("ipaddress.address.error");

    static String getMessage(String key) {
        return IPAddressStringException.getMessage(key);
    }

    public IPAddressTypeException(IPAddress one, String key) {
        super(one + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(IPAddressSection one, String key) {
        super(one + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(String one, String key) {
        super(String.valueOf(one) + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(long lower, long upper, String key) {
        super(String.valueOf(lower) + "-" + upper + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(IPAddressSection one, int prefixLength, String key) {
        super(one + " /" + prefixLength + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(IPAddressDivision one, int prefixLength, String key) {
        super(one + " /" + prefixLength + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(IPAddressDivision one, String key) {
        super(one + " , " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(int prefixLength, IPAddress.IPVersion version, String key) {
        super((Object)((Object)version) + " /" + prefixLength + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(int prefixLength, String key) {
        super(String.valueOf(prefixLength) + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(CharSequence prefixLength, IPAddress.IPVersion version, String key, Throwable cause) {
        super((Object)((Object)version) + " /" + prefixLength + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key), cause);
    }

    public IPAddressTypeException(IPAddressSegment one, int oneIndex, IPAddressSegment two, int twoIndex, String key) {
        super(String.valueOf(oneIndex + 1) + ":" + one + ", " + (twoIndex + 1) + ":" + two + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(IPAddressSegment one, IPAddressSegment two, String key) {
        super(one + ", " + two + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }

    public IPAddressTypeException(IPAddressSection one, IPAddressSection two, String key) {
        super(one + ", " + two + ", " + errorMessage + " " + IPAddressTypeException.getMessage(key));
    }
}

