/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.okhttp;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okhttp3.Call;

public class OkHttpFuture<T>
implements Future<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final Call call;
    private T result;

    public OkHttpFuture(Call call) {
        this.call = call;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.call.cancel();
        return this.call.isCanceled();
    }

    @Override
    public boolean isCancelled() {
        return this.call.isCanceled();
    }

    @Override
    public boolean isDone() {
        return this.call.isExecuted();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.result;
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.latch.await(timeout, unit)) {
            return this.result;
        }
        throw new TimeoutException();
    }

    void finish() {
        this.latch.countDown();
    }

    void setResult(T result) {
        this.result = result;
    }
}

