/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.avro;

import com.github.sbt.avro.SchemaGenerationException;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;

public class AvscFilesParser {
    private final Supplier<Schema.Parser> parserSupplier;
    private Map<String, Schema> context;

    public AvscFilesParser() {
        this(Schema.Parser::new);
    }

    public AvscFilesParser(Supplier<Schema.Parser> supplier) {
        this.parserSupplier = supplier;
        this.context = new HashMap<String, Schema>();
    }

    public void addTypes(Iterable<Schema> iterable) {
        for (Schema schema : iterable) {
            this.context.put(schema.getFullName(), schema);
        }
    }

    public Map<File, Schema> parseFiles(Collection<File> collection) {
        HashSet<File> hashSet = new HashSet<File>(collection);
        HashMap<File, Schema> hashMap = new HashMap<File, Schema>();
        HashMap<File, AvroRuntimeException> hashMap2 = new HashMap<File, AvroRuntimeException>();
        Schema.Parser parser = this.unstashParser();
        boolean bl = true;
        while (bl && !hashSet.isEmpty()) {
            bl = false;
            hashMap2.clear();
            for (File file2 : hashSet) {
                try {
                    Schema schema = parser.parse(file2);
                    hashMap.put(file2, schema);
                    bl = true;
                    this.stashParser(parser);
                }
                catch (AvroRuntimeException avroRuntimeException) {
                    hashMap2.put(file2, avroRuntimeException);
                    parser = this.unstashParser();
                }
                catch (IOException iOException) {
                    throw new SchemaGenerationException(String.format("Error parsing schema file %s", file2), iOException);
                }
            }
            hashSet.removeAll(hashMap.keySet());
        }
        if (!hashSet.isEmpty()) {
            String string = hashSet.stream().map(file -> {
                String string = Optional.ofNullable((Exception)hashMap2.get(file)).map(Throwable::getMessage).orElse("Unknown error");
                return file.getName() + ": " + string;
            }).collect(Collectors.joining(",\n"));
            throw new SchemaGenerationException("Can not parse schema files:\n" + (String)string);
        }
        return hashMap;
    }

    private void stashParser(Schema.Parser parser) {
        this.context = parser.getTypes();
    }

    private Schema.Parser unstashParser() {
        Schema.Parser parser = this.parserSupplier.get();
        Set set = parser.getTypes().keySet();
        this.context.keySet().removeAll(set);
        parser.addTypes(this.context);
        return parser;
    }
}

