/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.avro;

import com.github.sbt.avro.AvroCompiler;
import com.github.sbt.avro.AvroVersion;
import com.github.sbt.avro.AvscFilesParser;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificData;

public class AvroCompilerBridge
implements AvroCompiler {
    private static final AvroVersion AVRO_1_9_0 = new AvroVersion(1, 9, 0);
    private static final AvroVersion AVRO_1_10_0 = new AvroVersion(1, 10, 0);
    private final AvroVersion avroVersion = AvroVersion.getRuntimeVersion();
    protected AvscFilesParser parser = new AvscFilesParser();
    protected GenericData.StringType stringType;
    protected SpecificCompiler.FieldVisibility fieldVisibility;
    protected boolean enableDecimalLogicalType;
    protected boolean createSetters;
    protected boolean optionalGetters;

    public void setStringType(String string) {
        this.stringType = GenericData.StringType.valueOf((String)string);
    }

    public void setFieldVisibility(String string) {
        this.fieldVisibility = SpecificCompiler.FieldVisibility.valueOf((String)string);
    }

    public void setEnableDecimalLogicalType(boolean bl) {
        this.enableDecimalLogicalType = bl;
    }

    public void setCreateSetters(boolean bl) {
        this.createSetters = bl;
    }

    public void setOptionalGetters(boolean bl) {
        this.optionalGetters = bl;
    }

    protected void configureCompiler(SpecificCompiler specificCompiler) {
        specificCompiler.setStringType(this.stringType);
        specificCompiler.setFieldVisibility(this.fieldVisibility);
        specificCompiler.setEnableDecimalLogicalType(this.enableDecimalLogicalType);
        specificCompiler.setCreateSetters(this.createSetters);
        if (this.avroVersion.compareTo(AVRO_1_9_0) >= 0) {
            specificCompiler.setGettersReturnOptional(this.optionalGetters);
        }
        if (this.avroVersion.compareTo(AVRO_1_10_0) >= 0) {
            specificCompiler.setOptionalGettersForNullableFieldsOnly(this.optionalGetters);
        }
    }

    public void recompile(Class<?>[] classArray, File file) throws Exception {
        ArrayList<Schema> arrayList = new ArrayList<Schema>(classArray.length);
        for (Class<?> clazz : classArray) {
            System.out.println("Recompiling Avro record: " + clazz.getName());
            Schema schema = SpecificData.get().getSchema(clazz);
            arrayList.add(schema);
            SpecificCompiler specificCompiler = new SpecificCompiler(schema);
            this.configureCompiler(specificCompiler);
            specificCompiler.compileToDestination(null, file);
        }
        this.parser.addTypes(arrayList);
    }

    public void compileIdls(File[] fileArray, File file) throws Exception {
        for (File file2 : fileArray) {
            System.out.println("Compiling Avro IDL: " + file2);
            Idl idl = new Idl(file2);
            Protocol protocol = idl.CompilationUnit();
            SpecificCompiler specificCompiler = new SpecificCompiler(protocol);
            this.configureCompiler(specificCompiler);
            specificCompiler.compileToDestination(file2, file);
        }
    }

    public void compileAvscs(File[] fileArray, File file) throws Exception {
        Map<File, Schema> map = this.parser.parseFiles(Arrays.asList(fileArray));
        for (Map.Entry<File, Schema> entry : map.entrySet()) {
            File file2 = entry.getKey();
            Schema schema = entry.getValue();
            System.out.println("Compiling Avro schema: " + file2 + ":" + schema.getFullName());
            SpecificCompiler specificCompiler = new SpecificCompiler(schema);
            this.configureCompiler(specificCompiler);
            specificCompiler.compileToDestination(file2, file);
        }
    }

    public void compileAvprs(File[] fileArray, File file) throws Exception {
        for (File file2 : fileArray) {
            System.out.println("Compiling Avro protocol: " + file2);
            Protocol protocol = Protocol.parse((File)file2);
            SpecificCompiler specificCompiler = new SpecificCompiler(protocol);
            this.configureCompiler(specificCompiler);
            specificCompiler.compileToDestination(file2, file);
        }
    }
}

