/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io.bundle;

import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.io.bundle.BundleResource;
import htsjdk.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.List;

public final class BundleBuilder {
    private final List<BundleResource> resources = new ArrayList<BundleResource>();
    private String primaryResource;

    public BundleBuilder addPrimary(BundleResource resource) {
        ValidationUtils.nonNull(resource, "resource");
        if (this.primaryResource != null) {
            throw new IllegalStateException(String.format("Can't add primary resource %s to a bundle that already has primary resource %s", resource.getContentType(), this.primaryResource));
        }
        this.primaryResource = resource.getContentType();
        this.addSecondary(resource);
        return this;
    }

    public BundleBuilder addSecondary(BundleResource resource) {
        ValidationUtils.nonNull(resource, "resource");
        this.resources.add(resource);
        return this;
    }

    public Bundle build() {
        if (this.primaryResource == null) {
            throw new IllegalStateException("A bundle must have a primary resource.");
        }
        Bundle bundle = new Bundle(this.primaryResource, this.resources);
        this.primaryResource = null;
        this.resources.clear();
        return bundle;
    }
}

