/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation.type;

import android.animation.IntEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.view.animation.AccelerateDecelerateInterpolator;
import androidx.annotation.NonNull;
import com.rd.animation.controller.ValueController;
import com.rd.animation.data.type.SlideAnimationValue;
import com.rd.animation.type.BaseAnimation;

public class SlideAnimation
extends BaseAnimation<ValueAnimator> {
    private static final String ANIMATION_COORDINATE = "ANIMATION_COORDINATE";
    private static final int COORDINATE_NONE = -1;
    private SlideAnimationValue value = new SlideAnimationValue();
    private int coordinateStart = -1;
    private int coordinateEnd = -1;

    public SlideAnimation(@NonNull ValueController.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public ValueAnimator createAnimator() {
        ValueAnimator animator = new ValueAnimator();
        animator.setDuration(350L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                SlideAnimation.this.onAnimateUpdated(animation);
            }
        });
        return animator;
    }

    @Override
    public SlideAnimation progress(float progress) {
        if (this.animator != null) {
            long playTime = (long)(progress * (float)this.animationDuration);
            if (((ValueAnimator)this.animator).getValues() != null && ((ValueAnimator)this.animator).getValues().length > 0) {
                ((ValueAnimator)this.animator).setCurrentPlayTime(playTime);
            }
        }
        return this;
    }

    @NonNull
    public SlideAnimation with(int coordinateStart, int coordinateEnd) {
        if (this.animator != null && this.hasChanges(coordinateStart, coordinateEnd)) {
            this.coordinateStart = coordinateStart;
            this.coordinateEnd = coordinateEnd;
            PropertyValuesHolder holder = this.createSlidePropertyHolder();
            ((ValueAnimator)this.animator).setValues(new PropertyValuesHolder[]{holder});
        }
        return this;
    }

    private PropertyValuesHolder createSlidePropertyHolder() {
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)ANIMATION_COORDINATE, (int[])new int[]{this.coordinateStart, this.coordinateEnd});
        holder.setEvaluator((TypeEvaluator)new IntEvaluator());
        return holder;
    }

    private void onAnimateUpdated(@NonNull ValueAnimator animation) {
        int coordinate = (Integer)animation.getAnimatedValue(ANIMATION_COORDINATE);
        this.value.setCoordinate(coordinate);
        if (this.listener != null) {
            this.listener.onValueUpdated(this.value);
        }
    }

    private boolean hasChanges(int coordinateStart, int coordinateEnd) {
        if (this.coordinateStart != coordinateStart) {
            return true;
        }
        return this.coordinateEnd != coordinateEnd;
    }
}

