/*
 * Decompiled with CFR 0.152.
 */
package com.rd.animation.type;

import android.animation.ArgbEvaluator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.view.animation.AccelerateDecelerateInterpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.rd.animation.controller.ValueController;
import com.rd.animation.data.type.ColorAnimationValue;
import com.rd.animation.type.BaseAnimation;

public class ColorAnimation
extends BaseAnimation<ValueAnimator> {
    public static final String DEFAULT_UNSELECTED_COLOR = "#33ffffff";
    public static final String DEFAULT_SELECTED_COLOR = "#ffffff";
    static final String ANIMATION_COLOR_REVERSE = "ANIMATION_COLOR_REVERSE";
    static final String ANIMATION_COLOR = "ANIMATION_COLOR";
    private ColorAnimationValue value = new ColorAnimationValue();
    int colorStart;
    int colorEnd;

    public ColorAnimation(@Nullable ValueController.UpdateListener listener) {
        super(listener);
    }

    @Override
    @NonNull
    public ValueAnimator createAnimator() {
        ValueAnimator animator = new ValueAnimator();
        animator.setDuration(350L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                ColorAnimation.this.onAnimateUpdated(animation);
            }
        });
        return animator;
    }

    @Override
    public ColorAnimation progress(float progress) {
        if (this.animator != null) {
            long playTime = (long)(progress * (float)this.animationDuration);
            if (((ValueAnimator)this.animator).getValues() != null && ((ValueAnimator)this.animator).getValues().length > 0) {
                ((ValueAnimator)this.animator).setCurrentPlayTime(playTime);
            }
        }
        return this;
    }

    @NonNull
    public ColorAnimation with(int colorStart, int colorEnd) {
        if (this.animator != null && this.hasChanges(colorStart, colorEnd)) {
            this.colorStart = colorStart;
            this.colorEnd = colorEnd;
            PropertyValuesHolder colorHolder = this.createColorPropertyHolder(false);
            PropertyValuesHolder reverseColorHolder = this.createColorPropertyHolder(true);
            ((ValueAnimator)this.animator).setValues(new PropertyValuesHolder[]{colorHolder, reverseColorHolder});
        }
        return this;
    }

    PropertyValuesHolder createColorPropertyHolder(boolean isReverse) {
        int colorEnd;
        int colorStart;
        String propertyName;
        if (isReverse) {
            propertyName = ANIMATION_COLOR_REVERSE;
            colorStart = this.colorEnd;
            colorEnd = this.colorStart;
        } else {
            propertyName = ANIMATION_COLOR;
            colorStart = this.colorStart;
            colorEnd = this.colorEnd;
        }
        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)propertyName, (int[])new int[]{colorStart, colorEnd});
        holder.setEvaluator((TypeEvaluator)new ArgbEvaluator());
        return holder;
    }

    private boolean hasChanges(int colorStart, int colorEnd) {
        if (this.colorStart != colorStart) {
            return true;
        }
        return this.colorEnd != colorEnd;
    }

    private void onAnimateUpdated(@NonNull ValueAnimator animation) {
        int color = (Integer)animation.getAnimatedValue(ANIMATION_COLOR);
        int colorReverse = (Integer)animation.getAnimatedValue(ANIMATION_COLOR_REVERSE);
        this.value.setColor(color);
        this.value.setColorReverse(colorReverse);
        if (this.listener != null) {
            this.listener.onValueUpdated(this.value);
        }
    }
}

