/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.target;

import be.ugent.rml.store.Quad;
import be.ugent.rml.target.HttpMethod;
import be.ugent.rml.target.HttpRequestTargetHelper;
import be.ugent.rml.target.Target;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpRequestTarget
implements Target {
    protected final Map<String, String> httpRequestInfo;
    protected final Map<String, String> httpRequestHeaders;
    private final List<Quad> metadata;
    private final ByteArrayOutputStream byteArrayOutputStream;
    protected final Logger logger;
    private final String serializationFormat;
    protected HttpRequestTargetHelper httpRequestTargetHelper;
    private static final Map<String, String> serializationFormats = Map.of("ntriples", "application/n-triples", "turtle", "text/turtle", "jsonld", "application/ld+json", "trix", "text/xml", "trig", "application/trig", "nquads", "application/n-quads");

    public HttpRequestTarget(Map<String, String> httpRequestInfo, Map<String, String> httpRequestHeaders, String serializationFormat, List<Quad> metadata, HttpRequestTargetHelper httpRequestTargetHelper) {
        this.httpRequestInfo = httpRequestInfo;
        this.httpRequestHeaders = httpRequestHeaders;
        this.metadata = metadata;
        this.serializationFormat = serializationFormat;
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.logger = LoggerFactory.getLogger(HttpRequestTarget.class);
        this.httpRequestTargetHelper = httpRequestTargetHelper;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.byteArrayOutputStream;
    }

    @Override
    public String getSerializationFormat() {
        return this.serializationFormat;
    }

    public Map<String, String> getHttpRequestInfo() {
        return this.httpRequestInfo;
    }

    @Override
    public void close() {
        this.logger.debug("Closing target");
        this.httpRequestInfo.put("data", this.byteArrayOutputStream.toString(StandardCharsets.UTF_8));
        this.byteArrayOutputStream.reset();
        if (!this.httpRequestInfo.containsKey("methodName")) {
            this.httpRequestInfo.put("methodName", HttpMethod.PUT.name());
        }
        if (!this.httpRequestHeaders.containsKey("content-type")) {
            this.httpRequestHeaders.put("content-type", serializationFormats.get(this.serializationFormat));
        }
    }

    @Override
    public List<Quad> getMetadata() {
        return this.metadata;
    }
}

