/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.extractor;

import be.ugent.idlab.knows.dataio.record.Record;
import be.ugent.idlab.knows.dataio.record.RecordValue;
import be.ugent.rml.extractor.Extractor;
import be.ugent.rml.functions.SingleRecordFunctionExecutor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReferenceExtractor
implements Extractor,
SingleRecordFunctionExecutor {
    public String reference;
    private final boolean ignoreDoubleQuotes;
    private final boolean strictReferenceResolution;

    public ReferenceExtractor(String reference, boolean ignoreDoubleQuotes, boolean strictReferenceResolution) {
        this.reference = reference;
        this.ignoreDoubleQuotes = ignoreDoubleQuotes;
        this.strictReferenceResolution = strictReferenceResolution;
    }

    @Override
    public List<Object> extract(Record record) {
        RecordValue recordValue;
        String temp = this.reference;
        if (this.ignoreDoubleQuotes && temp.startsWith("\"") && temp.endsWith("\"")) {
            temp = temp.substring(1, temp.length() - 1);
        }
        if ((recordValue = record.get(temp)).isOk()) {
            Object value = recordValue.getValue();
            if (value instanceof Iterable) {
                return new ArrayList<Object>((Collection)value);
            }
            return List.of(value);
        }
        if (recordValue.isEmpty() || recordValue.isNotFound() && !this.strictReferenceResolution) {
            return List.of();
        }
        throw new IllegalArgumentException(recordValue.getMessage());
    }

    public String toString() {
        return "ReferenceExecutor that works with " + this.reference;
    }

    @Override
    public Object execute(Record record) throws IOException {
        return this.extract(record);
    }

    public String getReference() {
        return this.reference;
    }
}

