/*
 * Decompiled with CFR 0.152.
 */
package be.ugent.rml.access;

import be.ugent.idlab.knows.dataio.access.Access;
import be.ugent.idlab.knows.dataio.access.DatabaseType;
import be.ugent.idlab.knows.dataio.access.LocalFileAccess;
import be.ugent.idlab.knows.dataio.access.RDBAccess;
import be.ugent.idlab.knows.dataio.access.RemoteFileAccess;
import be.ugent.idlab.knows.dataio.access.SPARQLEndpointAccess;
import be.ugent.idlab.knows.dataio.access.WoTAccess;
import be.ugent.rml.Utils;
import be.ugent.rml.records.ReferenceFormulation;
import be.ugent.rml.records.SPARQLResultFormat;
import be.ugent.rml.store.Quad;
import be.ugent.rml.store.QuadStore;
import be.ugent.rml.term.Literal;
import be.ugent.rml.term.NamedNode;
import be.ugent.rml.term.Term;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessFactory {
    private final String basePath;
    private final String mappingPath;
    final Logger logger = LoggerFactory.getLogger((String)"ROOT");
    private static final Map<String, String> REF_FORM_MIMETYPE = Map.of("http://w3id.org/rml/CSV", "text/csv");

    public AccessFactory(String basePath, String mappingPath) {
        this.basePath = basePath;
        this.mappingPath = mappingPath;
    }

    public Access getAccess(Term logicalSource, QuadStore rmlStore) {
        List<Term> sources = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/source"), null));
        if (!sources.isEmpty()) {
            LocalFileAccess access;
            Term source = sources.get(0);
            Term term = sources.get(0);
            if (term instanceof Literal) {
                Literal literal = (Literal)term;
                String value = literal.getValue();
                if (Utils.isRemoteFile(value)) {
                    Term refForm = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/referenceFormulation"), null)).get(0);
                    String mimeType = REF_FORM_MIMETYPE.get(refForm.toString());
                    access = new RemoteFileAccess(value, mimeType);
                } else {
                    access = new LocalFileAccess(value, this.basePath);
                }
            } else {
                List<Term> sourceType = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), null));
                sourceType.remove(new NamedNode("http://w3id.org/rml/Source"));
                switch (sourceType.get(0).getValue()) {
                    case "http://w3id.org/rml/RelativePathSource": 
                    case "http://w3id.org/rml/FilePath": {
                        String path = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://w3id.org/rml/path"), null)).get(0).getValue();
                        List<Quad> rootNodes = rmlStore.getQuads(source, new NamedNode("http://w3id.org/rml/root"), null);
                        if (rootNodes.isEmpty()) {
                            access = new LocalFileAccess(path, null);
                            break;
                        }
                        String root = Utils.getObjectsFromQuads(rootNodes).get(0).getValue();
                        if (root.equals("http://w3id.org/rml/MappingDirectory")) {
                            access = new LocalFileAccess(path, this.mappingPath);
                            break;
                        }
                        access = new LocalFileAccess(path, this.basePath);
                        break;
                    }
                    case "http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#Database": {
                        access = this.getRDBAccess(rmlStore, source, logicalSource);
                        break;
                    }
                    case "http://www.w3.org/ns/sparql-service-description#Service": {
                        List<Term> endpoint = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://www.w3.org/ns/sparql-service-description#endpoint"), null));
                        if (endpoint.isEmpty()) {
                            throw new Error("No SPARQL endpoint found.");
                        }
                        List<Term> query = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/iterator"), null));
                        if (query.isEmpty()) {
                            throw new Error("No SPARQL query found");
                        }
                        List<Term> referenceFormulations = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/referenceFormulation"), null));
                        List<Term> resultFormatObject = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://www.w3.org/ns/sparql-service-description#resultFormat"), null));
                        SPARQLResultFormat resultFormat = this.getSPARQLResultFormat(resultFormatObject, referenceFormulations);
                        access = new SPARQLEndpointAccess(resultFormat.getContentType(), endpoint.get(0).getValue(), query.get(0).getValue());
                        break;
                    }
                    case "http://www.w3.org/ns/csvw#Table": {
                        List<Term> urls = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://www.w3.org/ns/csvw#url"), null));
                        if (urls.isEmpty()) {
                            throw new Error("No url found for the CSVW Table");
                        }
                        String value = urls.get(0).getValue();
                        if (Utils.isRemoteFile(value)) {
                            access = new RemoteFileAccess(value, "text/csvw");
                            break;
                        }
                        access = new LocalFileAccess(value, this.basePath, "text/csvw");
                        break;
                    }
                    case "https://www.w3.org/2019/wot/td#Thing": {
                        HashMap auth2 = new HashMap();
                        auth2.put("data", new HashMap());
                        auth2.put("info", new HashMap());
                        try {
                            Term propertyAffordance = rmlStore.getQuad(source, new NamedNode("https://www.w3.org/2019/wot/td#hasPropertyAffordance"), null).getObject();
                            List<Term> form = Utils.getObjectsFromQuads(rmlStore.getQuads(propertyAffordance, new NamedNode("https://www.w3.org/2019/wot/td#hasForm"), null));
                            List<Term> targets = Utils.getObjectsFromQuads(rmlStore.getQuads(form.get(0), new NamedNode("https://www.w3.org/2019/wot/hypermedia#hasTarget"), null));
                            List<Term> contentTypes = Utils.getObjectsFromQuads(rmlStore.getQuads(form.get(0), new NamedNode("https://www.w3.org/2019/wot/hypermedia#forContentType"), null));
                            String target = targets.get(0).getValue();
                            String contentType = contentTypes.isEmpty() ? null : contentTypes.get(0).getValue();
                            access = new WoTAccess(target, contentType, new HashMap(), auth2);
                        }
                        catch (Exception e) {
                            this.logger.error("Cannot create WoT TD:Thing access");
                            access = null;
                        }
                        break;
                    }
                    case "https://www.w3.org/2019/wot/td#PropertyAffordance": {
                        HashMap<String, String> headers = new HashMap<String, String>();
                        HashMap auth = new HashMap();
                        auth.put("data", new HashMap());
                        auth.put("info", new HashMap());
                        List<Term> form = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("https://www.w3.org/2019/wot/td#hasForm"), null));
                        List<Term> targets = Utils.getObjectsFromQuads(rmlStore.getQuads(form.get(0), new NamedNode("https://www.w3.org/2019/wot/hypermedia#hasTarget"), null));
                        List<Term> contentTypes = Utils.getObjectsFromQuads(rmlStore.getQuads(form.get(0), new NamedNode("https://www.w3.org/2019/wot/hypermedia#forContentType"), null));
                        List<Term> headerList = Utils.getObjectsFromQuads(rmlStore.getQuads(form.get(0), new NamedNode("http://www.w3.org/2011/http#headers"), null));
                        try {
                            Term thing = Utils.getSubjectsFromQuads(rmlStore.getQuads(null, new NamedNode("https://www.w3.org/2019/wot/td#hasPropertyAffordance"), source)).get(0);
                            List<Term> securityConfiguration = Utils.getObjectsFromQuads(rmlStore.getQuads(thing, new NamedNode("https://www.w3.org/2019/wot/td#hasSecurityConfiguration"), null));
                            this.logger.debug("Security config: {}", (Object)Arrays.toString(securityConfiguration.toArray()));
                            for (Term sc : securityConfiguration) {
                                boolean isOAuth = !Utils.getObjectsFromQuads(rmlStore.getQuads(sc, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("https://www.w3.org/2019/wot/security#OAuth2SecurityScheme"))).isEmpty();
                                boolean isBearer = !Utils.getObjectsFromQuads(rmlStore.getQuads(sc, new NamedNode("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), new NamedNode("https://www.w3.org/2019/wot/security#BearerSecurityScheme"))).isEmpty();
                                List<Term> securityIn = Utils.getObjectsFromQuads(rmlStore.getQuads(sc, new NamedNode("https://www.w3.org/2019/wot/security#in"), null));
                                List<Term> securityName = Utils.getObjectsFromQuads(rmlStore.getQuads(sc, new NamedNode("https://www.w3.org/2019/wot/security#name"), null));
                                List<Term> securityValue = Utils.getObjectsFromQuads(rmlStore.getQuads(sc, new NamedNode("https://w3id.org/idsa/core/tokenValue"), null));
                                if (isOAuth || isBearer) {
                                    if (isOAuth) {
                                        this.logger.debug("OAuth2 is used");
                                        Term securityAuth = Utils.getObjectsFromQuads(rmlStore.getQuads(sc, new NamedNode("https://www.w3.org/2019/wot/security#authorization"), null)).get(0);
                                        ((Map)auth.get("info")).put("authorization", securityAuth.getValue());
                                        ((Map)auth.get("info")).put("name", securityName.get(0).getValue());
                                        Term securityRefresh = Utils.getObjectsFromQuads(rmlStore.getQuads(sc, new NamedNode("https://w3id.org/idsa/core/refreshValue"), null)).get(0);
                                        Term securityClientID = Utils.getObjectsFromQuads(rmlStore.getQuads(sc, new NamedNode("https://w3id.org/idsa/core/clientID"), null)).get(0);
                                        Term securityClientSecret = Utils.getObjectsFromQuads(rmlStore.getQuads(sc, new NamedNode("https://w3id.org/idsa/core/clientSecret"), null)).get(0);
                                        ((Map)auth.get("data")).put("refresh", securityRefresh.getValue());
                                        ((Map)auth.get("data")).put("client_id", securityClientID.getValue());
                                        ((Map)auth.get("data")).put("client_secret", securityClientSecret.getValue());
                                        this.logger.debug("Refresh token: {}", (Object)securityRefresh.getValue());
                                        this.logger.debug("Client ID: {}", (Object)securityClientID.getValue());
                                        this.logger.debug("Client Secret: {}", (Object)securityClientSecret.getValue());
                                    }
                                    Literal bearerToken = new Literal("Bearer " + securityValue.get(0).getValue());
                                    securityValue.set(0, bearerToken);
                                }
                                try {
                                    if (securityIn.get(0).getValue().equals("header")) {
                                        this.logger.info("Applying security configuration of {} in header", (Object)sc.getValue());
                                        this.logger.debug("Name: {}", (Object)securityName.get(0).getValue());
                                        this.logger.debug("Value: {}", (Object)securityValue.get(0).getValue());
                                        headers.put(securityName.get(0).getValue(), securityValue.get(0).getValue());
                                        continue;
                                    }
                                    throw new NotImplementedException();
                                }
                                catch (IndexOutOfBoundsException e) {
                                    this.logger.warn("Unable to apply security configuration for {}", (Object)sc.getValue());
                                }
                            }
                        }
                        catch (IndexOutOfBoundsException e) {
                            this.logger.warn("No td:Thing description, unable to determine security configurations, assuming no security policies apply");
                        }
                        if (targets.isEmpty()) {
                            throw new Error("No target found for TD Thing");
                        }
                        String target = targets.get(0).getValue();
                        String contentType = contentTypes.isEmpty() ? null : contentTypes.get(0).getValue();
                        for (Term headerListItem : headerList) {
                            try {
                                List<Term> header = Utils.getList(rmlStore, headerListItem);
                                for (Term h : header) {
                                    String headerName = Utils.getObjectsFromQuads(rmlStore.getQuads(h, new NamedNode("http://www.w3.org/2011/http#fieldName"), null)).get(0).getValue();
                                    String headerValue = Utils.getObjectsFromQuads(rmlStore.getQuads(h, new NamedNode("http://www.w3.org/2011/http#fieldValue"), null)).get(0).getValue();
                                    this.logger.debug("Retrieved HTTP header: '{}','{}'", (Object)headerName, (Object)headerValue);
                                    headers.put(headerName, headerValue);
                                }
                            }
                            catch (IndexOutOfBoundsException e) {
                                this.logger.warn("Unable to retrieve header name and value for {}", (Object)headerListItem.getValue());
                            }
                        }
                        access = new WoTAccess(target, contentType, headers, auth);
                        break;
                    }
                    case "http://www.w3.org/ns/dcat#Distribution": {
                        List<Term> dcatUrls = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://www.w3.org/ns/dcat#downloadURL"), null));
                        if (dcatUrls.isEmpty()) {
                            throw new Error("No url found for the DCAT Distribution");
                        }
                        String dcatValue = dcatUrls.get(0).getValue();
                        if (Utils.isRemoteFile(dcatValue)) {
                            List<Term> refFormulationTerms = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/referenceFormulation"), null));
                            String mimetype = REF_FORM_MIMETYPE.get(refFormulationTerms.get(0).getValue());
                            if (mimetype != null) {
                                access = new RemoteFileAccess(dcatValue, mimetype);
                                break;
                            }
                            access = new RemoteFileAccess(dcatValue);
                            break;
                        }
                        this.logger.debug("Local file found `{}`, trying in basePath '{}' and mapping path '{}'", new Object[]{dcatValue, this.basePath, this.mappingPath});
                        File f1 = new File(this.basePath, dcatValue);
                        File f2 = new File(this.mappingPath, dcatValue);
                        File f3 = new File(dcatValue);
                        if (f1.exists() || f3.exists()) {
                            access = new LocalFileAccess(dcatValue, this.basePath);
                            break;
                        }
                        if (f2.exists()) {
                            access = new LocalFileAccess(dcatValue, this.mappingPath);
                            break;
                        }
                        throw new Error("Cannot find " + dcatValue);
                    }
                    default: {
                        throw new NotImplementedException(sourceType.get(0).getValue());
                    }
                }
            }
            return access;
        }
        throw new Error("The Logical Source does not have a source.");
    }

    private RDBAccess getRDBAccess(QuadStore rmlStore, Term source, Term logicalSource) {
        List<Term> contentType;
        List<Term> driverObject = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#jdbcDriver"), null));
        if (driverObject.isEmpty()) {
            throw new Error("The database source object " + source + " does not include a driver.");
        }
        DatabaseType database = DatabaseType.getDBtype((String)driverObject.get(0).getValue());
        List<Term> dsnObject = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#jdbcDSN"), null));
        if (dsnObject.isEmpty()) {
            throw new Error("The database source object " + source + " does not include a Data Source Name.");
        }
        String dsn = dsnObject.get(0).getValue();
        String referenceFormulation = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/referenceFormulation"), null)).get(0).getValue();
        String iterator = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://w3id.org/rml/iterator"), null)).get(0).getValue();
        String query = referenceFormulation.equals(ReferenceFormulation.RDBTable) ? String.format("SELECT * FROM %s", iterator) : iterator;
        List<Term> usernameObject = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#username"), null));
        if (usernameObject.isEmpty()) {
            throw new Error("The database source object " + source + " does not include a username.");
        }
        String username = usernameObject.get(0).getValue();
        String password = "";
        List<Term> passwordObject = Utils.getObjectsFromQuads(rmlStore.getQuads(source, new NamedNode("http://www.wiwiss.fu-berlin.de/suhl/bizer/D2RQ/0.1#password"), null));
        if (!passwordObject.isEmpty()) {
            password = passwordObject.get(0).getValue();
        }
        return new RDBAccess(dsn, database, username, password, query, (contentType = Utils.getObjectsFromQuads(rmlStore.getQuads(logicalSource, new NamedNode("http://semweb.mmlab.be/ns/rml#referenceFormulation"), null))).isEmpty() ? "text/csv" : contentType.get(0).getValue());
    }

    private SPARQLResultFormat getSPARQLResultFormat(List<Term> resultFormats, List<Term> referenceFormulations) {
        this.logger.debug("Getting SPARQL result format for result format '{}' and reference formulations '{}'", (Object)resultFormats.toString(), (Object)referenceFormulations.toString());
        if (resultFormats.isEmpty() && referenceFormulations.isEmpty()) {
            throw new Error("Please specify the sd:resultFormat of the SPARQL endpoint or a rml:referenceFormulation.");
        }
        if (referenceFormulations.isEmpty()) {
            for (SPARQLResultFormat format : SPARQLResultFormat.values()) {
                if (!resultFormats.get(0).getValue().equals(format.getUri())) continue;
                return format;
            }
            throw new Error("Unsupported sd:resultFormat: " + resultFormats.get(0));
        }
        if (resultFormats.isEmpty()) {
            for (SPARQLResultFormat format : SPARQLResultFormat.values()) {
                if (!format.getReferenceFormulations().contains(referenceFormulations.get(0).getValue())) continue;
                return format;
            }
            throw new Error("Unsupported rml:referenceFormulation for a SPARQL source.");
        }
        for (SPARQLResultFormat format : SPARQLResultFormat.values()) {
            this.logger.debug(format + "   " + resultFormats.get(0).getValue().equals(format.getUri()) + "   " + format.getReferenceFormulations().contains(referenceFormulations.get(0).getValue()));
            this.logger.debug(format.getReferenceFormulations().toString());
            if (!resultFormats.get(0).getValue().equals(format.getUri())) continue;
            return format;
        }
        throw new Error("Format specified in sd:resultFormat doesn't match the format specified in rml:referenceFormulation.");
    }
}

