/*
 * Decompiled with CFR 0.152.
 */
package com.pff;

import com.pff.DescriptorIndexNode;
import com.pff.PSTActivity;
import com.pff.PSTAppointment;
import com.pff.PSTContact;
import com.pff.PSTDescriptorItem;
import com.pff.PSTDistList;
import com.pff.PSTException;
import com.pff.PSTFile;
import com.pff.PSTFolder;
import com.pff.PSTMessage;
import com.pff.PSTNodeInputStream;
import com.pff.PSTRss;
import com.pff.PSTTableBC;
import com.pff.PSTTableBCItem;
import com.pff.PSTTask;
import com.pff.PSTTimeZone;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Set;

public class PSTObject {
    public static final int NID_TYPE_HID = 0;
    public static final int NID_TYPE_INTERNAL = 1;
    public static final int NID_TYPE_NORMAL_FOLDER = 2;
    public static final int NID_TYPE_SEARCH_FOLDER = 3;
    public static final int NID_TYPE_NORMAL_MESSAGE = 4;
    public static final int NID_TYPE_ATTACHMENT = 5;
    public static final int NID_TYPE_SEARCH_UPDATE_QUEUE = 6;
    public static final int NID_TYPE_SEARCH_CRITERIA_OBJECT = 7;
    public static final int NID_TYPE_ASSOC_MESSAGE = 8;
    public static final int NID_TYPE_CONTENTS_TABLE_INDEX = 10;
    public static final int NID_TYPE_RECEIVE_FOLDER_TABLE = 11;
    public static final int NID_TYPE_OUTGOING_QUEUE_TABLE = 12;
    public static final int NID_TYPE_HIERARCHY_TABLE = 13;
    public static final int NID_TYPE_CONTENTS_TABLE = 14;
    public static final int NID_TYPE_ASSOC_CONTENTS_TABLE = 15;
    public static final int NID_TYPE_SEARCH_CONTENTS_TABLE = 16;
    public static final int NID_TYPE_ATTACHMENT_TABLE = 17;
    public static final int NID_TYPE_RECIPIENT_TABLE = 18;
    public static final int NID_TYPE_SEARCH_TABLE_INDEX = 19;
    public static final int NID_TYPE_LTP = 31;
    protected PSTFile pstFile;
    protected byte[] data;
    protected DescriptorIndexNode descriptorIndexNode;
    protected HashMap<Integer, PSTTableBCItem> items;
    protected HashMap<Integer, PSTDescriptorItem> localDescriptorItems = null;
    protected LinkedHashMap<String, HashMap<DescriptorIndexNode, PSTObject>> children;
    protected PSTTableBC table;
    static int[] compEnc = new int[]{71, 241, 180, 230, 11, 106, 114, 72, 133, 78, 158, 235, 226, 248, 148, 83, 224, 187, 160, 2, 232, 90, 9, 171, 219, 227, 186, 198, 124, 195, 16, 221, 57, 5, 150, 48, 245, 55, 96, 130, 140, 201, 19, 74, 107, 29, 243, 251, 143, 38, 151, 202, 145, 23, 1, 196, 50, 45, 110, 49, 149, 255, 217, 35, 209, 0, 94, 121, 220, 68, 59, 26, 40, 197, 97, 87, 32, 144, 61, 131, 185, 67, 190, 103, 210, 70, 66, 118, 192, 109, 91, 126, 178, 15, 22, 41, 60, 169, 3, 84, 13, 218, 93, 223, 246, 183, 199, 98, 205, 141, 6, 211, 105, 92, 134, 214, 20, 247, 165, 102, 117, 172, 177, 233, 69, 33, 112, 12, 135, 159, 116, 164, 34, 76, 111, 191, 31, 86, 170, 46, 179, 120, 51, 80, 176, 163, 146, 188, 207, 25, 28, 167, 99, 203, 30, 77, 62, 75, 27, 155, 79, 231, 240, 238, 173, 58, 181, 89, 4, 234, 64, 85, 37, 81, 229, 122, 137, 56, 104, 82, 123, 252, 39, 174, 215, 189, 250, 7, 244, 204, 142, 95, 239, 53, 156, 132, 43, 21, 213, 119, 52, 73, 182, 18, 10, 127, 113, 136, 253, 157, 24, 65, 125, 147, 216, 88, 44, 206, 254, 36, 175, 222, 184, 54, 200, 161, 128, 166, 153, 152, 168, 47, 14, 129, 101, 115, 228, 194, 162, 138, 212, 225, 17, 208, 8, 139, 42, 242, 237, 154, 100, 63, 193, 108, 249, 236};
    private static final long EPOCH_DIFF = 11644473600000L;

    public String getItemsString() {
        return this.items.toString();
    }

    protected PSTObject(PSTFile theFile, DescriptorIndexNode descriptorIndexNode) throws PSTException, IOException {
        this.pstFile = theFile;
        this.descriptorIndexNode = descriptorIndexNode;
        PSTTableBC table = new PSTTableBC(new PSTNodeInputStream(this.pstFile, this.pstFile.getOffsetIndexNode(descriptorIndexNode.dataOffsetIndexIdentifier)));
        this.items = table.getItems();
        if (descriptorIndexNode.localDescriptorsOffsetIndexIdentifier != 0L) {
            this.localDescriptorItems = theFile.getPSTDescriptorItems(descriptorIndexNode.localDescriptorsOffsetIndexIdentifier);
        }
    }

    protected PSTObject(PSTFile theFile, DescriptorIndexNode folderIndexNode, PSTTableBC table, HashMap<Integer, PSTDescriptorItem> localDescriptorItems) {
        this.pstFile = theFile;
        this.descriptorIndexNode = folderIndexNode;
        this.items = table.getItems();
        this.table = table;
        this.localDescriptorItems = localDescriptorItems;
    }

    public DescriptorIndexNode getDescriptorNode() {
        return this.descriptorIndexNode;
    }

    public long getDescriptorNodeId() {
        if (this.descriptorIndexNode != null) {
            return this.descriptorIndexNode.descriptorIdentifier;
        }
        return 0L;
    }

    public int getNodeType() {
        return PSTObject.getNodeType(this.descriptorIndexNode.descriptorIdentifier);
    }

    public static int getNodeType(int descriptorIdentifier) {
        return descriptorIdentifier & 0x1F;
    }

    protected int getIntItem(int identifier) {
        return this.getIntItem(identifier, 0);
    }

    protected int getIntItem(int identifier, int defaultValue) {
        if (this.items.containsKey(identifier)) {
            PSTTableBCItem item = this.items.get(identifier);
            return item.entryValueReference;
        }
        return defaultValue;
    }

    protected boolean getBooleanItem(int identifier) {
        return this.getBooleanItem(identifier, false);
    }

    protected boolean getBooleanItem(int identifier, boolean defaultValue) {
        if (this.items.containsKey(identifier)) {
            PSTTableBCItem item = this.items.get(identifier);
            return item.entryValueReference != 0;
        }
        return defaultValue;
    }

    protected double getDoubleItem(int identifier) {
        return this.getDoubleItem(identifier, 0.0);
    }

    protected double getDoubleItem(int identifier, double defaultValue) {
        if (this.items.containsKey(identifier)) {
            PSTTableBCItem item = this.items.get(identifier);
            long longVersion = PSTObject.convertLittleEndianBytesToLong(item.data);
            return Double.longBitsToDouble(longVersion);
        }
        return defaultValue;
    }

    protected long getLongItem(int identifier) {
        return this.getLongItem(identifier, 0L);
    }

    protected long getLongItem(int identifier, long defaultValue) {
        if (this.items.containsKey(identifier)) {
            PSTTableBCItem item = this.items.get(identifier);
            if (item.entryValueType == 3) {
                return item.entryValueReference;
            }
            if (item.entryValueType == 20) {
                if (item.data != null && item.data.length == 8) {
                    return PSTObject.convertLittleEndianBytesToLong(item.data, 0, 8);
                }
                System.err.printf("Invalid data length for long id 0x%04X\n", identifier);
            }
        }
        return defaultValue;
    }

    protected String getStringItem(int identifier) {
        return this.getStringItem(identifier, 0);
    }

    protected String getStringItem(int identifier, int stringType) {
        return this.getStringItem(identifier, stringType, null);
    }

    protected String getStringItem(int identifier, int stringType, String codepage) {
        PSTTableBCItem item = this.items.get(identifier);
        if (item != null) {
            if (codepage == null) {
                codepage = this.getStringCodepage();
            }
            if (stringType == 0) {
                stringType = item.entryValueType;
            }
            if (!item.isExternalValueReference) {
                return PSTObject.createJavaString(item.data, stringType, codepage);
            }
            if (this.localDescriptorItems != null && this.localDescriptorItems.containsKey(item.entryValueReference)) {
                PSTDescriptorItem descItem = this.localDescriptorItems.get(item.entryValueReference);
                try {
                    byte[] data = descItem.getData();
                    if (data == null) {
                        return "";
                    }
                    return PSTObject.createJavaString(data, stringType, codepage);
                }
                catch (Exception e) {
                    System.err.printf("Exception %s decoding string %s: %s\n", e.toString(), PSTFile.getPropertyDescription(identifier, stringType), this.data != null ? this.data.toString() : "null");
                    return "";
                }
            }
            return PSTObject.createJavaString(this.data, stringType, codepage);
        }
        return "";
    }

    static String createJavaString(byte[] data, int stringType, String codepage) {
        try {
            if (stringType == 31) {
                return new String(data, "UTF-16LE");
            }
            if (codepage == null) {
                return new String(data);
            }
            if ((codepage = codepage.toUpperCase(Locale.US)).contentEquals("ISO-8859-8-I")) {
                codepage = "ISO-8859-8";
            }
            try {
                return new String(data, codepage);
            }
            catch (UnsupportedEncodingException e) {
                return new String(data, "UTF-8");
            }
        }
        catch (Exception err) {
            System.err.println("Unable to decode string");
            err.printStackTrace();
            return "";
        }
    }

    private String getStringCodepage() {
        PSTTableBCItem cpItem = this.items.get(16381);
        if (cpItem == null) {
            cpItem = this.items.get(16350);
        }
        if (cpItem != null) {
            return PSTFile.getInternetCodePageCharset(cpItem.entryValueReference);
        }
        return null;
    }

    public Date getDateItem(int identifier) {
        if (this.items.containsKey(identifier)) {
            PSTTableBCItem item = this.items.get(identifier);
            if (item.data.length == 0) {
                return new Date(0L);
            }
            int high = (int)PSTObject.convertLittleEndianBytesToLong(item.data, 4, 8);
            int low = (int)PSTObject.convertLittleEndianBytesToLong(item.data, 0, 4);
            return PSTObject.filetimeToDate(high, low);
        }
        return null;
    }

    protected byte[] getBinaryItem(int identifier) {
        if (this.items.containsKey(identifier)) {
            PSTTableBCItem item = this.items.get(identifier);
            if (item.entryValueType == 258) {
                if (!item.isExternalValueReference) {
                    return item.data;
                }
                if (this.localDescriptorItems != null && this.localDescriptorItems.containsKey(item.entryValueReference)) {
                    PSTDescriptorItem descItem = this.localDescriptorItems.get(item.entryValueReference);
                    try {
                        return descItem.getData();
                    }
                    catch (Exception e) {
                        System.err.printf("Exception reading binary item: reference 0x%08X\n", item.entryValueReference);
                        return null;
                    }
                }
            }
        }
        return null;
    }

    protected PSTTimeZone getTimeZoneItem(int identifier) {
        byte[] tzData = this.getBinaryItem(identifier);
        if (tzData != null && tzData.length != 0) {
            return new PSTTimeZone(tzData);
        }
        return null;
    }

    public String getMessageClass() {
        return this.getStringItem(26);
    }

    public String toString() {
        return this.localDescriptorItems + "\n" + this.items;
    }

    public String getDisplayName() {
        return this.getStringItem(12289);
    }

    public String getAddrType() {
        return this.getStringItem(12290);
    }

    public String getEmailAddress() {
        return this.getStringItem(12291);
    }

    public String getComment() {
        return this.getStringItem(12292);
    }

    public Date getCreationTime() {
        return this.getDateItem(12295);
    }

    public Date getLastModificationTime() {
        return this.getDateItem(12296);
    }

    public static void printFormattedNumber(String pref, long number) {
        System.out.print(pref);
        PSTObject.printFormattedNumber(number);
    }

    public static void printFormattedNumber(long number) {
        System.out.print("dec: ");
        System.out.print(number);
        System.out.print(", hex: ");
        System.out.print(Long.toHexString(number));
        System.out.print(", bin: ");
        System.out.println(Long.toBinaryString(number));
    }

    public static void printHexFormatted(byte[] data, boolean pretty) {
        PSTObject.printHexFormatted(data, pretty, new int[0]);
    }

    protected static void printHexFormatted(byte[] data, boolean pretty, int[] indexes) {
        if (pretty) {
            System.out.println("---");
        }
        String line = "";
        int nextIndex = 0;
        int indexIndex = 0;
        if (indexes.length > 0) {
            nextIndex = indexes[0];
            ++indexIndex;
        }
        for (int x = 0; x < data.length; ++x) {
            long tmpLongValue = (long)data[x] & 0xFFL;
            if (indexes.length > 0 && x == nextIndex && nextIndex < data.length) {
                System.out.print("+");
                line = line + "+";
                while (indexIndex < indexes.length - 1 && indexes[indexIndex] <= nextIndex) {
                    ++indexIndex;
                }
                nextIndex = indexes[indexIndex];
            }
            line = Character.isLetterOrDigit((char)tmpLongValue) ? line + (char)tmpLongValue : line + ".";
            if (Long.toHexString(tmpLongValue).length() < 2) {
                System.out.print("0");
            }
            System.out.print(Long.toHexString(tmpLongValue));
            if (x % 2 == 1 && pretty) {
                System.out.print(" ");
            }
            if (x % 16 != 15 || !pretty) continue;
            System.out.print(" " + line);
            System.out.println("");
            line = "";
        }
        if (pretty) {
            System.out.println(" " + line);
            System.out.println("---");
            System.out.println(data.length);
        }
    }

    protected static byte[] decode(byte[] data) {
        for (int x = 0; x < data.length; ++x) {
            int temp = data[x] & 0xFF;
            data[x] = (byte)compEnc[temp];
        }
        return data;
    }

    protected static byte[] encode(byte[] data) {
        int[] enc = new int[compEnc.length];
        for (int x = 0; x < enc.length; ++x) {
            enc[PSTObject.compEnc[x]] = x;
        }
        for (int x = 0; x < data.length; ++x) {
            int temp = data[x] & 0xFF;
            data[x] = (byte)enc[temp];
        }
        return data;
    }

    public static long convertLittleEndianBytesToLong(byte[] data) {
        return PSTObject.convertLittleEndianBytesToLong(data, 0, data.length);
    }

    public static long convertLittleEndianBytesToLong(byte[] data, int start, int end) {
        long offset = data[end - 1] & 0xFF;
        for (int x = end - 2; x >= start; --x) {
            offset <<= 8;
            long tmpLongValue = (long)data[x] & 0xFFL;
            offset |= tmpLongValue;
        }
        return offset;
    }

    public static long convertBigEndianBytesToLong(byte[] data, int start, int end) {
        long offset = 0L;
        for (int x = start; x < end; ++x) {
            offset <<= 8;
            offset |= (long)data[x] & 0xFFL;
        }
        return offset;
    }

    public static PSTObject detectAndLoadPSTObject(PSTFile theFile, long descriptorIndex) throws IOException, PSTException {
        return PSTObject.detectAndLoadPSTObject(theFile, theFile.getDescriptorIndexNode(descriptorIndex));
    }

    static PSTObject detectAndLoadPSTObject(PSTFile theFile, DescriptorIndexNode folderIndexNode) throws IOException, PSTException {
        int nidType = folderIndexNode.descriptorIdentifier & 0x1F;
        if (nidType == 2 || nidType == 3 || nidType == 4) {
            PSTTableBC table = new PSTTableBC(new PSTNodeInputStream(theFile, theFile.getOffsetIndexNode(folderIndexNode.dataOffsetIndexIdentifier)));
            HashMap<Integer, PSTDescriptorItem> localDescriptorItems = null;
            if (folderIndexNode.localDescriptorsOffsetIndexIdentifier != 0L) {
                localDescriptorItems = theFile.getPSTDescriptorItems(folderIndexNode.localDescriptorsOffsetIndexIdentifier);
            }
            if (nidType == 2 || nidType == 3) {
                return new PSTFolder(theFile, folderIndexNode, table, localDescriptorItems);
            }
            return PSTObject.createAppropriatePSTMessageObject(theFile, folderIndexNode, table, localDescriptorItems);
        }
        throw new PSTException("Unknown child type with offset id: " + folderIndexNode.localDescriptorsOffsetIndexIdentifier);
    }

    static PSTMessage createAppropriatePSTMessageObject(PSTFile theFile, DescriptorIndexNode folderIndexNode, PSTTableBC table, HashMap<Integer, PSTDescriptorItem> localDescriptorItems) {
        PSTTableBCItem item = table.getItems().get(26);
        String messageClass = "";
        if (item != null) {
            messageClass = item.getStringValue();
        }
        if (messageClass.equals("IPM.Note") || messageClass.equals("IPM.Note.SMIME.MultipartSigned")) {
            return new PSTMessage(theFile, folderIndexNode, table, localDescriptorItems);
        }
        if (messageClass.equals("IPM.Appointment") || messageClass.equals("IPM.OLE.CLASS.{00061055-0000-0000-C000-000000000046}") || messageClass.startsWith("IPM.Schedule.Meeting")) {
            return new PSTAppointment(theFile, folderIndexNode, table, localDescriptorItems);
        }
        if (messageClass.equals("IPM.Contact")) {
            return new PSTContact(theFile, folderIndexNode, table, localDescriptorItems);
        }
        if (messageClass.equals("IPM.Task")) {
            return new PSTTask(theFile, folderIndexNode, table, localDescriptorItems);
        }
        if (messageClass.equals("IPM.Activity")) {
            return new PSTActivity(theFile, folderIndexNode, table, localDescriptorItems);
        }
        if (messageClass.equals("IPM.Post.Rss")) {
            return new PSTRss(theFile, folderIndexNode, table, localDescriptorItems);
        }
        if (messageClass.equals("IPM.DistList")) {
            return new PSTDistList(theFile, folderIndexNode, table, localDescriptorItems);
        }
        System.err.println("Unknown message type: " + messageClass);
        return new PSTMessage(theFile, folderIndexNode, table, localDescriptorItems);
    }

    static String guessPSTObjectType(PSTFile theFile, DescriptorIndexNode folderIndexNode) throws IOException, PSTException {
        PSTTableBC table = new PSTTableBC(new PSTNodeInputStream(theFile, theFile.getOffsetIndexNode(folderIndexNode.dataOffsetIndexIdentifier)));
        Set<Integer> keySet = table.getItems().keySet();
        for (Integer key : keySet) {
            if (key >= 1 && key <= 3071) {
                return "Message envelope";
            }
            if (key >= 4096 && key <= 12287) {
                return "Message content";
            }
            if (key >= 13312 && key <= 13823) {
                return "Message store";
            }
            if (key >= 13824 && key <= 14079) {
                return "Folder and address book";
            }
            if (key >= 14080 && key <= 14591) {
                return "Attachment";
            }
            if (key >= 14592 && key <= 14847) {
                return "Address book";
            }
            if (key >= 14848 && key <= 15359) {
                return "Messaging user";
            }
            if (key < 15360 || key > 15615) continue;
            return "Distribution list";
        }
        return "Unknown";
    }

    protected static Date filetimeToDate(int high, int low) {
        long filetime = (long)high << 32 | (long)low & 0xFFFFFFFFL;
        long ms_since_16010101 = filetime / 10000L;
        long ms_since_19700101 = ms_since_16010101 - 11644473600000L;
        return new Date(ms_since_19700101);
    }

    public static Calendar apptTimeToCalendar(int minutes) {
        long ms_since_16010101 = (long)minutes * 60000L;
        long ms_since_19700101 = ms_since_16010101 - 11644473600000L;
        Calendar c = Calendar.getInstance(PSTTimeZone.utcTimeZone);
        c.setTimeInMillis(ms_since_19700101);
        return c;
    }

    public static Calendar apptTimeToUTC(int minutes, PSTTimeZone tz) {
        Calendar cUTC = PSTObject.apptTimeToCalendar(minutes);
        if (tz != null) {
            Calendar cLocal = Calendar.getInstance(tz.getSimpleTimeZone());
            cLocal.clear();
            cLocal.set(cUTC.get(1), cUTC.get(2), cUTC.get(5), cUTC.get(11), cUTC.get(12), cUTC.get(13));
            long utcs = cLocal.getTimeInMillis() / 1000L;
            cUTC.setTimeInMillis(utcs * 1000L);
        }
        return cUTC;
    }
}

