/*
 * Decompiled with CFR 0.152.
 */
package com.ricardojlrufino.jexplorer.dnd;

import com.ricardojlrufino.jexplorer.dnd.FileTreeDragSource;
import com.ricardojlrufino.jexplorer.utils.StringUtils;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class FileTransferHandler
extends TransferHandler {
    public DataFlavor uriListFlavor;

    public FileTransferHandler() {
        try {
            this.uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public boolean canImport(JComponent dest, DataFlavor[] flavors) {
        if (FileTreeDragSource.started.get()) {
            JTree tree = (JTree)dest;
            Point location = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(location, tree);
            TreePath dragPath = tree.getPathForLocation(location.x, location.y);
            if (dragPath != null) {
                TreeNode node = (TreeNode)dragPath.getLastPathComponent();
                return !node.isLeaf();
            }
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (flavors[i].equals(DataFlavor.javaFileListFlavor)) {
                return true;
            }
            if (!flavors[i].equals(this.uriListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(JComponent src, Transferable transferable) {
        try {
            LinkedList<File> files = new LinkedList<File>();
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                files.addAll(list);
            } else if (transferable.isDataFlavorSupported(this.uriListFlavor)) {
                String[] pieces;
                String data = (String)transferable.getTransferData(this.uriListFlavor);
                for (String piece : pieces = StringUtils.splitTokens(data, "\r\n")) {
                    if (piece.startsWith("#")) continue;
                    String path = null;
                    if (piece.startsWith("file:///")) {
                        path = piece.substring(7);
                    } else if (piece.startsWith("file:/")) {
                        path = piece.substring(5);
                    }
                    files.add(new File(path));
                }
            }
            this.handleTranferFile(files);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public abstract void handleTranferFile(List<File> var1);

    public static class FileTransferable
    implements Transferable {
        private List listOfFiles;
        private boolean move;
        private TreePath selectedNode;

        public FileTransferable(List listOfFiles) {
            this.listOfFiles = listOfFiles;
        }

        public void setSelectionPath(TreePath selectedNode) {
            this.selectedNode = selectedNode;
        }

        public FileTransferable(List<File> selectedFiles, boolean move) {
            this.move = move;
            this.listOfFiles = selectedFiles;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.javaFileListFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.javaFileListFlavor.equals(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            return this.listOfFiles;
        }

        public void setMove(boolean move) {
            this.move = move;
        }

        public boolean isMove() {
            return this.move;
        }

        public TreePath getLastSelectedPath() {
            return this.selectedNode;
        }
    }
}

