/*
 * Decompiled with CFR 0.152.
 */
package com.ricardojlrufino.jexplorer;

import com.ricardojlrufino.jexplorer.FileOperation;
import com.ricardojlrufino.jexplorer.FilePropertiesDialog;
import com.ricardojlrufino.jexplorer.FileTreeCellRenderer;
import com.ricardojlrufino.jexplorer.FileTreeModel;
import com.ricardojlrufino.jexplorer.dnd.FileTransferHandler;
import com.ricardojlrufino.jexplorer.dnd.FileTreeDragSource;
import com.ricardojlrufino.jexplorer.utils.LimitedQueue;
import com.ricardojlrufino.jexplorer.utils.Translate;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JExplorerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTree tree;
    private FileTreeModel treeModel;
    protected JPopupMenu popup;
    private File rootDir;
    private FileTreeModel.FileTreeNode rootNode;
    private Translate translate;
    private LimitedQueue<FileOperation> undoQueue = new LimitedQueue(5);
    private FileTransferHandler.FileTransferable currentFileTransferable;

    public JExplorerPanel(File rootDir) {
        this.rootDir = rootDir;
        this.initComponents();
        this.initMenus();
        this.initKeyboard();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.rootNode = new FileTreeModel.FileTreeNode(this.rootDir);
        this.rootNode.populateDirectories(true);
        this.treeModel = new FileTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(2);
        this.tree.setCellRenderer(new FileTreeCellRenderer());
        this.tree.addTreeExpansionListener(new TreeExpansionHandler());
        this.tree.setTransferHandler(new FileTransferHandler(){

            @Override
            public void handleTranferFile(List<File> files) {
                try {
                    if (JExplorerPanel.this.currentFileTransferable instanceof FileTransferHandler.FileTransferable) {
                        JExplorerPanel.this.handleTransferFile(files, JExplorerPanel.this.currentFileTransferable.isMove());
                    } else {
                        JExplorerPanel.this.handleTransferFile(files, false);
                    }
                }
                catch (IOException e) {
                    JExplorerPanel.this.showException(e.getMessage(), e);
                }
            }
        });
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int selRow;
                if (e.getClickCount() == 2 && (selRow = JExplorerPanel.this.tree.getRowForLocation(e.getX(), e.getY())) > -1) {
                    JExplorerPanel.this.tree.setSelectionRow(selRow);
                    JExplorerPanel.this.handleOpen();
                }
            }
        });
        FileTreeDragSource.install(this);
        JScrollPane treeScroll = new JScrollPane(this.tree);
        Dimension preferredSize = treeScroll.getPreferredSize();
        Dimension widePreferred = new Dimension(200, (int)preferredSize.getHeight());
        treeScroll.setPreferredSize(widePreferred);
        this.add(treeScroll);
        this.configureTree(this.tree);
        this.translate = new Translate(){

            @Override
            public String get(String name) {
                return JExplorerPanel.this.tr(name);
            }
        };
    }

    protected void initMenus() {
        this.popup = new JPopupMenu();
        this.addMenu(this.tr("Add File"), 70, (ActionEvent e) -> this.handleAddNew(false));
        this.addMenu(this.tr("Add Directory"), 68, (ActionEvent e) -> this.handleAddNew(true));
        this.addMenu(this.tr("Refresh"), KeyStroke.getKeyStroke(116, 0), (ActionEvent e) -> this.handleReload());
        this.popup.addSeparator();
        this.addMenu(this.tr("Rename"), KeyStroke.getKeyStroke(113, 0), (ActionEvent e) -> this.handleRename());
        this.addMenu(this.tr("Cut"), "control X", (ActionEvent e) -> this.handleCut());
        this.addMenu(this.tr("Copy"), "control C", (ActionEvent e) -> this.handleCopy());
        this.addMenu(this.tr("Paste"), "control V", (ActionEvent e) -> this.handlePaste());
        this.addMenu(this.tr("Delete"), KeyStroke.getKeyStroke(127, 0), (ActionEvent e) -> this.handleDelete());
        this.popup.addSeparator();
        this.addMenu(this.tr("Properties"), "alt ENTER", (ActionEvent e) -> this.handleProperties());
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int selRow = JExplorerPanel.this.tree.getRowForLocation(e.getX(), e.getY());
                    if (selRow > -1) {
                        JExplorerPanel.this.tree.setSelectionRow(selRow);
                    } else {
                        JExplorerPanel.this.tree.clearSelection();
                    }
                    JExplorerPanel.this.popup.show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        this.configureMenu(this.popup);
    }

    protected void initKeyboard() {
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (127 == evt.getKeyCode()) {
                    JExplorerPanel.this.handleDelete();
                } else if (evt.isAltDown() && evt.getKeyCode() == 10) {
                    JExplorerPanel.this.handleProperties();
                } else if (10 == evt.getKeyCode()) {
                    JExplorerPanel.this.handleOpen();
                } else if (113 == evt.getKeyCode()) {
                    JExplorerPanel.this.handleRename();
                } else if (116 == evt.getKeyCode()) {
                    JExplorerPanel.this.handleReload();
                } else if (evt.isControlDown() && evt.getKeyCode() == 67) {
                    JExplorerPanel.this.handleCopy();
                } else if (evt.isControlDown() && evt.getKeyCode() == 88) {
                    JExplorerPanel.this.handleCut();
                } else if ((!evt.isControlDown() || evt.getKeyCode() != 86) && evt.isControlDown() && evt.getKeyCode() == 90) {
                    JExplorerPanel.this.handleUndo();
                }
            }
        });
    }

    public void setCurrentFileTransferable(FileTransferHandler.FileTransferable currentFileTransferable) {
        this.currentFileTransferable = currentFileTransferable;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.treeModel.setFileFilter(fileFilter);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void replaceWorkingDirectory(File selectedFile) {
        this.rootDir = selectedFile;
        FileFilter fileFilter = this.rootNode.getFileFilter();
        this.rootNode = new FileTreeModel.FileTreeNode(this.rootDir);
        this.rootNode.setFileFilter(fileFilter);
        this.rootNode.populateDirectories(true);
        this.treeModel = new FileTreeModel(this.rootNode);
        this.tree.setModel(this.treeModel);
        this.undoQueue.clear();
    }

    private JMenuItem addMenu(String title, int mnemonic, ActionListener actionListener) {
        JMenuItem mi = new JMenuItem(title);
        mi.setMnemonic(mnemonic);
        mi.addActionListener(actionListener);
        this.popup.add(mi);
        return mi;
    }

    private JMenuItem addMenu(String title, String acelerator, ActionListener actionListener) {
        return this.addMenu(title, KeyStroke.getKeyStroke(acelerator), actionListener);
    }

    private JMenuItem addMenu(String title, KeyStroke keyStroke, ActionListener actionListener) {
        JMenuItem mi = new JMenuItem(title);
        mi.setAccelerator(keyStroke);
        mi.addActionListener(actionListener);
        this.popup.add(mi);
        return mi;
    }

    protected String tr(String name) {
        return name;
    }

    protected void log(String message) {
        System.out.println("[JEXPLORER]: " + message);
    }

    private void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    private void showErrorMessage(String title, String message) {
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    public void showException(String string, Exception e) {
        e.printStackTrace();
    }

    protected void configureTree(JTree tree) {
    }

    protected void configureMenu(JPopupMenu popup) {
    }

    protected void handleAddNew(boolean directory) {
        File file;
        String name = JOptionPane.showInputDialog(this, (Object)(directory ? this.tr("New Directory") : this.tr("New File")));
        TreePath selectionPath = this.getSelectedPathOrRoot();
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        File parentFile = (File)parentNode.getUserObject();
        if (parentFile == null) {
            this.showMessage(this.tr("Please select a folder to add"));
            return;
        }
        if (parentFile.isFile()) {
            parentFile = parentFile.getParentFile();
            selectionPath = selectionPath.getParentPath();
        }
        if ((file = new File(parentFile, name)).exists()) {
            this.showMessage(this.tr("File already exists"));
            return;
        }
        try {
            if (directory) {
                file.mkdir();
            } else {
                file.createNewFile();
            }
        }
        catch (Exception e) {
            this.showErrorMessage("Error creating file or directory", e.getMessage());
        }
        this.insertFileIntoTree(file, selectionPath);
    }

    protected void handleReload() {
        System.out.println("reload...");
        FileTreeModel.FileTreeNode node = (FileTreeModel.FileTreeNode)this.getSelectedPathOrRoot().getLastPathComponent();
        if (node == null) {
            return;
        }
        boolean rootChanged = this.detectRootChanges();
        if (rootChanged) {
            this.log("Root files changed, reload all...");
            node = this.rootNode;
        }
        node.reloadChildren();
        this.treeModel.nodeStructureChanged(node);
    }

    private boolean detectRootChanges() {
        File[] listFiles = this.rootDir.listFiles(this.treeModel.getFileFilter());
        return this.rootNode.getChildCount() != listFiles.length;
    }

    protected void handleOpen() {
        FileTreeModel.FileTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && selectedNode.isLeaf() && this.validateSelectionPaths()) {
            this.handleOpenFile(this.getSelectedFile());
        }
    }

    protected void handleProperties() {
        if (this.validateSelectionPaths()) {
            File selectedFile = this.getSelectedFile();
            FilePropertiesDialog dialog = new FilePropertiesDialog(selectedFile, this.translate);
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
        }
    }

    protected void handleOpenFile(File file) {
        JOptionPane.showMessageDialog(this, "Handle Open : " + file.getName());
    }

    protected void handleRename() {
        FileTreeModel.FileTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode == null) {
            return;
        }
        File selected = selectedNode.getFile();
        String name = JOptionPane.showInputDialog(this, this.tr("Rename"), selected.getName());
        if (name != null && !name.isEmpty()) {
            FileOperation.FileOperationRename rename = new FileOperation.FileOperationRename(selectedNode, name);
            this.executeOperation(rename);
            selected = rename.getNewFile();
            this.treeModel.nodeStructureChanged(selectedNode.getParent());
        }
    }

    protected void handleDelete() {
        if (!this.validateSelectionPaths()) {
            return;
        }
        TreePath[] paths = this.tree.getSelectionPaths();
        ArrayList<String> names = new ArrayList<String>();
        for (TreePath treePath : paths) {
            FileTreeModel.FileTreeNode node = (FileTreeModel.FileTreeNode)treePath.getLastPathComponent();
            TreePath[] file = node.getFile();
            names.add(file.getName());
        }
        File file = this.getSelectedFile();
        String question = this.tr("Delete") + " " + this.tr(file.isDirectory() ? "Directory" : "File");
        String message = this.tr("This operation cannot be undone !");
        int response = JOptionPane.showConfirmDialog(this, question + ": " + names + "\n" + message, null, 0);
        if (0 == response) {
            LinkedList<File> files = new LinkedList<File>();
            for (TreePath treePath : paths) {
                files.add(this.getSelectedFile(treePath));
            }
            FileOperation.FileOperationDelete delete = new FileOperation.FileOperationDelete(files);
            boolean deleted = this.executeOperation(delete);
            for (TreePath treePath : paths) {
                if (!deleted) continue;
                TreePath parentPath = treePath.getParentPath();
                this.tree.addSelectionPath(parentPath);
                this.treeModel.removeNodeFromParent((MutableTreeNode)treePath.getLastPathComponent());
            }
        }
    }

    protected boolean executeOperation(FileOperation operation) {
        try {
            if (operation.execute()) {
                operation.setTree(this.tree);
                operation.saveTreeSelection();
                this.undoQueue.push(operation);
                return true;
            }
        }
        catch (Exception e) {
            this.showErrorMessage("Error : " + e.getClass().getSimpleName(), e.getMessage());
        }
        return false;
    }

    protected void handleUndo() {
        FileOperation lasFileOperation = this.getLastFileOperation();
        if (lasFileOperation != null) {
            try {
                boolean undo = lasFileOperation.undo();
                if (!undo) {
                    this.showErrorMessage(this.tr("Undo"), this.tr("Failed to undo last change"));
                }
                lasFileOperation.restoreTreeSelection();
                this.handleReload();
            }
            catch (Exception e) {
                this.showErrorMessage("Error : " + e.getClass().getSimpleName(), e.getMessage());
            }
        }
    }

    private void handlePaste() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (transferable != null) {
            this.tree.getTransferHandler().importData(this.tree, transferable);
        }
    }

    private void handleCopy() {
        List<File> selectedFiles = this.getSelectedFiles();
        if (!selectedFiles.isEmpty()) {
            this.currentFileTransferable = new FileTransferHandler.FileTransferable(selectedFiles, false);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(this.currentFileTransferable, null);
        }
    }

    private void handleCut() {
        List<File> selectedFiles = this.getSelectedFiles();
        TreePath selectedNode = this.tree.getSelectionPath();
        if (!selectedFiles.isEmpty()) {
            this.currentFileTransferable = new FileTransferHandler.FileTransferable(selectedFiles, true);
            this.currentFileTransferable.setSelectionPath(selectedNode);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(this.currentFileTransferable, null);
        }
    }

    public FileOperation getLastFileOperation() {
        if (this.undoQueue.isEmpty()) {
            return null;
        }
        return (FileOperation)this.undoQueue.pop();
    }

    public void handleTransferFile(List<File> files, boolean isMove) throws IOException {
        TreePath selectedNode;
        TreePath selectionPath = this.tree.getSelectionPath();
        File targetFolder = this.getSelectedFile();
        if (targetFolder == null) {
            targetFolder = this.rootDir;
        }
        this.log("Transfer Files: , mode: " + (isMove ? "MOVE" : "COPY") + ", target: " + targetFolder);
        for (File file : files) {
            this.log(" - File Origin: " + file);
        }
        if (!targetFolder.isDirectory()) {
            selectionPath = selectionPath.getParentPath();
            targetFolder = ((FileTreeModel.FileTreeNode)selectionPath.getLastPathComponent()).getFile();
        }
        FileOperation.FileOperationCopy copyOrMove = new FileOperation.FileOperationCopy(files, targetFolder, isMove);
        this.executeOperation(copyOrMove);
        List<File> targetFiles = copyOrMove.getTargetFiles();
        if (isMove && (selectedNode = this.currentFileTransferable.getLastSelectedPath().getParentPath()) != null) {
            FileTreeModel.FileTreeNode parentNode = (FileTreeModel.FileTreeNode)selectedNode.getLastPathComponent();
            parentNode.reloadChildren();
            this.treeModel.nodeStructureChanged(parentNode);
        }
        if (selectionPath != null) {
            this.insertFileIntoTree(targetFiles, selectionPath);
            this.tree.addSelectionPath(selectionPath);
        } else {
            this.rootNode.reloadChildren();
            this.treeModel.nodeStructureChanged(this.rootNode);
        }
        this.currentFileTransferable = null;
    }

    private FileTreeModel.FileTreeNode getSelectedNode() {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        return (FileTreeModel.FileTreeNode)node;
    }

    private File getSelectedFile() {
        return this.getSelectedFile(this.tree.getSelectionPath());
    }

    private TreePath getSelectedPathOrRoot() {
        TreePath selectionPath = this.tree.getSelectionPath();
        if (selectionPath == null) {
            selectionPath = new TreePath(this.rootNode);
        }
        return selectionPath;
    }

    private boolean validateSelectionPaths() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null) {
            return false;
        }
        int leafs = 0;
        int dirs = 0;
        for (TreePath treePath : paths) {
            TreeNode node = (TreeNode)treePath.getLastPathComponent();
            if (node.isLeaf()) {
                ++leafs;
                continue;
            }
            ++dirs;
        }
        if (leafs > 0 && dirs > 0) {
            this.showMessage(this.tr("Invalid Selection"));
            return false;
        }
        if (dirs > 0 && leafs > 0) {
            this.showMessage(this.tr("Invalid Selection"));
            return false;
        }
        return true;
    }

    public File getSelectedFile(TreePath path) {
        if (path == null) {
            return null;
        }
        FileTreeModel.FileTreeNode node = (FileTreeModel.FileTreeNode)path.getLastPathComponent();
        return node.getFile();
    }

    private List<File> getSelectedFiles() {
        TreePath[] paths = this.tree.getSelectionPaths();
        LinkedList<File> names = new LinkedList<File>();
        for (TreePath treePath : paths) {
            FileTreeModel.FileTreeNode node = (FileTreeModel.FileTreeNode)treePath.getLastPathComponent();
            File file = node.getFile();
            names.add(file);
        }
        return names;
    }

    private void insertFileIntoTree(File file, TreePath parentPath) {
        this.insertFileIntoTree(Arrays.asList(file), parentPath);
    }

    private void insertFileIntoTree(List<File> files, TreePath parentPath) {
        FileTreeModel.FileTreeNode parentNode = (FileTreeModel.FileTreeNode)parentPath.getLastPathComponent();
        parentNode.reloadChildren();
        this.treeModel.nodeStructureChanged(parentNode);
        this.tree.expandPath(parentPath);
    }

    protected class TreeExpansionHandler
    implements TreeExpansionListener {
        protected TreeExpansionHandler() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
            TreePath path = evt.getPath();
            JTree tree = (JTree)evt.getSource();
            FileTreeModel.FileTreeNode node = (FileTreeModel.FileTreeNode)path.getLastPathComponent();
            if (node.populateDirectories(true)) {
                ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(node);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
        }
    }
}

