/*
 * Decompiled with CFR 0.152.
 */
import com.ricardojlrufino.jexplorer.FileOperation;
import com.ricardojlrufino.jexplorer.JExplorerPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTextArea;

public class FileExplorerPanelLinuxDebug
extends JFrame {
    private JTextArea textArea;
    private String root;

    public FileExplorerPanelLinuxDebug() {
        final Preferences prefs = Preferences.userNodeForPackage(FileExplorerPanelLinuxDebug.class);
        this.root = prefs.get("lastFolder", System.getProperty("user.home"));
        System.out.println("Current Folder: " + this.root);
        this.setDefaultCloseOperation(3);
        this.setTitle("JExplorerPanel demo");
        this.setSize(800, 500);
        this.setLayout(new BorderLayout());
        this.textArea = new JTextArea();
        this.textArea.setBackground(Color.BLACK);
        this.textArea.setForeground(Color.WHITE);
        this.textArea.setMinimumSize(new Dimension(400, (int)this.getSize().getHeight()));
        this.updateDir();
        final JExplorerPanel fileExplorerPanel = new JExplorerPanel(new File(this.root)){

            @Override
            protected boolean executeOperation(FileOperation operation) {
                boolean status = super.executeOperation(operation);
                FileExplorerPanelLinuxDebug.this.updateDir();
                return status;
            }

            @Override
            protected void handleUndo() {
                super.handleUndo();
                FileExplorerPanelLinuxDebug.this.updateDir();
            }

            @Override
            protected void initMenus() {
                super.initMenus();
                this.popup.remove(0);
            }
        };
        fileExplorerPanel.setMinimumSize(new Dimension(400, (int)this.getSize().getHeight()));
        this.add((Component)fileExplorerPanel, "Center");
        this.add((Component)this.textArea, "East");
        JButton button = new JButton("Browse");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
                fileChooser.setFileSelectionMode(1);
                int result = fileChooser.showOpenDialog(FileExplorerPanelLinuxDebug.this);
                if (result == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    fileExplorerPanel.replaceWorkingDirectory(selectedFile);
                    prefs.put("lastFolder", selectedFile.getAbsolutePath());
                }
            }
        });
        this.add((Component)button, "South");
    }

    private void updateDir() {
        try {
            String cmd = FileExplorerPanelLinuxDebug.execCmd(new String[]{"bash", "-c", "cd " + this.root + " ; tree"});
            this.textArea.setText(cmd);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new FileExplorerPanelLinuxDebug().setVisible(true);
    }

    public static String execCmd(String[] cmd) throws IOException {
        Scanner s = new Scanner(Runtime.getRuntime().exec(cmd).getInputStream()).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

