/*
 * Decompiled with CFR 0.152.
 */
package fr.free.jnizet.retry;

import com.google.common.base.Preconditions;
import fr.free.jnizet.retry.WaitStrategy;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

public final class WaitStrategies {
    private static final WaitStrategy NO_WAIT_STRATEGY = new FixedWaitStrategy(0L);

    private WaitStrategies() {
    }

    public static WaitStrategy noWait() {
        return NO_WAIT_STRATEGY;
    }

    public static WaitStrategy fixedWait(long sleepTime, @Nonnull TimeUnit timeUnit) throws IllegalStateException {
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"The time unit may not be null");
        return new FixedWaitStrategy(timeUnit.toMillis(sleepTime));
    }

    public static WaitStrategy randomWait(long maximumTime, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"The time unit may not be null");
        return new RandomWaitStrategy(0L, timeUnit.toMillis(maximumTime));
    }

    public static WaitStrategy randomWait(long minimumTime, @Nonnull TimeUnit minimumTimeUnit, long maximumTime, @Nonnull TimeUnit maximumTimeUnit) {
        Preconditions.checkNotNull((Object)((Object)minimumTimeUnit), (Object)"The minimum time unit may not be null");
        Preconditions.checkNotNull((Object)((Object)maximumTimeUnit), (Object)"The maximum time unit may not be null");
        return new RandomWaitStrategy(minimumTimeUnit.toMillis(minimumTime), maximumTimeUnit.toMillis(maximumTime));
    }

    public static WaitStrategy incrementingWait(long initialSleepTime, @Nonnull TimeUnit initialSleepTimeUnit, long increment, @Nonnull TimeUnit incrementTimeUnit) {
        Preconditions.checkNotNull((Object)((Object)initialSleepTimeUnit), (Object)"The initial sleep time unit may not be null");
        Preconditions.checkNotNull((Object)((Object)incrementTimeUnit), (Object)"The increment time unit may not be null");
        return new IncrementingWaitStrategy(initialSleepTimeUnit.toMillis(initialSleepTime), incrementTimeUnit.toMillis(increment));
    }

    @Immutable
    private static final class IncrementingWaitStrategy
    implements WaitStrategy {
        private final long initialSleepTime;
        private final long increment;

        public IncrementingWaitStrategy(long initialSleepTime, long increment) {
            Preconditions.checkArgument((initialSleepTime >= 0L ? 1 : 0) != 0, (String)"initialSleepTime must be >= 0 but is %d", (Object[])new Object[]{initialSleepTime});
            this.initialSleepTime = initialSleepTime;
            this.increment = increment;
        }

        @Override
        public long computeSleepTime(int previousAttemptNumber, long delaySinceFirstAttemptInMillis) {
            long result = this.initialSleepTime + this.increment * (long)(previousAttemptNumber - 1);
            return result >= 0L ? result : 0L;
        }
    }

    @Immutable
    private static final class RandomWaitStrategy
    implements WaitStrategy {
        private static final Random RANDOM = new Random();
        private final long minimum;
        private final long maximum;

        public RandomWaitStrategy(long minimum, long maximum) {
            Preconditions.checkArgument((minimum >= 0L ? 1 : 0) != 0, (String)"minimum must be >= 0 but is %d", (Object[])new Object[]{minimum});
            Preconditions.checkArgument((maximum > minimum ? 1 : 0) != 0, (String)"maximum must be > minimum but maximum is %d and minimum is", (Object[])new Object[]{maximum, minimum});
            this.minimum = minimum;
            this.maximum = maximum;
        }

        @Override
        public long computeSleepTime(int previousAttemptNumber, long delaySinceFirstAttemptInMillis) {
            long t = Math.abs(RANDOM.nextLong()) % (this.maximum - this.minimum);
            return t + this.minimum;
        }
    }

    @Immutable
    private static final class FixedWaitStrategy
    implements WaitStrategy {
        private final long sleepTime;

        public FixedWaitStrategy(long sleepTime) {
            Preconditions.checkArgument((sleepTime >= 0L ? 1 : 0) != 0, (String)"sleepTime must be >= 0 but is %d", (Object[])new Object[]{sleepTime});
            this.sleepTime = sleepTime;
        }

        @Override
        public long computeSleepTime(int previousAttemptNumber, long delaySinceFirstAttemptInMillis) {
            return this.sleepTime;
        }
    }
}

