/*
 * Decompiled with CFR 0.152.
 */
package com.runjva.sourceforge.jsocks.protocol;

import com.runjva.sourceforge.jsocks.protocol.InetRangeResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class InetRange
implements Cloneable {
    Hashtable<String, Object[]> host_names;
    Vector<Object[]> all = new Vector();
    Vector<String> end_names;
    boolean useSeparateThread = true;

    public InetRange() {
        this.host_names = new Hashtable();
        this.end_names = new Vector();
    }

    public synchronized boolean add(String s0) {
        if (s0 == null) {
            return false;
        }
        String s = s0.trim();
        if (s.length() == 0) {
            return false;
        }
        if (s.endsWith(".")) {
            int[] addr = InetRange.ip2intarray(s);
            long to = 0L;
            long from = 0L;
            if (addr == null) {
                return false;
            }
            for (int i = 0; i < 4; ++i) {
                if (addr[i] >= 0) {
                    from += (long)addr[i] << 8 * (3 - i);
                    continue;
                }
                to = from;
                while (i < 4) {
                    to += 255L << 8 * (3 - i++);
                }
                break;
            }
            Object[] entry = new Object[]{s, null, new Long(from), new Long(to)};
            this.all.addElement(entry);
        } else if (s.startsWith(".")) {
            this.end_names.addElement(s);
            this.all.addElement(new Object[]{s, null, null, null});
        } else {
            StringTokenizer tokens = new StringTokenizer(s, " \t\r\n\f:");
            if (tokens.countTokens() > 1) {
                Object[] entry = new Object[]{s, null, null, null};
                this.resolve(entry, tokens.nextToken(), tokens.nextToken());
                this.all.addElement(entry);
            } else {
                Object[] entry = new Object[]{s, null, null, null};
                this.all.addElement(entry);
                this.host_names.put(s, entry);
                this.resolve(entry);
            }
        }
        return true;
    }

    public synchronized void add(InetAddress ip) {
        long to;
        long from = to = InetRange.ip2long(ip);
        this.all.addElement(new Object[]{ip.getHostName(), ip, new Long(from), new Long(to)});
    }

    public synchronized void add(InetAddress from, InetAddress to) {
        this.all.addElement(new Object[]{from.getHostAddress() + ":" + to.getHostAddress(), null, new Long(InetRange.ip2long(from)), new Long(InetRange.ip2long(to))});
    }

    public synchronized boolean contains(String host) {
        return this.contains(host, true);
    }

    public synchronized boolean contains(String host0, boolean attemptResolve) {
        if (this.all.size() == 0) {
            return false;
        }
        String host = host0.trim();
        if (host.length() == 0) {
            return false;
        }
        if (this.checkHost(host)) {
            return true;
        }
        if (this.checkHostEnding(host)) {
            return true;
        }
        long l = this.host2long(host);
        if (l >= 0L) {
            return this.contains(l);
        }
        if (!attemptResolve) {
            return false;
        }
        try {
            InetAddress ip = InetAddress.getByName(host);
            return this.contains(ip);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public synchronized boolean contains(InetAddress ip) {
        if (this.checkHostEnding(ip.getHostName())) {
            return true;
        }
        if (this.checkHost(ip.getHostName())) {
            return true;
        }
        return this.contains(InetRange.ip2long(ip));
    }

    public synchronized String[] getAll() {
        int size = this.all.size();
        String[] all_names = new String[size];
        for (int i = 0; i < size; ++i) {
            Object[] entry = this.all.elementAt(i);
            all_names[i] = (String)entry[0];
        }
        return all_names;
    }

    public synchronized boolean remove(String s) {
        Enumeration<Object[]> enumx = this.all.elements();
        while (enumx.hasMoreElements()) {
            Object[] entry = enumx.nextElement();
            if (!s.equals(entry[0])) continue;
            this.all.removeElement(entry);
            this.end_names.removeElement(s);
            this.host_names.remove(s);
            return true;
        }
        return false;
    }

    public String toString() {
        String[] all = this.getAll();
        if (all.length == 0) {
            return "";
        }
        String s = all[0];
        for (int i = 1; i < all.length; ++i) {
            s = s + "; " + all[i];
        }
        return s;
    }

    public Object clone() {
        InetRange new_range = new InetRange();
        new_range.all = (Vector)this.all.clone();
        new_range.end_names = (Vector)this.end_names.clone();
        new_range.host_names = (Hashtable)this.host_names.clone();
        return new_range;
    }

    private synchronized boolean contains(long ip) {
        Enumeration<Object[]> enumx = this.all.elements();
        while (enumx.hasMoreElements()) {
            Long to;
            Object[] obj = enumx.nextElement();
            Long from = obj[2] == null ? null : (Long)obj[2];
            Long l = to = obj[3] == null ? null : (Long)obj[3];
            if (from == null || from > ip || to < ip) continue;
            return true;
        }
        return false;
    }

    private boolean checkHost(String host) {
        return this.host_names.containsKey(host);
    }

    private boolean checkHostEnding(String host) {
        Enumeration<String> enumx = this.end_names.elements();
        while (enumx.hasMoreElements()) {
            if (!host.endsWith(enumx.nextElement())) continue;
            return true;
        }
        return false;
    }

    private void resolve(Object[] entry) {
        long ip = this.host2long((String)entry[0]);
        if (ip >= 0L) {
            entry[2] = entry[3] = new Long(ip);
        } else {
            InetRangeResolver res = new InetRangeResolver(entry);
            res.resolve(this.useSeparateThread);
        }
    }

    private void resolve(Object[] entry, String from, String to) {
        long t;
        long f = this.host2long(from);
        if (f >= 0L && (t = this.host2long(to)) >= 0L) {
            entry[2] = new Long(f);
            entry[3] = new Long(t);
        } else {
            InetRangeResolver res = new InetRangeResolver(entry, from, to);
            res.resolve(this.useSeparateThread);
        }
    }

    static long ip2long(InetAddress ip) {
        long l = 0L;
        byte[] addr = ip.getAddress();
        if (addr.length == 4) {
            for (int i = 0; i < 4; ++i) {
                l += ((long)addr[i] & 0xFFL) << 8 * (3 - i);
            }
        } else {
            return 0L;
        }
        return l;
    }

    long host2long(String host) {
        long ip = 0L;
        if (!Character.isDigit(host.charAt(0))) {
            return -1L;
        }
        int[] addr = InetRange.ip2intarray(host);
        if (addr == null) {
            return -1L;
        }
        for (int i = 0; i < addr.length; ++i) {
            ip += (long)(addr[i] >= 0 ? addr[i] : 0) << 8 * (3 - i);
        }
        return ip;
    }

    static int[] ip2intarray(String host) {
        int[] address = new int[]{-1, -1, -1, -1};
        int i = 0;
        StringTokenizer tokens = new StringTokenizer(host, ".");
        if (tokens.countTokens() > 4) {
            return null;
        }
        while (tokens.hasMoreTokens()) {
            try {
                address[i++] = Integer.parseInt(tokens.nextToken()) & 0xFF;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return address;
    }
}

