/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.markdown.confluence.core.service;

import com.github.qwazer.markdown.confluence.core.ConfluenceConfig;
import com.github.qwazer.markdown.confluence.core.ConfluenceException;
import com.github.qwazer.markdown.confluence.core.model.ConfluencePage;
import com.github.qwazer.markdown.confluence.core.service.ConfluenceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpStatusCodeException;

@Service
public class PageService {
    private static final Logger LOG = LoggerFactory.getLogger(PageService.class);
    private final ConfluenceService confluenceService;

    @Autowired
    public PageService(ConfluenceService confluenceService) {
        this.confluenceService = confluenceService;
    }

    public Long postWikiPageToConfluence(ConfluenceConfig.Page page, String wiki) {
        LOG.info("Posting page {} to Confluence...", (Object)page.getTitle());
        try {
            ConfluencePage oldPage = this.confluenceService.findPageByTitle(page.getTitle());
            if (oldPage != null) {
                LOG.info("Update existing page");
                oldPage.setContent(wiki);
                oldPage.setTitle(page.getTitle());
                oldPage.setLabels(page.getLabels());
                this.confluenceService.updatePage(oldPage);
                this.confluenceService.addLabels(oldPage.getId(), page.getLabels());
                return oldPage.getId();
            }
            LOG.info("Create new page");
            ConfluencePage newPage = new ConfluencePage();
            newPage.setContent(wiki);
            newPage.setTitle(page.getTitle());
            newPage.setLabels(page.getLabels());
            Long ancestorId = this.confluenceService.findAncestorId(page.getParentTitle());
            newPage.setAncestorId(ancestorId);
            Long pageId = this.confluenceService.createPage(newPage);
            this.confluenceService.addLabels(pageId, page.getLabels());
            return pageId;
        }
        catch (HttpStatusCodeException e) {
            throw new ConfluenceException(e.getResponseBodyAsString(), e);
        }
    }

    public <T> List<T> union(Collection<T> list1, Collection<T> list2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(list1);
        set.addAll(list2);
        return new ArrayList(set);
    }

    public <T> List<T> intersection(Collection<T> list1, Collection<T> list2) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list1) {
            if (!list2.contains(t)) continue;
            list.add(t);
        }
        return list;
    }
}

