/*
 * Decompiled with CFR 0.152.
 */
package com.github.qwazer.markdown.confluence.core.service;

import com.github.qwazer.markdown.confluence.core.ConfluenceConfig;
import com.github.qwazer.markdown.confluence.core.service.FileReaderService;
import com.github.qwazer.markdown.confluence.core.service.MarkdownService;
import com.github.qwazer.markdown.confluence.core.service.PageService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MainService {
    private final FileReaderService fileReaderService;
    private final MarkdownService markdownService;
    private final PageService pageService;

    @Autowired
    public MainService(FileReaderService fileReaderService, MarkdownService markdownService, PageService pageService) {
        this.fileReaderService = fileReaderService;
        this.markdownService = markdownService;
        this.pageService = pageService;
    }

    public void processAll(ConfluenceConfig confluenceConfig) throws IOException {
        List<ConfluenceConfig.Page> orderedList = MainService.order(confluenceConfig.getPages());
        for (ConfluenceConfig.Page page : orderedList) {
            String plainFileContent = this.fileReaderService.readFile(page);
            String wikiText = this.markdownService.convertMarkdown2Wiki(plainFileContent, confluenceConfig);
            this.pageService.postWikiPageToConfluence(page, confluenceConfig, wikiText);
        }
    }

    public static List<ConfluenceConfig.Page> order(Collection<ConfluenceConfig.Page> pages) {
        if (pages.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashMap group = new HashMap();
        ArrayList<ConfluenceConfig.Page> roots = new ArrayList<ConfluenceConfig.Page>();
        ArrayList<ConfluenceConfig.Page> childs = new ArrayList<ConfluenceConfig.Page>();
        for (ConfluenceConfig.Page page : pages) {
            if (MainService.hasParent(page, pages)) {
                childs.add(page);
                continue;
            }
            roots.add(page);
        }
        LinkedList<ConfluenceConfig.Page> linkedList = new LinkedList<ConfluenceConfig.Page>();
        linkedList.addAll(roots);
        linkedList.addAll(MainService.order(childs));
        return linkedList;
    }

    private static boolean hasParent(ConfluenceConfig.Page page, Collection<ConfluenceConfig.Page> pages) {
        boolean res = false;
        for (ConfluenceConfig.Page curr : pages) {
            if (!curr.getTitle().equals(page.getParentTitle())) continue;
            return true;
        }
        return res;
    }
}

