/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.utils.filter;

import cn.hutool.core.util.CharsetUtil;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.AES;
import com.tugos.dst.admin.utils.filter.SensitiveNode;
import com.tugos.dst.admin.utils.filter.StringPointer;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.NavigableSet;
import org.springframework.core.io.ClassPathResource;

public class SensitiveFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SENSITIVE_WORD_FILE = "sensitive_words.txt";
    public static SensitiveFilter DEFAULT = null;
    static final int DEFAULT_INITIAL_CAPACITY = 131072;
    protected SensitiveNode[] nodes = new SensitiveNode[131072];

    public SensitiveFilter() {
    }

    public SensitiveFilter(BufferedReader reader) {
        try {
            String line = reader.readLine();
            while (line != null) {
                this.put(line);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean put(String word) {
        if (word == null || word.trim().length() < 2) {
            return false;
        }
        if (word.length() == 2 && word.matches("\\w\\w")) {
            return false;
        }
        StringPointer sp = new StringPointer(word.trim());
        int hash = sp.nextTwoCharHash(0);
        int mix = sp.nextTwoCharMix(0);
        int index = hash & this.nodes.length - 1;
        SensitiveNode node = this.nodes[index];
        if (node != null) {
            while (true) {
                if (node.headTwoCharMix == mix) {
                    node.words.add(sp);
                    return true;
                }
                if (node.next == null) {
                    new SensitiveNode((int)mix, (SensitiveNode)node).words.add(sp);
                    return true;
                }
                node = node.next;
            }
        }
        node = new SensitiveNode(mix);
        node.words.add(sp);
        this.nodes[index] = node;
        return true;
    }

    public String filter(String sentence, char replace) {
        int step;
        StringPointer sp = new StringPointer(sentence);
        boolean replaced = false;
        block0: for (int i = 0; i < sp.length - 2; i += step) {
            step = 1;
            int hash = sp.nextTwoCharHash(i);
            SensitiveNode node = this.nodes[hash & this.nodes.length - 1];
            if (node == null) continue;
            int mix = sp.nextTwoCharMix(i);
            while (node != null) {
                if (node.headTwoCharMix == mix) {
                    NavigableSet<StringPointer> desSet = node.words.headSet(sp.substring(i), true);
                    for (StringPointer word : desSet.descendingSet()) {
                        if (!sp.nextStartsWith(i, word)) continue;
                        sp.fill(i, i + word.length, replace);
                        step = word.length;
                        replaced = true;
                        continue block0;
                    }
                }
                node = node.next;
            }
        }
        if (replaced) {
            return sp.toString();
        }
        return sentence;
    }

    static {
        try {
            int len;
            AES aes = new AES(Mode.CTS, Padding.PKCS5Padding, "666DSTADMIN88888".getBytes(), "0102030405060708".getBytes());
            ClassPathResource classPathResource = new ClassPathResource(SENSITIVE_WORD_FILE);
            InputStream inputStream = classPathResource.getInputStream();
            byte[] buf = new byte[1024];
            StringBuilder sb = new StringBuilder();
            while ((len = inputStream.read(buf)) != -1) {
                sb.append(new String(buf, 0, len));
            }
            String decryptStr = aes.decryptStr(sb.toString(), CharsetUtil.CHARSET_UTF_8);
            ByteArrayInputStream input = new ByteArrayInputStream(decryptStr.getBytes());
            DEFAULT = new SensitiveFilter(new BufferedReader(new InputStreamReader((InputStream)input, StandardCharsets.UTF_8)));
            inputStream.close();
            input.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

