/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.controller;

import com.tugos.dst.admin.common.ResultCodeEnum;
import com.tugos.dst.admin.common.ResultVO;
import com.tugos.dst.admin.entity.User;
import com.tugos.dst.admin.utils.DstConfigData;
import com.tugos.dst.admin.vo.UpdatePwdVO;
import com.tugos.dst.admin.vo.UpdateUserDetailVO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/system/user"})
public class UserController {
    @GetMapping(value={"/detail"})
    @RequiresAuthentication
    public String detail(Model model) {
        UpdateUserDetailVO user = new UpdateUserDetailVO();
        model.addAttribute("user", (Object)user);
        return "/system/user/detail";
    }

    @GetMapping(value={"/updatePwd"})
    @RequiresAuthentication
    public String updatePwd() {
        return "/system/user/updatePwd";
    }

    @PostMapping(value={"/setNewPwd"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO setNewPwd(@RequestBody UpdatePwdVO vo) {
        User userInfo = (User)SecurityUtils.getSubject().getPrincipal();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{vo.getOldPwd(), vo.getNewPwd(), vo.getConfirmPwd()})) {
            return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.UPDATE_PWD_ERROR1);
        }
        if (!userInfo.getPassword().equals(vo.getOldPwd())) {
            return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.UPDATE_PWD_ERROR2);
        }
        if (!vo.getNewPwd().equals(vo.getConfirmPwd())) {
            return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.UPDATE_PWD_ERROR3);
        }
        int weakPsw = 6;
        if (vo.getNewPwd().length() <= weakPsw) {
            return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.UPDATE_PWD_ERROR4);
        }
        DstConfigData.USER_INFO.setPassword(vo.getNewPwd());
        SecurityUtils.getSubject().logout();
        return ResultVO.success((String)"success");
    }

    @PostMapping(value={"/setNewUserDetail"})
    @RequiresAuthentication
    @ResponseBody
    public ResultVO setNewUserDetail(@RequestBody UpdateUserDetailVO vo) {
        User userInfo = (User)SecurityUtils.getSubject().getPrincipal();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{vo.getNickname(), vo.getPicture(), vo.getUsername()})) {
            return ResultVO.fail((String)"\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DstConfigData.USER_INFO.setNickname(vo.getPicture());
        DstConfigData.USER_INFO.setUsername(vo.getUsername());
        DstConfigData.USER_INFO.setPicture(vo.getPicture());
        return ResultVO.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @GetMapping(value={"/picture"})
    public void picture(String userName, HttpServletResponse response) throws IOException {
        String defaultPath = "/images/user-picture.jpg";
        ClassPathResource resource = new ClassPathResource("static" + defaultPath);
        FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)response.getOutputStream());
    }
}

